// File:  C:\cbproj\Remote_CW_Keyer\HelpMap.c
// Date:  2023-11-22
// Author:  Wolfgang Buescher (DL4YHF)
// Purpose: Lookup table to convert 'help topic identifiers'
//          into HTML filenames and HTML anchor names,
//          using any web browser instead of Microsoft's defunct *.hlp system.

// #include "VCL.H"    // 2007-04-26: removed the Borland/VCL dependency - hooray !
#include "windows.h"   // ... but still we need windows.h for YHF_Help.c

#include "YHF_Help.h"  // DL4YHF's HTML-based replacement for the defunct *.hlp system
#include "HelpIDs.h"   // application-specific help topic identifiers

//------------- "Conversion Table"  for help topic IDs -> HTML links --------
// All help topic identifiers defined in the application's  HelpIDs.h
// should have an entry in the table below (often with an HTML anchor, too):
T_YHF_HelpMapEntry MyHelpMap[] =
{ // iHelpContext         html_file_name         html_anchor_name
 { HELPID_MAIN_INDEX    , "Remote_CW_Keyer.htm", "\0"                  },
 { HELPID_MAIN_WINDOW   , "Remote_CW_Keyer.htm", "keyer_application"   },
 { HELPID_MAIN_MENU     , "Remote_CW_Keyer.htm", "main_menu"           },
 { HELPID_HOTKEYS       , "Remote_CW_Keyer.htm", "hotkeys"             },
 { HELPID_IO_CONFIG     , "Remote_CW_Keyer.htm", "keyer_IO_config_tab" },
 { HELPID_AUDIO_SETTINGS, "Remote_CW_Keyer.htm", "audio_settings_tab"  },
 { HELPID_NETWORK_SETTINGS,"Remote_CW_Keyer.htm","network_settings_tab"},
 { HELPID_NETWORK_FUNCS , "Remote_CW_Keyer.htm", "network_functionality"},
 { HELPID_NETWORK_STATUS, "Remote_CW_Keyer.htm", "network_status"      },
 { HELPID_NETWORK_USERS,  "Remote_CW_Keyer.htm", "network_users"       },
 { HELPID_LOCAL_IP_ADDRESS,"Remote_CW_Keyer.htm","local_IP_address"    },
 { HELPID_LISTENING_PORT, "Remote_CW_Keyer.htm", "listening_port"      },
 { HELPID_REMOTE_URL_AND_PORT,"Remote_CW_Keyer.htm", "remote_URL_and_port"},
 { HELPID_USER_NAME,      "Remote_CW_Keyer.htm", "user_name"           },
 { HELPID_USER_CALLSIGN,  "Remote_CW_Keyer.htm", "user_callsign"       },
 { HELPID_HAMLIB_SERVER,  "Remote_CW_Keyer.htm", "hamlib_server"       },
 { HELPID_KEYER_SETTINGS, "Remote_CW_Keyer.htm", "keyer_settings_tab"  },
 { HELPID_KEYER_MEMORIES, "Remote_CW_Keyer.htm", "keyer_memories"      },
 { HELPID_DEBUG_TAB     , "Remote_CW_Keyer.htm", "keyer_debug_tab"     },
 { HELPID_TEST_TAB      , "Remote_CW_Keyer.htm", "keyer_test_tab"      },
 { HELPID_TIMING_SCOPE  , "Remote_CW_Keyer.htm", "Timing_Scope"        },
 { HELPID_TRX_TAB       , "Remote_CW_Keyer.htm", "TRX_Tab"             },
 { HELPID_BAND_SELECTION, "Remote_CW_Keyer.htm", "Band_Selection_and_Band_Stacking_Registers"      },
 { HELPID_SPECTRUM_REF_LEVEL,"Remote_CW_Keyer.htm","Spectrum_Ref_Level"},
 { HELPID_FREQUENCY_MARKER,"Remote_CW_Keyer.htm","Frequency_Markers"   },
 { HELPID_HARDWARE      , "Remote_CW_Keyer.htm", "Circuits"            },


 // .-.-.
 { 0 /* end of list*/         , "\0",            "\0"                }
};
