/*----- Help Topic Identifiers for the "Remote CW Keyer" --------*/
/*                                                               */
/* File  : C:\cbproj\Remote_CW_Keyer\HelpIDs.h                   */
/* Author:         W.Buescher (DL4YHF)                           */
/* Date  :  2023-12-11                                           */
/*                                                               */
/* Purpose: Replacement for Microsoft's defunc *.hlp system.     */
/*     To use HTML instead of "compiled help files", add module  */
/*     c:\cbproj\YHF_Tools\YHF_Help.cpp to the project .         */
/*---------------------------------------------------------------*/

  // default-value of HelpContext-property
#define HELPID_DEFAULT        0

  // Help topics (must exist in 'MyHelpMap', with filename and optional "anchor":
#define HELPID_MAIN_INDEX           100
#define HELPID_MAIN_WINDOW          110
#define HELPID_MAIN_MENU            115
#define HELPID_EXPORT_SETTINGS      117      // actually, "import and export settings"
#define HELPID_HOTKEYS              120
#define HELPID_IO_CONFIG            130
#define HELPID_AUX_COM_PORTS        135
#define HELPID_AUX_COM_PORT_DETAILS 136
#define HELPID_AUX_IO_CTRL_TOKENS   137
#define HELPID_AUDIO_SETTINGS       140
#define HELPID_CW_SIDETONE          142
#define HELPID_AUDIO_CW_DECODER     145
#define HELPID_NETWORK_SETTINGS     150
#define HELPID_NETWORK_FUNCS        152
#define HELPID_NETWORK_STATUS       154
#define HELPID_NETWORK_USERS        156
#define HELPID_LOCAL_IP_ADDRESS     157
#define HELPID_LISTENING_PORT       158
#define HELPID_REMOTE_URL_AND_PORT  160
#define HELPID_USER_NAME            161
#define HELPID_USER_CALLSIGN        162

#define HELPID_HAMLIB_SERVER        165  // not on the "Network" tab but under 'Config'..'Rig Control' !

#define HELPID_KEYER_SETTINGS       170
#define HELPID_KEYER_MEMORIES       175
#define HELPID_DEBUG_TAB            180
#define HELPID_TEST_TAB             190
#define HELPID_TIMING_SCOPE         200
#define HELPID_TRX_TAB              210 // .. with VFO frequency and remote spectrum/spectrogram
#define HELPID_BAND_SELECTION       215
#define HELPID_SPECTRUM_REF_LEVEL   220
#define HELPID_FREQUENCY_MARKER     230

#define HELPID_HARDWARE             300


#ifdef _YHF_HELP_  // if YHF_Help.h has been included.. (for main program)
  extern T_YHF_HelpMapEntry MyHelpMap[];
#endif

/* EOF <HelpIDs.h> */
