// File: Remote_CW_Keyer/HamlibResultCodes.h
// Author:  Wolfgang Buescher, DL4YHF
//
// Contains a few integer values returned by 'rigctld'-compatible command handlers.
//

#define HAMLIB_RESULT_NO_ERROR   0       // no error .. rigctld would respond with "RPRT 0\n" or something like that.
   // Dont't modify the following.. they are actually NEGATIVE 'Hamlib error codes'
#define HAMLIB_RESULT_INVALID_PARAM   -1 // invalid parameter
#define HAMLIB_RESULT_INVALID_CONFIG  -2 // invalid configuration
#define HAMLIB_RESULT_NO_MEMORY       -3 // here also used when a response would exceed HLSRV_RESPONSE_MAX_LENGTH
#define HAMLIB_RESULT_NOT_IMPLEMENTED -4 // > "function not implemented, but will be" (here: not really..)
#define HAMLIB_RESULT_COMM_TIMEOUT    -5 // communication timed out
#define HAMLIB_RESULT_IO_ERROR        -6 // IO error, including open failed
#define HAMLIB_RESULT_INTERNAL_ERROR  -7 // > "Internal Hamlib error, huh!"
#define HAMLIB_RESULT_PROTOCOL_ERROR  -8 // > "Protocol error"
#define HAMLIB_RESULT_REJECTED_BY_RIG -9 // > "Command rejected by the rig"
#define HAMLIB_RESULT_ARG_TRUNCATED  -10 // > "Command performed, but arg truncated"
#define HAMLIB_RESULT_NOT_AVAILABLE  -11 // > "Function not available" (WB: Also used here if a client doesn't have sufficient permissions)
#define HAMLIB_RESULT_NOT_TARGETABLE -12 // > "VFO not targetable"
#define HAMLIB_RESULT_RIG_BUS_ERROR  -13 // > "Error talking on the bus"
#define HAMLIB_RESULT_RIG_BUS_BUSY   -14 // > "Collision on the bus"
#define HAMLIB_RESULT_BAD_ARGUMENT   -15 // > "NULL RIG handle or any invalid pointer parameter in get arg"
#define HAMLIB_RESULT_INVALID_VFO    -16 // > "Invalid VFO"
#define HAMLIB_RESULT_ARG_OUT_OF_DOM -17 // > "Argument out of domain of func" (WB: Also used here if an argument could not be parsed into e.g. an integer)
#define HAMLIB_RESULT_FN_DEPRECATED  -18 // > "Function deprecated"
#define HAMLIB_RESULT_SECURITY_ERROR -19 // > "Security error"
#define HAMLIB_RESULT_RIG_NOT_POWERED -20 // > "Rig not powered on"
