//---------------------------------------------------------------------------
// File:   C:\cbproj\Remote_CW_Keyer\FreqList.h         
//         (based on \cbproj\SpecLab\FreqList.h)                          
// Purpose: Simple frequency list with text file import (for Spectrum Lab) 
// Date:   2009-07-09  (ISO 8601, YYYY-MM-DD)                              
// Author: Wolfgang Buescher (DL4YHF)                                      
//   For details, see implementation (*.c) .                               
//---------------------------------------------------------------------------

//------------ Data Types -------------------------------------------------
typedef struct t_FreqListEntry
{
  int    index;              // unique array index, zero based

  double dblFrequency_Hz;    // frequency in Hertz (not kHz.. use SI-units ! )
  char   sz7Callsign[8];     // CALLSIGN (unfortunately missing in the EiBi database)
  char   sz7ActiveStatus[8]; // 'N' = definitely NOT active; etc etc
  char   sz7Locator[8];      //
    // The following, rather exotic components are from the EiBi database:
  int    iStartTime, iEndTime; // "Time (UTC)" (time of day in MINUTES)
  char   sz7DaysActive[8];     // "Days" (of week, of activity)
  char   sz7ITUcountry[8];     // ITU country code

  char   sz31StationName[32]; // station name like "Polskie Radio"
  char   sz7Language[8];      // program language from EiBi database
  char   sz7Target[8];        // Target area (like Eu, EEu, SEA, etc), from EiBi database
  char   sz31Remarks[32];     // remarks (max 31 characters, rarely used)

  // Everything else (from the CSV file) is ignored !

  struct t_FreqListEntry *pPrev; // pointer to previous item (NULL=first item)
  struct t_FreqListEntry *pNext; // pointer to next item (NULL=end of the list)
  
} T_FreqListEntry;


//------------ Prototypes -------------------------------------------------
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* nicht "cplusplus" */

//---------------------------------------------------------------------------
CPROT int  FreqList_Load(char *pszFilenames); /* loads a list from a file */
CPROT void FreqList_Exit(void);  /* unloads the list and cleans up resources */

CPROT T_FreqListEntry *FreqList_GetEntryByIndex( int index );
CPROT T_FreqListEntry *FreqList_GetEntryByFrequency( double dblFreq_Hz, double dblUnixDateAndTime );
CPROT T_FreqListEntry *FreqList_GetNextEntry( T_FreqListEntry *pEntry, double dblUnixDateAndTime );
CPROT int FreqList_EntryToMultiLineText( T_FreqListEntry *pFLE, char *pszDest, const char *pszEndstop );




/* EOF < FreqList.h >  */