//---------------------------------------------------------------------------
// File: C:\cbproj\Remote_CW_Keyer\Dialogs.h
// Purpose:  Wrapper for some "common dialogs" in the Windows API .
//               by  Wolfgang Buescher (DL4YHF) .
//               NO APPLICATION-SPECIFIC STUFF IN HERE !
//               This unit is used in a number of projects (see history).
//
// Revision History:
//  2024-11-25: Replaced HUNDREDS of "char pointers" by "const char *"
//              because 'modern compilers' (e.g. "ISO C++11") are
//              very pedantic about char pointers, and refuse to
//              use STRING LITERALS as a "char *" !
//           After that, most of the non-VCL-modules could be compiled
//           with Borland C++Builder V6 and Embarcadero C++Builder V12.
//           Details about those modifications in YHF_Tools/StringLib.h .
//  2005-10-24:  Added "YHF_BrowseForFolder" (for WinPic) .
//  2004-07-13:  Created for DL4YHF's "Spectrum Lab".
//               Also used -the same day- for DL4YHF's "WinPic".
//---------------------------------------------------------------------------

#ifndef _YHF_DIALOGS_H_
#define _YHF_DIALOGS_H_


//---------------- Constants ------------------------------------------------
// Dialog button codes (not button IDs, but return codes for the modal dialogs)
#define YHF_DLG_BTN_NONE   0
#define YHF_DLG_BTN_OK     1  // .. or "YES" (same meaning) . DON'T MODIFY - this code is specified in the help system; "edit"-command
#define YHF_DLG_BTN_YES    1
#define YHF_DLG_BTN_CANCEL 2  // also returned when instead of  'Yes' or 'No' the user CLOSED the dialog box !
#define YHF_DLG_BTN_HELP   3
#define YHF_DLG_BTN_NO     4  // sometimes required to distinguish between 'No' and 'Cancel'/'Abort'/'Close' !
#define YHF_DLG_BTN_USER1  11
#define YHF_DLG_BTN_USER2  12

#define YHF_DLG_ID_EDIT1   21 /* control ID for the edit field in the dialog */

// Edit field options (used in some simple dialogs)
#define  YHF_EDIT_NORMAL       0
#define  YHF_EDIT_DECIMAL_ONLY 0x0010
#define  YHF_EDIT_HEXADECIMAL  0x0020


//---------------- Variables ------------------------------------------------
extern HINSTANCE APPL_hInstance; // must be set somewhere in the application,
                // so we don't have to pass this in all those functions .
                // Unlike other stuff, this "HINSTANCE"-thingy won't change
                // while a "normal, small windoze app" is running .

//---------------- Prototypes -----------------------------------------------

  // For peaceful coexistence between "C" and "C++" :
#ifndef CPROT
// Note on "extern": do not trust the lousy example from Borland !!
//   >extern "c" = bullshit (not recognized by Borland C++ V4.0)
//   >extern "C" = correct  (though the help system says something different)
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  /* ! "cplusplus" */
#endif

//--------------------------------------------------------------------------
CPROT BOOL YHF_ChooseColor( HWND hwndOwner, const char *pszCaption, DWORD *pdwRGBColor );
  // Color Selection Dialog.
  // Works a bit like Borland's TColorDialog but allows defining the CAPTION.

//--------------------------------------------------------------------------
CPROT BOOL YHF_BrowseFolder(HWND hwndOwner, const char *pszCaption, char *pszFolder, int iMaxLen );
  // Folder Selection Dialog.
  //  The current folder (pszFolder) will be selected in the dialog,
  //  so it must be VALID (or contain an empty string) before the call .

//--------------------------------------------------------------------------
CPROT int YHF_RunIntegerInputDialog( // MODAL dialog; returns YHF_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  const char *pszTitle, const char *pszLabel1,  const char *pszLabel2,
  int  *piValue,  int iEditOptions, int  iHelpID );

CPROT int YHF_RunStringEditDialog(  // MODAL dialog; returns YHF_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  const char *pszTitle, const char *pszLabel1, const char *pszLabel2,
  const char *pszDefaultValue, int iEditOptions,
  char *pszDestination,  int iMaxLength, int  iHelpID );

CPROT int YHF_RunFloatInputDialog(  // MODAL dialog; returns YHF_DLG_BTN_...
  HWND hwndOwner,  // handle to the window which will be blocked by the dialog
  const char *pszTitle, const char *pszLabel1, const char *pszLabel2,
  const char *pszFormatString,  // [in] your choice.. ex: hard-coded to "%.3lf" (until 2023-01, for DL4YHF's "Curve Editor")
  double *pdblValue,  int iEditOptions, int  iHelpID );
  // return value:  for all three functions above, one of the YHF_DLG_BTN_ codes defined in YHF_Dialogs.h .


//--------------------------------------------------------------------------
CPROT BOOL YHF_GetMouseCursorPos( int *piScreenX, int *piScreenY );
  // Not really "dialog-related", but see YHF_Dialogs.cpp .....


#endif // _YHF_DIALOGS_H_

// EOF < YHF_Dialogs.h >
