// File:  C:\cbproj\Remote_CW_Keyer\Debouncer.h
// Date:  2024-05-26
// Author:  Wolfgang Buescher (DL4YHF)
// Purpose: "Instantiatable" Debouncer for digital inputs.
//          First used in the author's "Remote CW Keyer" project,
//          to debounce the "dash" and "dot" signals from a
//          Morse key, before processing in the 'Elbug' emulator.
//  Details only in the implementation (*.c module).

#ifndef  DEBOUNCER_H_INCLUDED
# define DEBOUNCER_H_INCLUDED 1

#ifndef _DATA_TYPES_H_
# include "yhf_type.h"  // old fashioned stuff like BYTE, WORD, DWORD, etc^10
#endif


//---------------------------------------------------------------------------
// Constants  ..
//---------------------------------------------------------------------------

           // .. none so far



//---------------------------------------------------------------------------
// Data Types ..
//---------------------------------------------------------------------------


typedef struct t_Debouncer // Data (struct) for one instance of a digital debouncer:
{ int  iMinStableIntervals; // number of Debounce() calls with "stable" input
                            // before the input becomes the new ouput.
                            // With iMinStableIntervals=0, Debounce() simply
                            // returns the 'new input' (immediately), e.g.
                            //  "Debouncer OFF".
  BOOL fPrevInput;          // state of the digital input on the last Debounce()-call
  BOOL fCurrOutput;         // current "debounced" output, returned by Debounce()
  int  iBounceCountdown;    // "countdown", actually a timer, because Debounce()
                            // shall be called at regular intervals (e.g. every 2ms)
} T_Debouncer;



//---------------------------------------------------------------------------
// Function prototypes
//---------------------------------------------------------------------------
#ifndef CPROT   // for peaceful co-existence of C and C++ ...
#ifdef __cplusplus
 #define CPROT extern "C"
#else
 #define CPROT
#endif  // not "cplusplus" ?
#endif // ndef CPROT ?

CPROT void Debouncer_Init( T_Debouncer *pDebouncer, int iMinStableIntervals );

CPROT BOOL Debounce( T_Debouncer *pDebouncer, BOOL fNewInput );


#endif // ndef DEBOUNCER_H_INCLUDED ?
