//---------------------------------------------------------------------------
// File: C:\cbproj\Remote_CW_Keyer\AuxComPortDetails_Dialog.cpp
// Date: 2025-06-13
// Author: Wolfgang Buescher (DL4YHF)
// Purpose: Dialog to configure 'Details' for any of the Remote CW Keyer's
//          'Additional COM Ports' (original shorter name 'Aux COM Ports').
//      THIS module is just a part of the the BORing graphic user interface,
//      written in a stoneage version of Borland's C++ Builder (BCB V6),
//      using their easy-to-use VCL (Visual Component Library).
//
//      You won't have much fun using THIS module with anything but BCB V6 !
//      Fortunately, the 'Additional COM Port' module is written in plain old
//      C without any Borland- or Qt-specific crap
//        - see C:\cbproj\Remote_CW_Keyer\AuxComPorts.c .
//
// Most recent modifications: See AuxComPorts.c .
//
//---------------------------------------------------------------------------

#include "switches.h"   // project specific compiler switches ("options"),
                        // must be included before anything else !
#include "yhf_type.h"   // classic types like BYTE, WORD, DWORD, BOOL, ..
#include <windows.h>    // Must be included BEFORE vcl.h for some strange reason.
                        // Contains stuff like WAVEINCAPS, WAVEOUTCAPS, etc^255 .
#include <vcl.h>        // Borland's stoneage Visual Component Library
#include <buttons.hpp>  // TBitBtn       a la Borland VCL (but why in an extra header?)
#include <ComCtrls.hpp> // TTabSheet     a la Borland VCL ...
#include <CheckLst.hpp> // TCheckListBox a la Borland VCL ....
#include <Grids.hpp>    // TStringGrid   a la Borland VCL .....
#include <string.h>
#include <stdio.h>      // not using "standard I/O" here, but e.g. sprintf()
#include <math.h>
#pragma hdrstop

#include "Utilities.h"    // stuff like UTL_iWindowsVersion, UTL_iAppInstance, ShowError(), etc
#include "YHF_Dialogs.h"  // API for a few common dialogs, e.g. YHF_RunStringEditDialog()
#include "YHF_Help.h"     // DL4YHF's HTML-based replacement for the defunct *.hlp system
#include "YHF_WinStuff.h" // Win32 API functions, helpers for 'Rich Edit' controls, etc
#include "HelpIDs.h"      // application specific help topic identifiers
#include "Translator.h"   // APPL_TranslateAllForms() [only works with Borland VCL]
#include "Translations.h" // tranlation table (static, built-in string table w/o whistles and bells)
#include "Keyer_GUI_no_VCL.h" // from the 'Keyer GUI', this module only needs the VCL-free part

#if( SWI_USE_DSOUND ) // use "Direct Sound" / dsound_wrapper.c ?
# include "dsound_wrapper.h"
#endif // SWI_USE_DSOUND ?

#if( SWI_USE_WAVE_AUDIO || SWI_USE_MIDI )
# include <mmsystem.h> // without this, some stupid header didn't know what a 'LPCWAVEFORMATEX' is
#endif // SWI_USE_WAVE_AUDIO or SWI_USE_MIDI ?

#include "StringLib.h" // DL4YHF's "string library", uses C STRINGS ONLY, even runs on Microcontrollers
#include "Elbug.h"     // old 'Elbug' functions, converted from PIC-assembler to "C"
#include "SoundTab.h"  // cosine lookup table, filter coefficients, T_Float, etc.
#include "CwGen.h"     // CW generator (converts text to Morse code)
#include "CwDSP.h"     // CW-'Digital Signal Processor' / sidetone generator
#include "CwNet.h"     // Socket-based 'Client or Server' for the Remote CW Keyer
#include "CwKeyer.h"   // prototypes for the 'worker thread' that stitches all together
#include "Inet_Tools.h" // Base64 encoding/decoding, SHA1 calculation, etc..
#if(SWI_USE_HTTP_SERVER) // build an application with integrated HTTP server ?
# include "HttpServer.h" // formerly simple HTTP server (turned into a monster)
# include "TIconToFavicon.h" // function to convert the application's icon
                             // into "Favicon.ico" for the web server .
#endif // SWI_USE_HTTP_SERVER ?

#include "SpecDisp.h"  // SpecDisp_UpdateSpectrum(), ..Waterfall(), FreqScale(),..
#include "FreqList.h"  // import 'frequencies of interest' from e.g. the EiBi frequency list
#include "Keyer_GUI.h" // stuff like FillComboWithSerialPorts(), etc etc etc

#if( SWI_NUM_AUX_COM_PORTS > 0 ) // compile with support for 'Auxiliary / Additional COM ports' / Winkeyer emulation ?
# include "AuxComPorts.h" // structs and API functions for the "Auxiliary" (later: "Additional") COM ports
#endif // SWI_NUM_AUX_COM_PORTS ?


//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "AuxComPortDetails_Dialog.h"


static int AuxComPortDlg_iCurrentInstance = 0;



//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm_AuxComPortDetails *Form_AuxComPortDetails;
//---------------------------------------------------------------------------
__fastcall TForm_AuxComPortDetails::TForm_AuxComPortDetails(TComponent* Owner)
   : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TForm_AuxComPortDetails::Timer1Timer(TObject *Sender)
{ // Show a short (but "live") summary about what's happening on with this port:

  T_AuxComPortInstance *pAuxCom;

  if( (AuxComPortDlg_iCurrentInstance>=0) &&  (AuxComPortDlg_iCurrentInstance<SWI_NUM_AUX_COM_PORTS) )
   { pAuxCom = &AuxComPorts[AuxComPortDlg_iCurrentInstance];
     if( pAuxCom->hComPort != INVALID_HANDLE_VALUE )
      { Lab_CurrentState->Caption = AnsiString( AuxCom_GetCurrentStatusAsString(pAuxCom) );
        // Similar as in the main form (TKeyerMainForm::Timer1Timer),
        // Show INPUT STATES (DCD,DSR,CTS,RI) .. but here only for ONE port:
        Ed_DCD->Color = ( pAuxCom->dwDigitalSignalStates & AUX_COM_DIG_SIGNAL_DCD ) ? clLime : clWindow;
        Ed_DSR->Color = ( pAuxCom->dwDigitalSignalStates & AUX_COM_DIG_SIGNAL_DSR ) ? clLime : clWindow;
        Ed_CTS->Color = ( pAuxCom->dwDigitalSignalStates & AUX_COM_DIG_SIGNAL_CTS ) ? clLime : clWindow;
        Ed_RI->Color  = ( pAuxCom->dwDigitalSignalStates & AUX_COM_DIG_SIGNAL_RI  ) ? clLime : clWindow;
        // ,-------------------------------------------------------------------------'
        // '-> "Lime" = "Light Green" ? There is no simple clLightGreen in the VCL so use this instead.
        //
        // Show OUTPUT STATES (DTR,RTS as last driven in AuxComThread() for this port):
        Ed_DTR->Color = ( pAuxCom->dwDigitalSignalStates & AUX_COM_DIG_SIGNAL_DTR ) ? clLime : clWindow;
        Ed_RTS->Color = ( pAuxCom->dwDigitalSignalStates & AUX_COM_DIG_SIGNAL_RTS ) ? clLime : clWindow;
      }
     else // serial port currently NOT OPEN, so cannot read states of inputs, etc:
      {
        Ed_DCD->Color = clWindow;
        Ed_DSR->Color = clWindow;
        Ed_CTS->Color = clWindow;
        Ed_RI->Color  = clWindow;
        Ed_DTR->Color = clWindow;
        Ed_RTS->Color = clWindow;
        Lab_CurrentState->Caption = "Port not opened";
      }
   }
  else
   { Lab_CurrentState->Caption = "Status not available";
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm_AuxComPortDetails::Btn_HelpClick(TObject *Sender)
{ // ex: YHF_HELP_ShowHelpContext( HELPID_AUX_COM_PORTS );
  YHF_HELP_ShowHelpContext( HELPID_AUX_COM_PORT_DETAILS );
}

//---------------------------------------------------------------------------
void __fastcall TForm_AuxComPortDetails::Lab_ProgrammableFunctionsClick(TObject *Sender)
{ YHF_HELP_ShowHelpContext( HELPID_AUX_IO_CTRL_TOKENS );
}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------
BOOL AuxComPortDetails_RunModal( // 'API function', called from the GUI, no VCL.
  int iAuxComInstance )  // [in] 0 .. SWI_NUM_AUX_COM_PORTS-1 (ZERO-based index),
                         // [in,out] CwKeyer_Config (global variable)
  // [return] TRUE:  User clicked "OK", and CwKeyer_Config (global variable) was modified;
  //          FALSE: User clicked "CANCEL", and CwKeyer_Config was NOT updated.
{
  T_AuxComPortInstance *pInstance;
  T_AuxComConfig       *pAuxComCfg;

  TForm_AuxComPortDetails *pForm = Form_AuxComPortDetails;

  char sz255[256];
  char *pszDest= sz255;
  char *pszEnd = sz255 + 255;
  int i,iResult;
  long lCheckedBits;
  TCheckListBox *pCLB;
  BOOL fConflict;


  if(!pForm) return FALSE;  // oops.. the (VCL-) "Form" doesn't exist !
  if( (iAuxComInstance<0) || (iAuxComInstance>=SWI_NUM_AUX_COM_PORTS) )
   { return FALSE;  // oops.. illegal array index for an 'Additional COM Port' !
   }
  AuxComPortDlg_iCurrentInstance = iAuxComInstance; // <- for a 'life display' in the modal dialog form itself
  pInstance  = &AuxComPorts[iAuxComInstance];
  pAuxComCfg = &CwKeyer_Config.sAuxCom[iAuxComInstance];

  pszDest = sz255;
  SL_AppendPrintf( &pszDest, pszEnd, "Additional COM Port #%d", (int)(iAuxComInstance+1) );
  pForm->Caption = sz255;

  FillComboWithSerialPorts( pForm->CB_ComPort, pAuxComCfg->iPortNumber, FALSE/*fNeedValidPort*/, &fConflict,
      TE("Select COM port, or type e.g. COM123 if windows doen't enumerate it") );
  FillComboWithItemsFromTokenLists( pForm->CB_Baudrate, SerialPortBaudrates, NULL, NULL,
                                 pAuxComCfg->iBitsPerSecond );
  KeyerGUI_SerialFormatToString( pAuxComCfg->iNumDatabits, pAuxComCfg->iParity,
                                 pAuxComCfg->iNumStopbits, sz255 );
  pForm->Ed_SerialFormat->Text = AnsiString( sz255 );
  FillComboWithItemsFromTokenLists( pForm->CB_ComPortUsage, AuxComPortUsages,NULL, NULL,
                                    pAuxComCfg->iPortUsage );
  FillComboWithItemsFromTokenLists( pForm->CB_TunnelNumber, AuxComPortTunnelNumbers, NULL, NULL,
                                    pAuxComCfg->iTunnelIndex );
  pForm->Ed_DTR->Text = AnsiString( pAuxComCfg->sz40DTR ); // freely programmable OUTPUT function
  pForm->Ed_RTS->Text = AnsiString( pAuxComCfg->sz40RTS ); // freely programmable OUTPUT function
  pForm->Ed_DCD->Text = AnsiString( pAuxComCfg->sz40DCD ); // freely programmable INPUT function
  pForm->Ed_DSR->Text = AnsiString( pAuxComCfg->sz40DSR ); // freely programmable INPUT function
  pForm->Ed_CTS->Text = AnsiString( pAuxComCfg->sz40CTS ); // freely programmable INPUT function
  pForm->Ed_RI->Text  = AnsiString( pAuxComCfg->sz40RI  ); // freely programmable INPUT function
  pForm->Ed_PortParams->Text = AnsiString( pAuxComCfg->sz40Params );
  iResult = pForm->ShowModal();
  if(iResult==mrOk)
    { // put the modified settings back into CwKeyer_Config :
      pAuxComCfg->iPortNumber = ParseSerialPortNumberFromText( AnsiString(pForm->CB_ComPort->Text).c_str() );
      pAuxComCfg->iBitsPerSecond = StrToIntDef(pForm->CB_Baudrate->Text, pAuxComCfg->iBitsPerSecond );
      strncpy( sz255, pForm->Ed_SerialFormat->Text.c_str(), 40 );
      KeyerGUI_ParseSerialFormat( sz255, &pAuxComCfg->iNumDatabits, &pAuxComCfg->iParity,
                                         &pAuxComCfg->iNumStopbits );
      pAuxComCfg->iPortUsage = SL_FindStringInTable( AuxComPortUsages, AnsiString(pForm->CB_ComPortUsage->Text).c_str() );
      pAuxComCfg->iTunnelIndex = SL_FindStringInTable( AuxComPortTunnelNumbers, AnsiString(pForm->CB_TunnelNumber->Text).c_str() );
      strncpy( pAuxComCfg->sz40DTR, pForm->Ed_DTR->Text.c_str(), 40 ); // freely programmable OUTPUT function
      strncpy( pAuxComCfg->sz40RTS, pForm->Ed_RTS->Text.c_str(), 40 ); // freely programmable OUTPUT function
      strncpy( pAuxComCfg->sz40DCD, pForm->Ed_DCD->Text.c_str(), 40 ); // freely programmable INPUT function
      strncpy( pAuxComCfg->sz40DSR, pForm->Ed_DSR->Text.c_str(), 40 ); // freely programmable INPUT function
      strncpy( pAuxComCfg->sz40CTS, pForm->Ed_CTS->Text.c_str(), 40 ); // freely programmable INPUT function
      strncpy( pAuxComCfg->sz40RI , pForm->Ed_RI->Text.c_str(),  40 ); // freely programmable INPUT function
      strncpy( pAuxComCfg->sz40Params,pForm->Ed_PortParams->Text.c_str(), 40); // e.g. hint to decode received traffic, etc
      return TRUE;
    }

  (void)pInstance; // ... assigned a value that is never used .. well, NOT YET


  return FALSE;

} // end AuxComPortDetails_RunModal()




/* EOF < AuxComPortDetails_Dialog.cpp > */


