// *****************************************************************************
// Robert Tyrakowski
// dk7nt@rbty.de
//
// http://www.qsl.net/dk7nt
//
// More information on the www site
//
// V 1.0 / 16.06.2003
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// GA628 LCD Display for MSP430F1232
// Voltage doubler driven by ACLK
//
// Target: MSP430F1232
// Clock:  32,768 kHz
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// ACLK       		+: Out     Pin P2.0  Voltage doubler for 6V LCD supply
// SDA               : In/Out  Pin P3.0
// SCL        	 	 : Out     Pin P3.1
// LCD-RST			 : OUT     Pin P3.2
//
//
// *****************************************************************************

#include "GA628.h"

void Copy_to_LCD_Buf(const unsigned char * buffer, unsigned char len);
unsigned char Set_Icons(void);

void wait(void)
{
;
}

//------------------------------------------------------------------------------
//  I2C
//------------------------------------------------------------------------------
void LCD_Start(void)
{
   SDA_L;
   wait();
   SCL_L;
}

//------------------------------------------------------------------------------
void LCD_Stop(void)
{
   SDA_L;
   wait();
   SCL_H;
   wait();
   SDA_H;
}

//------------------------------------------------------------------------------
unsigned char LCD_RDACK(void)
{
unsigned char i;
   SDA_In;                   // Port as input
   wait();
	SDA_H;		  	          // read ACK
   wait();
	SCL_H;
   wait();
	i = SDA_DI;
	SCL_L;
   wait();
   SDA_Out;                  // Port as output
	return(i);
}

//------------------------------------------------------------------------------
//   I2C Write byte
//
// Call:     datum = value to write
// Returns:  1 ok, 0 not ok
//------------------------------------------------------------------------------
unsigned char LCD_Write_Byte(unsigned char datum)
{
unsigned char i = 8;
	do {
		if ( datum & 0x80 ) {
			SDA_H;
		} else  {
			SDA_L;
		}
      wait();
		datum<<=1;
      SCL_H;
      wait();
      SCL_L;
	}
	while( --i );
   return LCD_RDACK();
}

//------------------------------------------------------------------------------
// Displays a message in the GA628 LCD line
// Source is LCD_Buf
// Returns:  1 ok, 0 not ok
//------------------------------------------------------------------------------
unsigned char Display_Line(void)
{
unsigned char x,i;
   x = 1 ;
   LCD_Start();
   if (!LCD_Write_Byte(0x74)) {
      if (!LCD_Write_Byte(0x80)) {
   	  	if (!LCD_Write_Byte(0x8C)) {
   	  	 	if (!LCD_Write_Byte(0x40)) {
		  	      i=0;
			      while (i<12){
			 	      if (LCD_Write_Byte(LCD_Buf[i++]|0x80)) {
				         x=1;
				         break;
				      } else {
				         x=0;
				      }
			      }
	         }
         }
	   }
   }
   LCD_Stop();
   return(x);
}

//------------------------------------------------------------------------------
// Write command to GA628
// Source is LCD_Buff
// Returns:  1 ok, 0 not ok
//------------------------------------------------------------------------------
unsigned char LCD_Write_Command(unsigned char cnt)
{
unsigned char x,i,j;
   i = 0;
   x = 1 ;
   LCD_Start();
	while (i <= cnt){
		if (LCD_Write_Byte(LCD_Buf[i++])) {
			x=1;
			break;
		} else {
			x=0;
	   }
   }
   LCD_Stop();
   return(x);
}

//------------------------------------------------------------------------------
// Clear GA628 Display
//------------------------------------------------------------------------------
unsigned char Clear_Display(void)
{
   Copy_to_LCD_Buf(Clear_LCD,5);
   return(LCD_Write_Command(0x05));
}

//------------------------------------------------------------------------------
// Copy data to LCD_Buf
//------------------------------------------------------------------------------
void Copy_to_LCD_Buf(const unsigned char * buffer, unsigned char len)
{
unsigned char x;
   for (x=0;x<len;x++) {
      LCD_Buf[x]=buffer[x];
   }
}

//------------------------------------------------------------------------------
// Turn ACLK off and set output to LOW for power save
// (used before entering LPM)
//------------------------------------------------------------------------------
void Disable_ACLK(void)
{
   ACLK_Off;
	ACLK_Low;
}

//------------------------------------------------------------------------------
// Turn ACLK on after power save
// (used after leaving LPM)
//------------------------------------------------------------------------------
void Enable_ACLK(void)
{
	ACLK_On;
}

//------------------------------------------------------------------------------
// Init GA628
// Returns:  1 ok, 0 not ok
//------------------------------------------------------------------------------
unsigned char Init_GA628(void)
{
   icon_feldstaerke = 0;
   icon_1 = 0;
   icon_2 = 0;
   icon_pfeiloben = 0;
   icon_pfeilunten = 0;
   icon_melodie = 0;
   icon_brief = 0;
   icon_hoerer = 0;
   icon_battinnen = 0;
   icon_battaussen = 0;

   LCDRst_L;
   // insert delay if neccessary
   LCDRst_H;
   Enable_ACLK();
   Copy_to_LCD_Buf(Init_LCD,10);
   if (!( LCD_Write_Command(10))) {
//   Set LCD Icons off
  	   Set_Icons();
   	return Clear_Display() ;
	}
   return 1 ;
}

//------------------------------------------------------------------------------
// Set Icons
// Returns:  1 ok, 0 not ok
//------------------------------------------------------------------------------

unsigned char Set_Icons(void)
{
unsigned char x;
   Copy_to_LCD_Buf(Icons_ONOff,18);
   switch (strength & 0x07) {
	    case 0 : icon_feldstaerke = 00;
		         break;
	    case 1 : icon_feldstaerke = 0x10;
		         break;
	    case 2 : icon_feldstaerke = 0x18;
		         break;
	    case 3 : icon_feldstaerke = 0x1c;
		         break;
	    case 4 : icon_feldstaerke = 0x1e;
		         break;
	    case 5 : icon_feldstaerke = 0x1f;
		         break;
	 }
   LCD_Buf[4]  = icon_feldstaerke;
   LCD_Buf[6]  = icon_1 | icon_2;
   LCD_Buf[7]  = icon_pfeiloben | icon_pfeilunten;
   LCD_Buf[9]  = icon_melodie;
   LCD_Buf[10] = icon_brief;
   LCD_Buf[12] = icon_hoerer;
   LCD_Buf[14] = icon_battinnen;
   LCD_Buf[15] = icon_battaussen;
   return (LCD_Write_Command(18));
}

void Test_Icon(void)
{
   icon_feldstaerke = 0x1F;
   icon_1 = 0xF0;
   icon_2 = 0x0F;
   icon_pfeiloben = 0x0F;
   icon_pfeilunten = 0xF0;
   icon_melodie = 0xFF;
   icon_brief = 0xFF;
   icon_hoerer = 0xFF;
   icon_battinnen = 0xFF;
   icon_battaussen = 0xFF;
	strength = 5;
  	Set_Icons();
}
