/***************************************************************

  DVMS            Digital Voice Mailbox System
  SERV
  VTGEN

  --------------------------------------------------
  write logfiles
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#ifdef DVMS
#include "dvms.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#endif

#include "util.h"

void write_log(int state,char *r,char *format,...)
{ static  char cbuf[256],*level[4]={"#F","#S","#R","#K"},*s;

  if((cfg.loglevel&3)<state)
    return;

  char help[80];
  int handle;
  struct tm *tt;
  time_t t;
  va_list argpoint;

  va_start(argpoint,format);
  vsprintf(cbuf,format,argpoint);
  va_end(argpoint);

  t=ad_time(NULL);
  tt=localtime(&t);
#ifdef DVMS
  sprintf(help,"log\\log%u%02u%02u.VMS",tt->tm_year%10,tt->tm_mon+1,tt->tm_mday);
#endif
#ifdef VTGEN
  sprintf(help,"log\\log%u%02u%02u.LOG",tt->tm_year%10,tt->tm_mon+1,tt->tm_mday);
#endif

  if ((handle=open(help,O_APPEND|O_CREAT|O_TEXT|O_RDWR,S_IREAD|S_IWRITE))!=-1)
  {  if(strlen(cbuf)<=40)
    {
      sprintf(help,"%s %s %s %-7.7s %-10.10s %-.40s\n",datestr(ad_time(NULL),1),timestr(ad_time(NULL)),level[state],get_tcb()->name,r,cbuf);
      write(handle,help,strlen(help));
    }
    else
    {
      if((s=strchr(cbuf+30,32))!=NULL)
        s[0]=0;
      sprintf(help,"%s %s %s %-7.7s %-10.10s %-.40s\n",datestr(ad_time(NULL),1),timestr(ad_time(NULL)),level[state],get_tcb()->name,r,cbuf);
      write(handle,help,strlen(help));

      if(s!=NULL)
      {  sprintf(help,"%s %s %s %-7.7s %-10.10s %-.40s\n",datestr(ad_time(NULL),1),timestr(ad_time(NULL)),level[state],get_tcb()->name,r,s+1);
        write(handle,help,strlen(help));
      }
    }
    close(handle);
  }
//  else
//    fprintf(stderr,"\nwrite_log: can't open logfile %s",help);
}

#ifdef DVMS
void wrtdtmflog(char *s)
{ if(!(cfg.loglevel&4))
    return;

  char help[80];
  int handle;
  struct tm *tt;
  time_t t;

  t=ad_time(NULL);
  tt=localtime(&t);
#ifdef DVMS
  sprintf(help,"log\\dtmflog.VMS",tt->tm_year%10,tt->tm_mon+1,tt->tm_mday);
#endif

  if ((handle=topen(help,O_APPEND|O_CREAT|O_TEXT|O_RDWR,S_IREAD|S_IWRITE))>0)
  { sprintf(help,"%s %s %-12.12s %-.40s\n",
            datestr(ad_time(NULL),1),timestr(ad_time(NULL)),
            get_tcb("mailbox")->cmd,s);
    write(handle,help,strlen(help));
    tclose(handle);
  }
}

#endif