/***************************************************************

  DVMS            Digital Voice Mailbox System
  VTGEN
  SERV

  --------------------------------------------------
  little window manager but compatible
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#ifdef __MSDOS__

#if defined DVMS || defined INSTALL
#include "dvms.h"
#include "dvmswin.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#include "vtwin.h"
#endif
#include "tnclow.h"
#include "tncrdwrt.h"

struct text_info ti[_MAXWINDOWS];
char far *screen=NULL;
char dosscreen[80];
int mono=0,curr_win=-1,winok=0,vmode,vmodeold;
int far* video;

#ifndef INSTALL
void screensave(int s)
{
  if(s)
  { outp(*video,0x17);
    outp(*video+1,inp(*video+1)&127);
    outp(*video+4,0x21);
    _AX=0x1201;
    _BL=0x36;
    geninterrupt(0x10);
  }
  else
  {  _AX=0x1200;
    _BL=0x36;
    geninterrupt(0x10);
    outp(*video,0x17);
    outp(*video+1,inp(*video+1)|128);
    outp(*video+4,0x28);
  }
}
#endif
void attr(int attr)
{  if(mono)
    if(attr!=0x70)
    {
      attr&=0xf;
      if(attr==0xE)
        attr=0xF;
    }
  textattr(attr);
}

int storescr(char *s)
{  FILE *f;

  if(screen==NULL)
  {  video=(int far*)MK_FP(0,0x463);
    if(*video==0x3b4)
    {  mono=1;
      screen=(char far*)MK_FP(0xb000,0);
    }
    else
      screen=(char far*)MK_FP(0xb800,0);
  }

  if(s==NULL)
    return 0;
  if(!s[0])
    _tmpname(s);

  if((f=fopen(s,"wb"))==NULL)
    return 0;
  else
  { struct text_info tti;
    void *scrsave;
    gettextinfo(&tti);
    fwrite(&tti,sizeof(struct text_info),1,f);
    if ((scrsave = malloc(tti.screenheight*160)) != NULL)
    { memcpy(scrsave,screen,tti.screenheight*160);
      fwrite(scrsave,tti.screenheight*160,1,f);
      free(scrsave);
    }
    fclose(f);
    return 1;
  }
}

int retrscr(char *s)
{  FILE *f;

  if(s==NULL)
     return 0;

  if((f=fopen(s,"rb"))==NULL)
  {clrscr();
   curr_win=-1;
   #ifndef INSTALL
   winmgr_on();
   #endif
   return 0;
  }
  else
  { struct text_info tti;
    void *scrsave;
    fread(&tti,sizeof(struct text_info),1,f);
    if ((scrsave = malloc(tti.screenheight*160)) != NULL)
    { fread(scrsave,tti.screenheight*160,1,f);
      memcpy(screen,scrsave,tti.screenheight*160);
      free(scrsave);
    }
    fclose(f);
    window(tti.winleft,tti.wintop,tti.winright,tti.winbottom);
    attr(tti.attribute);
    gotoxy(tti.curx,tti.cury);
    return 1;
  }
}

void prt(int x,int y,int attrib,char *string)
{
 int xc=0;
 if(mono)
  if(attrib!=0x70)
  {  attrib&=0xf;
    if(attrib==0xE)
      attrib=0xF;
  }
 while(string[xc])
 {
   screen[(x-1)*2+(y-1)*160+xc*2]=string[xc];
   screen[(x-1)*2+(y-1)*160+xc*2+1]=attrib;
   xc++;
 }
}

void win(int num,int x,int y,int xsize,int ysize,char *titel,int attrib)
{
  int i,j;
  char space[90];
  memset(space,0x20,sizeof(space));
  space[xsize]=0;

  attr(attrib);
  prt(x,y,attrib,"");

  for(i=1;i<=xsize;i++)
  {
    if(i==(xsize/2-strlen(titel)/2))
    {
      prt(i+x,y,attrib,titel);
      i+=strlen(titel);
    }
    prt(i+x,y,attrib,"");
  }
  prt(i+x,y,attrib,"");


  for(j=1;j<=ysize;j++)
  {
    gotoxy(x,y+j);
    prt(x,y+j,attrib,"");
    prt(x+1,y+j,attrib,space);
    prt(x+xsize+1,y+j,attrib,"");
  }
  prt(x,y+ysize+1,attrib,"");
  for(i=1;i<=xsize;i++)
    prt(x+i,y+ysize+1,attrib,"");
  prt(x+xsize+1,y+ysize+1,attrib,"");

  window(x+1,y+1,x+xsize,y+ysize);
  gettextinfo(&ti[num]);
  gotoxy(1,1);
}

int get_win(void)
{
  return(curr_win);
}

int set_win(int win)
{
  int t;
  if(!winok)
    return 0;

  if(curr_win!=-1)
    gettextinfo(&ti[curr_win]);

  window(ti[win].winleft,ti[win].wintop,ti[win].winright,  ti[win].winbottom);
  gotoxy(ti[win].curx,ti[win].cury);
  textattr(ti[win].attribute);
  t=curr_win;
  curr_win=win;
  return(t);
}
#ifndef VTGEN
int dgets(char *input,int length)
{
  #ifdef INSTALL
  char help[258];

  if(length>255)
    length=255;

  help[0]=length;
  cgets(help);
  strcpy(input,help+2);
  return(help[1]);
  #endif

  #ifdef DVMS
  int i,x=wherex(),y=wherey();
  for(i=0;i<length;i++)
    putch(' ');
  gotoxy(x,y);
  return getline(input,length,2);
  #endif
}
#endif

void winmgr_off(void)
{
  textmode(vmode);
  #ifndef INSTALL
  if(cfg.scrsave)
    screensave(0);
  #endif
  _setcursortype(_NORMALCURSOR);
  #ifndef INSTALL
  if(access(dosscreen,0))
  #endif
    clrscr();
  #ifndef INSTALL
  else
  {  retrscr(dosscreen);
    remove(dosscreen);
  }
  #endif
  _AX=0x0b00;
  _BX=0;
  geninterrupt(0x10);
}
#endif