#ifdef DVMS
#include "dvms.h"
#endif

#ifdef VTGEN
#include "vtgen.h"
#endif
int xchdir(char *dir)
{  char path[81];
  int i;

  if(strlen(dir)>80)
   return -1;

  strcpy(path,dir);

  i=strlen(path);
  while(path[--i]!='\\');
  path[i]=0;

  if(path[0]&&(path[1]==':'))
   _chdrive((path[0]&0x5f)-'@');
  return chdir(path);
}

char *stristr(char *s1,char *s2)
// *****************************************************************
//
//  Sucht nach einem Teilstring in einem String.
//  Die Funktion ist analog zur Bibliotheksfunktion strstr,
//  unterscheidet aber nicht zwischen Gro- und Kleinschreibung
//
// *****************************************************************
{ int i;
  int l=strlen(s2);

  while(s1[0])
  { i=0;
   while((((s1[i]^s2[i])&0x5f)==0) && s2[i])
    i++;
   if(i==l)
    return s1;
   s1++;
  }
  return NULL;
}

void subst(char *s,char i,char j)
{  while((s=strchr(s,i))!=NULL)
    s[0]=j;
}


#ifdef VTGEN
#ifdef __MSDOS__
//char *monthstr[]={"Jan","Feb","M{r","Apr","Mai","Jun",
//               "Jul","Aug","Sep","Okt","Nov","Dez"};

char *strdatetime(char *input)
{
  static char buffer[20];
  unsigned second,minute,hour,day,month,year,i;
  do
    outp(0x70,0xA);
  while(inp(0x71)&0x80);

  outp(0x70,0);
  second=inp(0x71);
  outp(0x70,2);
  minute=inp(0x71);
  outp(0x70,4);
  hour  =inp(0x71);

  outp(0x70,7);
  day   =inp (0x71);
  outp(0x70,8);
  month =inp (0x71);
  outp(0x70,9);
  year  =inp (0x71);

  buffer[0]=(day>>4)+0x30;
  buffer[1]=(day&15)+0x30;
  buffer[2]='.';

  buffer[3]=(month>>4)+0x30;
  buffer[4]=(month&15)+0x30;

 // for(i=0;i<4;i++)
//    buffer[i+3]=monthstr[(month>>4)*10+(month&15)-1][i];

  buffer[6-1]='.';
  buffer[7-1]=(year>>4)+0x30;
  buffer[8-1]=(year&15)+0x30;
  buffer[9-1]=' ';

  //_strtime(buffer+10);

  buffer[10-1]=(hour>>4)+0x30;
  buffer[11-1]=(hour&15)+0x30;
  buffer[12-1]=':';
  buffer[13-1]=(minute>>4)+0x30;
  buffer[14-1]=(minute&15)+0x30;
  buffer[15-1]=':';
  buffer[16-1]=(second>>4)+0x30;
  buffer[17-1]=(second&15)+0x30;
  buffer[18-1]=0;

  if(input!=NULL)
    strcpy(input,buffer);
 return(buffer);
}

unsigned todec(unsigned hex)
{
   return((hex&15)+((hex>>4)&15)*10/*+((hex>>8)&15)*100L+((hex>>12)&15)*1000L*/);
}

void beep(long freq)
{
  long v;
  char low,high;

  if(!freq)
    outp( 0x61, inp( 0x61 )&252);
  else
  {
    outp( 0x61, inp( 0x61 ) | 0x3 );

    v=1193180L/freq;

    low=(char)(v&255);
    high=(char)((v>>8)&255);

    outp(0x43,182);
    outp(0x42,low);
    outp(0x42,high);
  }
}
#endif
long free_disk_space(char *path,int total)
{
  struct diskfree_t free;
  char help[80];

  _fullpath(help,path, sizeof(help));

  if(_dos_getdiskfree( (int)toupper(help[0])-64, &free))
  {
    write_log(_fatal,"free_disk_space","error");
    exit(11);
  }

  if(!total)
  return( (long) free.avail_clusters
      * (long) free.bytes_per_sector
      * (long) free.sectors_per_cluster);
  else
  return( (long) free.total_clusters
      * (long) free.bytes_per_sector
      * (long) free.sectors_per_cluster);

}

char *tovtascii(char *s)
{ int i;
  for(i=0;s[i]!=0;i++)
   switch(s[i])
   {
    case '': s[i]='`';break;
    case '\\':s[i]='/';break;
    case '@': s[i]=0x80;break;
    case '': s[i]=123;break;
    case '': s[i]=124;break;
    case '': s[i]=125;break;
    case '': s[i]=91;break;
    case '': s[i]=92;break;
    case '': s[i]=93;break;
    case '': s[i]=126;break;
    case  21: s[i]=64; break;
    case 219: s[i]=127;break;
   }
  return s;
}

#endif

char *firstarg(char *s)
{
  int i;
  for(i=0;s[i];i++)
    if(s[i]!=32)
       break;
  return s+i;
}

char *nextarg(char *prevarg)
{
  int i;
  for(i=0;prevarg[i];i++)
    if(prevarg[i]==32)
      break;

  prevarg+=i;

  if(prevarg[0]==0)
    return prevarg;

  for(i=0;prevarg[i];i++)
    if(prevarg[i]!=32)
      break;
  prevarg+=i;

  return prevarg;
}

char *datestr(time_t time,int year)
// *************************************************************************
//
//   Legt das Datum (UNIX-Format) in einem String ab
//
// *************************************************************************
{
  static char datum[12];
  struct time t;
  struct date d;
  unixtodos(time,&d,&t);
  if(d.da_mon>12)
  { d.da_mon=1;            // Bugfix fr marode Borland-Bibliothek
    d.da_year++;
  }
  sprintf(datum,"%02d.%02d",d.da_day,d.da_mon);
  if(year)
    sprintf(datum+6,".%04d",d.da_year);
  return datum;
}

char *timestr(time_t time)
// *************************************************************************
//
//   Legt die Uhrzeit (UNIX-Format) in einem String ab
//
// *************************************************************************
{
  static char zeit[8];
  struct time t;
  struct date d;
  unixtodos(time,&d,&t);
  sprintf(zeit,"%02d:%02d",t.ti_hour,t.ti_min);
  return zeit;
}

char *zeitspanne(time_t zeit,int sekunden)
{
  long unsigned hours=zeit/3600;
  long unsigned days=hours/24;
  static char s[16];

  s[0]=0;

  if(sekunden)
  { if(sekunden==2)
    { if(zeit<180)
      {  sprintf(s,"%u.%u",(unsigned)(zeit/18),((((unsigned)zeit)%18)*4)/7);
          return s;
      }
      zeit/=18;
    }
    if(zeit<240)                        // unter 4min in Sekunden anzeigen
      sprintf(s,"%lds",zeit);
    else if(zeit<(4*60L*60))            // unter 4h in Minuten
      sprintf(s,"%ldm",zeit/60);
    else if(zeit<(4*24L*60L*60))
      sprintf(s,"%ldh",zeit/(60*60));   // unter 4Tagen in Stunden
    else if(zeit<(999*24L*60L*60))
      sprintf(s,"%ldd",zeit/(60L*60*24));
  }
  else
  { if(days>10000)
    { sprintf(s,"-:--");
      if(sekunden)
        strcat(s,"   ");
    }
    else
    { zeit-=hours*3600;
      hours-=days*24;

      if(days)
        sprintf(s,"%lu.",days);
      sprintf(s+strlen(s),"%02lu:%02lu",hours,zeit/60);
    }
  }
  return s;
}

#ifdef __MSDOS__
#define cpu_upd 10800L
long cpu_index(void)
{ static long cpuindex=0L;
  static long lastcall=-cpu_upd;
  if((timer()-lastcall)>cpu_upd)
  {  long tic=timer();
    int i=0,j=0;
    lastcall=timer();
    while(tic==timer()) j++;
    tic=timer();
    while(tic==timer())
    { i++;
      for(j=1;j<1200;j++);
    }
    if((tic+1)==timer() && i>cpuindex)
     cpuindex=i;
  }
  return cpuindex;
}
#endif

int accessp(char *p,char *f)
{
 char path[256];
 subst(p,'/','\\');
 if(p[strlen(p)-1]!='\\')
  strcat(p,"\\");

 sprintf(path,"%s%s",p,f);
 return access(path,0);
}
