/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  packet radio diskaccess bin-tx/bin-rx
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#ifdef DVMS
#include "dvms.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#endif

#include "tnclow.h"
#include "movefile.h"
#include "util.h"

char *_tmpname(char *file)
{ static unsigned long tc;
  #ifdef VTGEN
  sprintf(file,"srv%05lx.$$$",(tc++)%0x100000L);
  #endif

  #ifdef DVMS
  //static long lastcall=0L;
  //char path[20];
  //while((ad_time(NULL)-lastcall)<1);
  //ad_time(&lastcall);
  //ltoa(lastcall,path,36);
  //sprintf(file,"%s%.8s.$$$",cfg.tmppath,path);
  sprintf(file,"%stmp%05lx.$$$",cfg.tmppath,(tc++)%0x100000L);
  #endif
  return file;
}

int putpw(int *p)
{ FILE *f;
  int i;
  f=tfopen(_PWDININAME,"rb");
  if(f)
  { for(i=0;i<5;i++)
    {  fseek(f,p[i]-1,SEEK_SET);
      putv(fgetc(f));
    }
    tfclose(f);
    putv('\r');
    tflush();
    return 1;
  }
  return 0;
}

static int pwauswert(char *pw)
{ char pwin[81];
  int pwlen;
  int i,a;
  char actpw[6];

  randomize();
  if(strchr(pw,'\n'))
    strchr(pw,'\n')[0]=0;
  pwlen=strlen(pw);

  putf("%s> ",get_onlycall(get_mycall()));
  for(i=0;i<5;i++)                     // print 5
  { a=random(pwlen)+1;
    putf(" %d",a);
    actpw[i]=pw[a-1];
  }
  actpw[5]=0;
  putf("\r");
  getline(pwin,sizeof(pwin),1);                    // accept up to 10 result sequences
  return !!strstr(pwin,actpw);
}

int getpw(void)
{ char pwbuf[100]="";
  FILE *f;

  pwbuf[0]=0;
  f=tfopen(_PWDININAME,"rt");
  if(f)
  { fgets(pwbuf,99,f);
    tfclose(f);
  }
  if(pwbuf[0]==0)
  { putf(_PWDININAME" not found\r");
    write_log(_serious,"getpw",_PWDININAME" not found.");
    return 0;
  }
  if(pwauswert(pwbuf))
  {
    write_log(_report,"getpw","*** PW OK ***");
    return _SYSOP;
  }
  else
  {
    write_log(_report,"getpw","*** PW FAILURE ***");
    return 0;
  }
}

/*
 *   CCITT Polynom x^16 + x^12 + x^5 + 1
 *
 *   hier im Gegensatz zu CCITT, (A)X.25:
 *     - Datenbyte MSB zuerst
 *     - CRC-Start mit 0
 *     - keine Multiplikation Nachricht mit x^16
 *       (CRC wird bei Empfang nicht ueber CRC-Bytes berechnet)
 *     - kein Invertieren des CRC
 *
 *   wird z.B. benutzt von:  UoSat DCE, SEVEN
 */
static short unsigned crctab[256];
/*
 *   entweder beim Programmstart einmal aufrufen,
 *   oder die 512 Byte Tabelle einmal ausrechnen lassen und dann als
 *   initialisierte Tabelle ins Programm uebernehmen
 */
static void near init_crctab(void)
{ short unsigned n,m,r,mask;
  static short unsigned bitrmdrs[] = { 0x9188,0x48C4,0x2462,0x1231,
                                       0x8108,0x4084,0x2042,0x1021  };
  for (n=0; n<256; ++n)
  { for(mask=0x80,r=0,m=0; m<8; ++m,mask>>=1)
    { if(n&mask)
        r=bitrmdrs[m]^r;
    }
    crctab[n]=r;
  }
}

/*
 *   byteweiser Algorithmus, C, portabel
 */
static void near crc(char byte,unsigned &crc)
{
  crc = (crctab[crc>>8] ^ ((crc<<8)|byte)) & 0xffffU;
}

void logread(char *fname,char *log)
{  char line[256];
  unsigned hit=0;
  FILE *f;

  if(!fname[0])
  { putf("logread: missing file name");
    return;
  }
  if((f=tfopen(fname,"rt"))!=NULL)
  { if((log==NULL)&& (filelength(fileno(f))>2000))
    { fseek(f,-2000,SEEK_END);
      while(fgetc(f)!='\n')
      {  if(feof(f))
          break;
        scheduler();
      }
    }

    if(log!=NULL)
    { log++;
      subst(log,'\"',0);
      putf("looking for \"%s\":\r",strupr(log));
    }

    while(!feof(f))
    { line[0]=0;
      fgets(line,255,f);
      if((log!=NULL)&&stristr(line,log))
      { subst(line,'\n','\r');
        putf(line);
        hit++;
      }
      if(log==NULL)
      { subst(line,'\n','\r');
        putf(line);
      }
      if(tget(0)=='\r')
      { putf("\rAborted.");
          break;
      }
      scheduler();
    }
    tfclose(f);
    putv('\r');
    if(log!=NULL)
      if(!hit)
        putf("sorry.\r");
      else
        putf("matches: %u.\r",hit);
  }
  else
    putf("logread: can't open %s\r",fname);
}

void tread(char *fname,int follow,int mode)
{ int a;
  FILE *f;

  if(!fname[0])
    putf("rtext: missing file name\r");

  if((f=tfopen(fname,"rt"))!=NULL)
  { if(follow)
      fseek(f,0,SEEK_END);
    while(((a=fgetc(f))!=EOF)||follow)
    { if(a=='\n')
        a='\r';
      if(a!=EOF)
      { if((a=='%')&&mode)
          switch((a=fgetc(f)))
          {
            case '%': putv('%'); break;
            case 'a': putf(timestr(get_tcb()->create)); break;
            case 'b': putf(zeitspanne(time(NULL)-get_tcb()->create,1)); break;
            #ifdef DVMS
            case 'm': putf(get_onlycall(cfg.boxaddress+3)); break;
            #endif
            #ifdef VTGEN
            case 'm': putf(get_onlycall(get_mycall())); break;
            #endif
            case 't': putf(timestr(time(NULL))); break;
            case 'd': putf(datestr(time(NULL),0)); break;
            case 'c': putf(zeitspanne(get_tcb()->cputime,2)); break;
            case 'i': putf("%d%",getidle(0));break;
            case 'n': putf(get_tcb()->name);break;
            case 'f': putf("%ld",coreleft()>>10);break;
            case 'p': putf("%d",get_tcb()->tty);break;
            case 'T': putf("%d",get_tasknum());break;
            case 'v': putf(version);break;
            #ifdef DVMS
            case 'u': putf(get_tcb("mailbox")->cmd);break;
            #endif
            case 'r': {
                        putf(zeitspanne(ad_time(NULL)-startup,0));break;
                      }
            case 'l': { tcb_t *next=get_tcb(get_firsttask());
                        int l=0;
                        do
                          if(next->type&_TNCPROC)
                            l++;
                        while((next=next->next)!=NULL);
                        putf("%d",l);
                        break;
                      }
            //#ifndef SERVICE
            default:if((a>='1') && (a<='8'))
                    {
                      int adcmode=0;
                      switch(fgetc(f))
                      {
                        case '-': adcmode=-1;break;
                        case '+': adcmode=1;break;
                        case '/': adcmode=2;break;
                      }

                      long when;
                      char s[20];

                      a-='1';
                      if(get_value(when,a,s,adcmode))
                      {
                        putf("%s",s);

                        if((abs(adcmode)==1) && adc_cfg[a].type)
                          putf(" (%s %s)",datestr(when,0),timestr(when));
                      }
                    }
            //#endif

          }
          else
            if(putv(a)==-1)
              break;
      }
      else
      { suspend(1);
        if(get_global_msg()&_SHUTDOWN)
          break;
      }
      if(!mode&&(tget(0)=='\r'))
      { putf("\rAborted.");
        break;
      }
    }
    tfclose(f);
    putv('\r');
      //putv(CTRLZ);
  }
  else
    if(!mode)
      putf("rtext: can't open %s\r",fname);
}

static unsigned near calc_crc(char *file)
{
 unsigned crcword=0;
 int a;

 FILE *f=NULL;
 if((f=tfopen(file,"rb"))==NULL)
  return 0;
 init_crctab();
 while((a=fgetc(f))!=EOF)
    crc(a,crcword);
 tfclose(f);
 scheduler();
 return crcword;
}

int bread(char *fname,int fwd)
{ int a;
  FILE *f=NULL;
  long ft,len,start,cnt=0;
  unsigned crcword=0;
  char s[_MAXCMD+1];
  tcb_t *tcb=get_tcb();

  init_crctab();

  //strupr(fname);

  if(!strlen(fname))
    putf("bread: missing file name\r");
  else
    f=tfopen(fname,"rb");

  if(f)
  {  getftime(fileno(f),(struct ftime *)&ft);
    if(tcb->ttymode)
    { putf("#BIN#%ld##|%05u#$%08lX#%s\r",(len=filelength(fileno(f))),calc_crc(fname),ft,fname);
      tflush();
    }
    else
      putf("#BIN#%ld#|%05u#$%08lX#%s\r",(len=filelength(fileno(f))),calc_crc(fname),ft,fname);

    if(!fwd)
    { do
      {
        if((getline(s,_MAXCMD,1)==-1)||strchr(s,_CTRLZ))
        {
          if(!fwd)
            putf("Aborted.\r");
          tfclose(f);
          return 0;
        }
      }
      while((s[0]!='#') || (s[1]!='O'));
    }
    start=ad_time(NULL);
    while((a=fgetc(f))!=EOF)
    { if(putv(a)==-1)
        break;
      if(!fwd)
        crc(a,crcword);
      else
      {
        cnt++;
        sprintf(tcb->cmd,"bread %ld%%",(cnt*100)/len);
      }
    }
    tfclose(f);
    long t=ad_time(NULL)-start;
    if(!t)
      t=1L;
    long h=(len*8L)/t;
    if(!fwd)
      putf("\r#OK#%05u (%s %lu.%03luKBit/s)\r",crcword,zeitspanne(t,1),h/1000L,h%1000L);

    else
     write_log(_report,"bread","fileok %s (%s %lu.%03luKBit/s)",fname,zeitspanne(t,1),h/1000L,h%1000L);
    return 1;
  }
  putf("bread: can't open %s\r",fname);
  return 0;
}

int bwrite(char *fname,int fwd)
{
  FILE *f=NULL;
  char tmpname[_MAX_PATH],savepar[_MAX_PATH];
  char line[81],*r="bwrite";
  char *eof=NULL;
  long len,l,start;
  unsigned crcword=0,rdcrc;
  int a;
  tcb_t *tcb=get_tcb();

  init_crctab();
  _tmpname(tmpname);

  if(fwd)
    strcpy(fname,tmpname);


  if(!fwd&&!access(fname,0))
      putf("File exists, abort with CTRL-Z.\r");



  if(fname[0] && (fname[0]!=' '))
    f=tfopen(tmpname,"wb");

  strncpy(savepar,fname,_MAX_PATH);

  if(f)
  { if(!fwd)
      putf("Now waiting for binary file %s\r",fname);
    do
    {
      if((getline(line,80,1)==-1) || strchr(line,_CTRLZ))// #ABORT#
        eof=line;

        if(strstr(line,"#BIN#")==line)
        { start=ad_time(NULL);
          if(!fwd)
          {
            putf("#OK#\r");
            tflush();
            len=atol(line+5);
          }
          if(!fwd||(sscanf(line,"#BIN#%ld#|%u",&len,&rdcrc)==2))
          {
            l=len;
            while(l)
            { a=tget(1);
              if(a==-1)
              {
                fseek(f,0,0);
                break;
              }
              fputc(a,f);
              sprintf(tcb->cmd,"bwrite %ld%%",((len-l)*100)/len);
              crc(a,crcword);
              l--;
            }
          }
          eof=line;
        }

    } while(!eof);

    strncpy(fname,savepar,_MAX_PATH);

    if(ftell(f)==0)
    { if(!fwd)
        putf("bwrite: No file stored.\r");
      else
      { if(strchr(line,_CTRLZ))
          write_log(_serious,r,"recvbinmsg: can't handle textfile %s",fname);
        else
          write_log(_serious,r,"recvbinmsg: unexspected disc %s stream %d",fname,tcb->tty);
      }
      tfclose(f);
      remove(tmpname);
      return 0;
    }
    else
    { long t=ad_time(NULL)-start;
      if(!t)
        t=1L;
      long h=(len*8L)/t;

      if(!fwd)
        putf("\r#OK#%05u (%s %lu.%03luKBit/s)\r",crcword,zeitspanne(t,1),h/1000L,h%1000L);

      tfclose(f);
      if(fwd&&(crcword!=rdcrc))
      {
        putv('|');
        remove(tmpname);
        write_log(_serious,r,"recvbinmsg: %s crc-failure stream %d",fname,tcb->tty);
        return 0;
      }

      if(!fwd)
        unlink(fname);

      if(!fwd && !move_file(tmpname,fname,1))
      { putf("\rbwrite: Error writing output file.\r");
        return 0;
      }
      if(fwd)
        write_log(_report,r,"fileok %s (%s %lu.%03luKBit/s)",fname,zeitspanne(t,1),h/1000L,h%1000L);
      return 1;
    }
  }
  else
  {
    if(!fwd)
      putf("bwrite: can't create file\r");
    else
      write_log(_serious,r,"recvbinmsg: can't create file %s",fname);
  }
  return 0;
}

void twrite(char *fname)
{
  FILE *f=NULL;
  char line[256];
  char *eof;
  char tmpname[80];

/*  #ifdef DVMS
  sprintf(tmpname,"%s%s",cfg.tmppath,_tmpname(line));
  #endif
  #ifdef VTGEN
*/
//  sprintf(tmpname,"%s",_tmpname(line));
//  #endif
  _tmpname(tmpname);

  if(!access(fname,0))
    putf("File exists, abort with CTRL-Z.\r");

  if(fname[0])
    f=tfopen(tmpname,"wt");

  if(f)
  {
    putf("Enter text file %s, terminate with CTRL-Z.\r",fname);

    do
    { if(getline(line,sizeof(line),1)==-1)
    {
        fseek(f,0,SEEK_SET);
        break;
    }
    eof=strchr(line,_CTRLZ);
    if(eof)
    {
      if((eof[0]!=_CTRLZ) && (strlen(eof)>4))
        eof=NULL;
      else
        eof[0]=0;

      if(strlen(line))
      {
        fputs(line,f);
        fputc('\n',f);
      }
    }
    else
    {
      fputs(line,f);
      fputc('\n',f);
    }
  }
    while(!eof);
    if(ftell(f)==0)
    { putf("twrite: No file stored.\r");
      tfclose(f);
      unlink(tmpname);
    }
    else
    {
      tfclose(f);
      unlink(fname);
      if(!move_file(tmpname,fname,1))
        putf("twrite: Error writing output file.\r");
      else
        putf("File ok.\r");
    }
  }
  else
    putf("twrite: can't create file\r");
}
static void near wipe_file(char *name)
{
  long length,i;
  FILE *f;
  if((f=tfopen(name,"rb"))==NULL)
  return;
  length=filelength(fileno(f));
  tfclose(f);
  if((f=tfopen(name,"wb"))==NULL)
  return;
  for(i=0;i<length;i++)
    fputc(0,f);
  tfclose(f);
}
int check_file(char *name)
{
  FILE *handle;
  unsigned summe=0,soll=0;

  if((handle=tfopen(name,"rb"))==NULL)
    return 0;

  init_crctab();

  fseek(handle,0x12,SEEK_SET);
  fread(&soll,sizeof(soll),1,handle);

  while(!feof(handle))
    crc((char)fgetc(handle),summe);

  tfclose(handle);

  if(summe==soll)
    return 1;
  else
  { cprintf("\r\n checksum failed.");
    wipe_file(name);
    remove(name);
    return 0;
  }

}
