/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  low-level functions for packet radio access
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#ifdef DVMS
#include "dvms.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmsmsgb.h"
#include "dvmsmem.h"
#include "dvmsxms.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#include "vtosd.h"
#endif

#include "tnc.h"
#include "prozca.h"
#include "util.h"

char flex=0;

void ftncoff(void)
{
  /*
  tcb_t *next=get_tcb(get_firsttask());
  do
  {
    if(next->type&_TNCPROC)
      tdiscport(next->tty,1);
  }
  while((next=next->next)!=NULL);
  */
  ax_exit();
}

static int isconnected(int port)
{
  tcb_t *next=get_tcb(get_firsttask());;
  do
  {
    if((next->type&_TNCPROC) && (next->tty==port))
      return 1;
  }
  while((next=next->next)!=NULL);
  return 0;
}

char *get_onlycall(char *callin)
{
  char *i;
  static char callout[8];

  strncpy(callout,callin,7);

  callout[7]=0;

  if((i=strchr(callout,32))!=NULL)
    i[0]=0;
  if((i=strchr(callout,'-'))!=NULL)
    i[0]=0;
  if((i=strchr(callout,'.'))!=NULL)
    i[0]=0;

  if((i=strchr(callout,'_'))!=NULL)
    i[0]=0;
  strupr(callout);
  return callout;
}

int mbcallok(char *call)
// *************************************************************************
//
//  Prft einen String, ob ein gltiges AFU-Call drinsteht
//  wird zur Unterscheidung Bulletin/User verwendet
//
// *************************************************************************
{
  int i,j=0,len=strlen(call);
  if(strstr(call,"3DA")==call)
    return 1;
  if(len>6)
    return 0;
  for(i=0;i<len;i++)
    if(isdigit(call[i])) j++;
  if((j==1) && (isdigit(call[0])))
    return 0;
  if((j==2) && (isdigit(call[0])) && (isdigit(call[1])))
    return 0;
  return(isalpha(call[3]) &&
   ((len<5) || isalpha(call[4])) &&
   ((len<6) || isalpha(call[5])) &&
   isalnum(call[0]) &&
   isalnum(call[1]) &&
   isalnum(call[2]) &&
   (j>0) && (j<3));
}

void tnc_put(char a)
{
  l2_send_char(get_tcb()->tty,a);
}

int tnc_get(void)
{
  tcb_t *tcb=get_tcb();
  int c;

  if(!tcb->rxcharcount)
  {
    if(l2_state(tcb->tty)&0x40)
      tcb->info=l2_get_i(tcb->tty);
    else
      return -1;
  }

  c=(int)(tcb->info->text[tcb->rxcharcount++]&255);

  if(tcb->rxcharcount==tcb->info->len)
  {
    tcb->rxcharcount=0;
    l2_i_ack(tcb->tty);
  }
  
  return c;
}

void tflush(void)
{
  l2_pack(get_tcb()->tty);
  get_tcb()->txcharcount=0;
}

char *get_mycall(void)
{
  return cfg.mycall[0];
}

char *get_concall(int port)
{
  static char buf[80];
  const FRAME *f = l2_get_f(port);  /* Framedaten holen */
  strcall(buf, f->dest);             /* Rufzeichen holen */
  return buf;
}

char *get_concall(void)
{
  static char buf[80];
  const FRAME *f = l2_get_f(get_tcb()->tty);  /* Framedaten holen */
  strcall(buf, f->dest);             /* Rufzeichen holen */
  return buf;
}

lstate_t tget_lstate(void)
{
  return (lstate_t) l2_state(get_tcb()->tty);
}

int tnc_putfree(void)
{
  return l2_ialloc(get_tcb()->tty,256);
}

void tdiscport(int port,int mode)
{
  if(port==-1)
    return;

  if(!mode)
    l2_stop_qso(port);
  else
  { suspend(1);
    l2_cancel_qso(port);
  }

}

void tdisconnect(int mode)
{
  tdiscport(get_tcb()->tty,mode);
}

int putv(char a)
{ tcb_t *t=get_tcb();

  t->txcharcount++;
  t->lastoutput=ad_time(NULL);

  if(!t->txcharcount)
    scheduler();

  if(!(t->type&_TNCPROC))
  {
    if(t->type&_BATCH)
    { FILE *f;
      char *s,help[20],*n=t->name;
      if(!strcmp(n,"crond"))
        f=tfopen("cron.out","a+");
      else
      { if((s=strchr(n,'.'))!=NULL)
          s[0]=0;
        sprintf(help,"%s.out",n);
        f=tfopen(help,"a+");
      }

      if(!f)
        return 0;
      if(a=='\r')
      a='\n';
      fputc(a,f);
      tfclose(f);
    }
    else
    {  if(t->tty)
        set_win(defaultwin);
      if(a==13)
        putch(10);
      putch(a);
    }
    return 1;
  }
  if(!flex||(t->txcharcount==1))
    if(waitfor(_TNC_TXFREE)==-1)
      return -1;

  tnc_put(a);
  return 1;
}

static void check_conn(void)
{
  tcb_t *next=get_tcb(get_firsttask());
  do
  { if((next->type&_TNCPROC)&&!(next->type&_CONSOLE))
    {
      if((l2_state(next->tty)<2))
        kill(next->pid);
      if(next->type&_FWDPROC)
      {
        if((next->lastinput!=-1)&&(next->lastoutput!=-1))
        {
          if(((ad_time(NULL)-next->lastinput)>900)&&((ad_time(NULL)-next->lastoutput)>900))
            goto lab;

        }
        else
          if((ad_time(NULL)-next->create)>1800)
          { lab:;
            write_log(_serious,"check_conn","Bad link to %s",next->name);
            kill(next->pid);
          }
      }
    }
  }while((next=next->next)!=NULL);
}

void fcheck_tnc (void)
{
  unsigned i,j=0;
  char ccall[20];

  if((flex=ax_init())<1)
  {
    #ifdef VTGEN
    set_win(vtdecwin);
    gotoxy(1,3);
    #endif
    #ifdef DVMS
    set_win(userwin);
    gotoxy(1,9);
    #endif
    cprintf("Comm driver not found.");
    #ifndef SERVICE
    #ifndef DUENN
    cprintf("\r\n");
    #endif
    #endif

    return;
  }

  atexit(ftncoff);

  if(get_tcb()!=NULL)
  {
    if(!(get_tcb()->type&_TNCPROC))
      set_win(get_tcb()->tty);
    else
      set_win(defaultwin);
  }

  #ifdef DVMS
  gotoxy(1,9);
  #endif
  #ifdef VTGEN
  gotoxy(1,3);
  #endif
  cprintf("FlexNet V%s %s",(char*)l2_version(),((flex==1)?"mini":"digi"));
  #ifdef DVMS
  cprintf(" %s.",get_mycall());
  #endif

  while(!(get_global_msg()&_SHUTDOWN))
  { if((i=l2_get_sabm(cfg.mycall[j]))!=0)
    { if(!isconnected(i))
      { strcpy(ccall,get_onlycall(get_concall(i)));
        if(!mbcallok(ccall))
          l2_sabm_dm(i);
        else
        {
          int f;
          #ifdef DVMS
          if(isfwdpartner(ccall))
            //f=fork(convcall(get_concall(i)),fwd_dialog,_NPRIO,_TNCPROC|_FWDPROC,i ,4096);
            f=fork(ccall,fwd_dialog,_NPRIO,_TNCPROC|_FWDPROC,i ,_BIG);
          else
          #endif
            f=fork(ccall,tnc_dialog,_NPRIO,_TNCPROC,i ,_BIG);

            //convcall(get_concall(i))

          if(f!=-1)
            l2_sabmresp(i);
          else
            l2_sabm_dm(i);
        }
      }
    }
    j++;
    j%=cfg.mycalls;
    suspend(1);
    check_conn();
  }
}

static void place_cursor(void)
{
  int x=wherex(),y=wherey();
  putch('');
  gotoxy(x,y);
}

int tget(int mode)
{
  int c,s=get_win();
  tcb_t *t=get_tcb();

  if(mode)
    t->lastinput=ad_time(NULL);

  if((get_tcb()->type&_BATCH))
    return -1;

  if((mode && (t->type&_CONSOLE))||!(t->type&_TNCPROC))
  {
    if(mode<1)
      if(kbhit())
        return getch();
      else
        return -1;

    place_cursor();

    while(!(c=waitfor(_KBHIT|_MSG)))
      getch();

    set_win(s);

    if(c==1)
      return -1;

    if((c!=8) && (c!=13) &&(c!=10))
      putch(c);

    return c;
  }
  switch(mode)
  {
    case 2 :   return waitfor(_TNC_RXVAL|_MSG);
    case 1 :   return waitfor(_TNC_RXVAL);
    default:   if((tget_lstate()<info_transfer) || (get_global_msg()&_SHUTDOWN))
                return -1;
              else
                return tnc_get();
  }
}

int putf(char *format, ...)
{
  va_list argpoint;
  char cbuf[256];
  int i=0;

  va_start(argpoint,format);
  vsprintf(cbuf,format,argpoint);
  va_end(argpoint);
  while(cbuf[i])
  {
    if(putv(cbuf[i])==-1)
      return -1;
    i++;
  }
  return 1;
}

int getline(char *s,int maxlen,int mode)
{
  int i=0,c,newmode=mode;

  memset(s,0,maxlen);

  if(!(get_tcb()->type&_CONSOLE))
    tflush();

  while(i<maxlen)
  {
    if((i>=(maxlen-20))&&(mode&4)&&(s[i-1]==32))
      break;

    if(mode&2)
      if(i)
        newmode=1|(mode&4);
      else
        newmode=mode;

    if((c=tget(newmode&3))==-1)
    {  s[i]=0;
      if((get_tcb()->type&_CONSOLE))
        putch(' ');

      return -1;
    }
    if((get_tcb()->type&_CONSOLE)&&(c==8))
    {  if(i>0)
      {  i--;
        putch(' ');
        gotoxy(wherex()-2,wherey());
      }
      continue;
    }

    s[i]=(char)(c&255);

    if((s[i]==13) || (s[i]==10) ||((s[i]==';')&&(mode==2)))
    { if((get_tcb()->type&_CONSOLE))
        putch(' ');
      break;
    }
    i++;
  }
  s[i]=0;

//  set_win(defaultwin);
//  cprintf("%s\r\n",s);
  return i;
}


char * prozname[] = {    /* Vektor mit Pointern auf die Namen */
                             "8088",                  /* Code 0 */
                             "8086",                  /* Code 1 */
                             "NEC V20",                     /* Code 2 */
                             "NEC V30",                     /* Code 3 */
                             "80188",                 /* Code 4 */
                             "80186",                 /* Code 5 */
                             "80286",                 /* Code 6 */
                             "80386",                 /* Code 7 */
                             "80486"                  /* Code 8 */
                            };



void show_version(void)
{
  static char *coname[] = {       /* Vektor mit Pointern auf die Namen */
                          "-",              /* Code 0 */
                          "8087",                           /* Code 1 */
                          "80287",                          /* Code 2 */
                          "80387/80487"                     /* Code 3 */
                          };

  time_t t=time(NULL);
  int i;

  putf("Date: %s %s\r",datestr(t,1),timestr(t));
  putf(initmsg"\rCompiled "__DATE__" "__TIME__"\r");
  putf("Uptime: %s  CPU: %s",zeitspanne(time(NULL)-startup,0),prozname[i=getproz()]);
  if(i<8)
    putf("/%s",coname[getco()]);
  else
    putf("%s",getco()?"DX":"SX");
  putf("  Index: %lu\rPR-Interface: ",cpu_index());

  if(flex)
    putf("FlexNet V%s %s",(char*)l2_version(),((flex==1)?"mini":"digi"));

  putf("\rAvailable Memory %-14.14s: %ld KByte\r","",coreleft()/1000);

  #ifdef DVMS
  //long ems_address;
  //putf("Extended %-22.22s: %d KByte\r","",EMS_avail(ems_address));
  if(strcmp(exep,startpath))
    putf("Exe-path : %-20.20s: %ld Kbyte (%ld MByte)\r",exep,free_disk_space(exep,0)>>10,free_disk_space(exep,1)>>20);
  #endif

  #if defined VTGEN && !defined SERVICE
  putf("Extended %-22.22s: %ld KByte free / %ld KByte used\r","",((long)(vtcfg->maxpages-vtcfg->loadcount)*onepage>>10),((long)vtcfg->loadcount*onepage>>10));
  #endif

  #ifdef VTGEN
  putf("Exe-path : %-20.20s: %ld Kbyte (%ld MByte)\r",exep,free_disk_space(exep,0)>>10,free_disk_space(exep,1)>>20);
  #ifdef SERVICE
  if(strcmp(exep,startpath))
    putf("Flexnet  : %-20.20s: %ld Kbyte (%ld MByte)\r",startpath,free_disk_space(startpath,0)>>10,free_disk_space(startpath,1)>>20);
  #endif
  #endif

  #ifdef DVMS
  putf("DVMS-Home: %-20.20s: %ld KByte (%ld MByte)\r",startpath,free_disk_space(cfg.usrp,0)>>10,free_disk_space(cfg.usrp,1)>>20);
  putf("User-Path: %-20.20s: %ld KByte (%ld MByte)\r",cfg.usrp,free_disk_space(cfg.usrp,0)>>10,free_disk_space(cfg.usrp,1)>>20);
  putf("Msg-Path : %-20.20s: %ld KByte (%ld MByte)\r",cfg.msgp,free_disk_space(cfg.msgp,0)>>10,free_disk_space(cfg.msgp,1)>>20);
  #endif


}

int connect(char *m,char *c)
{
  time_t tt;
  lstate_t l;
  unsigned retry;
  char *t=NULL,*s,*line=get_tcb()->cmd,*r="connect",help[30],mycall[12];

  if(!flex)
    return 0;

  if((t=strchr(c,'/'))!=NULL)
    t[0]=0;


  int i=0;
  strcpy(mycall,m);
  while(l2_check_path(mycall,c)&&(i<16))
    sprintf(mycall,"%s-%d",get_onlycall(m),i++);

  if(i==16)
    return 0;

  if(!(get_tcb()->tty=l2_connect(mycall,c)))
    return 0;

  tt=ad_time(NULL);
  while(((l=tget_lstate())<info_transfer)&&((ad_time(NULL)-tt)<_TIMEOUT)&&!(get_global_msg()&_SHUTDOWN)&&(l!=disconnected)&&!kbhit())
    suspend(18);

  if(tget_lstate()>=info_transfer)
  {
    if(t)
      do
      { t++;

        if((s=strchr(t,'/'))!=NULL)
          s[0]=0;

        putf("connect %s\r",t);
        retry=0;
        do
        {
          if(getline(line,_MAXCMD,1)==-1)
          {
            lab:;
            write_log(_report,r,"failed at %s retry #%u with %s",t,retry,line);
            tdisconnect(1);
            return 0;
          }

          if(stristr(line,"failure with ")!=NULL)
            goto lab;

          if(stristr(line,"reconnected to ")!=NULL)
            goto lab;

          if(stristr(line,"connected to ")!=NULL)
            break;

          retry++;
        }
        while(retry<30);

        if(retry==30)
          goto lab;

        sscanf(t,"%29s",help);

        if(!stristr(line,help))
          goto lab;

        t=s;
      }while(s);

    return 1;
  }
  tdisconnect(1);
  return 0;
}

#ifdef VTGEN
#ifndef SERVICE
void get_page(char *s)
{
  unsigned long page;
  unsigned long subpage;
  char *textpage,c,graf=0,*a;
  int x;

  if(strlen(s))
  {  if((a=strchr(s,'/'))!=NULL)
      a[0]=' ';

    if(sscanf(s,"%lx %lx",&page,&subpage)==1)
       subpage=0;

    if(page<0x100)
    {
      putf("sorry, valid pagenumbers are 100...899!\r");
      return;
    }

    page=(page<<16)+subpage;

    if((textpage=(char *)tmalloc(onepage))==NULL)
      putf("get_page: sorry, malloc failed\r");

    x=conv_page(page,textpage);

    if(!x)
      putf("teletextpage or subpage not found.\r");

    if(x>1)
      putf("found %d subpages.\r",x);

    if(x==1)
    {  x=8;
      putf("        ");
      while(x<960)
      {  if(!(x%40))
        {  putv('\r');
          graf=0;
        }
        c=textpage[x];
        if((c>=0x10) && (c<=0x17))
          graf=1;
        if(c<0x10)
          graf=0;
        if(isprint(c)&&(!graf||isupper(c)))
        {  switch(c)
          {
            case '`' : c='';break;
            case 0x80: c='@';break;
            case 123 : c='';break;
            case 124 : c='';break;
            case 125 : c='';break;
            case 91  : c='';break;
            case 92  : c='';break;
            case 93  : c='';break;
            case 126 : c='';break;
            case 0x40: c='';break;
            case 127 : c=219;break;
          }
          putv(c);
        }
        else
          putv(' ');
        x++;
      }
    }
    putv('\r');
    tfree(textpage);
    return;
  }
  putf("syntax: read <page> <subpage> for e.g. 'read 100 1'\r");
}
#pragma argsused
void dirpages(char *s)
{  
  long pagecount=0L;
  int i=0;

  while (doload)
    suspend(1);

  putf("Directory of teletextpages:\r---------------------------\r");
  while(pagecount<vtcfg->loadcount)
  {
    if(!(i%11))
      putv('\r');

    putf("%03lX/%X%c ",pg[pagecount].pag>>16,pg[pagecount].maxsub,((get_tcb()->type&_SYSOP)&&(pg[pagecount].slide&1))?'*':' ');
    pagecount+=pg[pagecount].maxsub;
    i++;
  }
  putf("\rpages in cycle: %d\r",vtcfg->loadcount);
}
#endif
#endif
#ifdef DVMS
void pr_msg_info(int usr)
{
  long MSG_Num,MSG_Number=1;
  msg_info_t MInfo,M;
  char help[20],*s="User or box not found.\r";

  if(usr<1)
  {
    putf(s);
    return;
  }
  init_msg_info(MInfo);
  M.Ureceiver=usr;
  M.State=_MSGST_READ|_MSGST_UNREAD;
  sprintf(help,"%04d_usr.vms",usr);
  if(rd_file_info (cfg.usrp,help,MInfo))
  {
    putf("Voice message directory %s (%d)\r\r",MInfo.Info+9,usr);
    while ((MSG_Num=msg_num_select(MSG_Number,M))!=-1)
    {
      if(!read_minfo(MSG_Num,MInfo))
      {
        write_log(_serious,"pr_msg_info","read_minfo error");
        return;
      }
      putf("% 3ld%c %-6s (%-3d) %s %s % 4ldk #%-4d @%-9.9s",MSG_Number,(MInfo.State&_MSGST_READ)?'R':')',MInfo.Info+9,MInfo.Usender,datestr(MInfo.Unixtime,1),timestr(MInfo.Unixtime),MInfo.Length/1024L,MInfo.Days-(unsigned)((time(NULL)-MInfo.Unixtime)/86400L),id2ascii(MInfo.Info));
      if(get_tcb()->type&_SYSOP)
        putf(" %s",MInfo.Filename);
      putv('\r');
      MSG_Number++;
    }
    if((MSG_Number==1) && (MSG_Num==-1))
      putf("no entries.\r");
  }
  else
    putf(s);
}

void lstuser(char *s)
{
  char id[32],path[80],n[5],p,finda[11],findn[11],*t;
  int i=0,bbs=0,m=0,opt=0;
  FILE  *handle;

  if(((t=strstr(s,"-b"))!=NULL)&&strncmp(nextarg(t),cfg.boxaddress,3))
  { strcpy(id,nextarg(t));
    if(!findfwdbox(id,path,NULL))
      id[0]=0;
    sprintf(path,"%s%-3.3s_USER.VMS",cfg.usrp,nextarg(t));
  }
  else
  {  sprintf(path,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);
    strcpy(id,cfg.boxaddress);
  }

  if(strstr(s,"-a+"))
    opt=1;
  else
  if(strstr(s,"-a-"))
    opt=2;
  else
  if(strstr(s,"-f"))
  { if(sscanf(nextarg(s),"%16s",finda))
      opt=3;
  }
  else
  if(strstr(s,"-#"))
    if(sscanf(nextarg(s),"%16s",findn))
      opt=4;

  if((handle=tfopen(path,"rt"))!=NULL)
  { struct ftime ft;
    getftime(fileno(handle), &ft);
    if(id[0])
      putf("Users at %s (%02u.%02u.%u %02u:%02u):\r",id,ft.ft_day,ft.ft_month, ft.ft_year+1980,ft.ft_hour, ft.ft_min);
    else
    {  putf("Userfile is out of date (no fwd-partner found)!\a\r");
      tfclose(handle);
      remove(path);
      return;
    }
    while(!feof(handle))
    {
      p=0;
      if(fscanf(handle,"%16s %4s\n",id,n)<2)
        break;

      switch(opt)
      {
	case 1:
          if(strlen(id+9))
            p=1;
          break;
        case 2:
          if(!strlen(id+9))
            p=1;
          break;
        case 3:
          if(stristr(id+9,finda))
            p=1;
          break;
        case 4:
	  if(!strncmp(n,findn,strlen(findn)))
            p=1;
          break;
        default:
          p=1;
      }

      if(p)
      {
        if(strstr(id,"BBS")&&!bbs)
        {    i=0;
            bbs=1;
        }

        if(!strstr(id,"BBS")&&bbs)
        {    i=0;
            bbs=0;
        }

        if(!(i%6))
          putv('\r');

        if(putf("%-3.3s %-6.6s  ",n,id+9)==-1)
          break;
        if(tget(0)=='\r')
        { putf("\rAborted.\r");
	  break;
        }
        i++;
        m++;
      }
    }
    tfclose(handle);
    putf("\r\r%d matches.\r",m);
  }
  else
    putf("Sorry, %s is no forwardpartner.\r",nextarg(t));
}

int get_user(char *c)
{
  FILE  *handle;
  char path[80],id[17];
  int i=0,u,ret,len;
  sprintf(path,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);
  if((handle=tfopen(path,"rt"))!=NULL)
  {
    while(!feof(handle))
    {
      if(fscanf(handle,"%16s %d",id,&u)<2)
	break;
      len = strchr(id,' ')-id-9;
      if(!strncmp(id+9,strupr(c),len))
      {
           ret=u;
           i++;
      }
    }
    tfclose(handle);
  }
  else
    return 0;

  if(i==1)
    return (ret);

  if(i>1)
    return -1;

  return i;
}

static void showp(int i)
{ unsigned long f=fwdp[i].f;
  putf("%-28.28s %-.40s ",fwdp[i].p,fwdp[i].c);
  if(f)
  {
    putf(", ");
    if(f&_FWDPOLL)
      putv('P');
  }
  putv('\r');
}

void list_fwdp(void)
{
  int i;
  putf("Forwardpartners at %s:\r",cfg.boxaddress);
  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
    showp(i);
  if(fwdp[0].p[0])
  {
    showp(0);
    i++;
  }

  putf("\rfound %d partners.\r",i-1);
}

int chng_header(msg_info_t &m,char *cmd)
{
  char *fstarg=nextarg(cmd),command[20];
  enum hdrcmd_t {  hdrerr=-1,
                  file=0,_time,msgid,_stat,usend,urecv,cst1,cst2,
                  srate,length,days,info,extend
                };

  char *hdrcmd[]=  {"file","time","msgid","stat","usend","urecv","cst1","cst2",
                   "srate","length","days","info","extend",NULL
                  };
  if(!cmd[0] || !fstarg[0])
    return 0;
  sscanf(cmd,"%19s",command);
  switch(checkcmd(hdrcmd,command,0))
  {
    case hdrerr: return 0;
    case file:   sscanf(fstarg,"%12s",m.Filename);
                break;
    case _time: putf("sorry - can't change.\r");
                break;
    case msgid: sscanf(fstarg,"%x",&m.Id);
                break;
    case _stat: sscanf(fstarg,"%x",&m.State);
                break;
    case usend: sscanf(fstarg,"%d",&m.Usender);
                break;
    case urecv: sscanf(fstarg,"%d",&m.Ureceiver);
                break;
    case cst1:  sscanf(fstarg,"%d",&m.Custom1);
                break;
    case cst2:  sscanf(fstarg,"%d",&m.Custom2);
                break;
    case srate:  sscanf(fstarg,"%u",&m.Srate);
                m.Srate*=10;
                break;
    case length:sscanf(fstarg,"%ld",&m.Length);
                break;
    case days:  sscanf(fstarg,"%d",&m.Days);
                break;
    case info:   sscanf(fstarg,"%16s",m.Info);
                break;
    case extend:sscanf(fstarg,"%64s",m.extend);
                break;
  }
  m.Unixtime=ad_time(NULL);
  return 1;
}

void listheader(msg_info_t &m,int mode)
{
  putf("File  : %.12s\r",m.Filename);
  putf("Time  : %s %s\r",datestr(m.Unixtime,1),timestr(m.Unixtime));
  putf("MsgId : %04X\r",m.Id);
  putf("Stat  : %04X\r",m.State);
  putf("Usend : %-4d\r",m.Usender);
  putf("Urecv : %-4d\r",m.Ureceiver);
  if(mode)
  { putf("Cst1  : %-4d\r",m.Custom1);
    putf("Cst2  : %-4d\r",m.Custom2);
  }
  putf("Srate : %ld\r",m.Srate/10L);
  putf("Length: %ld\r",m.Length);
  putf("Days  : %d\r",m.Days);
  putf("Info  : %.16s\r",m.Info);
  putf("Extend: %.64s\r",m.extend);
  putf("-----------------------\r");
}

void list_msg(void)
{
  long Msg_Count,Msg_Num;
  msg_info_t m;

  Msg_Num=mails();

  for (Msg_Count=0;Msg_Count<Msg_Num;Msg_Count++)
  {  set_win(filewin);
    putf("Msg % 3ld / %ld\r",Msg_Count+1,Msg_Num);
    read_minfo (Msg_Count,m);
    listheader(m,0);

    if(tget(0)=='\r')
    { putf("\rAborted.\r");
      break;
    }
  }
}

void header(char *file,char *cmd)
{
  msg_info_t m;
  FILE *f;

  if((f=tfopen(file,"rb+wb+"))==NULL)
  { putf("File %s not found.\r",file);
    return;
  }
  if(!read_finfo (f,m))
    putf("File %s has no valid DVMS-header!\a\r",file);
  else
  {  if(chng_header(m,cmd))
    write_finfo(m,f);
    listheader(m,1);
  }
  tfclose(f);

}
#endif