/***************************************************************

  DVMS            Digital Voice Mailbox System
  VTGEN
  SERV
  --------------------------------------------------
  Packet radio user-command interpreter
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#ifdef DVMS
#include "dvms.h"
#include "dvmsamp.h"
#include "dvmscmd.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmsirq.h"
#include "dvmsmsgb.h"
#include "dvmspara.h"
#include "dvmsstat.h"
#include "dvmssuba.h"
#include "dvmssyso.h"
#include "dvmspurg.h"
#include "dvmsptt.h"
#include "movefile.h"
#endif

#ifdef VTGEN
#include "vtgen.h"
#include "vtdtmf.h"
#include "vtread.h"
#include "vtpara.h"
#include "vtvps.h"
#include "vtptt.h"
#include "vti2c.h"
#endif

#include "adc_box.h"
#include "dosexit.h"
#include "util.h"
#include "talk.h"
#include "tnc.h"
#include "tnccmd.h"
#include "tnclow.h"
#include "tncrdwrt.h"



int checkcmd(char *chkcmd[],char *cmd,int mode)
{  int i;
  if(!cmd[0])
    return -1;
  if(mode)
  {  for(i=0;chkcmd[i]!=NULL;i++)
      if(!stricmp(chkcmd[i],cmd))
        break;
  }
  else
  { for(i=0;chkcmd[i]!=NULL;i++)
      if(!strnicmp(chkcmd[i],cmd,strlen(cmd)))
        break;
  }
  if(chkcmd[i]==NULL)
    return -1;
  else
    return i;
}

#ifdef DVMS
char *unf="User not found.\r";
char *snc="Specification not clear.\r";
#endif
void do_reset(void)
{  put_global_msg(_SHUTDOWN);
  if(get_tcb()->type&_TNCPROC)
  {
    tflush();
    tdisconnect(1);
  }
  while(get_tasksrun()>1)
    scheduler();

  fcloseall();
  system("smartdrv /c");

  doreset=1;

}

int tnc_usrcmd(char *fstarg,char *connected)
{ char help[31],cmd[_MAXCMD+1];
  int i;
  sscanf(fstarg,"%s",cmd);
  fstarg=nextarg(fstarg);
  switch(checkcmd(usrcmd,cmd,0))
  {
      case _usrerror: return 0;
      case __exit:
      case _quit:
      case _disc:
      case _bye :  tread("txt\\logout.txt",0,1);
                *connected=0;
                if(get_tcb()->type&_TNCPROC)
                {
                  tflush();
                  //tdisconnect(1);
                }
                else
                  return 1;
                break;
      case _ps:    show_ps(fstarg);
                break;
      case _msg:
      case _talk:
      case _convers:
      case __write:  talk(fstarg);
                    break;
      case _time: {  time_t t=time(NULL);
                  putf("Date: %s  Time: %s\r",datestr(t,1),timestr(t));
                  break;}
      case __version:  show_version();
                  break;
      case _pw:    get_tcb()->type|=getpw();
                  break;

      case _info: if(fstarg[0]==0)
                  {
                  tread("txt\\info.txt",0,1);
                  break;
                  }
      case _help: if(sscanf(fstarg,"%30s",help)==1)
                  { char path[80];
                    subst(help,'\\',32);
                    subst(help,'/',32);
                    subst(help,'.',32);
                    sprintf(path,"txt\\%s.txt",help);
                    if(!access(path,0))
                      tread(path,0,1);
                    else
                      putf("Sorry, no information available.\r");
                  }
                  else
                    tread("txt\\help.txt",0,1);
                  break;

      case _actual:
      case _aktuell:  tread("txt\\aktuell.txt",0,1);
                      break;
      case _log:
                if(strstr(fstarg,"-d"))
                  tread("log\\dtmflog.vms",0,0);
                else
                {  char arg[30];
                  sscanf(fstarg,"%29s",arg);
                  if(!strlen(fstarg)||strchr(fstarg,'-')||strchr(arg,'\"'))
                  {  time_t t;
                    struct tm *tt;
                    t=time(NULL);
                    tt=localtime(&t);
                    #ifdef DVMS
                    sprintf(help,"log\\log%u%02u%02u.VMS",tt->tm_year%10,tt->tm_mon+1,tt->tm_mday);
                    #else
                    sprintf(help,"log\\log%u%02u%02u.LOG",tt->tm_year%10,tt->tm_mon+1,tt->tm_mday);
                    #endif
                  }
                  else
                  #ifdef DVMS
                    sprintf(help,"log\\log%s.VMS",arg);
                  #else
                    sprintf(help,"log\\log%s.LOG",arg);
                  #endif

                  if(strstr(fstarg,"-f")==NULL)
                    logread(help,strchr(fstarg,'\"'));
                  else
                    tread(help,1,0);
                  //write_log(_report,r,"log %s",fstarg);
                }
                break;

    case _adc:    show_adc(fstarg);
                  break;
    case _cron:   tread("crontab.ini",0,1);
                  break;
    case _status: rscstat(fstarg);
                  break;
    #ifdef VTGEN
    case _par:    tread(ININAME,0,0);
                  break;
    #ifndef SERVICE
      case __read:get_page(fstarg);
                  break;

      case _dir:  dirpages(fstarg);
                  break;
    #endif
    #endif
    #ifdef DVMS
      case _par:  tread(_DVMSININAME,0,0);
                  break;

      case _dir:if(strlen(fstarg)&&!strnicmp(fstarg,"path",strlen(fstarg)))
                  list_fwdp();
                else
                {  if(!strlen(fstarg))
                    pr_msg_info(get_user(get_tcb()->name));
                  else
                  {  if((i=atoi(fstarg))>0)
                      pr_msg_info(i);
                    else
                    {  if((i=get_user(fstarg))>0)
                        pr_msg_info(i);
                      else
                        switch(i)
                        {
                          case   0:putf(unf);break;
                          case -1:putf(snc);break;
                        }
                    }
                  }
                }
                break;
    case _user: lstuser(fstarg);
                break;
    case _finger:
    case _getinfo:
    case _whois:  if(!strlen(fstarg))
                  putf("syntax: GETINFO <boxnum>\r");
                else
                  if(!atoi(fstarg))
                  {
                    sscanf(fstarg,"%29s",help);
                    if((i=get_user(help))>0)
                      goto l1;
                    else
                      goto l11;
                  }
                  else
                  if(sscanf(fstarg,"%d",&i)==1)
                  {  l1:;
                    sprintf(help,"%s%04d_USR.VMS",cfg.usrp,i);
                    if(access(help,0))
                      goto l11;

                    sprintf(help,"%04d_USR.VMS",i);
                    if(rd_file_info(cfg.usrp,help,File_Info))
                    {
                      putf("User     : %-4d\r",File_Info.Ureceiver);
                      if(get_tcb()->type&_SYSOP)
                      {
                        putf("Subaudio : ");
                        switch(File_Info.Id>>8)
                        {
                          case 255:
                          putf("locked");
                          break;

                          case 0:
                          putf("no tone");
                          break;

                          default:
                          putf("%ldHz",(ctcss_tone[File_Info.Id>>8]/1000L));
                        }

                        putf("\rId       : %04X\r",File_Info.Id);
                        putf("State    : %04X\r",File_Info.State);
                      }
                      putf("Lastlogin: ");
                      sprintf(help,"%s %s\r",datestr(File_Info.Unixtime,1),timestr(File_Info.Unixtime));

                      if(File_Info.Unixtime)
                        putf(help);
                      else
                        putv('\r');
                      putf("Lifetime : %u\r",File_Info.Days);

                      putf("Info     : %s\r",File_Info.Info);
                      putf("Logins   : %d\r",File_Info.Usender);
                      putf("Sendmsgs : %d\r",File_Info.Custom2);
                      putf("Recvmsgs : %d\r",File_Info.Custom1);
                    }
                    else
                    { i=-1;
                      l11:;
                      switch(i)
                      {
                        case -1:putf(snc);break;
                        default:putf(unf);
                      }
                    }
                  }
                  break;
    #endif
 }
 return 1;
}

int tnc_syscmd(char *fstarg)
{ char help[30],cmd[_MAXCMD+1],*r="tnc_syscmd";
  int i,j;
  sscanf(fstarg,"%s",cmd);
  fstarg=nextarg(fstarg);
  switch(i=checkcmd(syscmd,cmd,0))
  {
    case _syserror: return 0;
    case _test: putf("Dataseg: %X\r",_DS);
                break;
    case _wtext:write_log(_report,r,"wtext %s",fstarg);
                twrite(fstarg);
                break;
    case _wprg: write_log(_report,r,"wprg %s",fstarg);
                bwrite(fstarg,0);
                break;
    case _rtext: write_log(_report,r,"rtext %s",fstarg);
                tread(fstarg,0,0);
                break;
    case _trace: write_log(_report,r,"trace %s",fstarg);
                tread(fstarg,1,0);
                break;
    case _rprg:  write_log(_report,r,"rprg %s",fstarg);
                bread(fstarg,0);
                break;
    case _oshell:write_log(_report,r,"oshell %s",fstarg);
                #ifdef DVMS
                hw_set(5,0);
                #endif
                if(get_tcb()->type&_TNCPROC)
                  oshell(fstarg,1);
                else
                  oshell(fstarg,0);
                #ifdef DVMS
                c_init();
                afsw(1);
                #endif
                break;
    case _kill: if(strlen(fstarg))
                {
                  write_log(_report,r,"kill %s",fstarg);
                  i=atoi(fstarg);
                  if((i==get_tasknum()) || !kill(i))
                    putf("kill: task not found or own task\r");
                }
                else
                  putf("syntax: KILL <task>\r");
                break;
    case _shutdown:
                write_log(_report,r,"shutdown %s",fstarg);
                put_global_msg(_SHUTDOWN);
                break;

    case _reset:putf("type RESET to confirm: ");
                getline(help,29,1);
                if(strcmp(help,"RESET"))
                  break;
                write_log(_report,r,"*** RESET ***");
                do_reset();
                break;

    case _xconnect:
    case _connect:
                  if(!(get_tcb()->type&_CONSOLE))
                    putf("You better use a digipeater.\r");
                  else
                  { int c,pw=0,p[5];
                    char *line=get_tcb()->cmd;
                    get_tcb()->type|=_TNCPROC;

                    if(i==_xconnect)
                    {  sscanf(fstarg,"%9s",help);
                      fstarg=nextarg(fstarg);
                    }
                    else
                      strcpy(help,get_tcb()->name);

                    if(connect(help,fstarg))
                    { set_win(defaultwin);
                      cprintf(">>> connected to %s\a\r\n",get_concall());
                      tflush();
                      while((tget_lstate()>=info_transfer) && !(get_global_msg()&_SHUTDOWN))
                      { if(kbhit())
                        {  set_win(defaultwin);
                          getline(line,76,2);
                          set_win(defaultwin);
                          cprintf("\r\n");
                          if(line[0]==4)
                            break;
                          putf("%s\r",line);
                          tflush();
                          if(!strcmp(line,"pw"))
                            pw=1;
                        }

                        i=0;
                        while((c=tget(0))!=-1)
                        { cmd[i++]=(char)c;
                          if(i>=(_MAXCMD-1))
                            break;
                        }
                        if(i)
                        { cmd[i]=0;
                          set_win(defaultwin);
                          for(j=0;j<i;j++)
                          {  switch(cmd[j])
                            { case '\r': cprintf("\r\n");break;
                              default: putch(cmd[j]);
                            }
                          }
                          if(pw && (sscanf(cmd,"%29s  %d %d %d %d %d",help,&p[0],&p[1],&p[2],&p[3],&p[4])==6))
                          { pw=0;
                            putpw(p);
                          }
                        }

                        gettalk();
                        suspend(1);
                      }
                      tdisconnect(1);
                      get_tcb()->type^=_TNCPROC;
                      putf("\r>>> reconnected to %s\r",get_mycall());
                      break;
                    }
                    get_tcb()->type^=_TNCPROC;
                    putf("\r>>> failure with %s\r",strupr(fstarg));
                  }
                  break;
 //#ifndef SERVICE
    case import:
                  if(sscanf(fstarg,"%30s",help)==1)
                  { char *t;
                    if((t=strchr(help,'.'))!=NULL)
                      t[0]=0;
                    sprintf(cmd,"%s.imp",help);
                    if(access(cmd,0))
                      putf("Importfile %s not found.\r",cmd);
                    else
                    { set_win(defaultwin);
                      cprintf("fork %d\r\n",fork(help,execimp,_NPRIO,_NPROC,-1,_BIG));
                    }
                  }
                  else
                    putf("syntax: IMPORT <filename>\r");
                  break;
    case _sleep:  if(!(get_tcb()->type&_BATCH))
                    putf("batch-syntax: SLEEP <seconds>\r");
                  else
                  if(fstarg[0])
                    suspend(atol(fstarg)*18L);
                  break;
   case _wrtadc:  write_adc();
                  break;
 //#endif
    #ifdef VTGEN
    #ifndef SERVICE
    case _dcfmon: switch(fstarg[0])
                  { case '0': dcfmon=0;
                              beep(0);
                              break;
                    case '1': dcfmon=1;
                              break;
                  }
                  if(!dcf_enable)
                   putf("Warning : DCF-RX disabled.\r");
                  putf("dcf mon : ");
                  switch(dcfmon)
                  { case 1:  putf("PC-speaker\r"); break;
                    default: putf("off\r");
                  }
                  putf("lastsync: ");
                  if(ddate[0].year)
                    putf("%s, %02u.%02u.%02u  %02u:%02u:%02u\r",
                        days[ddate[0].dayofweek],
                        ddate[0].day,ddate[0].month,ddate[0].year%100,
                        dtime[0].hour,dtime[0].minute,dtime[0].second);
                  else
                    putf("-\r");
                  break;

      case _load: if(strlen(fstarg))
                  {
                    reload(fstarg);
                    write_log(_report,r,"load %s",fstarg);
                  }
                  else
                  putf("syntax: LOAD [vt]|[cfg]\r");
                  break;
      case _readconfig: readconfig();
                      break;

      case _vps:if(!fstarg[0])
                  putf("syntax: VPS [[<day>.<month>] <hour>.<minute>]|i|p|s <nc> <pc>\r");
                else
                { unsigned nc=0,pc=0,day=0,month=15,hour=31,minute=63;
                  putf("Setting VPS-code to ");
                  write_log(_report,r,"vps %s",fstarg);
                  switch(fstarg[0]&0x5f)
                  { case 'P': hour=30;putf("pause code\r");break;
                    case 'I': hour=29;putf("interrupt code\r");break;
                    case 'S': putf("system status code\r");break;
                    default:

                    if(sscanf(fstarg,"%u.%u %u.%u %u %u",&day,&month,&hour,&minute,&nc,&pc)<4)
                    { struct time t;
                      struct date d;
                      unixtodos(ad_time(NULL),&d,&t);

                      hour=day;
                      minute=month;

                      day=d.da_day;
                      month=d.da_mon;
                    }
                    putf("%02u.%02u %02u.%02u nation:%u prg.src:%u\r",day,month,hour,minute,nc,pc);
                }
                initvps(nc,pc,day,month,hour,minute);
              }
              break;

    #ifndef DUENN
    case _set:  if(!fstarg[0])
                {putf("syntax: SET INP <num> on|off\r");
                 putf("        SET OUT <num> on|off|high|low\r");
                 putf("        SET PLL <num> [freq <freq>]|[port <port> <value>]\r");
                 putf("        SET WEATHER <dtmf>\r");
                 putf("        1:tst1 2:tst2 3:tst3 B:tst4 5:tst2+3\r        A:Audio %s 6:Ext %s\r",
                 (cfg.audio&(1<<cfg.ch[active_vid].aud))?"on ":"off",weatheraudio?"off":"on");
                 putf("        SET AUDIO <channels>\r");

                }
                else
                { write_log(_report,r,"set %s",fstarg);
                j=atoi(nextarg(fstarg));
                int u=0;
                ch_t ch;
                sscanf(fstarg,"%s",help);
                if(!strnicmp(help,"inp",strlen(help)))
                {char *s=nextarg(nextarg(fstarg));

                putf("INPUTS:\rPo Vid Aud APS12 Ena Name\r");
                for(i=0;i<_MAXVIDEOPORTS;i++)
                  if(cfg.ch[i].type&_USER)
                  { ch=cfg.ch[i];
                    u++;
                    if(j==u)
                    {if(!strnicmp(s,"on",2))
                       cfg.ch[i].disabled&=~1;
                     if(!strnicmp(s,"off",3))
                       cfg.ch[i].disabled|=1;
                     ch=cfg.ch[i];
                    }

                    putf("% 2u V%02u A%02u %c%c%c%c%c %s %s\r",
                         u,ch.vid,ch.aud,
                         (ch.type&_AUDTHR)?'A':' ',
                         (ch.type&_PRIV)?'P':' ',
                         (inpstate&(1<<ch.vid))?'S':' ',
                         (ch.vid==active23)?'1':' ',
                         (ch.vid==active3)?'2':' ',
                         ch.disabled?"OFF":"ON ",
                         ch.ch_id);
                  }
                }
                else
                if(!strnicmp(help,"out",strlen(help)))
                { char *s=nextarg(nextarg(fstarg)),*t;
                  j=atoi(nextarg(fstarg))-1;
                  if(!strnicmp(s,"on",2))
                    cfg.pttdisable&=~(1<<j);
                  else
                  if(!strnicmp(s,"off",3))
                    cfg.pttdisable|=(1<<j);
                  else
                  if(!strnicmp(s,"low",3))
                    cfg.txpower=0;//|=(1<<j);
                  else
                  if(!strnicmp(s,"med",3))
                    cfg.txpower=2;//&=~(1<<j);
                  else
                  if(!strnicmp(s,"high",4))
                    cfg.txpower=3;//&=~(1<<j);

                  switch(cfg.txpower&3)
                  {
                    case 0:
                    case 1:
                            t="low";break;
                    case 2: t="medium";break;
                    case 3: t="high";break;
                  }
                  putf("OUTPUTS:\r");
                  putf(" 1 23cm %s %s\r",(cfg.pttdisable&1)?"OFF":"ON ",t);
                  putf(" 2  3cm %s \r",(cfg.pttdisable&2)?"OFF":"ON ");
                }
                else
                if(!strnicmp(help,"weather",strlen(help)))
                {
                  char *s=nextarg(fstarg);
                  for(i=0;i<_MAXVIDEOPORTS;i++)
                    if(cfg.ch[i].type&_WEATHER)
                    { active_vid=i;
                      break;
                    }
                  if(i==_MAXVIDEOPORTS)
                  {
                    putf("No weatherport defined!\r");
                    break;
                  }

                  for(int i=0;s[i];i++)
                    weather(s[i],1);
                  putf("A:Audio %s 6:Ext %s\r",(cfg.audio&(1<<cfg.ch[active_vid].aud))?"on ":"off",weatheraudio?"off":"on");
                }
                else
                if(!strnicmp(help,"audio",strlen(help)))
                { fstarg=nextarg(fstarg);
                  cfg.audio=0;
                  while((sscanf(fstarg,"%d",&i)==1))
                  {
                    if(i<_MAXVIDEOPORTS)
                      cfg.audio|=(1<<i);
                    fstarg=nextarg(fstarg);
                  }
                  putf("Setting audio to 0x%04X.\r",cfg.audio);
                }
                else
                if(!strnicmp(help,"pll",strlen(help)))
                {
                   char *s=nextarg(fstarg);
                   unsigned pll=atoi(s);
                   s=nextarg(s);

                   if(!strnicmp(s,"freq",strlen(help)))
                   { long freq=atol(nextarg(s));
                     if((freq>=10000) && (freq <=12000))
                     {
                       if(pll_setfreq(pll,freq))
                         putf("Setting PLL %d frequency to %ld MHz.\r",pll,freq);
                       else
                         putf("I2C-address failure!\r");

                     }
                     else
                       putf("PLL %d frequency %ld value out of range!\r",pll,freq);
                   }
                   else
                   if(!strnicmp(s,"port",strlen(help)))
                   { unsigned port=3,value=0;
                     if(sscanf(nextarg(s),"%d %d",&port,&value)==2)
                     { if(port<=7)
                         value=!!value;
                       if(pll_setport(pll,port,value))
                         putf("Setting PLL %d port %d to %d.\r",pll,port,value);
                       else
                         putf("I2C-address failure!\r");
                     }
                     else
                       putf("PLL %d port %d settings invalid: %d!\r",pll,port,value);
                   }


                }
                }
                break;

    case _ptt:
                pttupd(atol(fstarg));
                putf("PTT: %s\r",ptt_state?"ON":"OFF");
                write_log(_report,r,"ptt %s",fstarg);
                break;
    case _monitor:write_log(_report,r,"monitor");
                  if(get_tcb()->type&_MONBIT)
                  {
                    get_tcb()->type&=(0xffffffff-_MONBIT);
                    putf("monitor off.\r");
                  }
                  else
                  {
                    get_tcb()->type|=_MONBIT;
                    putf("monitor on.\r");
                  }
                  break;
    #endif
    #else
    case _load:
                 readconfig();
                 putf("reading "ININAME"\r");
                 write_log(_report,r,"load "ININAME);
                 break;
    #endif

    #endif
    #ifdef DVMS
    case _dcfmon:

                  switch(fstarg[0])
                  { case '0': dcfmon=0;
                              beep(0);
                              c_tx_rate(0L,400000L);
                              break;
                    case '1':  dcfmon=1; break;
                    case '2':  dcfmon=2; break;
                  }
                  putf("dcf mon : ");
                  switch(dcfmon)
                  { case 1:  putf("PC-speaker\r"); break;
                    case 2:  putf("FX805\r"); break;
                    default: putf("off\r");
                  }
                  putf("lastsync: ");
                  if(ddate[0].year)
                    putf("%s, %02u.%02u.%02u  %02u:%02u:%02u\r",
                        days[ddate[0].dayofweek],
                        ddate[0].day,ddate[0].month,ddate[0].year%100,
                        dtime[0].hour,dtime[0].minute,dtime[0].second);
                  else
                    putf("-\r");

                  break;

    case _reorg: if(!strlen(fstarg))
                  putf("syntax: REORG usr|msg|all\r");
                else
                  if(!strnicmp(fstarg,"USR",strlen(fstarg)))
                  {
                    putf("reorg_usr invoked.\r");
                    write_log(_report,r,"reorg_usr");
                    fork("reorg_usr",reorg_usr,_NPRIO,_NPROC,0,_BIG);
                  }
                  else
                  if(!strnicmp(fstarg,"MSG",strlen(fstarg)))
                  {
                    putf("reorg_msg invoked.\r");
                    write_log(_report,r,"reorg_msg");
                    fork("reorg_msg",reorg_msg,_NPRIO,_NPROC,0,_BIG);
                  }
                  else
                  if(!strnicmp(fstarg,"ALL",strlen(fstarg)))
                  {
                    fork("reorg",event,_NPRIO,_NPROC,0,_BIG);
                    putf("reorg invoked.\r");
                  }
                  else
                    putf(snc);
                  break;
    case _record:  if(!strlen(fstarg))
                    putf("syntax: RECORD <filename>\r");
                  else
                  {
                    char drive[_MAX_DRIVE];
                    char dir[_MAX_DIR];
                    char file[_MAX_FNAME];
                    char ext[_MAX_EXT];
                    msg_info_t MInfo;
                    _splitpath(fstarg,drive,dir,file,ext);
                    if(!ext[0])
                      strcpy(ext,".vms");

                    sprintf(cmd,"%s%s",drive,dir);
                    sprintf(help,"%s%s",file,ext);
                    cronplay=1;
                    rdplay(cfg.sysp[0],"WRTMSG2.VMS");
                    ptt(-1);
                    init_msg_info(MInfo);
                    cronplay=0;
                    putf("recorder: ready!\r");
                    putf("record  : %ldKByte\r",record_write(cmd,help,cfg.max_msg_length,MInfo)>>10);
                    putf("playback: %s%s\r",cmd,help);
                    cronplay=1;
                    suspend(9);
                    rdplay(cmd,help);
                    cronplay=0;

                    write_log(_report,r,"record %s%s",cmd,help);
                  }
                  break;
    case _mkuser:  if(sscanf(fstarg,"%d",&i)==1)
                  {
                    int uold=ulogin;
                    msg_info_t uiold=User_Info;

                    User_Info.Info[0]=0;
                    ulogin=i;
                    User_Info.Ureceiver=i;
                    set_win(userwin);
                    clrscr();
                    putf("mkuser: ready!\r");
                    if(i&&reccall(i,FALSE))
                    {
                      change_userfile(User_Info.Info,i);
                      write_log(_report,r,"mkuser #%d",i);
                    }
                    else
                      putf("mkuser: failed.\r");
                    ulogin=uold;
                    User_Info=uiold;
                  }
                  else
                    putf("syntax: MKUSER <boxnum>\r");
                  break;
    case _mksysop:  i=0;
                    if(((i=get_user(fstarg))>0)||(sscanf(fstarg,"%d",&i)==1))
                    {

                      char path[80];
                      sprintf(path,"%s%04d_USR.VMS",cfg.usrp,i);
                      if(!access(path,0))
                      { sprintf(path,"%04d_USR.VMS",i);
                        rd_file_info(cfg.usrp,path,File_Info);
                        if(File_Info.Id&_USRID_SYSOP)
                        {
                          File_Info.Id&=(0xffff-_USRID_SYSOP);
                          putf("mksysop: %s (%d) is not sysop.\r",File_Info.Info+9,File_Info.Ureceiver);
                        }
                        else
                        {
                          File_Info.Id|=_USRID_SYSOP;
                          putf("mksysop: %s (%d) is sysop.\r",File_Info.Info+9,File_Info.Ureceiver);
                        }
                        wrt_file_info(cfg.usrp,path,0,File_Info);
                        write_log(_report,r,"mksysop #%d",i);
                      }
                      else
                        putf(unf);
                    }
                    else
                    {
                      if(!strlen(fstarg))
                        putf("syntax: MKSYSOP <user>|<call>\r");
                      else
                        switch(i)
                        {
                          case   0:putf(unf);break;
                          case -1:putf(snc);break;
                        }
                    }
                    break;

    case _mkboard:if(sscanf(fstarg,"%d",&i)==1)
                  {
                    int uold=ulogin;
                    msg_info_t uiold=User_Info;

                    User_Info.Info[0]=0;
                    ulogin=i;
                    User_Info.Ureceiver=i;
                    set_win(userwin);
                    clrscr();
                    putf("mkboard: ready!\r");
                    if(i&&reccall(i,TRUE))
                    {
                      change_userfile(User_Info.Info,i);
                      write_log(_report,r,"mkboard #%d",i);
                    }
                    else
                      putf("mkboard: failed.\r");

                    ulogin=uold;
                    User_Info=uiold;

                  }
                  else
                    putf("syntax: MKBOARD <board>\r");
                  break;
    case _lifetime:if(sscanf(fstarg,"%d %d",&i,&j)==2)
                  {

                    write_log(_report,r,"lifetime #%d days",i);
                    sprintf(help,"%04d_USR.VMS",i);
                    if(i&&rd_file_info(cfg.usrp,help,File_Info))
                    {
                      File_Info.Days=j;
                      wrt_file_info(cfg.usrp,help,FALSE,File_Info);
                      putf("lifetime in board %d set to %d days.\r",i,j);
                    }
                    else
                      putf("board %d not found.\r",i);
                  }
                  else
                    putf("syntax: LIFETIME <boxnum> <days>\r");

                  break;
    case _stripbox:if(!strlen(fstarg))
                    putf("syntax: STRIPBOX <boxnum>\r");
                  else
                    if(!atoi(fstarg))
                    {
                      sscanf(fstarg,"%29s",help);
                      if((i=get_user(help))>0)
                        goto l2;
                      else
                        goto l22;
                    }
                    else
                      if(sscanf(fstarg,"%d",&i)==1)
                      {
                        l2:;

                        write_log(_report,r,"unprot #%d",i);
                        sprintf(help,"%04d_USR.VMS",i);
                        if(rd_file_info(cfg.usrp,help,File_Info))
                        {
                          File_Info.State=File_Info.State&(0xffff-_USRST_PROTECT-_USRST_PROTAMP);
                          File_Info.Id&=0xff;
                          wrt_file_info(cfg.usrp,help,TRUE,File_Info);
                          sprintf(help,"%04d_NAM.VMS",i);
                          rd_file_info(cfg.usrp,help,File_Info);
                          File_Info.State=File_Info.State&(0xffff-_USRST_PROTECT);
                          wrt_file_info(cfg.usrp,help,TRUE,File_Info);
                          putf("All flags are stripped now (but you can leave your head on).\r");
                        }
                        else
                        {  l22:
                          switch(i)
                          {
                            case -1:putf(snc);break;
                            default:putf(unf);
                          }
                        }
                      }
                  break;

    case _playback:if(!strlen(fstarg))
                    putf("syntax: PLAYBACK <filename>\r");
                  else
                  {
                    char drive[_MAX_DRIVE];
                    char dir[_MAX_DIR];
                    char file[_MAX_FNAME];
                    char ext[_MAX_EXT];
                    if(strstr(fstarg,"-u"))
                    {
                      strcpy(cmd,cfg.usrp);
                      sprintf(help,"%04d_usr.vms",atoi(nextarg(fstarg)));
                    }
                    else
                    {
                      _splitpath(fstarg,drive,dir,file,ext);
                      if(!ext[0])
                        strcpy(ext,".vms");
                      sprintf(cmd,"%s%s",drive,dir);
                      sprintf(help,"%s%s",file,ext);
                    }
                    cronplay=1;
                    putf("playback: %s%s\r",cmd,help);
                    if(!rdplay(cmd,help))
                      putf("playback: failed.\r");
                    cronplay =0;
                    write_log(_report,r,"playback %s%s",cmd,help);
                  }
                  break;
    case _purge:    if(!strlen(fstarg))
                    putf("syntax: PURGE usr|msg\r");
                  else
                    if(!strnicmp(fstarg,"USR",strlen(fstarg)))
                    {
                      putf("purge_usr invoked.\r");
                      write_log(_report,r,"purge_usr");
                      fork("purge_usr",purge_usr,_NPRIO,_NPROC,0,_BIG);
                    }
                    else
                      if(!strnicmp(fstarg,"MSG",strlen(fstarg)))
                      {
                        write_log(_report,r,"purge_msg",get_tcb()->name);
                        putf("purge_msg invoked.\r");
                        fork("purge_msg",purge_msg,_NPRIO,_NPROC,0,_BIG);
                      }
                      else
                        putf(snc);

                  break;
    case _statistic:
                  write_log(_report,r,"statistic");
                  putf("statistic invoked.\r");
                  fork("statistic",statistic,_NPRIO,_NPROC,0,_BIG);
                  break;
    case _readconfig:
                  write_log(_report,r,"readconfig");
                  readconfig();
                  //putf("readconfig invoked.\r");
                  //fork("readconfig",readconfig,_NPRIO,_NPROC,0,4096);
                  break;
    case _state:    i=atoi(fstarg);
                  if(strlen(fstarg)&&(i<5)&&(i>=0))
                  {
                    write_log(_report,r,"state",fstarg);
                    swstate(atoi(fstarg));
                  }
                  else
                    putf("syntax: STATE 0|1|2|3\r");
                  break;
    case __disable:  write_log(_report,r,"disable");
                  swstate(0);
                  break;
    case __enable:  write_log(_report,r,"enable %s",fstarg);
                  if(fstarg[0] && ((i=atoi(fstarg))>0))
                    swstate(i);
                  else
                    swstate(3);
                  break;
    case _ampreg:  help[0]=0;
                  if(sscanf(fstarg,"%d %29s",&i,help)==2)
                  {
                    write_log(_report,r,"ampreg %d",i);
                    amp_exist(strupr(help));
                    if(i&&amp_callreg(i,help))
                      putf("ampreg: Call %s stored.\r",help);
                    else
                      putf("ampreg: Call %s or user not valid.\r",help);
                  }
                  else
                    putf("syntax: AMPREG <boxnum> <call>\r");
                  break;
    case _delbox:  help[0]=0;
                  if(!strlen(fstarg))
                    putf("syntax: DELBOX <boxnum>|<call>\r");
                  else
                  {
                    if(!atoi(fstarg)&&(sscanf(fstarg,"%29s",help)==1))
                    {
                      if((i=get_user(help))<1)
                        putf(unf);
                      else
                        if(del_usr(i))
                        {
                          write_log(_report,r,"usrkilled %d %s",i,help);
                          putf("delbox: User %s deleted.\r",help);
                        }
                        else
                          putf(unf);
                    }
                    else
                      if((sscanf(fstarg,"%d",&i)==1)&&del_usr(i))
                      {
                        write_log(_report,r,"usrkilled %d",i);
                        putf("delbox: User %d deleted.\r",i);
                      }
                      else
                        putf(unf);
                  }
                  break;
    case _delname:  if(!strlen(fstarg))
                    putf("syntax: DELNAME <boxnum>\r");
                  else
                    if(!atoi(fstarg))
                    {
                      sscanf(fstarg,"%29s",help);
                      if((i=get_user(help))>0)
                        goto l3;
                      else
                        goto l33;
                    }
                    else
                      if(sscanf(fstarg,"%d",&i)==1)
                      {
                        l3:;
                        write_log(_report,r,"delname #%d",i);
                        sprintf(help,"%s%04d_NAM.VMS",cfg.usrp,i);
                        if(!remove(help))
                          putf("delname: Namefile deleted.\r");
                        else
                        {  l33:;putf("delname: Namefile not found.\r");}
                      }
                  break;
    case _monitor:write_log(_report,r,"monitor");
                  if(get_tcb()->type&_MONBIT)
                  {
                    get_tcb()->type&=(0xffffffff-_MONBIT);
                    putf("monitor off.\r");
                  }
                  else
                  {
                    get_tcb()->type|=_MONBIT;
                    putf("monitor on.\r");
                  }
                  break;
    case _sf:
    case _forward:if(strcmp(get_tcb()->name,"crond"))
                    write_log(_report,r,"forward %s",fstarg);

                  if(sscanf(fstarg,"%30s",help)!=1)
                  {
                    fork("fwdd",fwdd,_NPRIO,_NPROC,0,_BIG);
                    putf("forward invoked.\r");
                  }
                  else
                  { strcpy(cmd,get_onlycall(help));
                    if(fwddcall(cmd))
                      putf("forward invoked.\r");
                    else
                      putf("nothing to forward to %s.\r",help);
                  }
                  break;
    case _header: if(!fstarg[0])
                  {
                    putf("syntax: HEADER [<file> [<statement> <value>]]|-m\r");
                    break;
                  }
                  if(strstr(fstarg,"-m"))
                    list_msg();
                  else
                  {  sscanf(fstarg,"%70s",cmd);
                    if(strchr(cmd,'.')==NULL)
                      strcat(cmd,".vms");
                    header(cmd,nextarg(fstarg));
                  }
                  break;
    case _put:    if(!fstarg[0])
                  {
                    putf("syntax: PUT <file> <fwdbox>\r");
                    break;
                  }
                  else
                  {
                    char file[20];
                    sscanf(fstarg,"%70s",cmd);

                    if(strchr(cmd,'.')==NULL)
                      strcat(cmd,".vms");

                    mkfilename(file);

                    sprintf(help,"fwd\\%s",file);

                    if(move_file(cmd,help,0))
                    {
                      sscanf(nextarg(fstarg),"%70s",cmd);
                      if(findfwdbox(cmd,help,NULL))
                      {
                        addfwdlist(help,help,file);
                        putf("File ok.\r");
                        write_log(_report,r,"putfile %s",fstarg);
                      }
                      else
                      {
                        putf("Sorry, box is not fwd-partner.\r");
                        remove(help);
                      }
                    }
                    else
                      putf("Sorry, file not found.\r");
                  }
                  break;

    case _beacon: fork("beacon",beacon,_NPRIO,_NPROC,-1,_BIG);
                  putf("Beacon processing started.\r");
                  break;
    #endif
  }

  return 1;
}

void tnc_dialog(void)
{ char connected=1;
  char *fstarg;
  char *line=get_tcb()->cmd;
  BOOL cok=FALSE;

  int i=0;

  #ifdef DVMS
    set_win(userwin);
    gotoxy(1,9);
    cprintf("Login  %s pid #%d         ",get_tcb()->name,get_tasknum());
    if(!(cfg.system_state&1))
    {
      putf("\r"CTEXT" disabled.\r");
      tflush();
      while(!(cfg.system_state&1) && !(get_global_msg()&_SHUTDOWN) && (tget_lstate()>=info_transfer))
      {
        if(((tget(0)&0x5f)=='P') && ((tget(0)&0x5f)=='W'))
        {
          while(tget(0)!=-1);
          if((get_tcb()->type|=getpw())&_SYSOP)
            break;
        }
        suspend(3);
      }
    }
    putf("\r"CTEXT);
    tread("txt\\login.txt",0,1);

    i=get_user(get_tcb()->name);
    if(i>0)
      pr_msg_info(i);
  #endif
  #ifdef VTGEN
    if(get_tcb(get_mycall())->name[0])
    {  set_win(defaultwin);
      cprintf("Login  %s task #%d\r\n",get_tcb()->name,get_tasknum());
    }
    putf("\r"CTEXT);
    tread("txt\\login.txt",0,1);
  #endif

  while(connected && !(get_global_msg()&_SHUTDOWN))
  {  do
    {  putf("-->");
      if(getline(line,_MAXCMD,2)==-1)
      { putv('\r');
        if(!gettalk())
        {
          connected=0;
          break;
        }
        else
        { //line[0]=0;
          continue;
        }
      }

      //i=strlen(line);
      //memset(line+i,0,_MAXCMD-i);
      //fstarg=firstarg(line);
      putv('\r');
    }while(!(fstarg=firstarg(line))[0]);

    if(!connected|| (get_global_msg()&_SHUTDOWN))
      break;

    i=tnc_usrcmd(fstarg,&connected);

    if((get_tcb()->type&_SYSOP)&&!i)
    {
      i=tnc_syscmd(fstarg);
      #ifdef DVMS
      if(!i)
      {
        err=0;
        i=execinipar(fstarg);
        if(!err && i)
        {  write_par();
          putf("changed "_DVMSININAME"\r");
          write_log(_report,"tnc_dialog",fstarg);
        }
      }
      #endif
    }

    if(!i)
    {
      char *t=strchr(fstarg,32);

      if(t)
        t[0]=0;

      putf("invalid command: %s\r",fstarg);
    }
    else
      if(!cok)
        cok=1;

    if(cok==1)
    { cok++;
      write_log(_report,"tnc_dialog","login stream %d",get_tcb()->tty);
    }
  }

  #ifdef VTGEN
  if(get_tcb(get_mycall())->name[0])
  {  set_win(defaultwin);
    cprintf("Logout %s pid #%d\r\n",get_tcb()->name,get_tasknum());
  }
  #endif
  #ifdef DVMS
  set_win(userwin);
  gotoxy(1,9);
  cprintf("Logout %s pid #%d           ",get_tcb()->name,get_tasknum());
  #endif
  if(cok)
    write_log(_report,"tnc_dialog","logout stream %d CPUt %s",get_tcb()->tty,zeitspanne(get_tcb()->cputime,2));

  if(get_global_msg()&_SHUTDOWN)
  { if(get_tcb()->type&_TNCPROC)
    { tflush();
      suspend(1);
      tdisconnect(1);
    }
  }

}

void execimp(void)
{ FILE *f;
  char *t,s[200],*r="import",*fstarg,*fname=get_tcb()->name,connected=1;
  int  i,line=0;

  get_tcb()->type|=(_SYSOP|_BATCH);
  if((t=strchr(fname,'.'))!=NULL)
    t[0]=0;

  sprintf(s,"%s.imp",fname);

  if((f=tfopen(s,"rt"))==NULL)
    return;

  sprintf(s,"%s.out",fname);
  remove(s);

  write_log(_report,r,"*** start import %s",fname);

  while(fgets(s,sizeof(s),f)&&connected&&!(get_global_msg()&_SHUTDOWN))
  { if((t=strchr(s,'\n'))!=NULL)
      t[0]=0;
    if((t=strchr(s,'\r'))!=NULL)
      t[0]=0;

    fstarg=firstarg(s);
    i=tnc_usrcmd(fstarg,&connected);
    if(!i)
    { i=tnc_syscmd(fstarg);
      #ifdef DVMS
      if(!i)
      {
        err=0;
        i=execinipar(fstarg);
        if(!err && i)
        { write_par();
          putf("changed "_DVMSININAME"\r");
          write_log(_report,"tnc_dialog",fstarg);
        }
        else
          if(!i)
            write_log(_serious,r,"syntax error in line %d",line);
      }
      #endif
      #ifdef VTGEN
      if(!i)
        write_log(_serious,r,"syntax error in line %d",line);
      #endif
    }
    line++;                    // remember line for error message
    scheduler();
  }
  write_log(_report,r,"*** end import %s",fname);
  tfclose(f);
  return;
}
