#include "flexappl.h"
#include "tnclow.h"

#define  taskversion "0.98"

#define _CURSOR      1
#define _MSG_VTLOAD  1
#define _SHUTDOWN   -1

#define _MSG        32
#define _TNC_RXVAL  16
#define _TNC_TXFREE  8
#define _KBHIT       2
#define _TSUSPEND    1

#define _MAXCMD 200
#define _MAXMSG 10
#define _MAXTASKS 80

#define _NPROC   1
#define _TNCPROC 2
#define _FWDPROC 4
#define _BATCH   8

#define _NPRIO   1

#define _MONBIT 0x100
#define _SYSOP  0x200
#define _CONSOLE 0x400

typedef struct { int  pid;
                 long msg;
               } msg_t;

typedef struct tcb {  //unsigned sp,ss;
                      jmp_buf jb;
                      unsigned *stack;
                      unsigned stacksize;
                      long create;
                      long cputime;
                      long lastcall;
                      long prio;
                      long type;
                      long state;
                      long lastinput;
                      long lastoutput;
                      int tty;
                      unsigned ttymode;
                      int msgrdcnt;
                      int msgwrcnt;
                      msg_t msg[_MAXMSG];
                      char name[32];
                      char cmd[_MAXCMD+1];
                      const INFO *info;
                      int rxcharcount;
                      char txcharcount;
                      int pid;
                      int parentid;
                      tcb *prev;
                      tcb *next;
                   }tcb_t;

typedef struct fopenrsc { unsigned pid;
                          FILE *f;
                          char file[_MAX_PATH];
                          char mode[10];
                          //fopenrsc *next;
                          //fopenrsc *prev;
                        } fopenrsc_t;

typedef struct openrsc  { unsigned pid;
                          unsigned handle;
                          char file[_MAX_PATH];
                          unsigned access;
                          unsigned mode;
                          //openrsc *prev;
                          //openrsc *next;
                        } openrsc_t;

typedef struct memrsc   { unsigned pid;
                          void *mem;
                          size_t size;
                          //memrsc *prev;
                          //memrsc *next;
                        } memrsc_t;


void suspend(unsigned long t);
int waitfor(long what);

int kill (int task);
int get_firsttask();
int fork(char *name,void *task,unsigned long prio,unsigned long type,int stream,unsigned stacksize);
int initsched(void);
int getidle(int mode);
#ifdef stacksched
void interrupt startsched(void);
void interrupt scheduler(void);
void interrupt taskend(void);
#else
void startsched(void);
void scheduler(void);
void taskend(void);
#endif
long get_global_msg(void);
void put_global_msg(long msg);
int put_msg(char *name,long msg);
int put_msg(int task,long msg);
msg_t *get_msg(void);
int get_tasknum(void);
int get_tasknum(char *name);
tcb_t *get_tcb(int task);
tcb_t *get_tcb(char *name);
tcb_t *get_tcb(void);
int get_tasksrun(void);
time_t ad_time(time_t *t);

void *tmalloc(size_t bytes);
void tfree(void *block);
FILE *tfopen(const char *filename, const char *mode);
int tfclose(FILE *stream);
int topen(const char *path, int access, unsigned mode );
int topen(const char *path, int access);
int tclose(int handle);
void rscstat(char *s);
void show_ps(char *s);
