/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  daemon to enable string-intertask-communication
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#ifdef DVMS
#include "dvms.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#endif

#include "tnclow.h"
#define _MAXTALK 50


void talkdaemon(void)
{  static msg_t *msg,msgbuf[_MAXTALK];
  char *buf;
  int m=0,i,wasquit,use;

    //alle msg adressen lschen.
  for(i=0;i<_MAXTALK;i++)
    msgbuf[i].msg=NULL;

  while(1)
  {  //pollen nach talk-msgs, beenden, falls shutdown.
    while((msg=get_msg())==NULL && !(get_global_msg()&_SHUTDOWN))
      suspend(1);

    if(get_global_msg()&_SHUTDOWN)
      break;

    //nachsehen, ob Nachricht eine Besttigung ist
    //.msg enthlt dann die bufferadresse .pid wird erniedrigt
    //wenn .pid==0 speicherbereich wieder freigeben
    wasquit=0;
    use=0;
    for(m=0;m<_MAXTALK;m++)
    {  if(msg->msg==msgbuf[m].msg)
      { wasquit=1;
        //cp("\r\nQuitmessage from %d",msg->pid);
        if(!(--msgbuf[m].pid))
        { tfree((void *)msgbuf[m].msg);
          msgbuf[m].msg=0L;
        }
      }

      if(msgbuf[m].msg!=NULL)
       use++;
    }

    //suchen nach erstem freien Block
    for(m=0;m<_MAXTALK;m++)
      if(msgbuf[m].msg==0L)
        break;

//      cp("\r\ntalkdaemon: %d blocks used.",use);

    //ist der absender task noch da und ist noch platz fr einen Zeiger
    if((!wasquit) && (m<_MAXTALK))
    {  //talknachricht abholen und in lokalen puffer kopieren
      //+11 weil platz frs absender Rufzeichen sein mu
      if((msgbuf[m].msg=(long)tmalloc(strlen((char *)msg->msg)+20))!=NULL)
      {  //cp("\r\ndaemon %lX newused",msgbuf[m].msg);
	//Rufzeichen extrahieren
	buf=strupr(get_onlycall((char *)msg->msg));
	#ifdef VTGEN
	if(!strcmp(buf,"ATV"))
	  sprintf((char *)msgbuf[m].msg,"%s:%s",get_tcb(msg->pid)->name,(char *)(msg->msg)+strlen(buf));
	else
	#endif
	  if(!strcmp(buf,"DTMF"))
	    strcpy((char *)msgbuf[m].msg,(char *)(msg->msg)+strlen(buf)+1);
	   else
	    sprintf((char *)msgbuf[m].msg,"*%-6s*:%s",get_tcb(msg->pid)->name,(char *)(msg->msg)+strlen(buf));
	  //cp("\r\ndaemon %s",(char *)msgbuf[m].msg);
	  //adressatenzhler hochzhlen
	msgbuf[m].pid=0;

	#ifdef VTGEN
	//ausnahmefall "screen"
	if(!strcmp(buf,"ATV"))
	{  if(put_msg("getprosd",msgbuf[m].msg)!=-1)
	    msgbuf[m].pid++;
	}
	else
	if(!strcmp(buf,"DTMF"))
	{  if(put_msg("dtmfupd",msgbuf[m].msg)!=-1)
	    msgbuf[m].pid++;
	}
	#else
	if(!strcmp(buf,"DTMF"))
	{  if(put_msg("mailbox",msgbuf[m].msg)!=-1)
	    msgbuf[m].pid++;
	}
	#endif
	else
	{  //nachsehen, wie oft die Nachricht verteilt werden mu
	  //nach erstem task suchen
	  tcb *next=get_tcb(get_firsttask());
	  do
	    if(( ((next->type&_MONBIT)&&!strcmp(buf,"MON"))||!strcmp(buf,"ALL")||!strcmp(next->name,buf))&&
	       (((next->type&0xff)==_TNCPROC)||(next->type&_CONSOLE))
	      )
	      {  if((msg->pid!=next->pid)&&(put_msg(next->pid,msgbuf[m].msg)!=-1))
                  msgbuf[m].pid++;
                //und nachricht verschicken
              }
          while((next=next->next)!=NULL);
        }
        //putf("\r\nmessage: %s from %s",(char *)msgbuf[m].msg,buf);
        //putf("\r\nsending message to %d users",msgbuf[m].pid);
          //hoppala, dann gibt's den Benutzer wohl doch nicht
        // nur zur Sicherheit drin um Zombies zu vermeiden
        if(!msgbuf[m].pid)
        { tfree((void*)msgbuf[m].msg);
          msgbuf[m].msg=0L;
        }
      }
    }
    if(m==_MAXTALK)
    {  if(get_tcb()!=NULL)
      {  if(!(get_tcb()->type&_TNCPROC))
          set_win(get_tcb()->tty);
        else
          set_win(defaultwin);
      }
      gotoxy(1,2);
      cprintf("talkdaemon: no more mem");
    }
    //scheduler();
  }
  //beim Beenden des talkdaemons alle allokierten Speicherbereiche
  //wieder freigeben
  for(m=0;m<_MAXTALK;m++)
    if(msgbuf[m].msg!=0L)
      tfree((void*)msgbuf[m].msg);
}
