/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  handles the ascii talk functions in packet radio
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#ifdef DVMS
#include "dvms.h"
#endif
#ifdef VTGEN
#include "vtgen.h"
#endif

#include "tnclow.h"
#include "util.h"

int gettalk(void)
{  msg_t *msg;

  if((msg=get_msg())==NULL)
    return 0;

  if(get_tcb()->type&_CONSOLE)
  { set_win(defaultwin);
    cprintf("%s\r\n",(char *)msg->msg);
  }
  else
    putf("%s\r",(char *)msg->msg);
  //Quittung senden
  while(put_msg(msg->pid,msg->msg)==-1)
    suspend(1);

  return 1;
}

void talk(char *t)
{  char buffer[81];
  char *b;
  int mode=0,clen;
  long start=time(NULL);

  //talk ohne parameter
  if(!t[0])
  {  putf("syntax: talk <user> [<msg>]\r");
    return;
  }
  #ifdef VTGEN
  if((get_tasknum((b=strupr(get_onlycall(t))))==-1) && strcmp(b,"ALL")&&strcmp(b,"ATV")&&!(!strcmp(b,"DTMF")&&(get_tcb()->type&_SYSOP)))
  #else
  if((get_tasknum((b=strupr(get_onlycall(t))))==-1) && strcmp(b,"ALL")&&!(!strcmp(b,"DTMF")&&(get_tcb()->type&_SYSOP)))
  #endif
  {  putf("User %s is not logged in.\r",b);
    return;
  }

  //herausfinden, ob nach dem Rufzeichen noch mehr steht
  if(sscanf(t,"%s%s",buffer,buffer)!=2)
  {  mode=1;
    putf("*** talking to %s; exit: /q\r",b);
    clen=strlen(buffer);
    buffer[clen++]=32;
    buffer[clen]=0;
  }

  do
  { //dauereingabemodus falls talk ohne text
    if(mode)
    {  do
      {  if(get_tcb()->type&_CONSOLE)
              set_win(defaultwin);
        //neue Zeile hohlen
        if(getline(buffer+clen,79-clen-4,6)==-1)
        {  //Verbindungsabbruch oder talkmsg ?
          if(!gettalk())
          {  mode=-1;
            break;
          }
          else
            continue;
        }

        if(get_tcb()->type&_CONSOLE)
          putv('\r');

      //ende sequenz ?
      }while(!buffer[clen]);
      if(!strcmp(buffer+clen,"/q"))
      {  putf("*** talk closed (%s).\r",zeitspanne(time(NULL)-start,1));
        break;
      }
    }
    if(mode==-1)
      break;
    //text retten
    if(!mode)
      strcpy(buffer,t);

    #ifdef VTGEN
    if((get_tasknum((b=strupr(get_onlycall(t))))==-1) && strcmp(b,"ALL")&&strcmp(b,"ATV")&&!(!strcmp(b,"DTMF")&&(get_tcb()->type&_SYSOP)))
    #else
    if((get_tasknum((b=strupr(get_onlycall(t))))==-1) && strcmp(b,"ALL")&&!(!strcmp(b,"DTMF")&&(get_tcb()->type&_SYSOP)))
    #endif
    {  putf("*** User %s has logged out.\r",b);
      break;
    }

    if(put_msg("talkd",(long)buffer)==-1)
    {  putf("*** put_msg failed.\r");
      break;
    }
    suspend(2);
  }while(mode);
}
