;**********************************************************************;
;*                       P R O Z C A . A S M                          *;
;*--------------------------------------------------------------------*;
;*    Aufgabe        : Stellt zwei Funktionen fr die Einbindung in   *;
;*                     C-Programme zur Verfgung, mit deren Hilfe     *;
;*                     der Prozessortyp und die Art des Co-Prozessors *;
;*                     ermittelt werden kann.                         *;
;*--------------------------------------------------------------------*;
;*    Autor          : MICHAEL TISCHER                                *;
;*    entwickelt am  : 15.08.1988                                     *;
;*    letztes Update : 17.10.1991                                     *;
;*--------------------------------------------------------------------*;
;*    assemblieren   : MASM PROZCA;  oder TASM PROZCA                 *;
;*                     ... dann mit einem C-Programm zusammenlinken   *;
;**********************************************************************;
PROZCA_TEXT  segment byte public 'CODE'
PROZCA_TEXT  ends
DGROUP  group  PROZCA_DATA,PROZCA_BSS
  assume  cs:PROZCA_TEXT,ds:DGROUP
PROZCA_DATA  segment word public 'DATA'
PROZCA_DATA  ends
PROZCA_BSS  segment word public 'BSS'
PROZCA_BSS  ends


;IGROUP group _text                ;Zusammenfassung der Programm-Segmente
;DGROUP group _bss,  _data         ;Zusammenfassung der Daten-Segmente
;       assume CS:IGROUP, DS:DGROUP, ES:DGROUP, SS:DGROUP

;_BSS   segment word public 'BSS'  ;dieses Segment nimmt alle nicht ini-
;_BSS   ends                       ;tialisierten statischen Variablen auf

;_DATA  segment word public 'FAR_DATA' ;alle initialisierten globalen und
                                  ;statischen Variablen werden in diesem
                                  ;Segment untergebracht
;_DATA  ends

;== Konstanten =========================================================

p_80486   equ   8                 ;Codes fr die verschiedenen Pro-
p_80386   equ   7                 ;zessortypen
p_80286   equ   6
p_80186   equ   5
p_80188   equ   4
p_v30     equ   3
p_v20     equ   2
p_8086    equ   1
p_8088    equ   0

co_80387  equ   3                 ;Codes fr die Coprozessoren
co_80287  equ   2
co_8087   equ   1
co_kein   equ   0

NOP_CODE  equ   90h               ;Code des Maschinensprache-Befehls NOP
DEC_DX_C  equ   4Ah               ;Code von DEC DX

;== globale Variablen ==================================================

PROZCA_DATA  segment word public 'DATA'

cpz       dw  0                   ;fr Co-Prozessor-Test

PROZCA_DATA  ends

;== Programm ===========================================================

PROZCA_TEXT  segment byte public 'CODE' ;das Programmsegment

public   @getproz$qv                 ;Funktion wird fr andere Programme
public   @getco$qv                   ;zugnglich

;-- GETPROZ: ermittelt den Prozessortyp, mit dem ein PC bestckt ist ---
;-- Aufruf von C: int getproz( void );
;-- Ausgabe     : die Nummer des Prozessortyps (siehe dazu Konstanten)

@getproz$qv  proc far

          pushf                   ;den Inhalt des Flag-Registers sichern
    push di

    ;== feststellen, ob Modell vor 80286 oder danach =============

          xor  ax,ax              ;AX auf 0 setzen
          push ax                 ;und auf den Stack bringen
          popf                    ;als Flag-Register vom Stack holen
          pushf                   ;wieder auf den Stack bringen
          pop  ax                 ;und als AX zurckholen
          and  ax,0f000h          ;nur die oberen 4 Bits nicht lschen
          cmp  ax,0f000h          ;sind die Bits 12 - 15 alle gleich 1?
    je   kleiner_286        ;JA, Modell vor 80286

    ;-- testen, ob es sich um 80486, 80386 oder 80286 handelt ----

          mov  dl,p_80286         ;es handelt sich auf jeden Fall um
    mov  ax,07000h          ;einen der drei Prozessoren
    push ax                 ;den Wert 07000h auf den Stack bringen
    popf                    ;als Flag-Register zurckholen
    pushf                   ;und wieder auf den Stack bringen
    pop  ax                 ;in das AX-Register zurckholen
    and  ax,07000h          ;nur die Bits 12 - 14 nicht ausblenden
    je   pende              ;sind die Bits 12 - 14 alle gleich 0?
          ;JA --> es handelt sich um einen 80286

    inc  dl                 ;Nein, es handelt sich um einen 80386
          ;oder 486. Zunchst auf 386 einstellen

    ;-- Der folgende Test zwischen 80386 und 80486 beruht auf ----
    ;-- einer Erweiterung des EFlags-Registers beim 80486 in
    ;-- Bitposition 18.
    ;-- Dieses Flag gibt es beim 80386 nicht, und deshalb lt
    ;-- sich sein Inhalt auch nicht per Software verndern.

    cli                     ;keine Interrupts jetzt

db 066h,08Bh,0DCh          ;mov    ebx,esp       aktuelles SP merken
db 066h,083h,0E4h,0FCh     ;and    esp,0FFFCh    auf DWORD abrunden
db 066h,09Ch               ;pushfd               Flag-Register ber
db 066h,058h               ;pop    eax           Stack nach AX
db 066h,08Bh,0C8h          ;mov    ecx,eax       und in CX merken
db 066h,035h,000h,0h,4h,0h ;xor    eax,1 shl 18  Alignment-Bit umdrehen
db 066h,050h               ;push   eax           und in das Flag-
db 066h,09Dh               ;popfd                Register bringen
db 066h,09Ch               ;pushfd               Flag wieder auf Stack
db 066h,058h               ;pop    eax           und dann nach AX
db 066h,051h               ;push   ecx           alten Flag-Inhalt
db 066h,09Dh               ;popfd                wieder zurck
db 066h,033h,0C1h          ;xor    eax,ecx       AL-Bit testen
db 066h,0C1h,0E8h,012h     ;shr    eax,18        AL-Bit nach Bit 0
db 066h,083h,0E0h,001h     ;and    eax,1h        alle anderen ausbl.
db 066h,08Bh,0E3h          ;mov    esp,ebx       SP wieder zurcks.

    sti                     ;Interrupts wieder erlauben
    add  dl,al              ;AL ist 1, wenn 486
    jmp  pende              ;der Test ist beendet

    ;== auf 80186 bzw. 80188 testen ==============================

kleiner_286 label near

    mov  dl,p_80188         ;Code fr 80188 laden
    mov  al,0ffh            ;alle Bits im AL-Register auf 1 setzen
    mov  cl,021h            ;Anzahl der Shift-Operationen nach CL
    shr  al,cl              ;AL CL mal nach rechts verschieben
    jne  t88_86             ;AL ist nicht 0, es mu sich um den
          ;80188 oder 80186 handeln

    ;== auf NEC V20 oder V30 testen ==============================

    mov  dl,p_v20           ;Code fr NEC V20 laden
    sti                     ;Interrupts sollen erlaubt sein
    push si                 ;den Inhalt des SI-Registers merken
    mov  si,0               ;mit dem ersten Byte in ES beginnen
    mov  cx,0ffffh          ;ein komplettes Segment lesen
       rep  lods byte ptr es:[si]  ;REP mit einem Segment-Override
                          ;funktioniert nur bei NEC V20, V30
       pop  si                 ;SI wieder vom Stack holen
       or   cx,cx              ;wurde das komplette Segment gelesen?
       je   t88_86             ;JA --> ist V20 oder V30

       mov  dl,p_8088          ;NEIN --> mu 8088 oder 8086 sein

    ;== auf ...88 oder ...86 bzw. V20 oder V30 testen ============
    ;-- Test mit Hilfe der Queue durchfhren (wie oben), hier ist
    ;-- jedoch eine kleinere Queue zu bercksichtigen

t88_86    label near

       push cs                 ;CS auf dem Stack merken
       pop  es                 ;und als ES zurckholen
       std                     ;bei Stringbefehlen abwrts zhlen
    mov  di,offset q2_end   ;DI auf das Ende der Queue setzen
    mov  al,0fbh            ;Befehlscode fr "STI"
       mov  cx,3               ;den Stringbefehl 3 mal ausfhren
       cli                     ;Interrupts unterdrcken
    rep  stosb              ;den INC DX-Befehl berschreiben
       cld                     ;bei Stringbefehlen wieder aufwrts
       nop                     ;Dummy-Befehle zum Queue fllen
       nop
       nop

       inc  dx                 ;Prozessorcode inkrementieren
       nop
q2_end:   sti                     ;Interrupts wieder erlauben
                                                                        
          ;-------------------------------------------------------------
                                                                        
pende     label near              ;die Tests sind abgeschlossen
                                                                        
    pop  di                 ;DI wieder vom Stack holen
    popf                    ;Flag-Register wieder vom Stack holen
          xor  dh,dh              ;HI-Byte des Prozessorcodes auf 0
    mov  ax,dx              ;Prozessorcode ist Return-Wert der Fkt

    ret                     ;zurck zum Aufrufer


@getproz$qv  endp                    ;Ende der Prozedur

;-- GETCO: ermittelt die Art des Co-Prozessors, sofern vorhanden -----
;-- Aufruf von C: int getco( void );
;-- Ausgabe     : die Nummer des Co-Prozessortyps (siehe Konstanten)

@getco$qv proc far

    mov   dx,co_kein           ;zunchst von fehlendem CP ausgehen

    mov   byte ptr cs:wait1,NOP_CODE   ;WAIT-Befehle bei 8087
    mov   byte ptr cs:wait2,NOP_CODE   ;durch NOP ersetzen

wait1:    finit                   ;Cop initialisieren
    mov   byte ptr cpz+1,0  ;Hi-Byte Control-Word auf 0
wait2:    fstcw cpz               ;Control-Word speichern
    cmp   byte ptr cpz+1,3  ;Hi-Byte Control-Word = 3?
    jne   gcende            ;Nein ---> kein Coprozessor

    ;-- es ist ein Coprozessor vorhanden. Auf 8087 testen --------

    inc   dx
    and   cpz,0FF7Fh        ;Interrupt-Enable-Mask-Flag ausblenden
    fldcw cpz               ;in das Control-Word laden
    fdisi                   ;IEM-Flag setzen
    fstcw cpz               ;Control-Word zurckladen
    test  cpz,80h           ;wurde das IEM-Flag gesetzt?
    jne   gcende            ;JA ---> ist 8087, Test beenden

    ;-- auf 80287/80387 testen -----------------------------------

    inc   dx
    finit                   ;Cop initialisieren
    fld1                    ;Zahl 1 auf den Cop-Stack
    fldz                    ;Zahl 0 auf den Cop-Stack
    fdiv                    ;1 durch 0 teilen, Erg nach ST
    fld   st                ;ST auf den Stack schieben
    fchs                    ;Vorzeichen in ST umdrehen
    fcompp                  ;ST und ST(1) vergleichen und poppen
    fstsw cpz               ;Resultat aus Status-Word ber ...
    mov   ah,byte ptr cpz+1 ;den Speicher und das AX-Register ...
    sahf                    ;in das Flag-Register
    je    gcende            ;Zero-Flag = 1 : 80287

    inc   dx                ;kein 80287, mu 80387 oder inte-
          ;grierter Co-Proz beim 80486 sein

gcende:   mov   ax,dx             ;Funktionsergebnis nach AX
    ret                     ;zurck zum Aufrufer

@getco$qv    endp

;== Ende ===============================================================

PROZCA_TEXT     ends                    ;Ende des Programm-Segments
    end                     ;Ende des Assembler-Source
