/***************************************************************

  DVMS            Digital Voice Mailbox System
  VTGEN
  SERV

  --------------------------------------------------
  moves a file
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#ifdef VTGEN
#include "vtgen.h"
#endif
#ifdef DVMS
#include "dvms.h"
#endif


int move_file(char *source,char *dest,int mode)
{ char dests[_MAX_PATH];
  char drive[_MAX_DRIVE];
  char dir[_MAX_DIR];
  char file[_MAX_FNAME];
  char ext[_MAX_EXT];
  char *buffer,*r="move_file";
  int handlein,handleout;
  long lengthcount=0,length;

  scheduler();
  _splitpath(source,drive,dir,file,ext);

  if(dest[strlen(dest)-1]=='\\')
    sprintf(dests,"%s%s%s",dest,file,ext);
  else
    strcpy(dests,dest);

  write_log(_report,r,"%s -> %s",source,dests);
  remove(dests);
  if(mode)
    if(!rename(source,dests))
      return 1;

  if((buffer=(char *)tmalloc(8192L))==NULL)
  { write_log(_serious,r,"malloc error");
    return(0);
  }

  if((handlein=topen(source,O_RDONLY|O_BINARY))<1)
  { write_log(_serious,r,"topen error %s",source);
    tfree(buffer);
    return(0);
  }

  if((handleout=topen(dests,O_CREAT|O_WRONLY|O_BINARY,S_IREAD|S_IWRITE))<1)
  { tclose(handlein);
    write_log(_serious,r,"topen error %s",dests);
    tfree(buffer);
    return(0);
  }

  length=filelength(handlein);

  while((lengthcount+8192L)<length)
  { if(read(handlein,buffer,8192U)==-1)
    { write_log(_serious,r,"read error %s",source);
      goto sprung;
    }
    if(write(handleout,buffer,8192U)==-1)
    { write_log(_serious,r,"write error %s",dests);
      goto sprung;
    }
    lengthcount+=8192L;
  }

  if(lengthcount<length)
  { if(read(handlein,buffer,(unsigned)(length-lengthcount))==-1)
    { write_log(_serious,r,"read error %s",source);
      goto sprung;
    }
    if(write(handleout,buffer,(unsigned)(length-lengthcount))==-1)
    { write_log(_serious,r,"write error %s",dests);
      goto sprung;
    }
  }

  tclose(handleout);
  tclose(handlein);

  if(mode)
    if(remove(source)==-1)
      write_log(_serious,r,"remove error %s",source);

 tfree(buffer);
 return(1);

 sprung:;
 tclose(handleout);
 tclose(handlein);
 tfree(buffer);
 return(0);
}