/***************************************************************
  DVMS
  VTGEN
  SERV

  --------------------------------------------------
  exit() and CTRL-BRK handling
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#ifdef DVMS
#include "dvms.h"
#include "dvmssuba.h"
#include "dvmsirq.h"
#include "dvmsptt.h"
#endif

#ifdef VTGEN
#include "vtgen.h"
#include "vti2c.h"
#endif

#include "util.h"

char doreset=0;

void atex(void)
{
  #ifdef DVMS
  ptt(0);
  hw_set(1,32);
  hw_set(5,0);
  afsw(0); 
  c_tx_rate(0L,0L);
  #endif
  #ifndef DVMS
  #ifndef DUENN
  pcf_set(0,255);
  pcf_set(1,255);
  pcf_set(2,255);
  pcf_set(3,255);
  pll_setport(_LINKTX,8,0x37);

  for(int i=0;i<3;i++)
  {
    tda_setreg(i,2,0);
    tda_setreg(i+4,2,0);
  }
  #endif
  #endif
  beep(0);
  fcloseall();
  _setcursortype(_NORMALCURSOR);
  textmode(LASTMODE);
  remove(dosscreen);
  xchdir(exep);
  if(doreset)
    reset();
}

#ifdef __MSDOS__
int c_break(void)
{ static char c_pressed=0;

  put_global_msg(_SHUTDOWN);
  c_pressed++;
  if(c_pressed==2)
  { /*
    tcb_t *next=get_tcb(get_firsttask());
    do
     kill(next->pid);
    while((next=next->next)!=NULL);
    */
    taskend();
  }
  return 2;
}
#endif