/***************************************************************
  DVMS        Digital Voice Mailbox System


  --------------------------------------------------
  extended memory access
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "xmsc.h"


int  GesFrei=0,MaxBl=0;           /* Gre des gesamten freien extended-Memory */
int   EMB_Handle;    /* Handle zum Zugriff auf EMB */

void EMB_off(void)
{  XMS_FreeMem(EMB_Handle);
}

int EMS_avail(long &address)
{ if(MaxBl)
  {  address=XMS_Lock(EMB_Handle);
    XMS_Unlock(EMB_Handle);
  }
  else
    address=NULL;

  return MaxBl;
}

int EMB_Init(void)
{ if(!XMS_Init())
  { printf(" extended memory manager not present.\a\n");
    return(0);
  }

  XMS_QueryFree(GesFrei,MaxBl);

  GesFrei-= 64;                   /* tatschliche Gre ohne HMA ber. */

  if(MaxBl>=GesFrei)                    /* kann der Wert stimmen? */
    MaxBl-=64;                                                /* Nein */
  if(MaxBl<=0)
      return 0;

  if(!(EMB_Handle=XMS_GetMem(MaxBl)))
  {
    write_log(_serious,"EMB_Init","Allocation Error");
    MaxBl=0;
    return 0;
  }

  long address;
  printf(" %d KByte of extended memory at 0x%lX.\n",EMS_avail(address),address);
  atexit(EMB_off);
  return EMB_Handle;
}

/*
#define maxdirlen 500;
typedef struct   {  char name[MAXPATH];
                    long offset;
                  } EMS_dir_t ;

int file2xms(char *name)
{ FILE *f;
  if((f=tfopen(name,"rb"))==NULL)
    return 0;
  char *buff=tmalloc(8192);
  if(buff==NULL)
  {  tfclose(f);
    return 0;
  }

  long read=0L,length=filelength(fileno(f)),XMS_off=emb_entry(name);

  if(XMS_off==-1L)
  { tfclose(f);
    tfree(buff);
    return 0;
  }

  while((length-read)>8192L)
  {  read+=fread(buff,sizeof(char),8192,f);
    XMS_Copy(0,buff,EMB_Handle,XMS_off,4096);
  }

  if(length-read)
  {  fread(buff,sizeof(char),length-read,f);
    XMS_Copy(0,buff,EMB_Handle,XMS_off,length-read);
  }
  tfclose(f);
  tfree(buff);
  return 0;
}

long xms_ofs(char *name)
{  return 0;
}
*/