/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  speaks time and date in messages
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#include "dvms.h"
#include "dvmshead.h"

void _ttime(time_t time)
{  char file[80];
  struct tm *unixtime;
  unixtime=localtime(&time);

  if(unixtime->tm_hour==1)
    strcpy(file,"EIN.VMS");
  else
    sprintf(file,"%u.VMS",unixtime->tm_hour);

  readsnd(sysp,file,location);
  readsnd(sysp,"UHR_UND.VMS",location);

  if(unixtime->tm_min)
  {  sprintf(file,"%u.VMS",unixtime->tm_min);
    readsnd(sysp,file,location);
  }
}

void _ddate(time_t date,int what)
{  char DAYS_MONTHS[13];
  struct tm unixtime,actime;
  time_t t;

  unixtime=*localtime(&date);
  ad_time(&t);
  actime=*localtime(&t);
  if(actime.tm_mon==unixtime.tm_mon&&actime.tm_year==unixtime.tm_year&&what)
  {  if((actime.tm_mday-unixtime.tm_mday)==1){ readsnd(sysp,"GESTERN.VMS",location);return;}
    if((actime.tm_mday-unixtime.tm_mday)==0){ readsnd(sysp,"HEUTE.VMS",location);return;}
  }
  if(what==3)
  { rdplay(sysp,"MSG_FRM2.VMS");
    location=0L;
  }
  if(unixtime.tm_wday<7)
  {  sprintf(DAYS_MONTHS,"WEEK_%03d.VMS",unixtime.tm_wday);
    readsnd(sysp,DAYS_MONTHS,location);
    readsnd(sysp,"den.VMS",location);
  }
  sprintf(DAYS_MONTHS,"%u",unixtime.tm_mday);
  strcat(DAYS_MONTHS,".VMS");

  if(unixtime.tm_mday==1) readsnd(sysp,"ersten.VMS",location);
  if(unixtime.tm_mday==3) readsnd(sysp,"dritten.VMS",location);
  if(unixtime.tm_mday!=1 && unixtime.tm_mday!=3) readsnd(sysp,DAYS_MONTHS,location);
  if(unixtime.tm_mday<20 && unixtime.tm_mday!=1 && unixtime.tm_mday!=3)  readsnd(sysp,"ten.VMS",location);
  if(unixtime.tm_mday>19) readsnd(sysp,"sten.VMS",location);

  sprintf(DAYS_MONTHS,"MONTH_%02d.VMS",unixtime.tm_mon+1);
  readsnd(sysp,DAYS_MONTHS,location);
}

void speak_time(void)
{  readsnd(sysp,"die_zeit.VMS",0L);
  _ttime(ad_time(NULL));
  playback(0L,location);
  location=0L;
}

void speak_date(void)
{  readsnd(sysp,"heute_ist.VMS",0L);
  _ddate(ad_time(NULL),FALSE);
  rem=location;
  playback(0L,rem);
  location=0L;
}