/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  dtmf-sysop functions / user preferences
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsamp.h"
#include "dvmscmd.h"
#include "dvmsdtmf.h"
#include "dvmshead.h"
#include "dvmsirq.h"
#include "dvmsmem.h"
#include "dvmsmsgb.h"
#include "dvmspara.h"
#include "dvmspurg.h"
#include "dvmssq.h"
#include "dvmsstat.h"
#include "dvmssuba.h"
#include "dvmstime.h"
#include "tnc.h"
#include "tnclow.h"
#include "util.h"

void speak_runtime(void)
{  char flag=0;
  unsigned long runtime=ad_time(NULL)-startup;
  rdplay(sysp,"VERSION.VMS");
  if(stopped()) return;
  spkstr(version,1);
//  spkstr("C",true);
  if(stopped()) return;
  rdplay(sysp,"RUNTIME.VMS");
  if(runtime/86400L)
  {
    spknum(runtime/86400L);
    rdplay(sysp,"DAYS.VMS");
    if(stopped()) return;
    flag=1;
  }
  if(((runtime/3600L)%24L)||flag)
  {
    spknum((runtime/3600L)%24);
    rdplay(sysp,"HOURS.VMS");
    if(stopped()) return;
  }
  spknum((runtime/60L)%60L);
  if(stopped()) return;
  rdplay(sysp,"MINUTES.VMS");
  if(stopped()) return;
}

void speak_fds(void)
{ char file[80];
  spknum((users()>>16)&0xffff);
  rdplay(sysp,"BOARDS.VMS");
  if(stopped()) return;
  spknum(users()&0xffff);
  rdplay(sysp,"USERS.VMS");
  if(stopped()) return;
  sprintf(file,"%s*.*",cfg.usrp);
  spknum(length(file)>>20);
  rdplay(sysp,"FDSPC_02.VMS");
  if(stopped()) return;
  spknum(mails());
  rdplay(sysp,"MAILS.VMS");
  sprintf(file,"%s*.*",cfg.msgp);
  spknum(length(file)>>20);
  rdplay(sysp,"FDSPC_01.VMS");
  if(stopped()) return;
  spknum(free_disk_space(cfg.msgp,0)>>20);

  if(!accessp(sysp,"OF.VMS"))
    rdplay(sysp,"OF.VMS");
  else
    rdplay(sysp,"VON.VMS");

  spknum(free_disk_space(cfg.msgp,1)>>20);
  rdplay(sysp,"FDSPC_00.VMS");
  if(stopped()) return;
}

int serv_user(void)
{ int usr;
  struct dostime_t _time;
  struct dosdate_t _date;
  char ok[3],help[80],dtmf[20];
  _dos_gettime(&_time);
  _dos_getdate(&_date);
  sprintf(help,"%02u%02u",_date.day,_time.hour);
  ok[0]=help[1];
  ok[1]=help[3];
  ok[2]=0;

  rdplay(cfg.sysp[0],"SERV_001.VMS");
  if(wait_carrier(1)==-1)return(0);
  rcvdtmf(dtmf,TRUE);
  usr=atoi(dtmf);

  if(spk_user(cfg.boxaddress,usr,FALSE))
    spk_name(cfg.boxaddress,usr);
  else
    rdplay(cfg.sysp[0],"SERV_008.VMS");
  if(wait_carrier(1)==-1)return(0);
  rcvdtmf(dtmf,TRUE);

  if(!strncmp(dtmf,ok,2))
  {  dtmf[0]=0;
    return(usr);
  }
  else
  {  dtmf[0]=0;
    return(0);
  }
}

void service(char *S_num)
{  long usr;
  char help[80],file[80],dtmf[80],*r="service";
  msg_info_t MInfo;
  struct dostime_t  time2,time1;
  struct dosdate_t  date2,date1;

  if(!strcmp(S_num,"001"))
  {  rdplay(cfg.sysp[0],"SERV_007.VMS");
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    rdplay(cfg.sysp[0],"SERV_005.VMS");
    location=0L;
    spkstr(dtmf,1);
    rdplay(sysp,"WRTMSG2.VMS");
    usr=atoi(dtmf);
    sprintf(file,"LOGIN_%02d.VMS",usr);
    init_msg_info(MInfo);
    record_write(cfg.sysp[0],file,cfg.max_msg_length,MInfo);
    rdplay(cfg.sysp[0],file);
    write_log(_report,r,"record logintxt %s",file);
  }

  if(!strcmp(S_num,"002"))
  {  rdplay(cfg.sysp[0],"SERV_007.VMS");
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    location=0L;
    spkstr(dtmf,1);
    usr=atoi(dtmf);
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    if(dtmf[0]=='*')
    {  sprintf(file,"LOGIN_%02d.VMS",usr);
      strcpy(help,cfg.sysp[0]);
      strcat(help,file);
      remove(help);
      write_log(_report,r,"delete logintxt %s",file);
      rdplay(cfg.sysp[0],"SERV_006.VMS");
    }
  }

  if(!strcmp(S_num,"003"))
  {  rdplay(cfg.sysp[0],"SERV_004.VMS");
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    rdplay(cfg.sysp[0],"SERV_005.VMS");

    location=0L;
    spkstr(dtmf,1);
    rdplay(sysp,"WRTMSG2.VMS");
    usr=atoi(dtmf);
    sprintf(file,"NEWS_%03d.VMS",usr);
    init_msg_info(MInfo);
    record_write(cfg.sysp[0],file,cfg.max_msg_length,MInfo);
    rdplay(cfg.sysp[0],file);
    write_log(_report,r,"record news %s",file);
  }

  if(!strcmp(S_num,"004"))
  {  rdplay(cfg.sysp[0],"SERV_004.VMS");
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    location=0L;
    spkstr(dtmf,1);
    usr=atoi(dtmf);
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    if(dtmf[0]=='*')
    {  sprintf(file,"NEWS_%03d.VMS",usr);
      strcpy(help,cfg.sysp[0]);
      strcat(help,file);
      remove(help);
      write_log(_report,r,"delete news %s",file);
      rdplay(cfg.sysp[0],"SERV_006.VMS");
    }
  }

  if(!strcmp(S_num,"011"))
  {  if((usr=serv_user())!=0)
    {  int uold=ulogin;
      msg_info_t uiold=User_Info;

      User_Info.Info[0]=0;
      if(reccall(usr,FALSE))
      {  write_log(_report,r,"mkuser #%d",usr);
        change_userfile(User_Info.Info,usr);
      }
      ulogin=uold;
      User_Info=uiold;
    }
  }

  if(!strcmp(S_num,"012"))
  {  if((usr=serv_user())!=0)
    {  write_log(_report,r,"deluser #%d",usr);
      del_usr(usr);
      rdplay(cfg.sysp[0],"SERV_003.VMS");
    }
  }

  if(!strcmp(S_num,"013"))
  {  if((usr=serv_user())!=0)
    {  write_log(_report,r,"stripbox #%d",usr);
      sprintf(file,"%04d_USR.VMS",usr);
      rd_file_info(cfg.usrp,file,File_Info);
      File_Info.State=File_Info.State&(0xffff-_USRST_PROTECT-_USRST_PROTAMP);
      File_Info.Id&=0xff;
      wrt_file_info(cfg.usrp,file,TRUE,File_Info);
      sprintf(file,"%04d_NAM.VMS",usr);
      rd_file_info(cfg.usrp,file,File_Info);
      File_Info.State=File_Info.State&(0xffff-_USRST_PROTECT);
      wrt_file_info(cfg.usrp,file,TRUE,File_Info);
      rdplay(cfg.sysp[0],"SERV_002.VMS");
    }
  }
  if(!strcmp(S_num,"014"))
  {  if((usr=serv_user())!=0)
    {  sprintf(file,"%04d_USR.VMS",usr);
      rd_file_info(cfg.usrp,file,File_Info);
      File_Info.Id|=_USRID_SYSOP;
      wrt_file_info(cfg.usrp,file,TRUE,File_Info);
      write_log(_report,r,"mksysop #%d",usr);
      rdplay(cfg.sysp[0],"SYST_ONL.VMS");
    }
  }

  if(!strcmp(S_num,"015"))
  {  if((usr=serv_user())!=0)
    {  sprintf(file,"%04d_USR.VMS",usr);
      rd_file_info(cfg.usrp,file,File_Info);
      File_Info.Id&=(0xffff-_USRID_SYSOP);
      wrt_file_info(cfg.usrp,file,TRUE,File_Info);
      rdplay(cfg.sysp[0],"SERV_002.VMS");
      write_log(_report,r,"rmsysop #%d",usr);
    }
  }

  if(!strcmp(S_num,"016"))
  {  if((usr=serv_user())!=0)
    {  write_log(_report,r,"delname #%d",usr);
      sprintf(help,"%s%04d_NAM.VMS",cfg.usrp,usr);
      remove(help);
      rdplay(cfg.sysp[0],"SERV_003.VMS");
    }
  }

  if(!strcmp(S_num,"017"))
  {  if((usr=serv_user())!=0)
    {  write_log(_report,r,"ampreg #%d",usr);
      amp_call(usr);
    }
  }

  if(!strcmp(S_num,"018"))
  {  write_log(_report,r,"auto ampreg");
    not_amp();
  }

  if(!strcmp(S_num,"019"))
  {  if((usr=serv_user())!=0)
    {  write_log(_report,r,"getinfo #%d",usr);
      sprintf(file,"%04d_USR.VMS",usr);
      rd_file_info(cfg.usrp,file,File_Info);
      usr=File_Info.Id;
      spknum((unsigned long) File_Info.State);
      spknum((unsigned long) usr);
    }
  }

  if(!strcmp(S_num,"021"))
  {  if((usr=serv_user())!=0)
    {  int uold=ulogin;
      msg_info_t uiold=User_Info;

      User_Info.Info[0]=0;
      if(reccall(usr,TRUE))
      { write_log(_report,r,"mkboard #%d",usr);
        change_userfile(User_Info.Info,usr);
        rdplay(cfg.sysp[0],"SET_LIFE.VMS");
        if(wait_carrier(1)==-1)return;
        rcvdtmf(dtmf,TRUE);
        sprintf(help,"%04d_USR.VMS",usr);
        rd_file_info(cfg.usrp,help,File_Info);
        File_Info.Days=atoi(dtmf);
        usr=File_Info.Days;
        wrt_file_info(cfg.usrp,help,FALSE,File_Info);
        rdplay(sysp,"LIFETIME.VMS");
        spknum((long)usr);
      }
      ulogin=uold;
      User_Info=uiold;

    }
  }

  if(!strcmp(S_num,"022"))
  {  if((usr=serv_user())!=0)
    {  write_log(_report,r,"rmboard #%d",usr);
      del_usr(usr);
      rdplay(cfg.sysp[0],"SERV_003.VMS");
    }
  }

  if(!strcmp(S_num,"023"))
  {  if((usr=serv_user())!=0)
    {  write_log(_report,r,"lifetime #%d",usr);
      rdplay(cfg.sysp[0],"SET_LIFE.VMS");
      if(wait_carrier(1)==-1)return;
      rcvdtmf(dtmf,TRUE);
      sprintf(help,"%04d_USR.VMS",usr);
      rd_file_info(cfg.usrp,help,File_Info);
      File_Info.Days=atoi(dtmf);
      usr=File_Info.Days;
      wrt_file_info(cfg.usrp,help,FALSE,File_Info);
      rdplay(sysp,"LIFETIME.VMS");
      spknum((long)usr);
      rdplay(sysp,"DAYS.VMS");
    }
  }

  if(!strcmp(S_num,"030"))
  {  rdplay(sysp,"SERV_008.VMS");
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    if(dtmf[0]=='*')
    {  write_log(_report,r,"record: welcome.vms");
      rdplay(sysp,"WRTMSG2.VMS");
      init_msg_info(MInfo);
      record_write(cfg.msgp,"WELCOME.VMS",cfg.max_msg_length,MInfo);
      rdplay(cfg.msgp,"WELCOME.VMS");
    }
  }
  if(!strcmp(S_num,"040"))
    all_call();

  if(!strcmp(S_num,"050"))
    auto_amp();


  if(!strcmp(S_num,"090"))
  {  write_log(_report,r,"reorg all");
    fork("reorg",event,_NPRIO,_NPROC,0,_BIG);
    rdplay(cfg.sysp[0],"SYST_ONL.VMS");
  }

  if(!strcmp(S_num,"091"))
  {  write_log(_report,r,"reorg usr");
    fork("reorg_usr",reorg_usr,_NPRIO,_NPROC,0,_BIG);
    rdplay(cfg.sysp[0],"SYST_ONL.VMS");
  }

  if(!strcmp(S_num,"092"))
  {  write_log(_report,r,"purge usr");
    fork("usr_serv",purge_usr,_NPRIO,_NPROC,0,_BIG);
    rdplay(cfg.sysp[0],"SYST_ONL.VMS");
  }

  if(!strcmp(S_num,"093"))
  {  write_log(_report,r,"reorg msg");
    fork("reorg_msg",reorg_msg,_NPRIO,_NPROC,0,_BIG);
    rdplay(cfg.sysp[0],"SYST_ONL.VMS");
  }

  if(!strcmp(S_num,"094"))
  {  write_log(_report,r,"purge msg");
    fork("msg_serv",purge_msg,_NPRIO,_NPROC,0,_BIG);
    rdplay(cfg.sysp[0],"SYST_ONL.VMS");
  }

  if(!strcmp(S_num,"095"))
  {  _dos_getdate(&date1);
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    if(strlen(dtmf)==8)
    {  unsigned year;
      dtmf[2]=0;
      dtmf[5]=0;
      date2.day=(unsigned char)atoi(dtmf);
      date2.month=(unsigned char)atoi(dtmf+3);
      year=(unsigned)atoi(dtmf+6);
      if (year > 94)
        date2.year=year+1900;
      else
        date2.year=year+2000;
      _dos_setdate(&date2);
      speak_date();
      spknum(date2.year);
      if(wait_carrier(1)==-1)goto def;
      rcvdtmf(dtmf,TRUE);
      if(dtmf[0]=='*')
        write_log(_report,r,"setdate");
      else
        goto def;
      dcf_ok=TRUE;
    }
    else
    {  def:;
      _dos_setdate(&date1);
    }
  }

  if(!strcmp(S_num,"096"))
  { _dos_gettime(&time1);
    if(wait_carrier(1)==-1)return;
    rcvdtmf(dtmf,TRUE);
    if(strlen(dtmf)==5)
    {  dtmf[2]=0;
      time2.hour=(char)atoi(dtmf);
      time2.minute=(char)atoi(dtmf+3);
      time2.second=0;
      time2.hsecond=0;
      _dos_settime(&time2);
      speak_time();
      if(wait_carrier(1)==-1)
        goto def1;
      rcvdtmf(dtmf,TRUE);
      if(dtmf[0]=='*')
        write_log(_report,r,"settime");
      else
      goto def1;
      dcf_ok=TRUE;
    }
    else
    {  def1:;
      _dos_settime(&time1);
    }

  }

//  if(!strcmp(S_num,"999"))
//  {
//    update(cfg.usrp);
//  }

  if(!strcmp(S_num,"098"))
  {  if(cfg.repeater)
      set_irqloop(1);

    write_log(_report,r,"playback test.vms");
    rdplay(cfg.sysp[0],"TEST.VMS");
    set_irqloop(0);
  }

  if(!strcmp(S_num,"099"))
  {  write_log(_report,r,"readconfig");
    readconfig();
  }

  if(!strcmp(S_num,"100"))
  {  write_log(_report,r,"reset");
    do_reset();
  }

//  if(!strcmp(S_num,"101"))
//  {
//  }
  if(!strcmp(S_num,"111"))
  {  fork("statistic",statistic,_NPRIO,_NPROC,0,_BIG);
    rdplay(cfg.sysp[0],"SYST_ONL.VMS");
    c_init();
    afsw(1);
    rdplay(cfg.sysp[0],"SYST_ONL.VMS");
  }
  dtmf[0]=0;
}

void edit_vms (void)
{struct find_t find;
 char path[80],buff[20],help[80],file[80];

 set_win(filewin);
 gotoxy(1,1);
 cputs("Path    : ");
 dgets(path,26);

 if(path[strlen(path)]!='\\') strcat(path,"\\");
 gotoxy(1,2);
 cputs("Filename: ");
 dgets(help,13);

 sprintf(file,"%s%s",path,help);

 if(!_dos_findfirst(file, 0xffff, &find ))
 do
 { toggle_wd();
   gotoxy(1,2);
   cprintf("Found: %s      ",find.name);

   rd_file_info(path,find.name,File_Info);
   list_minfo(File_Info);

   gotoxy(7,3);
   dgets(buff,14);
   if(strlen(buff)) strcpy(File_Info.Filename,buff);

   gotoxy(7,5);
   dgets(buff,5);
   if(strlen(buff)) sscanf(buff,"%x",&File_Info.Id);

   gotoxy(7,6);
   dgets(buff,5);
   if(strlen(buff)) sscanf(buff,"%x",&File_Info.State);

   gotoxy(7,7);
   dgets(buff,5);
   if(strlen(buff)) File_Info.Usender=atoi(buff);

   gotoxy(7,8);
   dgets(buff,5);
   if(strlen(buff)) File_Info.Ureceiver=atoi(buff);

   gotoxy(7,9);
   dgets(buff,5);
   if(strlen(buff)) File_Info.Custom1=atoi(buff);

   gotoxy(7,10);
   dgets(buff,5);
   if(strlen(buff)) File_Info.Custom2=atoi(buff);

   gotoxy(7,11);
   dgets(buff,3);
   if(strlen(buff)) File_Info.Srate=atoi(buff)*10;

   gotoxy(7,12);
   dgets(buff,7);
   if(strlen(buff)) File_Info.Length=atol(buff);

   gotoxy(7,13);
   dgets(buff,4);
   if(strlen(buff)) File_Info.Days=atoi(buff);

   gotoxy(7,14);
   dgets(buff,17);
   if(strlen(buff)) strcpy(File_Info.Info,buff);

   list_minfo(File_Info);
   wrt_file_info(path,find.name,FALSE,File_Info);
 }
 while(!_dos_findnext( &find ));
}

void swstate(int s)
{  switch(s)
  {  case 0:  if(get_tcb()->type&_TNCPROC)
              putf("DVMS disabled.\r");
            cfg.system_state=0;
            break;

    case 1:  cfg.system_state=1;
            if(get_tcb()->type&_TNCPROC)
                putf("Repeater enabled, Box disabled.\r");
            break;

    case 2:  cfg.system_state= 3;
            if(get_tcb()->type&_TNCPROC)
              putf("Repeater and Box enabled, Newlogin disabled.\r");
            break;

    case 3: cfg.system_state= 7;
            if(get_tcb()->type&_TNCPROC)
              putf("Repeater, Box and Newlogin enabled.\r");
            break;
    default:;
  }

  if((s>=0) && (s<=4))
    write_par();

  if(!(cfg.system_state&1))
    rdplay(cfg.sysp[0],"SYST_OFL.VMS");
  else
  if((cfg.system_state==1))
  {  rdplay(cfg.sysp[0],"SYST_ONL.VMS");
    spknum(1);
  }
  else
  if((cfg.system_state==3))
  {  rdplay(cfg.sysp[0],"SYST_ONL.VMS");
    spknum(2);
  }
  else
  if((cfg.system_state==7))
  {  rdplay(cfg.sysp[0],"SYST_ONL.VMS");
    spknum(3);
  }
}
