/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  FX805 chip access / subaudio related functions
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmssb.h"

#define PTT   128
#define C_CS  64
#define C_CLK 32
#define C_DAT 16
#define C_REP 1


char fx805=0;

long ctcss_tone[]=
  {
       0L, 67000L, 71900L, 74400L, 77000L, 79700L, 82500L, 85400L, 88500L,
   91500L, 94800L, 97400L,100000L,103500L,107200L,110900L,114800L,118800L,
  123000L,127300L,131800L,136500L,141300L,146200L,151400L,156700L,162200L,
  167900L,173800L,179900L,186200L,192800L,203500L,210700L,218100L,225700L,
  233600L,241800L,250300L, 69300L,159800L,165500L,171300L,177300L,183500L,
  189700L,196600L,199500L,206500L,229100L,254100L,999999L
  };

int ctcss;
unsigned maxtones=(sizeof(ctcss_tone)>>2)-1;
unsigned long ctcss_time=0;
#ifdef __MSDOS__
void beep(long freq)
{ long v;
  char low,high;

  if(!freq)
    outp( 0x61, inp( 0x61 )&252);
  else
  { outp( 0x61, inp( 0x61 ) | 0x3 );
    v=1193180L/freq;
    low=(char)(v&255);
    high=(char)((v>>8)&255);
    outp(0x43,182);
    outp(0x42,low);
    outp(0x42,high);
  }
}

static void send(int byte)
{ static  int count;
  for(count=0;count<8;count++)
  { outp(cfg.iobase+6,inp(cfg.iobase+6)&(PTT|C_CS|(((byte&128)/128)*C_DAT)));
    outp(cfg.iobase+6,inp(cfg.iobase+6)|(((byte&128)/128)*C_DAT)|C_CLK );
    byte<<=1;
  }
  outp(cfg.iobase+6,inp(cfg.iobase+6)&(128+64));
}

static int receive(void)
{ static  int count,byte;
  byte=0;
  for(count=0;count<8;count++)
  {  byte<<=1;
    outp(cfg.iobase+6,inp(cfg.iobase+6)&(C_CLK^255));
    outp(cfg.iobase+6,inp(cfg.iobase+6)|C_CLK);
    byte|=(inp(cfg.iobase+6)&C_REP);
  }
  return(byte);
}

static void c_select(int Select)
{ if (usesb16)
    return;
  if(Select)
  { outp(0x021,inp(0x021)|1 );
    outp(cfg.iobase+6,inp(cfg.iobase+6)&(C_CS^255));
  }
  else
  { outp(cfg.iobase+6,inp(cfg.iobase+6)|C_CS);
    outp(0x021,inp(0x021)&(255-1) );
  }
}
static void c_control(int Control)
{ if (usesb16)
    return;
  c_select(TRUE);
  send(0x70);
  send(Control);
  c_select(FALSE);
}
void afsw(int i)
{
  if(cfg.afswitch)
  {  if(i)
      c_control(128+16+8*!!ulogin);
    else
      c_control(128+8*!!ulogin);
  }
  else
    c_control(128+16+8*!!ulogin);
}

void c_init(void)
{ if (usesb16)
    return;
  outp(cfg.iobase+7,128+16+1);
  outp(cfg.iobase+5,4);
  c_select(TRUE);
  send(0x01);
  c_select(FALSE);
  afsw(0);
}
#endif

void c_tx_gain(int Gain)
{ if(!fx805)
    return;

  c_select(TRUE);
  send(0x76);
  send(Gain);
  c_select(FALSE);
}

void c_tx_rate(unsigned long rate,unsigned long filter)
{ static  unsigned int  low,high,Q,P;

  if((!fx805) && (!usesb16))
  { beep(rate/1000L);
    return;
  }
  if(usesb16)
  { sb16_synth(rate/1000L);
    return;
  }

  low=0;
  high=0;

  if((rate>=67000L)&&(rate<2000000L))
  { if(!filter)
      filter=rate*2; //neu Juli 96
    P=(unsigned int) ((600L/(filter/1000L))<<4);
    Q=(unsigned int) (4000000L/(32L*rate/1000L) );
    low=Q&255;
    high=P|(Q>>8);
  }

  c_select(TRUE);
  send(0x73);
  send(high);
  send(low);
  c_select(FALSE);
}

static int c_state(void)
{ int S;
  c_select(TRUE);
  send(0x71);
  S=receive();
  c_select(FALSE);
  return(S);
}

static unsigned long c_rx_freq(int flag)
{ unsigned int  N,R;
  unsigned long F;
  int count=1000;
  if(!fx805)
    return 0UL;
  /*C_Control(128+16);*/
  if(flag)
    while(!(c_state()&1)&&count--);
  if(count==-1)
    return(0L);
  if(!flag && (c_state()&1))
  {  c_select(TRUE);
    send(0x72);
    N=receive();
    R=receive();
    c_select(FALSE);
  //  N=24;
  //  R=11;
    F=(unsigned long)N*4000000L/(1920L*(511L-(unsigned long)R))*1000L;
    return(F);
  }
  return(0L);
}

int test805(void)
{ fx805=1;
  c_init();
  c_control(128+32+16);
  c_tx_rate(400000L,0L);
  c_select(TRUE);
  send(0x75);
  send(0x55);
  c_select(FALSE);
  delay(100);
  c_tx_rate(0L,0L);
  if(c_state()&48)
    return 1;
  else
    return 0;
}

int get_ctcss (long ctcss)
{ int i,found=0;
  long diff=300000L,min=300000L;
  if((ctcss<66000L)||(ctcss>252000L))
       return(0);

  for (i=0;i<maxtones;i++)
  {  diff=labs(ctcss_tone[i]-ctcss);
    if(diff<min)
    { min=diff;
      found=i;
    }
  }
  return found;
}

void update_ctcss(void)
{
  unsigned long f;

  if((timer()-ctcss_time)>(375L/55L))
  { if(!(f=c_rx_freq(FALSE)))
    {  if((timer()-ctcss_time)>(cfg.subwait/55L))
	ctcss=0;
    }
    else
    {  ctcss_time=timer();
      ctcss=get_ctcss (f);
    }
  }
}

int check_ctcss(void)
{ if ((ctcss==(User_Info.Id>>8))||!(User_Info.Id>>8)||(ctcss==maxtones)/*||(ctcss==39)*/||((User_Info.Id>>8)==255))
    return(TRUE);
  else
    return(FALSE);
}
