/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  generates statistic file
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#include "dvms.h"
#include "dvmsirq.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmsmem.h"
#include "dvmsmsgb.h"
//#include "tnclow.h"
#include "util.h"

static int insert_file(char *file,FILE *g)
{  FILE *f;
  char a;

  if((f=tfopen(file,"rb"))!=NULL)
  {  while(!feof(f))
    {  if(((a=fgetc(f))!=255)&&(a!=_CTRLZ))
        if(a=='%')
          switch((a=fgetc(f)))
          {  case '%': fputc('%',g); break;
            case 'a': fprintf(g,timestr(get_tcb()->create)); break;
            case 'b': fprintf(g,zeitspanne(time(NULL)-get_tcb()->create,1)); break;
            case 'm': fprintf(g,get_onlycall(cfg.boxaddress+3)); break;
            case 't': fprintf(g,timestr(time(NULL))); break;
            case 'd': fprintf(g,datestr(time(NULL),0)); break;
            case 'c': fprintf(g,zeitspanne(get_tcb()->cputime,2)); break;
            case 'i': fprintf(g,"%d%",getidle(0));break;
            case 'n': fprintf(g,get_tcb()->name);break;
            case 'f': fprintf(g,"%ld",coreleft()>>10);break;
            case 'p': fprintf(g,"%d",get_tcb()->tty);break;
            case 'T': fprintf(g,"%d",get_tasknum());break;
            case 'v': fprintf(g,version);break;
            case 'u': fprintf(g,get_tcb("mailbox")->cmd);break;
            case 'r': {  
                        fprintf(g,zeitspanne(time(NULL)-startup,0));break;
                      }
            case 'l': { int l=0;
                        tcb_t *next=get_tcb(get_firsttask());
                        do
                          if(next->type&_TNCPROC)
                            l++;
                        while((next=next->next)!=NULL);
                        fprintf(g,"%d",l);
                        break;
                      }
            default:if((a>='1') && (a<='8'))
                    {
                      int adcmode=0;
                      switch(fgetc(f))
                      {
                        case '-': adcmode=-1;break;
                        case '+': adcmode=1;break;
                        case '/': adcmode=2;break;
                      }

                      long when;
                      char s[20];
                      a-='1';
                      if(get_value(when,a,s,adcmode))
                      {
                        fprintf(g,"%s",s);
                        if((abs(adcmode)==1) && adc_cfg[a].type)
                          fprintf(g," (%s %s)",datestr(when,0),timestr(when));
                      }
                    }
        }
        else
          fputc(a,g);
    }
    tfclose(f);
    return 1;
  }
  return 0;
}

void mails_waiting(unsigned usr,int *all,int *nnew)
{  msg_info_t File_Info;
  init_msg_info(File_Info);
  File_Info.Ureceiver=usr;
  File_Info.State=_MSGST_UNREAD|_MSGST_READ;
  //gotoxy(5,13);
  //cprintf("Searching and counting MSGs for %04d\n",usr);
  *all=number_of_msg_for(File_Info);

  if(*all==-1)
  {  write_log(_serious,"mails_waiting","hoppala");
    *all=0;
    *nnew=0;
  }

  if(*all!=0L)
  {  init_msg_info(File_Info);
    File_Info.Ureceiver=usr;
    File_Info.State=_MSGST_UNREAD;
    *nnew=number_of_msg_for(File_Info);
    if(*nnew==-1)
    {  write_log(_serious,"mails_waiting","murks");
      *all=0;
      *nnew=0;
    }
    return;
  }

  *nnew=0;
}

void statistic (void)
{  static sema=0;
  msg_info_t File_Info;
  struct tm *unixtime;
  FILE *handle;
  int all,nnew;
  char help[160],t[12],*file,*s,*r="statistic",path[_MAX_PATH];
       //*ftemp="fwd\\"_STATNAME".$$$",*fstat="fwd\\"_STATNAME".vms";

  unsigned unum,ucount=0,mcount=0,lt;
  long usersbytes,mailsbytes;
  unsigned long runtime=ad_time(NULL)-startup;

  if(!fwdp[0].p[0])
  {
    write_log(_serious,r,"No forward destination given!");
    return;
  }

  if(sema)
    return;

  sema=1;

  write_log(_report,r,"*** start");

  ltoa(time(NULL),t,36);
  file=t+strlen(t)-5;
  sprintf(path,"fwd\\fwd%s.vms",file);

  if((handle=tfopen(path,"wb"))!=NULL)
  {
    sscanf(cfg.statsend,"%7s @ %7s #%u",help+20,help+30,&lt);
    ltoa(ad_time(NULL),help,36);
    s=get_onlycall(cfg.boxaddress+3);

    fprintf(handle,"SB %s @ %s < %s $%s%-6.6s #%u\n",
                   help+20,help+30,s,s,file,lt);

    fputs(cfg.statsubj,handle);
    fputs("\r\n",handle);
    fprintf(handle,mkrhdr(help));

    fputs("\r\n",handle);
    fprintf(handle,initmsg);
    fprintf(handle,"\r\nBOX-ID: %s STAT: %s %s UPTIME: %lu.%02lu:%02lu\r\n\r\n",
    cfg.boxaddress,datestr(ad_time(NULL),1),timestr(ad_time(NULL)),runtime/86400L,(runtime/3600L)%24L,(runtime/60L)%60L);

    insert_file("txt\\stat_top.txt",handle);

    fprintf(handle,"\r\nUSERNUM:  CALL:   A /  N:  SEND: RECV: LOGINS:   LASTLOGIN:\r\n");
    for(unum=0;unum<1000;unum++)
    {  sprintf(help,"%s%04d_USR.VMS",cfg.usrp,unum);
      toggle_wd();
      if(!access(help,0))
      {  mails_waiting(unum,&all,&nnew);
        sprintf(help,"%04d_USR.VMS",unum);
        rd_file_info (cfg.usrp,help,File_Info);
        if(File_Info.Id==_MSGID_BBS)
          mcount++;
        else
          ucount++;

        unixtime=localtime(&File_Info.Unixtime);

        fprintf(handle,"% 4d      %-6.6s% 3d /% 3d % 5d % 5d % 5d       %02d.%02d %02d:%02d\r\n",
        unum,File_Info.Info+9,
        all,nnew,File_Info.Custom2,File_Info.Custom1,File_Info.Usender,
        unixtime->tm_mday,
        unixtime->tm_mon+1,
        unixtime->tm_hour,
        unixtime->tm_min);
      }
      scheduler();
    }

    sprintf(help,"%s*.*",cfg.usrp);
    usersbytes=length(help)>>10;
    sprintf(help,"%s*.*",cfg.msgp);
    mailsbytes=length(help)>>10;

    fprintf(handle,"\r\n Boards:%d - Users:%d (%ld KBytes) - Mails:%d (%ld KBytes)\r\n Free:%ld KBytes of %ld MByte\r\n",
    mcount,ucount,usersbytes,mails(),mailsbytes,free_disk_space(cfg.msgp,0)>>10,free_disk_space(cfg.msgp,1)>>20);
    insert_file("txt\\stat_bot.txt",handle);
    fputc(_CTRLZ,handle);
    tfclose(handle);
   }
   else
    write_log(_serious,r,"fopen error %s",help);


   //delfwdlist(fromright(fwdp[0].c,'/'),_STATNAME,0);
   sprintf(path,"fwd%s",file);
   addfwdlist(fromright(fwdp[0].c,'/'),fromright(fwdp[0].c,'/'),path);

   write_log(_report,r,"CPUt %s",zeitspanne(get_tcb()->cputime,2));
   sema=0;
}

BOOL IsInArray(char array[][7],int size,char *s)
{
  for (int i=0;i<size;i++)
    if(!strcmp(array[i],s))
      return TRUE;

  return FALSE;
}

static int callsort( const void *a, const void *b)
{
  return( strcmp((char *)a,(char *)b) );
}

#define _MAX 300

void beacon(void)
{
    static BOOL rec;
    char beacon[_MAX][7],help[_MAX_PATH],frame[256];
    msg_info_t minfo;
    char* s=frame;
    char* r="beacon";
    FILE* f;
    long m=mails();
    long i;
    long cnt=0;
    int j=0;

    time_t now=ad_time(NULL);

    if(rec)
      return;

    rec=TRUE;

    memset(beacon,0,sizeof(beacon));

    for(i=0;i<m;i++)
    {
      memset(&minfo,0,sizeof(msg_info_t));
      read_minfo (i,minfo);

      if((!(minfo.State&_MSGST_DELETED))&&
           (minfo.State&_MSGST_UNREAD)&&
          ((now-minfo.Unixtime)<(30L*24L*60L*60L))
        )
      {
          //set_win(keybwin);
          //cprintf("%s %s\r\n",minfo.Info,minfo.extend);
          if( (strlen(minfo.extend) > 9) &&
              !IsInArray(beacon,_MAX,minfo.extend+9) &&
              (cnt<_MAX)
            )
            strncpy(beacon[cnt++],minfo.extend+9,6);
      }

      scheduler();
    }

    //set_win(keybwin)
    //cprintf("huhu\r\n");

    f=tfopen("beacon.ini","rt");

    if(f==NULL)
    {
      write_log(_serious,r,"beacon.ini not found");
      return;
    }

    qsort((void *)beacon,cnt,7,callsort);

    if(cnt)
    {
      s+=sprintf(s,"%-.240s\rNew mail: ",cfg.boxheader);
      for(i=0;i<cnt;i++)
      {
        if(j&&!(j%9))
          s+=sprintf(s,"\r          ");
        s+=sprintf(s,"%s ",beacon[i]);
        if(strlen(frame)>246)
        {
          //set_win(keybwin)
          //cprintf("%s\r\n",frame);
          fseek(f,0,SEEK_SET);
          while(fgets(help,sizeof(help),f))
            l2_send_ui(get_mycall(), help, 0xf0,0, strlen(frame), frame);
          s=frame;
          frame[0]=0;
          j=0;
        }
        else
         j++;
      }
      if(frame[0])
      {
          fseek(f,0,SEEK_SET);
          while(fgets(help,sizeof(help),f))
            l2_send_ui(get_mycall(), help, 0xf0,0, strlen(frame), frame);
      }
      write_log(_report,r,"found %d messages",cnt);
    }

    tfclose(f);
    rec=FALSE;
}