/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  waits for condition squelch open / timeout
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#include "dvms.h"
#include "dvmscmd.h"
#include "dvmsirq.h"
#include "dvmsptt.h"
#include "dvmssuba.h"
#include "dvmstime.h"
#include "tnclow.h"

int wait_carrier(int s)
{ static char help[80];
  static int warn_flag;

  long count=0,state=0;

  struct tm *tm;
  time_t tt;
  msg_t *msg;

  set_audio(32);
  afsw(0);
  ptt(-1);

  if(cfg.cmd_wait)
   suspend(cfg.cmd_wait/55);

  while((!state) && !(get_global_msg()&_SHUTDOWN))
  {
    while(cronplay)
     suspend(1);

    if((msg=get_msg())!=NULL)
    {  if(strlen((char *)msg->msg)>16)
      {  strncpy(dtmf,(char *)msg->msg,16);
        dtmf[17]=0;
      }
      else
        strcpy(dtmf,(char *)msg->msg);

      while(put_msg(msg->pid,msg->msg)==-1)
        suspend(1);
      return 1;
    }

    ptt(-1);

    tt=ad_time(NULL);
    tm=localtime(&tt);

    if(!cfg.repeater&&(tm->tm_min==59) && (tm->tm_sec==40)&&(cfg.config&_CFGTIME)&&!ulogin&&!ptt_state)
    {  sprintf(help,"%sCALLTONE.VMS",cfg.sysp[0]);
      if(!access(help,0))
        rdplay(cfg.sysp[0],"CALLTONE.VMS");
    }

    if(((tm->tm_min==59)) && (tm->tm_sec==55)&&(cfg.config&_CFGTIME)&&!ulogin&&!ptt_state)
    { dcf_ok=FALSE;
      if(!call_state)
      { c_init();

        ptt(1);
        set_chb(16);
        rogersema=1;

        for(int i=0;i<5;i++)
        { c_tx_rate(cfg.tone,400000L);
          suspend(110/55);
          c_tx_rate(0L,0L);
          suspend(900/55);
        }

        c_tx_rate(cfg.tone,400000L);
        suspend(1000/55);
        c_tx_rate(0L,0L);

        while(cronplay)
          suspend(1);

        speak_time();
        set_chb(0);
        rogersema=0;
      }
    }

    count=(tt - dtmfstart);

    if(cfg.warn && (count<cfg.tout) && (count>cfg.warn)&&ulogin&&!warn_flag)
    { char oldsema=sema;
      sema=0;
      tt=dtmfstart;
      set_chb(16);
      rdplay(sysp,"warn.VMS");
      set_chb(0);
      sema=oldsema;
      warn_flag=TRUE;
      dtmfstart=tt;
    }

    if( cfg.tout && (count>cfg.tout)&& ulogin)
    { char oldsema=sema;
      sema=0;
      set_chb(16);
      logout(TRUE);
      set_chb(0);
      sema=oldsema;
      warn_flag=FALSE;
      state=-1;
      break;
    }

    if(count<=cfg.warn)
      warn_flag=FALSE;

    if(!ptt_state&&s&&((ad_time(NULL)-delstart)>cfg.tx_hold))
          state=-1;

    if(getsq())
      state=1;

    toggle_wd();
    suspend(1);
  }
  set_audio(16+32);
  afsw(1);
  dtmf[0]=0;
  if(get_global_msg()&_SHUTDOWN)
    state=-1;
  return(state);
}

void build_mask(void)
{ update_ctcss();
  toggle_wd();
  scheduler();
}

