/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  dtmf function: send message
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsamp.h"
#include "dvmscmd.h"
#include "dvmsdtmf.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmsirq.h"
#include "dvmsmem.h"
#include "dvmsmsgb.h"
#include "dvmssq.h"
#include "dvmssuba.h"
#include "movefile.h"

void send_msg(char *input)
{
  msg_info_t MInfo;
  unsigned usr=0,retry=0;
  unsigned long Msg_Length;
  char wrt_path[80],file[80],help[80],id[80],*r="send_msg";

  if(!input[0])
  {  rdplay(sysp,"TRANS_01.VMS");
    if(wait_carrier(1)==-1)
      return;
    rcvdtmf(help,TRUE);
    strcpy(input,help);
  }

  if(!check_ctcss())
  {  rdplay(sysp,"MSG_DEL5.VMS");
    return;
  }

  if(!usr_upd)
  {  User_Info.Days=cfg.max_usr_days;
    User_Info.Usender++;
    usr_upd=TRUE;
  }

  if(!checkdiskspace())
    return;

  rdplay(sysp,"WRTMSG1.VMS");

  switch(input[0])
  {
    case '#':  decode_callsign(help,input);
              if(!amp_search(id,&usr,help,FALSE))
                return;
              break;

    default : if(strlen(input)>3)
              {  usr=atoi(input+3);
                if(!expand_id(id,&usr,input))
                  goto usr_num1;
              }
              else
              {  usr=atoi(input);
                if(!expand_id(id,&usr,cfg.boxaddress))
                { usr_num1:;
                  rdplay(sysp,"USR_NUM1.VMS");
                  return;
                }
              }
  }

  init_msg_info(MInfo);

  if(!strncmp(id,cfg.boxaddress,3))
    MInfo.Id&=!_MSGID_EXPORT;
  else
  { if(!strlen(User_Info.Info+9))
    {
      rdplay(sysp,"MSG_DEL5.VMS");
      rdplay(sysp,"NOAMPREG.VMS");
      return;
    }
    MInfo.Id|=_MSGID_EXPORT;
  }

  spk_user(id,usr,FALSE);
  if(User_Info.State&_USRST_SPKNAME)
    spk_name(id,usr);

  strcpy(MInfo.Info,User_Info.Info);
  strcpy(MInfo.extend,id);
  MInfo.Usender=ulogin;
  MInfo.Ureceiver=usr;
  MInfo.Days=cfg.max_msg_days;
  MInfo.State=_MSGST_UNREAD;

  if(!(File_Info.Id&_MSGID_BBS))
    MInfo.Id|=_MSGID_PRIV;
  else
  {
    MInfo.Id|=_MSGID_BBS;
    if(File_Info.Days)
      MInfo.Days=File_Info.Days;
  }

  if(MInfo.Id&_MSGID_EXPORT)
  {
    rdplay(sysp,"WRTMSG6.VMS");
    setrate(cfg.fwd_srate);
    Msg_Length=cfg.max_msg_fwd_length;
    strcpy(wrt_path,"fwd\\");
  }
  else
  {
    rdplay(sysp,"WRTMSG2.VMS");
    setrate(cfg.default_srate);
    Msg_Length=cfg.max_msg_length;
    strcpy(wrt_path,cfg.msgp);
  }

  if(record_write(wrt_path,"DVMS_MSG.TMP",Msg_Length,MInfo)>(srate*3/8))
  {  spknum(MInfo.Length>>10);
    rdplay(sysp,"KILOBYTE.VMS");

    if(MInfo.Length>=(Msg_Length-cfg.endcut-400L))
      rdplay(sysp,"OVERTIME.VMS");

    if(User_Info.State&_USRST_ASKSEND)
    do
    {  do
      {  rdplay(sysp,"WRTMSG5.VMS");
        l:;
        if(wait_carrier(1)==-1)
          return;
        rcvdtmf(help,TRUE);
      }
      while(!check_ctcss()&&(retry++<4));

      if((help[0]=='*')||(help[0]=='A'))
        goto Skip;

      if((help[0]=='0')||(help[0]=='B'))
        rdplay(wrt_path,"DVMS_MSG.TMP");

      if(help[0]=='1')
      {
        rdplay(sysp,"CMDSSEND.VMS");
        goto l;
      }
      if((help[0]=='2')&&!(MInfo.Id&_MSGID_EXPORT))
      {
        if((MInfo.State&_MSGST_AUTOREP)&&!(MInfo.Id&_MSGID_EXPORT))
        {
          rdplay(sysp,"AUTOREP0.VMS");
          MInfo.State-=_MSGST_AUTOREP;
          wrt_file_info(wrt_path,"DVMS_MSG.TMP",FALSE,MInfo);
        }
        else
        {
          rdplay(sysp,"AUTOREP1.VMS");
          MInfo.State|=_MSGST_AUTOREP;
          wrt_file_info(wrt_path,"DVMS_MSG.TMP",FALSE,MInfo);
        }
      }
      if(help[0]=='3')
      {
        rdplay(sysp,"SET_LIFE.VMS");
        if(wait_carrier(1)==-1)return;
        rcvdtmf(help,TRUE);
        if(atoi(help)<cfg.max_msg_days)
        {
          MInfo.Days=atoi(help);

          wrt_file_info(wrt_path,"DVMS_MSG.TMP",FALSE,MInfo);
          rdplay(sysp,"LIFETIME.VMS");
          spknum((long)MInfo.Days);
        }
        help[0]=0;
      }
      if(help[0]=='5')
      { int i;
        rdplay(sysp,"TRANS_01.VMS");

        if(wait_carrier(1)==-1)return;
          rcvdtmf(help,TRUE);

        rdplay(sysp,"MSGCOPY2.VMS");

        if(spk_user(cfg.boxaddress,(i=atoi(help)),FALSE) && i)
        { l4:;
          if(go_on())
          { msg_info_t MInfotmp=MInfo;
            File_Info=User_Info;
            File_Info.State=_MSGST_COPY;
            File_Info.Unixtime=ad_time(NULL);

            MInfotmp.Ureceiver=i;
            MInfotmp.State=(_MSGST_EXTHEADER|_MSGST_UNREAD);
            MInfotmp.Id&=~_MSGID_EXPORT;

            add_msg_info(MInfotmp);

            sprintf(help,"%sDVMS_MSG.TMP",wrt_path);
            sprintf(file,"%s%s",cfg.msgp,MInfotmp.Filename);
            move_file(help,file,0);

            wrt_ext_info (cfg.msgp,MInfotmp.Filename,-1,File_Info);
            wrt_file_info(cfg.msgp,MInfotmp.Filename,FALSE,MInfotmp);

            rdplay(sysp,"MSGCOPY3.VMS");
          }
          else
            if(help[0]!='*')
              goto l4;
        }
      }
    }while(help[0]!='#'&&(retry++<4));

    if(MInfo.Id&_MSGID_EXPORT)
      setrate(cfg.fwd_srate);
    else
      setrate(cfg.default_srate);

    wrt_file_info(wrt_path,"DVMS_MSG.TMP",FALSE,MInfo);

    if(MInfo.Id&_MSGID_EXPORT)
    {
      if(findfwdbox(id,file,NULL))
      {
        ad_time(&MInfo.Unixtime);
        mkfilename(MInfo.Filename);
        if(!addfwdlist(file,id+3,MInfo.Filename))
          goto dispose;
      }
      else
      {
        write_log(_serious,r,"can't forward to %s",id);
        goto dispose;
      }
    }
    else
    {
      check_pr_msg(MInfo);
      ad_time(&MInfo.Unixtime);
      add_msg_info(MInfo);
    }

    sprintf(file,"%s%s",wrt_path,MInfo.Filename);
    sprintf(help,"%sDVMS_MSG.TMP",wrt_path);
    move_file(help,file,1);

    wrt_file_info(wrt_path,MInfo.Filename,FALSE,MInfo);

    rdplay(sysp,"WRTMSG3.VMS");

    User_Info.Custom2++;
    write_log(_report,r,"to %s",id);
    strcpy(help,get_onlycall(id+3));
    if(MInfo.Id&_MSGID_EXPORT)
      fwddcall(help);
    return;
  }
  else
  {
    dispose:;
    sprintf(help,"%sDVMS_MSG.TMP",wrt_path);
    remove(help);
  }
  Skip:;
  rdplay(sysp,"WRTMSG4.VMS");
}
