/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  cyclic screen update
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/
#ifdef __MSDOS__

#include "dvms.h"
#include "dvmsirq.h"
#include "dvmssq.h"
#include "dvmsdcf.h"
#include "dvmssuba.h"
#include "util.h"

void s_meter_update(unsigned long *sig_old)
{  int s_mom,pwr=get_irqpwr()>>4;

  if( pwr<cfg.sig_min)
    return;

  s_mom=((( pwr-cfg.sig_min)*11)/(15-cfg.sig_min));
  if((s_mom<=0)&&!(sig_count+1))
    return;

  *sig_old=(sig_count* *sig_old+(unsigned long)s_mom*1000L)/(sig_count+1);
  sig_count++;
}

static void chk_close(void)
{

  /* Close-Faehigkeit anmelden, reicht eigentlich einmal beim Start */
  _DX = 0x0001;   /* enable/disable close */
  _AX = 0x168F;
  geninterrupt(0x2F);	/* Returnwert brauchen wir nicht */

  /* Jetzt (zyklisch) gucken ob Close gewuenscht */
  _DX = 0x0100;   /* Query close */
  _AX = 0x168F;
  geninterrupt(0x2F);
  if (_AX == 0)
  {
    _DX = 0x0200;   /* acknowledge close */
    _AX = 0x168F;
    geninterrupt(0x2F);	/* Returnwert brauchen wir nicht */

    /* Hier machen und tun was zugemacht werden muss */
    //exit(0); /* So oder anders */
    //set_win(defaultwin);
    //cprintf("ismiribel\r\n");

    put_global_msg(_SHUTDOWN);
  }
}

void updscr(void)
{ static char bar[30],help[30],oldkey;
  int c;

  while(!(get_global_msg()&_SHUTDOWN))
  {
  set_win(sigwin);
  gotoxy(1,1);
  cprintf("AUDIO :");
  gotoxy(11,1);
  strcpy(bar,"");
  for(c=0;c<=(get_irqpwr()&15);bar[c]=219,c++);
  sprintf(help,"%s",bar);
  cprintf(help);

  gotoxy(11,2);
  cprintf("0123456789ABCDEF");

  gotoxy(1,3);
  cprintf("SIGNAL:");

  gotoxy(11,3);
  strcpy(bar,"________________");
  for(c=0;c<=((get_irqpwr()>>4)&15);bar[c]=219,c++);
  sprintf(help,"%s",bar);
  cprintf(help);

  if(ptt_state&&((get_irqpwr()>>4)&15))
      s_meter_update(&s_meter);

  set_win(systwin);
  gotoxy(1,1);
  sprintf(help,"%02lu:%02lu",idletime()/60L,idletime()%60L);
  cprintf("IDLE: %-8.8s",help);

  gotoxy(1,2);
  cprintf("PTT : ");
  if(ptt_state)
    attr(0x4F);
  cprintf("%s",ptt_state?"ON ":"OFF");

  gotoxy(1,3);
  attr(0x1f);
  cprintf("SQ  : ");
  if(getsq())
    attr(0x2F);
  else
    attr(0x1f);

  cprintf("%s",getsq()?"OPEN  ":"CLOSED");
  attr(0x1f);

  gotoxy(15,1);
  cprintf("CLK : %dKHz ",srate/1000);

  
  if(fx805)
  {
    gotoxy(15,2);
    cprintf("SUB : %ldHz  ",ctcss_tone[ctcss]/1000L);
  }

  gotoxy(15,3);
  cprintf("CALL: %s",(getdt(0)&CALL_BIT)?"      ":"1750Hz");

  gotoxy(28,1);
  cprintf("MEM  :%-3ldK",coreleft()/1024);

  gotoxy(28,2);
  cprintf("TASKS:%d ",get_tasksrun());

  gotoxy(28,3);
  cprintf("CIDLE:%-3d%%",getidle(1));

  prt(72,2,0x1f,_strtime(help));

  dcf_win();

  set_win(userwin);
  if(!ulogin || !User_Info.Ureceiver)
  {
    User_Info.Ureceiver=0;
    User_Info.Id=0;
    User_Info.Info[0]=0;
    User_Info.Info[9]=0;
    User_Info.Unixtime=0;
  }
  else
  {
    gotoxy(1,1);
    cprintf("User     : %-4d ",User_Info.Ureceiver);

    gotoxy(1,2);
    cprintf("Subaudio : ");
    switch(User_Info.Id>>8)
    {
      case 255:
        cprintf("locked ");
        break;

      case 0:
       cprintf("no tone ");
       break;

      default:
       cprintf("%ldHz    ",(ctcss_tone[User_Info.Id>>8]/1000L));
    }
    gotoxy(1,3);
    cprintf("Lastlogin: ");
    sprintf(help,"%s %s",datestr(User_Info.Unixtime,1),timestr(User_Info.Unixtime));

    help[19]=0;

    if(User_Info.Unixtime)
      cprintf(help);

    gotoxy(1,4);
    cprintf("Info     : %s ",User_Info.Info);

    gotoxy(1,5);
    cprintf("Logins   : %d ",User_Info.Usender);

    gotoxy(1,6);
    cprintf("Sendmsgs : %d ",User_Info.Custom2);

    gotoxy(1,7);
    cprintf("Recvmsgs : %d ",User_Info.Custom1);
  }

  if(cfg.scrsave)
  { if(inp(0x60)!=oldkey)
      get_tcb("keybd")->lastinput=ad_time(NULL);
    oldkey=inp(0x60);
    if((ad_time(NULL)-get_tcb("keybd")->lastinput)>=(cfg.scrsave*60))
      screensave(1);
    else
      screensave(0);
  }

  suspend(1);

  
  if(!ulogin&&!call_state&&cfg.subout&&!rogersema)
  {
    c_tx_gain(cfg.ctcss_gain);
    c_tx_rate(cfg.subout*!ctcss,0L);
  }
  cpu_index();
  chk_close();

  if(!(timer()%9))
  {  _AX=0;
    geninterrupt(0x28);
  }
  }
}

#endif