/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  dtmf command: receive message
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmscmd.h"
#include "dvmsdtmf.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmsmsgb.h"
#include "dvmsstat.h"
#include "dvmssq.h"
#include "dvmssend.h"
#include "dvmssuba.h"
#include "dvmstime.h"
#include "movefile.h"
#include "util.h"

long spk_msg_info(int usr, int MSG_Number,int flag)
{ long MSG_Num;
  int l=1,s=0;
  msg_info_t MInfo,MRInfo;
  char help[80],*r="spk_msg_info";

  if(MSG_Number<1)
  {  write_log(_serious,r,"MSG_Number #%ld out of range",MSG_Number);
    return(-1);
  }

  init_msg_info(MInfo);
   MInfo.Ureceiver=usr;

  if (flag)
    MInfo.State=_MSGST_UNREAD;
   else
    MInfo.State=_MSGST_READ|_MSGST_UNREAD;

  if((!usr_upd)&&ulogin)
  { User_Info.Days=cfg.max_usr_days;
    User_Info.Usender++;
    usr_upd=TRUE;
  }

  MSG_Num=msg_num_select(MSG_Number,MInfo);

  if(MSG_Num!=-1)
  {  if(!read_minfo(MSG_Num,MInfo))
    { write_log(_serious,r,"read_minfo error");
      return(-1);
    }

    list_minfo(MInfo);
    rdplay(sysp,"MSG_FRM0.VMS");

    if(stopped())
      return(MSG_Num);

    spknum((long) MSG_Number);

    if(stopped())
      return(MSG_Num);

    rdplay(sysp,"MSG_FRM1.VMS");

    if(stopped())
      return(MSG_Num);

    spk_user(MInfo.Info,MInfo.Usender,_USER_ONLY|_NO_CTCSS);

    if(stopped())
      return(MSG_Num);

    if(User_Info.State&_USRST_SPKNAME)
      spk_name(MInfo.Info,MInfo.Usender);

    if(stopped())
      return(MSG_Num);

    if(User_Info.State&_USRST_SPKNUM)
    { rdplay(sysp,"USR_NUM0.VMS");
      if(stopped()) return(MSG_Num);
      spknum((long)MInfo.Usender);
     /*
      sprintf(help,"%d",MInfo.Usender);
      spkstr(help,1);
     */
    }

    if(User_Info.State&_USRST_SPKDATE)
    { location=0L;
     _ddate(MInfo.Unixtime,3);
     playback(0L,location);
     if(stopped()) return(MSG_Num);
    }
    if(User_Info.State&_USRST_SPKTIME)
    { location=0L;
     _ttime(MInfo.Unixtime);
     playback(0L,location);
     if(stopped()) return(MSG_Num);
    }
     /* Scheffel 2043*/
    if(MInfo.State&_MSGST_EXTHEADER)
    do
    { if(!rd_ext_info(cfg.msgp,MInfo.Filename,l,MRInfo))
      { write_log(_serious,r,"extended header #%d corrupt %s",l,MInfo.Filename);
        sprintf(help,"%s%s",cfg.msgp,MInfo.Filename);
        if(move_file(help,cfg.tmppath,1))
          write_log(_serious,r,"file moved %s",MInfo.Filename);
           return(-1);
      }
      l++;

      if(MRInfo.State&_MSGST_TRANSFER)
      { if(!(s&1))
        {  rdplay(sysp,"TRANS_04.VMS");
          s|=1;
        }
      }
      if(MRInfo.State&_MSGST_READ)
      { if(!(s&2))
        {  rdplay(sysp,"MSGHEARD.VMS");
          s|=2;
        }
      }
      if(MRInfo.State&_MSGST_COPY)
      { if(!(s&4))
        {  rdplay(sysp,"MSGCOPY3.VMS");
          s|=4;
        }
      }

      if(s==7) break;
    }while(MRInfo.State&_MSGST_EXTHEADER);
  }
  return(MSG_Num);
}

int spk_short_list_of_msg(int usr)
{
  int all,nnew;
  mails_waiting(usr,&all,&nnew);
  if(all&&(all!=-1))
  {
    rdplay(sysp,"MSG_HLD1.VMS");

    if (all==1)
      rdplay(sysp,"EINE.VMS");
    else
      spknum(all);

    if(nnew)
    {
      rdplay(sysp,"MSG_URD1.VMS");
      if (nnew==1)
        rdplay(sysp,"EINE.VMS");
      else
        spknum(nnew);
    }

      return (1);
  }
  else
    return (0);
}

void spk_list_of_msg(int usr,int flag,int stmsg)
{ long MSG_Num;
  msg_info_t MInfo,File_Info;
  int MSG_Count=1,bbs=FALSE,retry,i,l;
  char dtmf[20],_dtmf[16],help[80],file[80],*r="spk_list_of_msg";

  if(!check_ctcss()) {rdplay(sysp,"MSG_DEL5.VMS");return;}

  if(flag&128) {MSG_Count=stmsg; goto l3;}

  if(usr!=ulogin)
  { sprintf(file,"%s%04d_USR.VMS",cfg.usrp,usr);

    if(!access(file,0))
    { sprintf(file,"%04d_USR.VMS",usr);
      rd_file_info (cfg.usrp,file,File_Info);
    }
    else
      init_msg_info(File_Info);

    if(File_Info.Id&_MSGID_BBS)
    {  bbs=TRUE;
      if(!(cfg.config&_CFGBBSON)&&!ulogin)
      {  rdplay(sysp,"FIRSTLOG.VMS");
        return;
      }
    }
    else
      if((cfg.config&_CFGMSGOFF)&&!ulogin)
      {  rdplay(sysp,"FIRSTLOG.VMS");
        return;
      }
  }

  if(!(flag&2))
  { if(flag&1)
      rdplay(sysp,"MSG_URD1.VMS");
    else
      rdplay(sysp,"MSG_HLD1.VMS");
  }
  else
    if(!spk_user(cfg.boxaddress,usr,0))
    { rdplay(sysp,"BBS_003.VMS");
      return;
    }
    else
    { if(spk_short_list_of_msg(usr))
      {  rdplay(sysp,"BBS_004.VMS");
        if(wait_carrier(1)==-1) return;
        rcvdtmf(dtmf,TRUE);
        if( (dtmf[0]=='*') || (dtmf[0]=='A'))
        {  rdplay(sysp,"ABORT000.VMS");
          return;
        }
        MSG_Count=atoi(dtmf)?atoi(dtmf):1;
      }
      else
        goto end;
    }

  l3:;
  write_log(_report,r,"receive_msg");
  do
  { MSG_Num= spk_msg_info(usr,MSG_Count,flag&1);
    if(MSG_Num!=-1L)
    {
      if(!read_minfo(MSG_Num,MInfo))
      { write_log(_serious,r,"read_minfo error");
        return;
      }

      retry=0;

      if(!(flag&128))
        do
        {
          rdplay (sysp,"MSG_PLY.VMS");
          if(wait_carrier(1)==-1) return;
          rcvdtmf(_dtmf,TRUE);
          if(retry++>4) return;
        }
        while(!check_ctcss()||!_dtmf[0]);
      else
        _dtmf[0]='#';

      if(_dtmf[0]=='A'||_dtmf[0]=='*') {rdplay(sysp,"ABORT000.VMS");return;}
        retry=0;

      if(_dtmf[0]=='#')
      {
        rdplay(cfg.msgp,MInfo.Filename);
        rdplay(sysp,"MSG_EOM0.VMS");

        //Msg-heard Info add
        if(isdigit(MInfo.Filename[0])&&ulogin)
        {
          File_Info=MInfo;
          l=1;

          //if ext-header exists - check if user is allready registered
          if(MInfo.State&_MSGST_EXTHEADER)
          do
          {
            if(!rd_ext_info (cfg.msgp,MInfo.Filename,l++,File_Info))
            {
              write_log(_serious,r,"extended header corrupt %s",MInfo.Filename);
              rdplay(sysp,"ABORT000.VMS");
              return;
            }
            if((File_Info.State&_MSGST_READ)&&(ulogin==File_Info.Ureceiver))
              goto wech;

          }while(File_Info.State&_MSGST_EXTHEADER);

          //Add userfile to ext header
          File_Info=User_Info;
          File_Info.Unixtime=ad_time(NULL);
          File_Info.State=_MSGST_READ;

          list_minfo(File_Info);
          wrt_ext_info (cfg.msgp,MInfo.Filename,-1,File_Info);
          MInfo.State|=_MSGST_EXTHEADER;
          User_Info.Custom1++;
        }

        wech:;
        //set the read flag
        if(usr==ulogin||bbs)
        {
           MInfo.State&=~_MSGST_UNREAD;
           MInfo.State|=_MSGST_READ;
           if(cfg.hrd_msg_days&&!bbs&&(MInfo.Days>cfg.hrd_msg_days))
             MInfo.Days=cfg.hrd_msg_days;
        }

        //create auto reply msg
        if((MInfo.State&_MSGST_AUTOREP)&&(usr==ulogin))
        {
          MInfo.State&=~_MSGST_AUTOREP;
          File_Info=MInfo;
          File_Info.Ureceiver=MInfo.Usender;
          File_Info.Usender=User_Info.Ureceiver;
          File_Info.Id=_MSGID_PRIV;
          File_Info.Days=cfg.max_msg_days;
          File_Info.State=_MSGST_UNREAD;
          File_Info.Srate=(srate/100);
          time(&MInfo.Unixtime);
          strcpy(File_Info.extend,MInfo.Info);
          strcpy(File_Info.Info,User_Info.Info);
          strcpy(File_Info.Filename,"AUTO_REP.VMS");
          write_minfo (File_Info);
          check_pr_msg(File_Info);
        }

        //Write to database
        write_minfo_num (MSG_Num,MInfo);

        //also update msgfile
        if(isdigit(MInfo.Filename[0]))
          wrt_file_info(cfg.msgp,MInfo.Filename,FALSE,MInfo);

        do
        {
          do//menue after reading a message
          {
            l1:;
            if(ulogin)
              rdplay(sysp,"MSG_EOM1.VMS");
            else
              if(go_on())
              { _dtmf[0]='#';
                break;
              }
              else
              { _dtmf[0]='A';
                goto raus;
              }
              l:;
              if(wait_carrier(1)==-1) return;
              rcvdtmf(_dtmf,TRUE);
          }
          while(!check_ctcss()&&(retry++<4));

          raus:;
          //create reply msg
          if((_dtmf[0]=='B')||(_dtmf[0]=='0'))
          { if(ulogin)
            { sprintf(help,"%3.3s%d",MInfo.Info,MInfo.Usender);
              send_msg (help);
            }
            else
              rdplay(sysp,"MSG_DEL5.VMS");

            if(_dtmf[1]=='*')
              _dtmf[0]='*';
            else
              _dtmf[0]='#';
          }
          //delete msg
          if(_dtmf[0]=='*')
          {
            if((User_Info.Id&_USRID_SYSOP) || (ulogin==MInfo.Usender)||(ulogin==MInfo.Ureceiver))
            { MInfo.State|=(_MSGST_DELETED|_MSGST_READ);

              if(MSG_Count>0)
                MSG_Count--;
              _dtmf[0]='#';
              write_minfo_num (MSG_Num,MInfo);
              File_Info=MInfo;
              if(isdigit(MInfo.Filename[0]))
                wrt_file_info(cfg.msgp,MInfo.Filename,FALSE,File_Info);
              rdplay(sysp,"MSG_DEL1.VMS");
            }
            else
              rdplay(sysp,"MSG_DEL5.VMS");
          }
          //helptext
          if(_dtmf[0]=='1')
          { rdplay(sysp,"CMDSRECV.VMS");
            goto l;
          }
          //speak msginfo
          if(_dtmf[0]=='2')
          { rdplay(sysp,"MSG_FRM1.VMS");
            spk_user(MInfo.Info,MInfo.Usender,_USER_ONLY);

            spk_name(MInfo.Info,MInfo.Usender);

            rdplay(sysp,"USR_NUM0.VMS");
            spknum((long)MInfo.Usender);

            location=0L;
            _ddate(MInfo.Unixtime,3);
            _ttime(MInfo.Unixtime);
            playback(0L,location);

            rdplay(sysp,"LIFETIME.VMS");
            spknum((long)((long)MInfo.Days-( (ad_time(NULL)-MInfo.Unixtime)/(24L*60L*60L))) );
            rdplay(sysp,"DAYS.VMS");

            spknum(MInfo.Length>>10);
            rdplay(sysp,"KILOBYTE.VMS");
            l=1;

            if(MInfo.State&_MSGST_EXTHEADER)
              do
              {
                if(!rd_ext_info(cfg.msgp,MInfo.Filename,l++,File_Info))
                { write_log(_serious,r,"extended header corrupt %s",MInfo.Filename);
                  sprintf(file,"%s%s",cfg.msgp,MInfo.Filename);
                  if(move_file(file,cfg.tmppath,1))
                    write_log(_serious,r,"file moved %s",MInfo.Filename);
                  break;
                }

                if(File_Info.State&_MSGST_TRANSFER)
                { rdplay(sysp,"TRANS_04.VMS");
                  if(!accessp(sysp,"AT.VMS"))
                    rdplay(sysp,"AT.VMS");
                  else
                    rdplay(sysp,"VON.VMS");
                  spk_user(File_Info.Info,File_Info.Ureceiver,_USER_ONLY);
                }
                if(File_Info.State&_MSGST_READ)
                { rdplay(sysp,"MSGHEARD.VMS");
                  if(!accessp(sysp,"AT.VMS"))
                    rdplay(sysp,"AT.VMS");
                  else
                    rdplay(sysp,"VON.VMS");

                  spk_user(File_Info.Info,File_Info.Ureceiver,_USER_ONLY);
                }
                if(File_Info.State&_MSGST_COPY)
                { rdplay(sysp,"MSGCOPY3.VMS");
                  if(!accessp(sysp,"AT.VMS"))
                    rdplay(sysp,"AT.VMS");
                  else
                    rdplay(sysp,"VON.VMS");

                  spk_user(File_Info.Info,File_Info.Ureceiver,_USER_ONLY);
                }

              }while(File_Info.State&_MSGST_EXTHEADER);
          }

          //set lifetime
          if((_dtmf[0]=='3')&&((User_Info.Id&128)||(ulogin==MInfo.Usender)||(ulogin==MInfo.Ureceiver)))
          {
            rdplay(cfg.sysp[0],"SET_LIFE.VMS");

            if(wait_carrier(1)==-1) return;

            rcvdtmf(dtmf,TRUE);

            if(User_Info.Id&_USRID_SYSOP)
            { write_log(_report,r,"setlifetime #%s",dtmf);
              MInfo.Days=(unsigned)atoi(dtmf);
            }
            else
              if(atoi(dtmf)<=cfg.max_msg_days)
                MInfo.Days=(unsigned)atoi(dtmf);

            write_minfo_num (MSG_Num,MInfo);

            if(isdigit(MInfo.Filename[0]))
              wrt_file_info(cfg.msgp,MInfo.Filename,FALSE,MInfo);

            rdplay(sysp,"LIFETIME.VMS");
            spknum((long)MInfo.Days);
            rdplay(sysp,"DAYS.VMS");
          }
          //transfer msg
          if(_dtmf[0]=='4')
          {
            if((User_Info.Ureceiver==MInfo.Ureceiver)||(User_Info.Id&_USRID_SYSOP))
            {
              if(!isdigit(MInfo.Filename[0]))
              { rdplay(sysp,"MSG_DEL5.VMS");
                return;
              }

              rdplay(sysp,"TRANS_01.VMS");

              if(wait_carrier(1)==-1)return;
                rcvdtmf(dtmf,TRUE);

              rdplay(sysp,"TRANS_02.VMS");

              if(spk_user(cfg.boxaddress,(i=atoi(dtmf)),FALSE) && i)
              {
                l2:;
                if (go_on())
                {
                  File_Info=User_Info;
                  File_Info.State=_MSGST_TRANSFER;
                  File_Info.Unixtime=ad_time(NULL);

                  wrt_ext_info(cfg.msgp,MInfo.Filename,-1,File_Info);

                  MInfo.Ureceiver=i;
                  MInfo.State=(_MSGST_EXTHEADER|_MSGST_UNREAD);

                  write_minfo_num (MSG_Num,MInfo);
                  wrt_file_info(cfg.msgp,MInfo.Filename,FALSE,MInfo);

                  rdplay(sysp,"TRANS_04.VMS");
                  _dtmf[0]='#';
                  goto raus1;
                }
                else
                  if(_dtmf[0]=='*')
                    goto l1;
                  else
                    goto l2;
              }
              else
                goto l1;
            }
            else
              rdplay(sysp,"MSG_DEL5.VMS");
          }
          //copy msg
          if(_dtmf[0]=='5')
          { if((User_Info.Ureceiver==MInfo.Ureceiver)||(User_Info.Id&_USRID_SYSOP))
            { if(!isdigit(MInfo.Filename[0]))
              {  rdplay(sysp,"MSG_DEL5.VMS");
                return;
              }
              rdplay(sysp,"TRANS_01.VMS");

              if(wait_carrier(1)==-1)return;
                rcvdtmf(dtmf,TRUE);

              rdplay(sysp,"MSGCOPY2.VMS");

              if(spk_user(cfg.boxaddress,(i=atoi(dtmf)),FALSE) && i)
              {
                if(go_on())
                { msg_info_t MInfotmp=MInfo;

                  File_Info=User_Info;
                  File_Info.State=_MSGST_COPY;
                  File_Info.Unixtime=ad_time(NULL);

                  MInfotmp.Ureceiver=i;
                  MInfotmp.State=(_MSGST_EXTHEADER|_MSGST_UNREAD);
                  MInfotmp.Id&=~_MSGID_EXPORT;

                  add_msg_info(MInfotmp);

                  sprintf(file,"%s%s",cfg.msgp,MInfotmp.Filename);
                  sprintf(help,"%s%s",cfg.msgp,MInfo.Filename);
                  move_file(help,file,0);

                  wrt_ext_info (cfg.msgp,MInfotmp.Filename,-1,File_Info);
                  wrt_file_info(cfg.msgp,MInfotmp.Filename,FALSE,MInfo);

                  rdplay(sysp,"MSGCOPY3.VMS");
                }
              }
            }
            else
              rdplay(sysp,"MSG_DEL5.VMS");

            goto l1;
          }

          if(_dtmf[0]=='A')
            break;

          raus1:;

        }while(_dtmf[0]!='#'&&(retry++<4));

        if((flag&1)&&!(flag&2)&&(MSG_Count>0))
          MSG_Count--;

      }
      if(_dtmf[0]=='A')
      {
        rdplay(sysp,"ABORT000.VMS");
        return;
      }
    }
    else
    {
      if(flag&128)
        rdplay(sysp,"MSG_NOM1.VMS");
      break;
    }

    MSG_Count++;

  }while(!(flag&128));

  end:;

  if(flag&128)
    return;

  rdplay(sysp,"MSG_EOM2.VMS");
}
