/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  record & write to disk / read from disk & playback
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#include "dvms.h"
#include "dvmscmd.h"
#include "dvmshead.h"
#include "dvmsirq.h"
#include "dvmsptt.h"
#include "dvmsmsgb.h"
#include "dvmssq.h"

long srate,rem,location=0L;

/****************************************************************************
 Abspielen einer .VMS Datei beliebiger Lnge
 path: Pfadangabe mit \ abgeschlossen
 input: Dateiname
 p: PTT STatus 1: PTT wird zu Beginn eingeschaltet
               2: PTT wird am Schlu ausgeschaltet
               3: PTT ist whrend des abspielens an, danach aus.
****************************************************************************/
unsigned long rdplay(char *path,char *input)
{  long RD_Count=0L;
  long RD_diff=0L;
  char help[80];
  FILE *f;

  if(!(cfg.system_state&1))
    return 0L;

  while(sema)
    suspend(1);

  sema=1;
  set_audio(32);

  set_win(filewin);
  gotoxy(1,1);
  sprintf(help,"Playback: %s%s",path,input);
  help[37]=0;
  cputs(help);

  sprintf(help,"%s%s",path,input);

  if((f=tfopen(help,"rb"))!=NULL)
  { read_finfo (f,File_Info);
    if(!File_Info.Filename[0]||(filelength(fileno(f))<File_Info.Length))
    {  write_log(_serious,"rdplay","error %s",help);
      tfclose(f);
      sema=0;
      return(0L);
    }
    srate=File_Info.Srate*100;
    list_minfo(File_Info);

    if(File_Info.Length<(rem=filelength(fileno(f))))
      rem=File_Info.Length;

    setrate(srate);
    ptt(1);

    while(RD_Count<File_Info.Length)
    {  if((RD_Count<_IRQ_CACHE)||
         ( ((RD_Count-get_irqcnt())<_MEM ) &&
           (((RD_Count%_MEM)>(get_irqcnt()%_MEM))||
           ((RD_Count%_MEM+_IRQ_CACHE)<(get_irqcnt()%_MEM)) ))||
            (RD_Count<=get_irqcnt()) )
      {  if(RD_Count<=get_irqcnt())
          set_irqact(4);
        else
          set_irqact(2);

        RD_diff=File_Info.Length-RD_Count;
        if(RD_diff>=_IRQ_CACHE)
        {  fread((void far *)(puffer+(RD_Count%_MEM)),(size_t)1,(size_t)_IRQ_CACHE,f);
//          printf("\n%ld %ld %ld %p %p",RD_Count%MEM,IRQ_CACHE,MEM,(puffer+(RD_Count%MEM)),puffer);          getch();
          RD_Count+=_IRQ_CACHE;
          RD_diff=_IRQ_CACHE;
        }
        else
        {  fread((void far *)(puffer+(RD_Count%_MEM)),(size_t)1,(size_t)RD_diff,f);
          RD_Count+=RD_diff;
        }
      }
      else
        if(RD_Count>_IRQ_CACHE)
        {  set_win(irqwin);
          gotoxy(1,1);
          cprintf("IRQ: % 6lu RD: % 6lu",get_irqcnt(),RD_Count);
          toggle_wd();
          ad_time(&delstart);
          if(!irq_state())
            break;
        }

      if((RD_Count>=RD_diff)&&!(get_irqact()&3))
        if(!do_irq(2,0L,File_Info.Length))
          break;
       /*printf("2IRQ_action %d %d\n",IRQ_action,IRQ_loop);*/

      if( (getdt(0)&16)&&!get_chb())
        goto end;
    }

    while(irq_state())
    { set_win(irqwin);
      gotoxy(1,1);
      cprintf("IRQ: % 6lu RD: % 6lu",get_irqcnt(),RD_Count);
      toggle_wd();
      if((getdt(0)&16)&&!get_chb())
        goto end;
    }
  }
  else
  { stop_irq();
    rem=0L;
    location=0L;
    write_log(_serious,"rdplay","tfopen error %s",help);
    goto end1;
  }
  end:;
  tfclose(f);
  location=get_irqcnt();
  stop_irq();

  end1:;
  if(rem)
  { ad_time(&delstart);
    ad_time(&dtmfstart);
  }

  toggle_wd();

  set_win(filewin);
  gotoxy(1,1);
  cprintf("% 38s","");

  set_win(irqwin);
  clrscr();

  sema=0;
  return(location);
}

/****************************************************************************
 Aufzeichnen von .VMS Dateien beliebiger Lnge
 path: Pfad, abgeschlossen mit \
 input Dateiname
 pblength: maximale Lnge der aufzuzeichnenden Datei (beliebig)
 WFile_Info: Informationen des .VMS Datei Headers
****************************************************************************/
unsigned long record_write(char *path,char *input,unsigned long pblength, msg_info_t &WFile_Info)
{ long Wrt_Count=0L,SQ_Count,ec=(cfg.endcut+cfg.sq_wait*55)*(srate/8000);
  char help[80];
  FILE *f;

  if(!(cfg.system_state&1)||(get_global_msg()&_SHUTDOWN))
    return 0L;

  while(sema)
    suspend(1);

  sema=1;
  set_win(filewin);
  gotoxy(1,1);
  sprintf(help,"Rec'n write: %s%s ec%ld",path,input,ec);
  help[38]=0;
  cputs(help);

  input[12]=0;
  sprintf(help,"%s%s",path,input);
  strcpy(WFile_Info.Filename,input);

  if((f=tfopen(help,"wb"))!=NULL)
  { write_finfo (WFile_Info,f);
    if((wait_carrier(1)==-1)||!do_irq(1,0L,pblength))
    { matsch:;
      tfclose(f);
      sema=0;
      remove(help);
      return(0L);
    }

    SQ_Count=timer();
    while(((timer()-SQ_Count)<cfg.sq_wait)&&irq_state())
    { if(stopped()||feof(f))
      { Wrt_Count=0L;
        break;
      }

      while(((Wrt_Count+_IRQ_CACHE)<get_irqcnt())&&((Wrt_Count+_IRQ_CACHE)<=get_irqcnt()))
      { fwrite((void*)(puffer+Wrt_Count%_MEM),(unsigned)_IRQ_CACHE,1,f);
        Wrt_Count+=_IRQ_CACHE;
      }
      if(get_irqact()&SQ_BIT)
	SQ_Count=timer();
      toggle_wd();
    }

    set_audio(32);
    stop_irq(); //neu
    if(get_irqcnt()>Wrt_Count)
    { if((get_irqcnt()-Wrt_Count-ec)>0L)
      { fwrite((void *)(puffer+Wrt_Count%_MEM),(unsigned)(get_irqcnt()-Wrt_Count-ec),1,f);
        Wrt_Count+=(get_irqcnt()-Wrt_Count-ec);
      }
      toggle_wd();
      location=Wrt_Count;
    }
    else
    { if((Wrt_Count-ec)>0L)
        location=Wrt_Count-ec;
    }
    WFile_Info.Length=location;
    WFile_Info.Srate=srate/100;
    update_msg_info(WFile_Info);
    write_finfo (WFile_Info,f);
    list_minfo(WFile_Info);
    //chsize(fileno(f),WFile_Info.Length+sizeof(msg_info_t));
    tfclose(f);
  }
  else
    write_log(_serious,"record_write","fopen error %s%s",path,input);

  set_win(irqwin);
  gotoxy(1,1);
  cprintf(" %ld bytes",location);
  set_win(filewin);
  gotoxy(1,1);
  cprintf("% 38s","");
  sema=0;

  if(WFile_Info.Length<1000)
  { remove(help);
    WFile_Info.Length=0;
  }
  else
  {  ad_time(&delstart);
    ad_time(&dtmfstart);
  }

  while(getsq())
  {  scheduler();

    toggle_wd();
  }

  return(WFile_Info.Length);
}
