/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  direct RAM record & playback functions
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#include "dvms.h"
#include "dvmscmd.h"
#include "dvmsirq.h"
#include "dvmsptt.h"
#include "dvmssuba.h"

char sema=0;

unsigned long playback(unsigned long memptr,unsigned long pblength)
{ if(!(cfg.system_state&1)||(get_global_msg()&_SHUTDOWN))
    return 0L;

  while(sema)
    suspend(1);
  sema=1;

  if((pblength>_MEM)||!pblength)
  {  write_log(_serious,"playback","pblength out of range %ld",pblength);
    sema=0;
    return(0L);
  }
  if(getdt(0)&16)
  {  sema=0;
    return 0L;
  }
  stop_irq();

  if(do_irq(2,memptr,pblength+memptr))
  {  ptt(1);
    set_win(filewin);
    gotoxy(1,2);
    cprintf("Playback: %lu Bytes",pblength);
    while(irq_state())
    {  set_win(irqwin);
      gotoxy(1,1);
      cprintf("IRQ: % 6lu           ",get_irqcnt());
      if(stopped()) break;
    }
    toggle_wd();
    location=get_irqcnt();
    stop_irq();
    set_win(filewin);
    gotoxy(1,2);
    cprintf("% 38s","");
    set_win(irqwin);
    clrscr();
  }
  sema=0;

  if(location)
  {  ad_time(&delstart);
    ad_time(&dtmfstart);
  }

  return(location);
}

unsigned long record(unsigned long pbmemptr,unsigned long pblength)
{ long SQ_Count=timer(),ec=(cfg.endcut+cfg.sq_wait*55)*(srate/8000);

  if(!(cfg.system_state&1)||(get_global_msg()&_SHUTDOWN))
    return 0L;

  while(sema)
    suspend(1);
  sema=1;

  s_meter=0L;
  sig_count=0L;
  ptt(-1);
  afsw(1);
  setrate(cfg.default_srate);
  set_win(filewin);
  gotoxy(1,2);
  cprintf("Record  : from %lu to %lu",pbmemptr,pbmemptr+pblength);

  stop_irq();
  if(do_irq(1,pbmemptr,pblength+pbmemptr))
  { while(((timer()-SQ_Count)<(long)cfg.sq_wait)&&irq_state())
    { set_win(irqwin);
      gotoxy(1,1);
      cprintf("IRQ: % 6lu %d ",get_irqcnt(),get_irqpse());
      if(stopped())
      {
        location=0L;
        goto lab;
      }
      if(get_irqact()&SQ_BIT)
	SQ_Count=timer();
    }
    set_audio(32);
    toggle_wd();
    location=get_irqcnt();
    stop_irq();
    lab:;
    if(location>ec)
      location-=ec;
    set_win(filewin);
    gotoxy(1,2);
    cprintf("% 38s","");
    set_win(irqwin);
    gotoxy(1,1);
    cprintf(" %ld bytes ",location);
  }
  if(location)
  { ad_time(&delstart);
    ad_time(&dtmfstart);
  }

  while(getsq())
  { scheduler();
    toggle_wd();
  }

  sema=0;
  return(location);
}


