/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  purge message/user - reorg message/user
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsdelm.h"
#include "dvmsfwd.h"
#include "dvmsirq.h"
#include "dvmsmem.h"
#include "dvmshead.h"
#include "dvmsmsgb.h"
#include "dvmsptt.h"
#include "dvmssuba.h"
//#include "tnclow.h"
#include "util.h"

void purge_msg (void)
{ static sema=0;
  long cpuold=get_tcb()->cputime;
  msg_info_t MInfo;
  long Msg_Count=0L,Msg_Num;
  char help[80],*r="purge_msg";
  if(sema)
   return;

  //while(sema)
  //  suspend(1);
  sema=1;

  Msg_Num=mails();

  write_log(_report,r,"*** start msgs #%ld",Msg_Num);

  set_win(filewin);
   clrscr();
  gotoxy(1,1);
  cprintf("Msg Service %d Message(s)....",Msg_Num);

  while(Msg_Num)
  {
    toggle_wd();
    read_minfo (Msg_Count,MInfo);
    if(!MInfo.Filename[0]) break;
    set_win(filewin);
    gotoxy(1,2);
    cprintf("MESSAGE NUMBER: %ld % 7d ",Msg_Count,MInfo.Days);

//    if((ad_time(NULL)-MInfo.Unixtime)<0)
//      write_log(_serious,(time(NULL)-MInfo.Unixtime)/86400L,"msg_serv: MsgLifetime<0",MInfo.Filename);

    if((!MInfo.Unixtime)||(MInfo.State&_MSGST_DELETED)||
       ((ad_time(NULL)-MInfo.Unixtime)>=(MInfo.Days*86400L))//&&
       //((ad_time(NULL)-MInfo.Unixtime)>0)
      )
    {  sprintf(help,"%s%s",cfg.msgp,MInfo.Filename);

      if(isdigit(MInfo.Filename[0]))
      {  remove(help);
        set_win(filewin);
        gotoxy(30,2);

        cputs("DELETED");

        if(MInfo.State&_MSGST_DELETED)
          write_log(_report,r,"erase del %s",help);
        else
          write_log(_report,r,"erase life %s",help);
      }
      init_msg_info(MInfo);
      change_minfo (Msg_Count,MInfo);
    }
    else
      Msg_Count++;

    Msg_Num--;
    scheduler();
  }
  write_log(_report,r,"CPUt %s",zeitspanne(get_tcb()->cputime-cpuold,2));
  sema=0;
}

int del_usr(int usr)
{  char file[80];

  write_log(_report,"del_usr","#%d",usr);

  sprintf(file,"%s%04d_USR.VMS",cfg.usrp,usr);
  if(remove(file)==-1)
    return 0;

  sprintf(file,"%s%04d_NAM.VMS",cfg.usrp,usr);
  remove(file);

  del_read(usr,FALSE);
  change_userfile("",usr);
  return 1;
}

void purge_usr(void)
{ static sema=0;
  struct find_t find;
  msg_info_t File_Info;
  long t,cpuold=get_tcb()->cputime;
  char help[80],*r="purge_usr";
  if(sema)
    return;

   //while(sema)
  // suspend(1);
  sema=1;
  write_log(_report,r,"*** start");

  sprintf(help,"%s????_USR.VMS",cfg.usrp);
  set_win(filewin);
  clrscr();
  gotoxy(1,1);
  cputs("User Service....");

  if(!_dos_findfirst(help, 0xffff, &find ))
  do
  { rd_file_info(cfg.usrp,find.name,File_Info);
    toggle_wd();
    if(File_Info.Id!=_MSGID_BBS)
    { t=(time(NULL)-File_Info.Unixtime);
      set_win(filewin);
      gotoxy(1,2);
      cprintf("USR: %s % 4ld",find.name,t/86400L);
      if(t>=(File_Info.Days*86400L)/*||(t<=0)*/)
      {  del_usr(atoi(find.name));
        set_win(filewin);
        cprintf("DEL:%s               ",find.name);
        write_log(_report,r,"erase life %s",find.name);
      }
    }
    scheduler();
  }
  while(!_dos_findnext( &find ));

  write_log(_report,r,"CPUt %s",zeitspanne(get_tcb()->cputime-cpuold,2));

  sema=0;
}

void reorg_usr(void)
{ static sema=0;
  FILE *aus;
  char file[80],help1[80],*r="reorg_usr";
  int u_count,ufound=0;
  long cpuold=get_tcb()->cputime;
  msg_info_t File_Info;

  if(sema)
    return;

  sema=1;

  set_win(filewin);
  clrscr();
  gotoxy(1,1);
  cprintf("reorg %-3.3s_USER.VMS        ",cfg.boxaddress);
  sprintf(file,"%s%-3.3s_USER.$$$",cfg.usrp,cfg.boxaddress);
  remove(file);
  write_log(_report,r,"*** start");

  if((aus=tfopen(file,"w"))==NULL)
  {  write_log(_serious,r,"fopen error %s",file);
    sema=0;
    return;
  }

  for(u_count=1;u_count<1000;u_count++)
  { set_win(filewin);
    gotoxy(1,2);

    sprintf(file,"%s%04d_USR.VMS",cfg.usrp,u_count);
    cputs(file);

    if(!access(file,0))
    { sprintf(file,"%04d_USR.VMS",u_count);
      rd_file_info(cfg.usrp,file,File_Info);

      File_Info.Days=cfg.max_usr_days;

      if(File_Info.Ureceiver!=u_count)
      {  File_Info.Ureceiver=u_count;
        wrt_file_info(cfg.usrp,file,FALSE,File_Info);
      }
      if(strncmp(File_Info.Info,ad_id(cfg.boxaddress),9))
      {  strncpy(File_Info.Info,ad_id(cfg.boxaddress),9);
        wrt_file_info(cfg.usrp,file,FALSE,File_Info);
      }
      if((File_Info.Id==_MSGID_BBS)&&strncmp(File_Info.Info+9,"BBS",3))
      {  strncpy(File_Info.Info,ad_id(cfg.boxaddress),9);
        wrt_file_info(cfg.usrp,file,FALSE,File_Info);
      }

      fprintf(aus,"%-16.16s %03d\n",File_Info.Info,File_Info.Ureceiver);
      ufound++;
    }
    scheduler();
  }
  tfclose(aus);

  sprintf(file,"%s%-3.3s_USER.$$$",cfg.usrp,cfg.boxaddress);
  sprintf(help1,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);
  remove(help1);
  rename(file,help1);

  write_log(_report,r,"users %d CPUt %s",ufound,zeitspanne(get_tcb()->cputime-cpuold,2));
  sema=0;
}
static int namesort( const void *a, const void *b)
{   return( strcmp((char *)a+3,(char *)b+3) );
}

void reorg_msg (void)
{
  static sema=0;
  long cpuold=get_tcb()->cputime;
  int countmsg=0,handle,i=0,j;
  char help[40],*r="reorg_msg";
  msg_info_t File_Info;
  struct find_t find;

  if(sema)
    return;

  sema=1;

  write_log(_report,r,"*** start");

  typedef char name_t[9];
  name_t *name;

  if((name=(name_t*)tmalloc(9000))==NULL)
  {  write_log(_report,r,"malloc failed");
    sema=0;
    return;
  }
  memset(name,0,9000);
  sprintf(help,"%s*.VMS",cfg.msgp);
  set_win(filewin);
  clrscr();
  gotoxy(1,1);
  cputs("reorg LIST.VMS        ");

  if(!_dos_findfirst(help, 0xffff, &find ))
  do
  { if(isdigit(find.name[0]))
    {
      strncpy(name[i],find.name,8);
      name[i++][8]=0;
      if(i>999)
      { write_log(_fatal,r,"too many messages!");
         tfree(name);
        sema=0;
        return;
      }
    }
  }
  while(!_dos_findnext( &find ));

  qsort((void *)name,i,sizeof(name_t),namesort);

  sprintf(help,"%s"_LISTNAME".VMS",cfg.msgp);
  if((handle=open(help,O_RDWR|O_BINARY))!=-1)
  {  if(filelength(handle)>0L)
    {  close (handle);
      char path[40];
      sprintf(path,"%s"_LISTNAME".BAK",cfg.msgp);
      remove(path);
      rename(help,path);
      remove(path);
    }
    else
      close (handle);
  }

  for(j=0;j<i;j++)
  { sprintf(help,"%s.VMS",name[j]);
    //set_win(defaultwin);
    //cprintf("\r\n%s",help);
    //getch();
    rd_file_info(cfg.msgp,help,File_Info);
    File_Info.Days=cfg.max_msg_days;
    wrt_file_info(cfg.msgp,help,FALSE,File_Info);

    write_minfo (File_Info);
    countmsg++;
  }
  tfree(name);
  write_log(_report,r,"messages %d CPUt %s",countmsg,zeitspanne(get_tcb()->cputime-cpuold,2));
  sema=0;
}

void event(void)
{  strcpy(get_tcb()->cmd,"purge_msg");
  purge_msg();
  strcpy(get_tcb()->cmd,"reorg_usr");
  reorg_usr();
  strcpy(get_tcb()->cmd,"purge_usr");
  purge_usr();
  c_init();
  afsw(1);
  ptt(ptt_state);
  write_log(_report,"reorg all","total CPUt %s",zeitspanne(get_tcb()->cputime,2));
}

void clean_up (void)
{ msg_info_t MInfo;
  char help[80],*r="clean_up";
  long Msg_Num;
  int Msg_Count=0;

  init_msg_info(MInfo);
  MInfo.State=_MSGST_READ;

  while((Msg_Num=msg_num_select(Msg_Count++,MInfo))!=-1)
  {  if(!read_minfo (Msg_Num,MInfo))
    {  write_log(_serious,r,"read_minfo error msg_num %ld",Msg_Num);
      return;
    }

    if((MInfo.Id!=_MSGID_BBS)&&isdigit(MInfo.Filename[0]))
    {  write_log(_report,r,"del %s",MInfo.Info);
      sprintf(help,"%s%s",cfg.msgp,MInfo.Filename);
      remove(help);
      toggle_wd();
      strcpy(MInfo.Filename,"CLEAN_UP.VMS");

      MInfo.State&=(0xffff-_MSGST_EXTHEADER-_MSGST_TRANSFER);
      write_minfo_num (Msg_Num,MInfo);
    }
    init_msg_info(MInfo);
    MInfo.State=_MSGST_READ;
  }
}
