/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  PTT-Control
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsirq.h"

int ptt_state=0;

int ptt(int s)
{ if(!(cfg.system_state&1))
    s=0;
  if(!cfg.repeater)
  {  if(s>0)
    { if(usesb16 && cfg.lpt)
	outp(lpt,inp(lpt) | 2);
      hw_set(6,128);
      hw_set(8,2);
      if(!ptt_state)
	suspend(cfg.tx_hold*100/55);
      ptt_state=1;
      ad_time(&delstart);
    }
    else
    {  while(call_state&&!(get_global_msg()&_SHUTDOWN))
	scheduler();
      if(ptt_state)
	suspend(cfg.tx_retrig*100/55);
      if(usesb16 && cfg.lpt)
	outp(lpt,inp(lpt) & 0xfd);
      hw_set(6,0);
      hw_set(8,0);
      ptt_state=0;
    }
  }
  else
  {  switch(s)
    {  case -1:
      if(((ad_time(NULL)-delstart)>=(long)cfg.tx_hold)&&!ulogin)
      {  while(call_state&&!(get_global_msg()&_SHUTDOWN))
          scheduler();

        if(usesb16 && cfg.lpt)
          outp(lpt,inp(lpt) & 0xfd);
        hw_set(6,0);
        hw_set(8,0);
        ptt_state=0;
      }
      break;

      case 0:
        if(usesb16 && cfg.lpt)
          outp(lpt,inp(lpt) & 0xfd);
        hw_set(6,0);
        hw_set(8,0);
        ptt_state=0;
      break;

      default:
        if(usesb16 && cfg.lpt)
          outp(lpt,inp(lpt) | 2);
        hw_set(6,128);
        hw_set(8,2);
        ptt_state=1;
        ad_time(&delstart);
    }
  }
  return ptt_state;
}
