/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  parameter-interpreter DVMS.INI
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsfwd.h"
#include "dvmsini.h"
#include "dvmspurg.h"
#include "dvmssuba.h"
#include "util.h"
#include "tnc.h"


adc_cfg_t adc_cfg[8];
config_t cfg;
int lin=-1;
char err=0,currfile=0,sysp[80];
static char *dvmsini=_DVMSININAME,*adcini=_ADCININAME,*pwdini=_PWDININAME,
     *fm1="- Can't create file: %s.\r\a",*fm2=" File created: %s.\r\a",
     *dir="- Unable to create dir: %s\a\r";


static int read_dvmsini(void);

static void near cfgerr(unsigned reason,char *s)
{  char *r,*file;
  err=1;
  if(!reason&&(lin==-1))
    return;
  switch(currfile)
  {
    case 1: file=dvmsini;break;
    case 2: file=adcini;break;
    default: file="";
  }

  switch (reason)
  {
    case 1: r="value out of range";break;
    case 2: r="argument missing";break;
    default: r="syntax error";

  }
  putf("- %s ",file);
  if(lin!=-1)
    putf("line %-3d ",lin);
  putf("[%s] (%s)\r",s,r);
}

int hadrok(char *call)
{  char *s,save[81];

  if(strlen(call)>80)
    return 0;

  strcpy(save,call);

  if(((s=strchr(save,'.'))==NULL)||!strchr(s+1,'.'))
    return 0;

  s[0]=0;
  return mbcallok(save);
}

long get_number (char *t,long min,long max)
{
  long number;
  char *s,help[81];
  s=nextarg(t);

  if(strlen(s)>80)
  {
    cfgerr(1,t);
    return -1L ;
  }

  if(!sscanf(s,"%80s",help))
  {
    cfgerr(2,t);
    return -1L;
  }
  if(help[0]==';')
  {
    cfgerr(0,t);
    return -1L;
  }
  if(!min&&(max==1))
  {
    if(!stricmp(help,"on"))
      return 1L;
    else
    {
      if(!stricmp(help,"off"))
        return 0L;
    }
  }
  if(help[0]=='$')
  {
    if(!sscanf(help+1,"%lx",&number))
    {
      cfgerr(2,t);
      return -1L;
    }
  }
  else
  if((help[0]=='0')&&((help[1]&0x5f)=='X'))
  {
    if(!sscanf(help+2,"%lx",&number))
    {
      cfgerr(2,t);
      return -1L;
    }
  }
  else
  if(help[0]=='%')
  {  int j=strlen(help+1),i;
     number=0L;
     for(i=0;i<j;i++)
     if(help[j-i]=='1')
       number|=(1<<i);
     else
     if(help[j-i]!='0')
     {  cfgerr(3,t);
        return -1L;
     }
  }
  else
  if(!sscanf(help,"%ld",&number))
  {
    cfgerr(2,t);
    return -1L;
  }

  if((number<min)||(number>max))
    cfgerr(1,t);
  else
  if((min==-1L) && (number>-1L))
    number=(long)get_ctcss (number*1000L);

  return number ;
}

char *dec2bin(unsigned long bin)
{  static char strout[34];
   int i,ok=0;
   strout[0]='%';
   if(!bin)
     strout[1+ok++]='0';
   else
   for(i=31;i>=0;i--)
   {
     if(bin&(1<<i))
     { strout[ok+1]='1';
       ok++;
     }
     else
       if(ok)
       {
         strout[ok+1]='0';
         ok++;
       }
   }
   strout[ok+1]=0;
   return strout;
}

long get_float (char *t,long min,long max)
{
  long number;
  char *s,*u,help[81],post[6];
  s=nextarg(t);

  if(strlen(s)>80)
  {
    cfgerr(1,t);
    return -1L;
  }

  if(!sscanf(s,"%80s",help))
  {
    cfgerr(2,t);
    return -1L;
  }
  if(help[0]==';')
  {
    cfgerr(0,t);
    return -1L;
  }
  post[0]=0;
  if((u=strchr(help,'.'))!=NULL)
    u[4]=0;

  if(!sscanf(help,"%ld.%3s",&number,post))
  {
    cfgerr(2,t);
    return -1L;
  }

  number*=1000L;
  switch(strlen(post))
  {
    case 1: number+=(atoi(post)*100);break;
    case 2: number+=(atoi(post)*10);break;
    case 3: number+=atoi(post);break;
  }
  if((number<1000L)&&(number>=0L))
    number*=((help[0]=='-')?-1L:1L);

  if((number<min) || (number>max))
    cfgerr(1,t);
  return number ;
}

static void ccdir(char *s)
{ set_win(filewin);
  cprintf(dir,s);
  if(!ignore)
    exit(30);
}

static int isdir(char *help)
{  struct stat statbuf;
  if(stat(help, &statbuf)==-1)
    return 0;
  return (statbuf.st_mode&S_IFDIR);
}

void chkfiles(void)
{
  char help[80];

  if(!isdir("dist"))
    if(mkdir("dist"))
     ccdir("dist");

  if(!isdir("txt"))
    if(mkdir("txt"))
     ccdir("txt");

  if(!isdir("fwd"))
    if(mkdir("fwd"))
     ccdir("fwd");

  if(!isdir("log"))
    if(mkdir("log"))
     ccdir("log");

  sprintf(help,"%s%-3.3s_user.vms",cfg.usrp,cfg.boxaddress);
  if(access(help,0)==-1)
    reorg_usr();

  sprintf(help,"%s"_LISTNAME".vms",cfg.msgp);
  if(access(help,0)==-1)
  {  int f=open(help,O_CREAT|O_BINARY|O_RDWR,S_IREAD|S_IWRITE);
    close(f);
    reorg_msg();
  }
}

static int xmkdir(char *path)
// **************************************************
//
//  Erzeugt einen ganzen Directorypfad
//  Funktioniert auch dann, wenn mehrere Directories
//  angelegt werden muessen.
//
// **************************************************
{ char pathcopy[81];
  char *pptr;
  struct stat statbuf;
  int  retwert=0;

  if(strlen(path)>79)
    return -1;

  pptr=pathcopy;             // Pfadanfang merken
  do
  { strcpy(pathcopy,path);
    strlwr(pathcopy);

    pptr=strchr(pptr,'\\');   // auf den nchsten back-Slash positionieren
    if(pptr)                 // wenn ein Slash da
    { pptr[0]=0;             // dann String an der Stelle beenden
      pptr++;
    }

    if(stat(pathcopy, &statbuf)!=-1)
    {  if(statbuf.st_mode&S_IFDIR)
      {  if(pptr==NULL)
          return 0;
      }
      else
        if(unlink(pathcopy)==-1)
          return -1;        // evtl vorhandenes File lschen (tdlich)
    }
    retwert=mkdir(pathcopy); // den letzten abgegebenen Returnwert bergeben
    //cprintf("\r\n%s",pathcopy);
  } while(pptr);            // solange Slashes im Pfad
  return retwert;
}

static char *get_path(char *t)
{ static char help[81];
  char *s;
  int i;

  s=nextarg(t);
  if(strlen(s)>80)
  {
   cfgerr(1,t);
   return NULL ;
  }

  if(!sscanf(s,"%s",help))
  {
   cfgerr(2,t);
   return NULL ;
  }

  if(help[0]==';')
  {
    cfgerr(0,t);
    return(NULL);
  }

  subst(help,'/','\\');
  strlwr(help);

  if(help[(i=strlen(help)-1)]=='\\')
    help[i]=0;
  struct stat statbuf;
  stat(help, &statbuf);
  if(stat(help, &statbuf)||!(statbuf.st_mode&S_IFDIR))
    if(!xmkdir(help))
      putf(" created directory: %s\r",help);
    else
    {  putf(dir,s);
      err=1;
    }

  strcat(help,"\\");
  return help;
}

static void near set_defaults(void)
{   memset(&cfg,0,sizeof(config_t));
    cfg.max_msg_length=500L*1024L;
    cfg.max_msg_fwd_length=250L*1024L;;

    cfg.iobase=0x300;
    cfg.irq=5;
    cfg.config=15;
    cfg.rzz=300;
    cfg.sq_inv=0;
    cfg.sq_wait=385/55;
    cfg.sq_sens=10;
    cfg.tx_hold=10;
    cfg.tx_retrig=20;
    cfg.dtmf_timeout=600;
    cfg.inp_timeout=0;
    cfg.repeater=0;
    cfg.utcoffset=-1;
    cfg.cmd_wait=300;
    cfg.sig_min=0;
    cfg.unum_min=100;
    cfg.endcut=440;
    cfg.sysop_num=100;
    cfg.sysop_tone=0;
    cfg.warn=45;
    cfg.tout=60;
    cfg.max_pause=4000;
    cfg.max_msg_days=180;
    cfg.hrd_msg_days=90;
    cfg.max_usr_days=999;
    cfg.dcf_used=0;
    cfg.afswitch=0;
    cfg.lpt=0;
    cfg.system_state=7;
    cfg.ctcss_gain=6;
    cfg.ctcss_open=-1;
    cfg.nouser_list=0;
    cfg.loglevel=2;
    cfg.beacon=0;
    cfg.scrsave=0;
    cfg.adcmaxsamples=336;
    cfg.adc_combase=0x2f8;
    cfg.subwait=1500;

    cfg.default_srate=32000;
    cfg.fwd_srate=16000;
    cfg.tone=600000L;
    cfg.subout=0L;
    //cfg.ssid=0;
    cfg.mycalls=1;

    //strcpy(cfg.sysp[1],"female\\");

    strcpy(cfg.sysp[0],"male\\");
    strcpy(cfg.usrp,"user\\");
    strcpy(cfg.msgp,"msg\\");

    if(getenv("TEMP"))
      strcpy(cfg.tmppath,getenv("TEMP"));
    else
    if(getenv("TMP"))
      strcpy(cfg.tmppath,getenv("TMP"));
    else
      strcpy(cfg.tmppath,"\\tmp\\");

    strcpy(cfg.boxaddress,"089DB0AAB.#BAY.DEU.EU");
    strcpy(cfg.boxheader ,"Sprachmailbox-Mnchen");
    strcpy(cfg.mycall[0],"DB0AAB-9");
    strcpy(cfg.statsend  ,"SPRACHE @ DB0AAB #1");
    strcpy(cfg.statsubj  ,"DVMS Mnchen: Benutzerstatistik");
    strcpy(cfg.call,"DB0AAB");
    strcpy(cfg.remote_switch,"12345");
    strcpy(cfg.sysop_code,"67890");

    if (usesb16) cfg.sbvol = 1;
    cfg.level_in = 15;
    cfg.level_mic = 0;
    cfg.level_out = 15;
    cfg.level_voc = 12;
    cfg.level_cw = 10;
}


int write_par(void)
{  char *fs="%-15s %s\n",*fu="%-15s %u\n",*fd="%-15s %d\n",*fld="%-15s %ld\n";
  FILE *f;
  if((f=tfopen(dvmsini,"w"))==NULL)
      return 0;
  fprintf(f,";"initmsg"\n");
  fprintf(f,";configuration file: %s\n",dvmsini);

  fprintf(f,";directories\n");
  fprintf(f,fs,inicmd[system1      ],cfg.sysp[0]);
  if(cfg.sysp[1][0])
    fprintf(f,fs,inicmd[system2    ],cfg.sysp[1]);
  if(cfg.sysp[2][0])
    fprintf(f,fs,inicmd[system3    ],cfg.sysp[2]);

  fprintf(f,fs,inicmd[userpath    ],cfg.usrp);
  fprintf(f,fs,inicmd[messagepath  ],cfg.msgp);
  fprintf(f,fs,inicmd[tmppath     ],cfg.tmppath);
  fputc('\n',f);

  fprintf(f,";identification\n");
  fprintf(f,fs,inicmd[boxaddress  ],cfg.boxaddress);

  fprintf(f,fs,inicmd[boxheader    ],cfg.boxheader);
  fprintf(f,"%-15s",inicmd[_mycall      ]);

  for(int i=0;i<cfg.mycalls;i++)
    fprintf(f," %s",cfg.mycall[i]);

  fprintf(f,"\n");
  fprintf(f,fs,inicmd[statsend    ],cfg.statsend);
  fprintf(f,fs,inicmd[statsubj    ],cfg.statsubj);
  fprintf(f,fs,inicmd[cwcall      ],cfg.call);

  fprintf(f,"\n;DVMS slotcard specification\n");
  fprintf(f,"%-15s 0x%X\n",inicmd[iobase],cfg.iobase);
  fprintf(f,fu,inicmd[irq],cfg.irq);

  fprintf(f,"\n;limits\n");
  fprintf(f,fld,inicmd[local_srate   ],cfg.default_srate/1000L);
  fprintf(f,fld,inicmd[fwd_srate     ],cfg.fwd_srate/1000L);
  fprintf(f,fld,inicmd[max_loc_length],cfg.max_msg_length>>10);
  fprintf(f,fld,inicmd[max_fwd_length],cfg.max_msg_fwd_length>>10);
  fprintf(f,fu,inicmd[max_msg_days   ],cfg.max_msg_days);
  fprintf(f,fu,inicmd[hrd_msg_days   ],cfg.hrd_msg_days);
  fprintf(f,fu,inicmd[max_usr_days   ],cfg.max_usr_days);
  fprintf(f,fu,inicmd[unum_min       ],cfg.unum_min);
  fprintf(f,fu,inicmd[endcut         ],cfg.endcut);
  fprintf(f,fd,inicmd[utcoffset      ],cfg.utcoffset);
  fprintf(f,fd,inicmd[scrsave        ],cfg.scrsave);

  fprintf(f,"\n;repeater control\n");
  fprintf(f,fu,inicmd[csgn          ],cfg.rzz);
  fprintf(f,fld,inicmd[beep_tone    ],cfg.tone/1000L);
  fprintf(f,fld,inicmd[subout       ],cfg.subout/1000L);
  fprintf(f,fu,inicmd[subwait      ],cfg.subwait);
  fprintf(f,fs,inicmd[config        ],dec2bin(cfg.config));
  fprintf(f,fu,inicmd[cmd_wait      ],cfg.cmd_wait);
  fprintf(f,fu,inicmd[tx_hold       ],cfg.tx_hold);
  fprintf(f,fu,inicmd[tx_retrig     ],cfg.tx_retrig);
  fprintf(f,fu,inicmd[repeater      ],cfg.repeater);
  fprintf(f,fd,inicmd[ctcss_open    ],(cfg.ctcss_open>0)?(ctcss_tone[cfg.ctcss_open]/1000):cfg.ctcss_open);
  fprintf(f,fu,inicmd[sq_wait       ],cfg.sq_wait*55);
  fprintf(f,fu,inicmd[sq_sens       ],cfg.sq_sens);
  fprintf(f,fs,inicmd[sq_inv        ],cfg.sq_inv?"on":"off");

  fprintf(f,fu,inicmd[warntime      ],cfg.warn);
  fprintf(f,fu,inicmd[timeout       ],cfg.tout);
  fprintf(f,fu,inicmd[inp_timeout   ],cfg.inp_timeout/60);
  fprintf(f,fu,inicmd[dtmf_tout     ],cfg.dtmf_timeout);
  fprintf(f,fs,inicmd[nouser_list   ],cfg.nouser_list?"on":"off");

  fprintf(f,"\n;sysop control\n");
  fprintf(f,fd,inicmd[systemstate   ],cfg.system_state);
  /*
  fprintf(f,fs,inicmd[_switch       ],cfg.remote_switch);
  fprintf(f,fs,inicmd[sysop_code    ],cfg.sysop_code);
  fprintf(f,fd,inicmd[sysop_tone    ],(cfg.sysop_tone>0)?(ctcss_tone[cfg.sysop_tone]/1000):cfg.sysop_tone);
  */
  fprintf(f,fu,inicmd[sysop_num     ],cfg.sysop_num);
  fprintf(f,fu,inicmd[loglevel      ],cfg.loglevel);
  fprintf(f,fs,inicmd[defuprefs     ],dec2bin(cfg.defuprefs));

  fprintf(f,"\n;hardware specials\n");
  fprintf(f,fu,inicmd[sig_min       ],cfg.sig_min);
  fprintf(f,fs,inicmd[sig_inv       ],cfg.sig_inv?"on":"off");

  fprintf(f,fs,inicmd[dcf_used      ],cfg.dcf_used?"on":"off");
  fprintf(f,fs,inicmd[afsw_805      ],cfg.afswitch?"on":"off");
  fprintf(f,fu,inicmd[ctcss_gain    ],cfg.ctcss_gain);
  fprintf(f,fu,inicmd[_lpt          ],cfg.lpt);

  if (cfg.sbvol)
  { fprintf(f,"\n;soundblaster mixer adjustments\n");
    fprintf(f,fu,inicmd[level_in      ],cfg.level_in);
    fprintf(f,fu,inicmd[level_mic     ],cfg.level_mic);
    fprintf(f,fu,inicmd[level_out     ],cfg.level_out);
    fprintf(f,fu,inicmd[level_voc     ],cfg.level_voc);
    fprintf(f,fu,inicmd[level_cw      ],cfg.level_cw);
  }

  fprintf(f,"\n;*** eof %s\n",dvmsini);
  tfclose(f);
  return 1;
}

static int isprcmd(char *s)
{  return !(nextarg(s)[0])&&((get_tcb()->type&_TNCPROC)||(get_tcb()->type&_CONSOLE));
}

int execinipar(char *s)
{     char cmd[80],*t;
      char *fs="%-15s %s",*fu="%-15s %u",*fd="%-15s %d",*fld="%-15s %ld";

      int prcmd=0,i;

      sscanf(s,"%79s",cmd);

      if(!cmd[0])
        return 0;

      if((prcmd=isprcmd(s))!=0)
        err=1;

      i=checkcmd(inicmd,cmd,!prcmd);

      switch(i)
      {
        case error:       cfgerr(0,cmd);
                          return 0;
        case iobase:      if(prcmd)
                            putf("%-15s 0x%X",inicmd[iobase],cfg.iobase);
                          else
                            cfg.iobase=(unsigned)get_number(s,0x200,0x3ff);
                          break;
        case local_srate: if(prcmd)
                            putf(fld,inicmd[local_srate],cfg.default_srate/1000L);
                          else
                            cfg.default_srate=get_number(s,12,32)*1000L;
                          break;
        case fwd_srate:   if(prcmd)
                            putf(fld,inicmd[fwd_srate],cfg.fwd_srate/1000L);
                          else
                            cfg.fwd_srate=get_number(s,12,32)*1000L;
                          break;
        case csgn:        if(prcmd)
                            putf(fu,inicmd[csgn],cfg.rzz);
                          else
                            cfg.rzz=(unsigned)get_number(s,0,1800);
                          break;
        case endcut:      if(prcmd)
                            putf(fu,inicmd[endcut],cfg.endcut);
                          else
                            cfg.endcut=(unsigned)get_number(s,0,3000);
                          break;
        case config:      if(prcmd)
                            putf(fs,inicmd[config],dec2bin(cfg.config));
                          else
                            cfg.config=(unsigned)get_number(s,0,0x1ff);
                          break;

        case userpath:    if(prcmd)
                            putf(fs,inicmd[userpath],cfg.usrp);
                          else
                            strcpy(cfg.usrp,get_path(s));
                          break;
        case system1:     if(prcmd)
                            putf(fs,inicmd[system1],cfg.sysp[0]);
                          else
                          {
                            strcpy(cfg.sysp[0],get_path(s));
                            strcpy(sysp,cfg.sysp[0]);
                          }
                          break;
        case system2:     if(prcmd)
                            putf(fs,inicmd[system2],cfg.sysp[1]);
                          else
                            strcpy(cfg.sysp[1],get_path(s));
                          break;
        case system3:     if(prcmd)
                            putf(fs,inicmd[system3],cfg.sysp[2]);
                          else
                            strcpy(cfg.sysp[2],get_path(s));
                          break;
        case messagepath: if(prcmd)
                            putf(fs,inicmd[messagepath],cfg.msgp);
                          else
                            strcpy(cfg.msgp,get_path(s));
                          break;
        case corruptpath: if(prcmd)
                            putf(fs,inicmd[corruptpath],cfg.tmppath);
                          else
                            strcpy(cfg.tmppath,get_path(s));
                          break;
        case tmppath: if(prcmd)
                            putf(fs,inicmd[tmppath],cfg.tmppath);
                          else
                            strcpy(cfg.tmppath,get_path(s));
                          break;

        case boxaddress:  if(prcmd)
                            putf(fs,inicmd[boxaddress],cfg.boxaddress);
                          else
                          {
                            if(strlen((t=nextarg(s)))>(sizeof(cfg.boxaddress)-1))
                              goto label;
                            if(!hadrok(t+3))
                              goto label;
                            if(!isdigit(t[0])||!isdigit(t[1])||!isdigit(t[2]))
                            {
                              label:;
                              putf("\r- %s ",dvmsini);
                              if(lin!=-1)
                                putf("line %-3d ",lin);
                              putf("[%s] (invalid boxaddress)",t);
                              err=1;
                            }
                            else
                              strcpy(cfg.boxaddress,strupr(t));
                          }
                          break;
        /*case ssid:        if(prcmd)
                            putf("%-15s %d",inicmd[ssid],cfg.ssid);
                          else
                            cfg.ssid=(unsigned)get_number(s,0,15);
                          break;
        */
        case _mycall:     if(prcmd)
                          { putf("%-15s",inicmd[_mycall]);
                            for(i=0;i<cfg.mycalls;i++)
                              putf(" %s",cfg.mycall[i]);
                            putv('\r');
                          }
                          else
                          { cfg.mycalls=0;
                            while(sscanf(s=nextarg(s),"%9s",cfg.mycall[cfg.mycalls])!=EOF)
                            { //putf("[%s][%s]\r",s,cfg.mycall[cfg.mycalls]);
                              strupr(cfg.mycall[cfg.mycalls]);
                              cfg.mycalls++;
                              if(cfg.mycalls==_MAXMYCALLS)
                                break;
                            }
                            if(!cfg.mycalls)
                            { cfg.mycalls=1;
                              strcpy(cfg.mycall[0],"MYCALL");
                            }
                          }
                          break;

        case boxheader:   if(prcmd)
                            putf(fs,inicmd[boxheader],cfg.boxheader);
                          else
                          {
                            if(strlen((t=nextarg(s)))>40)
                              cfgerr(1,t);
                            else
                              strcpy(cfg.boxheader,t);

                          }
                          break;
        case statsend:    if(prcmd)
                            putf(fs,inicmd[statsend],cfg.statsend);
                          else
                          {
                            if(strlen((t=nextarg(s)))>40)
                              cfgerr(1,t);
                            else
                            {
                              if(sscanf(t,"%7s @ %7s #%u",cmd,cmd,&i)==3)
                                strcpy(cfg.statsend,strupr(t));
                              else
                                cfgerr(0,t);
                            }
                          }
                          break;
        case statsubj:    if(prcmd)
                            putf(fs,inicmd[statsubj],cfg.statsubj);
                          else
                          {
                            if(strlen((t=nextarg(s)))>80)
                              cfgerr(1,t);
                            else
                              strcpy(cfg.statsubj,t);

                          }
                          break;
        case cwcall:      if(prcmd)
                            putf(fs,inicmd[cwcall],cfg.call);
                          else
                          {
                            if((strlen((t=nextarg(s)))>sizeof(cfg.call))||(strlen(t)<3))
                              cfgerr(1,t);
                            else
                              strcpy(cfg.call,strupr(t));
                          }
                          break;
      case unum_min:      if(prcmd)
                            putf(fu,inicmd[unum_min],cfg.unum_min);
                          else
                            cfg.unum_min=(unsigned)get_number(s,100,800);
                          break;
      case utcoffset:     if(prcmd)
                            putf(fd,inicmd[utcoffset],cfg.utcoffset);
                          else
                            cfg.utcoffset=(unsigned)get_number(s,-2,-1);
                          break;
      case loglevel:      if(prcmd)
                            putf(fu,inicmd[loglevel],cfg.loglevel);
                          else
                            cfg.loglevel=(unsigned)get_number(s,0,7);
                          break;
      case sysop_num:      if(prcmd)
                            putf(fu,inicmd[sysop_num],cfg.sysop_num);
                          else
                            cfg.sysop_num=(unsigned)get_number(s,1,999);
                          break;
      case cmd_wait:      if(prcmd)
                            putf(fu,inicmd[cmd_wait],cfg.cmd_wait);
                          else
                            cfg.cmd_wait=(unsigned)get_number(s,0,20000);
                          break;
      case irq:            if(prcmd)
                            putf(fu,inicmd[irq],cfg.irq);
                          else
                            cfg.irq=(unsigned)get_number(s,3,15);
                          break;
      case defuprefs:      if(prcmd)
                            putf(fs,inicmd[defuprefs],dec2bin(cfg.defuprefs));
                          else
                            cfg.defuprefs=(unsigned)get_number(s,0,0xffff);
                          break;

      /*
      case sysop_code:    if(prcmd)
                            putf(fs,inicmd[sysop_code],cfg.sysop_code);
                          else
                          {
                            if((strlen((t=nextarg(s)))>11)||(strlen(t)<3))
                              cfgerr(1,t);
                            else
                            { sscanf(t,"%s",cmd);
                              strcpy(cfg.sysop_code,strupr(cmd));
                            }
                          }
                          break;
      case sysop_tone:    if(prcmd)
                            putf(fd,inicmd[sysop_tone],cfg.sysop_tone>0?(ctcss_tone[cfg.sysop_tone]/1000):cfg.sysop_tone);
                          else
                            cfg.sysop_tone=(int)get_number(s,-1,250);
                          break;
      case _switch:     if(prcmd)
                            putf(fs,inicmd[_switch],cfg.remote_switch);
                          else
                          {
                            if((strlen((t=nextarg(s)))>15)||(strlen(t)<3))
                              cfgerr(1,t);
                            else
                            {
                              sscanf(t,"%s",cmd);
                              strcpy(cfg.remote_switch,cmd);
                            }
                          }
                          break;
      */
      case warntime:      if(prcmd)
                            putf(fu,inicmd[warntime],cfg.warn);
                          else
                            cfg.warn=(unsigned)get_number(s,20,999);
                          break;
      case scrsave:       if(prcmd)
                            putf(fu,inicmd[scrsave],cfg.scrsave);
                          else
                            cfg.scrsave=(unsigned)get_number(s,0,999);
                          break;
      case timeout:       if(prcmd)
                            putf(fu,inicmd[timeout],cfg.tout);
                          else
                            cfg.tout=(unsigned)get_number(s,10,999);
                          break;
      case dtmf_tout:     if(prcmd)
                            putf(fu,inicmd[dtmf_tout],cfg.dtmf_timeout);
                          else
                            cfg.dtmf_timeout=get_number(s,0,1800);
                          break;
      case inp_timeout:   if(prcmd)
                            putf(fu,inicmd[inp_timeout],cfg.inp_timeout/60);
                          else
                            cfg.inp_timeout=get_number(s,0,1000)*60;
                          break;

      case beep_tone:     if(prcmd)
                            putf(fld,inicmd[beep_tone],cfg.tone/1000);
                          else
                            cfg.tone=get_number(s,250,1000)*1000L;
                          break;
      case subout:       if(prcmd)
                            putf(fld,inicmd[subout],cfg.subout/1000);
                          else
                            cfg.subout=ctcss_tone[(int)get_number(s,-1,250)];

                          break;

      case sq_wait:        if(prcmd)
                            putf(fu,inicmd[sq_wait],cfg.sq_wait*55L);
                          else
                            cfg.sq_wait=get_number(s,100,3000)/55L;
                          break;
      case sq_sens:        if(prcmd)
                            putf(fu,inicmd[sq_sens],cfg.sq_sens);
                          else
                            cfg.sq_sens=get_number(s,0,100);
                          break;
      case sq_inv:        if(prcmd)
                            putf(fs,inicmd[sq_inv],cfg.sq_inv?"on":"off");
                          else
                            cfg.sq_inv=get_number(s,0,1);
                          break;
      case subwait:        if(prcmd)
                            putf(fu,inicmd[subwait],cfg.subwait);
                          else
                            cfg.subwait=get_number(s,0,3000);
                          break;
      case tx_hold:        if(prcmd)
                            putf(fu,inicmd[tx_hold],cfg.tx_hold);
                          else
                            cfg.tx_hold=get_number(s,0,300);
                          break;
      case tx_retrig:      if(prcmd)
                            putf(fu,inicmd[tx_retrig],cfg.tx_retrig);
                          else
                            cfg.tx_retrig=get_number(s,0,300);
                          break;
      case max_loc_length:if(prcmd)
                            putf(fld,inicmd[max_loc_length],cfg.max_msg_length>>10);
                          else
                            cfg.max_msg_length=get_number(s,100,5000)*1024L;
                          break;
      case max_fwd_length:if(prcmd)
                            putf(fld,inicmd[max_fwd_length],cfg.max_msg_fwd_length>>10);
                          else
                            cfg.max_msg_fwd_length=get_number(s,100,5000)*1024L;
                          break;
      case max_msg_days:  if(prcmd)
                            putf(fu,inicmd[max_msg_days],cfg.max_msg_days);
                          else
                            cfg.max_msg_days=get_number(s,0,999);
                          break;
      case hrd_msg_days:  if(prcmd)
                            putf(fu,inicmd[hrd_msg_days],cfg.hrd_msg_days);
                          else
                            cfg.hrd_msg_days=get_number(s,0,999);
                          break;
      case sig_min:        if(prcmd)
                            putf(fu,inicmd[sig_min],cfg.sig_min);
                          else
                            cfg.sig_min=get_number(s,0,14);
                          break;
      case sig_inv:       if(prcmd)
                            putf(fs,inicmd[sig_inv],cfg.sig_inv?"on":"off");
                          else
                            cfg.sig_inv=get_number(s,0,1);
                          break;
      case max_usr_days:  if(prcmd)
                            putf(fu,inicmd[max_usr_days],cfg.max_usr_days);
                          else
                            cfg.max_usr_days=get_number(s,30,9999);
                          break;
      case systemstate:   if(prcmd)
                            putf(fu,inicmd[systemstate],cfg.system_state);
                          else
                            cfg.system_state=get_number(s,0,7);
                          break;
      case repeater:      if(prcmd)
                            putf(fu,inicmd[repeater],cfg.repeater);//?"on":"off");
                          else
                            cfg.repeater=get_number(s,0,3);
                          break;
      case dcf_used:      if(prcmd)
                            putf(fs,inicmd[dcf_used],cfg.dcf_used?"on":"off");
                          else
                            cfg.dcf_used=get_number(s,0,1);
                          break;
      case afsw_805:      if(prcmd)
                            putf(fs,inicmd[afsw_805],cfg.afswitch?"on":"off");
                          else
                            cfg.afswitch=get_number(s,0,1);
                          break;
      case _lpt:          if(prcmd)
                            putf(fu,inicmd[_lpt],cfg.lpt);
                          else
                            cfg.lpt=get_number(s,0,3);
                          break;
      case ctcss_gain:    if(prcmd)
                            putf(fu,inicmd[ctcss_gain],cfg.ctcss_gain);
                          else
                            cfg.ctcss_gain=get_number(s,0,14);
                          break;
      case ctcss_open:     if(prcmd)
                            putf(fd,inicmd[ctcss_open],cfg.ctcss_open>0?(ctcss_tone[cfg.ctcss_open]/1000):cfg.ctcss_open);
                          else
                            cfg.ctcss_open=get_number(s,-1,250);
                          break;
      case nouser_list:    if(prcmd)
                            putf(fs,inicmd[nouser_list],cfg.nouser_list?"on":"off");
                          else
                            cfg.nouser_list=get_number(s,0,1);
                          break;
      case level_in:      if(prcmd)
                            putf(fu,inicmd[level_in],cfg.level_in);
                          else
                            cfg.level_in=get_number(s,0,15);
                          cfg.sbvol = 1;
                          break;
      case level_mic:     if(prcmd)
                            putf(fu,inicmd[level_mic],cfg.level_mic);
                          else
                            cfg.level_mic=get_number(s,0,15);
                          cfg.sbvol = 1;
                          break;
      case level_out:     if(prcmd)
                            putf(fu,inicmd[level_out],cfg.level_out);
                          else
                            cfg.level_out=get_number(s,0,15);
                          cfg.sbvol = 1;
                          break;
      case level_voc:     if(prcmd)
                            putf(fu,inicmd[level_voc],cfg.level_voc);
                          else
                            cfg.level_voc=get_number(s,0,15);
                          cfg.sbvol = 1;
                          break;
      case level_cw:      if(prcmd)
                            putf(fu,inicmd[level_cw],cfg.level_cw);
                          else
                            cfg.level_cw=get_number(s,0,15);
                          cfg.sbvol = 1;
                          break;
      }

      if((i!=error) && prcmd)
        putv('\r');

      if(err&&(lin==-1))
        read_dvmsini();

      return 1;
}

static int read_dvmsini(void)
{  char input[256],*s;
  FILE *f;
  lin=0;
  if ((f=tfopen(dvmsini,"r"))!=NULL)
  { currfile=1;
    while(!feof(f))
    {
      lin++;
      input[0]=0;
      fgets(input,sizeof(input),f);
      if((s=strchr(input,'\n'))!=NULL)
        s[0]=0;
      if((s=strchr(input,'\r'))!=NULL)
        s[0]=0;
      if((lin==1)&&(strstr(input,version)==NULL))
         ignore=1;

      if(((s=firstarg(input))[0]==';') || (s[0]=='#') || !s[0])
        continue;
      execinipar(s);
    }
    tfclose(f);
    currfile=0;
    lin=-1;

    /*UPDATE CHECK
    if(ignore&&(cfg.loglevel==3))
    {
      cfg.loglevel--;
    }
    */
  }
  else
  {
    if(!write_par())
      putf(fm1,dvmsini);
    else
      putf(fm2,dvmsini);

    return 0;
  }
  if(err)
    return 0;
  return 1;
}

static int read_adcini(void)
{  FILE *f;
  unsigned i;
  char input[256],*s,cmd[20];

  for(i=0;i<8;i++)
    adc_cfg[i].type=0;

  if ((f=tfopen(adcini,"rb"))==NULL)
  { if((f=tfopen(adcini,"wb"))==NULL)
    {  putf(fm1,adcini);
      return 0;
    }
    fputs(";Example ADC configuration\r\n"
          ";adc_combase 0x2f8 ;I/O-address of used COM-port\r\n"
          ";COM1:0x3f8 COM2:0x2f8  COM3:0x3e8 COM4:0x2e8\r\n"
          ";adc_maxsamples 336\r\n\r\n"
          ";          type  prec Vref  R1dvider   const     linear    pretext   posttext\r\n"
          ";adc_port 8  2    1    5.0   1645.0    1645.27      14.6    temp1.vms temp2.vms\r\n"
          ";adc_port [1...8] port assignment for definitions\r\n"
          ";type 0: unsused port  1: voltage sampling  2: resistor sampling\r\n"
          ";prec [0...3] number of postcomma numbers\r\n"
          ";pretext textfile to be spoken before measurement\r\n"
          ";posttext textfile to be spoken before measurement\r\n",f);
    tfclose(f);
    putf(fm2,adcini);
    return 1;
  }
  currfile=2;
  lin=0;
  while(!feof(f))
  {
    lin++;
    input[0]=0;
    fgets(input,sizeof(input),f);

    if((s=strchr(input,'\n'))!=NULL)
      s[0]=0;
    if((s=strchr(input,'\r'))!=NULL)
      s[0]=0;

    if(((s=firstarg(input))[0]==';') || (s[0]=='#') || !s[0])
      continue;
    cmd[0]=0;
    sscanf(s,"%19s",cmd);
    if(!cmd[0])
      continue;

    if(!stricmp(cmd,"adc_combase"))
      cfg.adc_combase=(unsigned)get_number(s,0x2e8,0x3f8);
    else
    if(!stricmp(cmd,"adc_maxsamples"))
      cfg.adcmaxsamples=get_number(s,0,100000L);
    else
    if(!stricmp(cmd,"adc_port"))
    {
      i=(unsigned)get_number(s,1,8)-1;
      s=nextarg(s);
      adc_cfg[i].type=(unsigned)get_number(s,0,2);
      s=nextarg(s);
      adc_cfg[i].prec=(unsigned)get_number(s,0,3);
      s=nextarg(s);
      adc_cfg[i].vref=get_float(s,0,1000000);
      s=nextarg(s);
      adc_cfg[i].r1teiler=get_float(s,0,100000000);///1000;
      s=nextarg(s);
      adc_cfg[i].constant=get_float(s,-100000000,100000000);///1000;
      s=nextarg(s);
      adc_cfg[i].linear=get_float(s,-1000000,1000000);
      s=nextarg(nextarg(s));
      if(!sscanf(s,"%13s",adc_cfg[i].pretext))
        cfgerr(2,input);
      s=nextarg(s);
      if(!sscanf(s,"%13s",adc_cfg[i].postext))
        cfgerr(2,input);
/*
      cprintf("\r\n%u %u %ld %ld %ld %ld %s %s",adc_cfg[i].type,adc_cfg[i].prec,
      adc_cfg[i].vref,adc_cfg[i].r1teiler,adc_cfg[i].constant,
      adc_cfg[i].linear,adc_cfg[i].pretext,adc_cfg[i].postext);
      cprintf("\r\nFilename: [%s]",adc_cfg[0].postext);
      getch();
*/
    }
  }
  tfclose(f);
  currfile=0;
  lin=-1;

  return 1;
}

static int read_pwdini(void)
{ FILE *f;
  char input[256],*s,*t,cmd[20];

  if ((f=tfopen(pwdini,"rb"))==NULL)
  { if((f=tfopen(pwdini,"wb"))==NULL)
    { putf(fm1,pwdini);
      return 0;
    }
    fputs("01234567890123456789012345678901234567890123456789012345678901234567890123456789\r\n"
          "switch     01234\r\n"
          "sysop_code 01234\r\n"
          "sysop_tone 0\r\n",f);
    tfclose(f);
    putf(fm2,pwdini);
    return 1;
  }
  currfile=2;
  lin=0;
  while(!feof(f))
  {
    lin++;
    input[0]=0;
    fgets(input,sizeof(input),f);

    if((s=strchr(input,'\n'))!=NULL)
      s[0]=0;
    if((s=strchr(input,'\r'))!=NULL)
      s[0]=0;

    //cprintf("\r\n%s",input);
    if(((s=firstarg(input))[0]==';') || (s[0]=='#') || !s[0])
      continue;
    cmd[0]=0;

    sscanf(s,"%19s",cmd);
    t=nextarg(s);

    if(!cmd[0])
      continue;

    if(!stricmp(cmd,"switch"))
    {
      sscanf(t,"%s",cmd);
      strcpy(cfg.remote_switch,strupr(cmd));
    }
    else
    if(!stricmp(cmd,"sysop_code"))
    {  sscanf(t,"%255s",cmd);
      strcpy(cfg.sysop_code,strupr(cmd));
    }
    else
    if(!stricmp(cmd,"sysop_tone"))
      cfg.sysop_tone=(int)get_number(s,-1,250);

  }
  tfclose(f);
  return 1;
}

void readconfig(void)
{
  //_setcursortype(_NOCURSOR);

  if(get_tasksrun())
  {
    set_win(filewin);
    clrscr();
  }
  else
    set_defaults();

  err=0;
  xchdir(startpath);


  putf(" reading dvms_adc.ini ");
  read_adcini();
  putf("passwd.ini ");
  read_pwdini();
  putf("dvms.ini ");

  if(!read_dvmsini())
  if(!ignore)
    exit(30);
  else
    write_par();

  putf("fwd.ini\r");
  rdfwdpartners();


}
