/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  Basic diskacces-functions for database management
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
       Guardinistr. 47
       D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmsmem.h"
#include "dvmsmsgb.h"
#include "dvmspurg.h"
#include "movefile.h"
#include "util.h"

void init_msg_info(msg_info_t &MInfo)
{ MInfo.Filename[0]=0;
  MInfo.extend[0]=0;
  MInfo.Id=0;
  MInfo.Unixtime=0;
  MInfo.Usender=0;
  MInfo.Custom1=0;
  MInfo.Custom2=0;
  MInfo.Ureceiver=0;
  MInfo.Length=0;
  MInfo.Srate=0;
  MInfo.Days=0;
  MInfo.State=0;
  strcpy(MInfo.Info,ad_id(cfg.boxaddress));
}

void mkfilename(char *s)
{
  char file[20];
  static time_t lastcall=0;

  while(ad_time(NULL)==lastcall)
   suspend(5);

  lastcall=ad_time(NULL);
  ltoa(ad_time(NULL),file,36);
  strupr(file);
  sprintf(s,"%-3.3s%s.VMS",cfg.boxaddress,file+strlen(file)-5);
}

/* MSG_Info File BASIC-Procedures */
int write_minfo(msg_info_t &MInfo)
{ FILE *f;
  char Path[80],*r="write_minfo";

  crc(MInfo);
  size_t rec_size = sizeof( msg_info_t);
  sprintf(Path,"%s"_LISTNAME".VMS",cfg.msgp);

  if ((f=tfopen(Path,"ab+"))!=NULL)
  {  if(fseek(f,0L,SEEK_END)!=0)
    {  write_log(_serious,r,"fseek error %s",Path);
      tfclose(f);
      return(0);
    }
    if(fwrite( &MInfo, rec_size, 1, f )!=1)
    {  write_log(_serious,r,"fwrite error %s",Path);
      tfclose(f);
      return(0);
    }
    tfclose(f);
    return(1);
  }
  else
    write_log(_serious,r,"fopen error %s",Path);
  return(0);
}

int write_minfo_num(long Num,msg_info_t &MInfo)
{  FILE *f;
  char Path[80],*r="write_minfo_num";
  crc(MInfo);
  size_t rec_size = sizeof( MInfo );
  sprintf(Path,"%s"_LISTNAME".VMS",cfg.msgp);

  if ((f=tfopen(Path,"rb+wb+"))!=NULL)
  {  if(fseek(f,Num*rec_size,SEEK_SET))
    {  write_log(_serious,r,"%s fseek error %ld",Path,Num*rec_size);
      tfclose(f);
      return(0);
    }

    if(fwrite( &MInfo, rec_size, 1, f )!=1)
    {  write_log(_serious,r,"fwrite error %s",Path);
      tfclose(f);
      return(0);
    }
    tfclose(f);
    return(1);
  }
  else
    write_log(_serious,r,"fopen error %s",Path);
  return(0);
}

int change_minfo (long M_num,msg_info_t &MInfo)
{ FILE *f;
  char Path[80],Path1[80],*r="change_minfo";
  msg_info_t MInfo_Read;
  long MSG_Count,MSG_Num;
  int Found;
  size_t rec_size = sizeof( MInfo );
  MSG_Num=mails();

  sprintf(Path,"%s"_LISTNAME".$$$",cfg.msgp);

  if ((f=tfopen(Path,"wb"))!=NULL)
  {  for(MSG_Count=0;MSG_Count<MSG_Num;MSG_Count++)
    {  scheduler();
      if(!read_minfo (MSG_Count,MInfo_Read))
      { write_log(_serious,r,"kotz");
        return 0;
      }
      Found=TRUE;

      if(M_num==MSG_Count)
      {  Found=FALSE;
        if( strlen(MInfo.Filename))
        {  Found=TRUE;
          strcpy(MInfo_Read.Filename,MInfo.Filename);
        }
        if( MInfo.Id )
        {  Found=TRUE;
          MInfo_Read.Id=MInfo.Id;
        }
        if( MInfo.Unixtime )
        {  Found=TRUE;
          MInfo_Read.Unixtime=MInfo.Unixtime;
        }
        if( MInfo.Usender)
        {  Found=TRUE;
          MInfo_Read.Usender=MInfo.Usender;
        }
        if( MInfo.Ureceiver)
        {  Found=TRUE;
          MInfo_Read.Ureceiver=MInfo.Ureceiver;
        }

        if( MInfo.Length )
        {  Found=TRUE;
          MInfo_Read.Length=MInfo.Length;
        }

        if( MInfo.Srate )
        {  Found=TRUE;
          MInfo_Read.Srate=MInfo.Srate;
        }
        if( MInfo.Days )
        {  Found=TRUE;
          MInfo_Read.Days=MInfo.Days;
        }
        if( MInfo.State )
        {  Found=TRUE;
       MInfo_Read.State=MInfo.State;
        }
      }
      if(Found)
      {  crc(MInfo_Read);
        if(!fwrite( &MInfo_Read, rec_size, 1, f ))
        {  write_log(_serious,r,"fwrite error");
          return(0);
        }
      }
    }
    tfclose(f);

    sprintf(Path,"%s"_LISTNAME".VMS",cfg.msgp);
    sprintf(Path1,"%s"_LISTNAME".BAK",cfg.msgp);

    if(remove(Path1)==-1)
      write_log(_serious,r,"remove error %s",Path1);

    if(rename(Path,Path1)==-1)
    {  write_log(_serious,r,"rename error %s",Path1);
      return 0;
    }

    sprintf(Path1,"%s"_LISTNAME".$$$",cfg.msgp);

    if(rename(Path1,Path)==-1)
    {  write_log(_serious,r,"rename error %s",Path);
      return 0;
    }
    return 1;
  }
  else
    write_log(_serious,r,"fopen error %s",Path);
  return 0;
}

int read_minfo(long M_num,msg_info_t &Read_MInfo)
{ FILE *f;
  char Path[80],*r="read_minfo";
  int SEEK,i;
  size_t rec_size = sizeof( msg_info_t );

  sprintf(Path,"%s"_LISTNAME".VMS",cfg.msgp);

  if (M_num<0)
    SEEK=SEEK_END;
  else
    SEEK=SEEK_SET;

  if ((f=tfopen(Path,"rb"))!=NULL)
  {  if(fseek(f,M_num*rec_size,SEEK)!=0)
    {  write_log(_serious,r,"fseek error %s",Path);
      init_msg_info(Read_MInfo);
      tfclose(f);
      return(FALSE);
    }

    if(fread(&Read_MInfo, rec_size, 1, f )!=1)
    {  write_log(_serious,r,"fread error %s",Path);
      init_msg_info(Read_MInfo);
      tfclose(f);
    return(FALSE);
    }

    tfclose(f);
    if(!crc(Read_MInfo))
    {   write_log(_serious,r,"minfo corrupt %s",Path);
       move_file(Path,cfg.tmppath,1);
       reorg_msg();
       init_msg_info(Read_MInfo);
       return(FALSE);
    }

    i=0;
    while(Read_MInfo.Info[i++])
    if(i>=sizeof(Read_MInfo.Info))
    { write_log(_serious,r,"minfo.info corrupt %s",Path);
      move_file(Path,cfg.tmppath,1);
      reorg_msg();
      init_msg_info(Read_MInfo);
      return(FALSE);
    }

  }
  else
  {  init_msg_info(Read_MInfo);
    write_log(_serious,r,"fopen error %s",Path);
    return(FALSE);
  }
  return(TRUE);
}


void update_msg_info (msg_info_t &MInfo)
{  ad_time(&MInfo.Unixtime);
  MInfo.Srate =srate/100;
}

void add_msg_info(msg_info_t &MInfo)
{ mkfilename(MInfo.Filename);
  write_minfo (MInfo);
}


int number_of_msg_for(msg_info_t MInfo)
{ msg_info_t MInfo_read;
  int Count_MSG=0;
  long Msg_Count,Msg_Num;
  FILE *f;
  char Path[80];

  size_t rec_size = sizeof( msg_info_t );

  Msg_Num=mails();

  if(Msg_Num==0)
    return(0);

  sprintf(Path,"%s"_LISTNAME".VMS",cfg.msgp);

  if((f=tfopen(Path,"rb"))!=NULL)
  {  for(Msg_Count=0;Msg_Count<Msg_Num;Msg_Count++)
    { if(fread(&MInfo_read, rec_size, 1, f )!=1)
      {  write_log(_serious,"number_of_msg_for","fread error %s",Path);
        tfclose(f);
        return(-1);
      }

      if(!(MInfo.State&_MSGST_DELETED))
      {  if((MInfo_read.State&MInfo.State)&&(MInfo_read.Ureceiver==MInfo.Ureceiver)&&!(MInfo_read.State&_MSGST_DELETED))
        Count_MSG++;
      }
      else
        if((MInfo_read.State&MInfo.State)&&(MInfo_read.Ureceiver==MInfo.Ureceiver)&&(MInfo_read.State&_MSGST_DELETED))
          Count_MSG++;

      scheduler();
    }
  }
  tfclose(f);
  return(Count_MSG);
}

long msg_num_select(long M_num,msg_info_t &MInfo)
{  msg_info_t MInfo_read;
  int Count_MSG=0;
  long Msg_Count,Msg_Num;
  FILE *f;
  char Path[80];
  size_t rec_size = sizeof( msg_info_t );

  Msg_Num=mails();

  sprintf(Path,"%s"_LISTNAME".VMS",cfg.msgp);

  if ((f=tfopen(Path,"rb"))!=NULL)
  {  for(Msg_Count=0;Msg_Count<Msg_Num;Msg_Count++)
    { if(fread(&MInfo_read, rec_size, 1, f )!=1)
     {  write_log(_serious,"msg_num_select","fread error %d num #%ld",Path,Msg_Count);
        tfclose(f);
        return(-1);
     }

     if(((MInfo_read.State&MInfo.State)||(!MInfo.State))             &&
        ((MInfo_read.Ureceiver==MInfo.Ureceiver)||(!MInfo.Ureceiver))&&
        !(MInfo_read.State&_MSGST_DELETED))

         Count_MSG++;

     if(Count_MSG == M_num)
      break;
   }
  }
  tfclose(f);
  if(Count_MSG==M_num)
    return(Msg_Count);
  else
   return -1L;
}

void list_minfo(msg_info_t &MInfo)
{ set_win(filewin);
  clrscr();
  gotoxy(1,3);
  cprintf("File: %s        ",MInfo.Filename);

  gotoxy(1,4);
  cprintf("Time: %s %s",datestr(MInfo.Unixtime,1),timestr(MInfo.Unixtime));

  gotoxy(1,5);
  cprintf("MsId: %04X  ",MInfo.Id);

  gotoxy(1,6);
  cprintf("Stat: %04X  ",MInfo.State);

  gotoxy(1,7);
  cprintf("Usen: %-4d",MInfo.Usender);

  gotoxy(1,8);
  cprintf("Urec: %-4d",MInfo.Ureceiver);

  gotoxy(1,9);
  cprintf("Cst1: %-4d",MInfo.Custom1);

  gotoxy(1,10);
  cprintf("Cst2: %-4d",MInfo.Custom2);

  gotoxy(1,11);
  cprintf("Srat: %ld",MInfo.Srate/10L);

  gotoxy(1,12);
  cprintf("Leng: %ld       ",MInfo.Length);

  gotoxy(1,13);
  cprintf("Days: %d  ",MInfo.Days);

  gotoxy(1,14);
  cprintf("Info: %s                ",MInfo.Info);
}

void change_userfile(char *id,int usr)
{  FILE *in,*out;
  int u1=0,u2=0,count=0,end=0;
  char id1[17],id2[17],file[80],help[80],*r="change_userfile";

  sprintf(help,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);

  if((in=tfopen(help,"rt"))==NULL)
  {  write_log(_serious,r,"fopen error %s",help);
    return;
  }
  sprintf(file,"%s$$$_USER.VMS",cfg.usrp);
  if((out=tfopen(file,"wt"))==NULL)
  {  write_log(_serious,r,"fopen error %s",file);
    tfclose(in);
    return;
  }
  fscanf(in,"%16s %d",id1,&u1);
  while(!feof(in))
  {// cprintf("\r\n %s %d",id1,u1);
   // cprintf("\r\n %s %d %d %d %d",id2,u2,usr,end,count);
    if(fscanf(in,"%16s %d",id2,&u2)==EOF)
      end=1;

    if(!count && (usr<u1)&&id[0])
      fprintf(out,"%-16.16s %03d\n",id,usr);

    if(!end&&(u1<usr) && (usr<u2)&&id[0])
      fprintf(out,"%-16.16s %03d\n",id,usr);

    if(usr==u1)
    {  if(id[0])
        fprintf(out,"%-16.16s %03d\n",id,usr);
    }
    else
      fprintf(out,"%-16.16s %03d\n",id1,u1);

    strcpy(id1,id2);
    u1=u2;
    scheduler();
    count++;
  }
  if((usr>u1)&&id[0])
    fprintf(out,"%-16.16s %03d\n",id,usr);

  tfclose(out);
  tfclose(in);
  remove(help);
  rename(file,help);
}
int get_callsign(char *file,char *Id,unsigned usr)
{  FILE *f;
  int found=FALSE,Rd_usr=0;
  char help[80];

  sprintf(help,"%s%-3.3s_USER.VMS",cfg.usrp,Id);
  if(!access(help,0))
  if ((f=fopen(help,"r"))!=NULL)
  {  while(fscanf(f,"%16s %d",file,&Rd_usr)!=EOF)
    {  if(Rd_usr==usr)
      {  found=TRUE;
        break;
      }
    }
    fclose(f);
  }
  else
    write_log(_serious,"get_callsign","fopen error %s",help);

  return found;
}
