/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  Functions for RAM allocation and HDD-statistic
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmspurg.h"
#include "dvmsxms.h"
#include "prozca.h"

char *puffer=NULL;

void unalloc_mem(void)
{  if(puffer!=NULL)
    tfree(MK_FP(FP_SEG(puffer)-1,4));
}

void alloc_mem(void)
{
  long l;

  printf(" %s CPU detected.\n",prozname[getproz()]);
  initsched();
  if(puffer!=NULL)
    tfree(MK_FP(FP_SEG(puffer)-1,4));

  puffer = (char *)tmalloc( _MEM+16L );
  char *s=" KBytes of conventional memory ";
  l=_MEM+16L;
  if(!puffer)
  {
    printf("- %lu%sare not available.\a\n",s,l>>10L);
    write_log(_fatal,"alloc_mem","%ld%sallocation error",s,l>>10);
    exit(10);
  }
  else
  {
    printf(" Codesize %ld KByte.\n",(long)(1+FP_SEG(puffer)-_psp)>>6L);
    printf(" %ld%sat 0x%lX.\n",l>>10L,s,((long)FP_SEG(puffer)<<4L)+(long)FP_OFF(puffer));
  }
  puffer=(char *) MK_FP(FP_SEG(puffer)+1,0);
  atexit(unalloc_mem);
  //EMB_Init();
}

long free_disk_space(char *path,int total)
{  struct diskfree_t free;
  char help[80];

  _fullpath(help,path, sizeof(help));

  if(_dos_getdiskfree( (int)toupper(help[0])-64, &free))
  {  write_log(_fatal,"free_disk_space","error");
    exit(11);
  }

  if(!total)
  return( (long) free.avail_clusters
      * (long) free.bytes_per_sector
      * (long) free.sectors_per_cluster);
  else
  return( (long) free.total_clusters
      * (long) free.bytes_per_sector
      * (long) free.sectors_per_cluster);

}

long length(char *File_Find)
{ long len=0L;
  struct find_t find;
  if(!_dos_findfirst(File_Find, 0xffff, &find ))
    do
      len=len+find.size;
    while(!_dos_findnext( &find ));
  return(len);
}

unsigned long users(void)
{ FILE *handle;
  char path[80],file[80];
  long  bcount=0,ucount=0;

  sprintf(path,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);

  if((handle=tfopen(path,"rb"))==NULL)
  {  write_log(_serious,"users: fopen error %s",path);
    return(0);
  }

  while(fscanf(handle,"%79s %79s",file,path)!=EOF)
  {  if(strncmp(file+9,"BBS",3))
      ucount++;
    else
      bcount++;
  }
  tfclose(handle);

  return(ucount|(bcount<<16));
}


unsigned int mails(void)
{  char path[40];
  long length;
  int handle;
  unsigned mailcount;

  sprintf(path,"%s"_LISTNAME".VMS",cfg.msgp);
  if((handle=topen( path, O_BINARY | O_RDONLY ))<1 )
  {  write_log(_serious,"mails","open error %s",path);
    return(0);
  }

  length=filelength(handle);
  tclose(handle);

  mailcount=(unsigned)(length/sizeof(msg_info_t));

  return(mailcount);
}

int checkdiskspace(void)
{  if(free_disk_space(cfg.msgp,0)<(cfg.max_msg_length*3L))
  {  purge_msg();
    if(free_disk_space(cfg.msgp,0)<(cfg.max_msg_length*3L))
    {  clean_up();
      rdplay(sysp,"CLEAN_U0.VMS");
    }

    if(free_disk_space(cfg.msgp,0)<(cfg.max_msg_length*3L))
    {  rdplay(sysp,"WRTMSG0.VMS");
      write_log(_serious,"checkdiskspace","rlps");
      return 0;
    }
    return(2);
  }
  return(1);
}
