/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  basic mailbox functions (DTMF command interpreter)
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsamp.h"
#include "dvmscmd.h"
#include "dvmsdelm.h"
#include "dvmsdtmf.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmshelp.h"
#include "dvmsrecm.h"
#include "dvmssend.h"
#include "dvmssyso.h"
#include "dvmssuba.h"
#include "dvmstime.h"


int  wait_carrier(int s);
int  wrt_file_info(char *path,char *input,int update,struct MSG_INFO &File_Info);

char rogersema=0;

void mailbox(void)
{  static char help[80],file[80];

  usr_upd=FALSE;
  swstate(-1);
  while (!(get_global_msg()&_SHUTDOWN))
  {  if(wait_carrier(0)==-10)
      return;

    rcvdtmf(dtmf,FALSE);

    if(!strncmp(dtmf,cfg.sysop_code,strlen(cfg.sysop_code)))
    {  if((ctcss==cfg.sysop_tone)||(ctcss==39)||(cfg.sysop_tone==-1))
        service(dtmf+strlen(cfg.sysop_code));
    }
    else
    if(((dtmf[0]=='1')||(dtmf[0]=='*'))&&(strlen(dtmf)<7)&&!ulogin)
      login(atoi(dtmf+1),dtmf);
    else
    if(!strncmp(dtmf,"04",2) && dtmf[2]=='0')
        spk_list_of_msg(atoi(dtmf+3+((dtmf[3]=='*')?1:0)),2,0);
    else
    if(!strncmp(dtmf,"08",2) && dtmf[2]=='0')
        spk_list_of_msg(atoi(dtmf+3+((dtmf[3]=='*')?1:0)),3,0);
    else
    if(!strncmp(dtmf,"000*",4)&&!ulogin)
      login(atoi(dtmf+4),dtmf);
    else
    if(!ulogin && (dtmf[3]=='*') && (strlen(dtmf)==7))
      paging(dtmf);
    else
    if(dtmf[0]=='D')
      spkstr(dtmf+1,1);
    else
    if((dtmf[0]=='C') || (dtmf[0]=='#' ))
    {   location=record(0L,_MEM);
       if(location)
         playback(0L,location);
       if(cfg.config&_CFGSIGNAL)
       { if(s_meter<10000L)
         { readsnd(sysp,"S_METER2.VMS",0L);
           sprintf(file,"%d.VMS",s_meter/1000L);
           readsnd(sysp,file,location);
           playback(0L,location);
         }
         else
           rdplay(sysp,"S_METER3.VMS");
       }
    }
    else
    if(!strcmp(dtmf,"011"))
      mbox_cmds(cfg.sysp[0],"NEWS_*.VMS",0);
    else
    if(!strcmp(dtmf,"012"))
      mbox_cmds(cfg.sysp[0],"STN_*.VMS",0);
    else
    if(!strcmp(dtmf,"013"))
      speak_fds();
    else
    if(!strcmp(dtmf,"014"))
      speak_runtime();
    else
    if(!strcmp(dtmf,"015"))
    { sprintf(help,"%.9s",ad_id(cfg.boxaddress));
      spkstr(help,1);
    }
    else
    if(!strncmp(dtmf,"01",2))
    {  if(strlen(dtmf)>2)
        topic_help(dtmf+2);
      else
        if(ulogin)
          mbox_cmds(cfg.sysp[0],"CMDS_*.VMS",0);
        else
          rdplay(sysp,"CMDSULOG.VMS");
    }
    else
    if(!strcmp(dtmf,"0"))
    {  if(ulogin)
        rdplay(sysp,"CMDSLOGD.VMS");
      else
        rdplay(sysp,"CMDSULOG.VMS");
    }
    else
    if(!strncmp(dtmf,"06",2) && ulogin)
    {  if(!check_ctcss())
        {rdplay(sysp,"MSG_DEL5.VMS");}
      else
        user_prefs_select(ulogin,dtmf+2);
    }
    else
    if(!strcmp(dtmf,"031"))
      speak_date();
    else
    if(!strcmp(dtmf,"03"))
      speak_time();
    else
    if(!strcmp(dtmf,"033"))
    {  speak_date();
      speak_time();
    }
    else
    if(!strncmp(dtmf,"030",3))
      speak_adc(dtmf[3]-'1',dtmf[4]);
    else
    if(!strcmp(dtmf,"02"))
      spk_10_user();
    else
    if(!strcmp(dtmf,"020"))
      spk_boards();
    else
    if(!strcmp(dtmf,"021")&&ulogin&&check_ctcss())
    {  File_Info=User_Info;
      sprintf(file,"%04d_USR.VMS",User_Info.Ureceiver);
      srate=User_Info.Srate*100;
      wrt_file_info(cfg.usrp,file,TRUE,File_Info);
      reccall(ulogin,FALSE);
      sprintf(help,"%04d_USR.VMS",User_Info.Ureceiver);
      rd_file_info(cfg.usrp,help,File_Info);
      User_Info=File_Info;
    }
    else
    if(!strcmp(dtmf,"0021")&&ulogin&&check_ctcss())
      recname(ulogin);
    else
    if(!strcmp(dtmf,"0210")&&ulogin&&check_ctcss())
    {  if(!(User_Info.State&_USRST_PROTAMP))
      {  File_Info=User_Info;
        sprintf(file,"%04d_USR.VMS",User_Info.Ureceiver);
        srate=User_Info.Srate*100;
        wrt_file_info(cfg.usrp,file,TRUE,File_Info);
        amp_call(ulogin);
      }
      else
        rdplay(sysp,"NLOGIN5.VMS");
    }
    else
    if(!strcmp(dtmf,"0220")&&ulogin)
    { if(strlen(User_Info.Info+9))
        spkstr(User_Info.Info+9,1);
      else
        rdplay(sysp,"noampreg.vms");
    }
    else
    if(!strcmp(dtmf,"022")&&ulogin)
      spk_user(cfg.boxaddress,ulogin,_USER_ONLY|_NO_CTCSS);
    else
    if(!strcmp(dtmf,"0022")&&ulogin)
      spk_name(cfg.boxaddress,ulogin);
    else
    if(!strcmp(dtmf,"023")&&ulogin&&check_ctcss())
    {  User_Info.State|=_USRST_PROTECT;
      File_Info=User_Info;
      sprintf(file,"%04d_USR.VMS",User_Info.Ureceiver);
      srate=User_Info.Srate*100;
      wrt_file_info(cfg.usrp,file,TRUE,File_Info);

      rdplay(sysp,"NLOGIN5.VMS");
    }
    else
    if(!strcmp(dtmf,"0023")&&ulogin&&check_ctcss())
    {  sprintf(file,"%04d_NAM.VMS",ulogin);
      rd_file_info(cfg.usrp,file,File_Info);
      File_Info.State|=_USRST_PROTECT;
      wrt_file_info(cfg.usrp,file,TRUE,File_Info);

      rdplay(sysp,"NLOGIN5.VMS");
    }
    else
    if(!strcmp(dtmf,"0230")&&ulogin&&check_ctcss())
    {  if(!strlen(User_Info.Info+9))
        rdplay(sysp,"noampreg.vms");
      else
      {  User_Info.State|=_USRST_PROTAMP;
        File_Info=User_Info;
        sprintf(file,"%04d_USR.VMS",User_Info.Ureceiver);
        srate=User_Info.Srate*100;
        wrt_file_info(cfg.usrp,file,TRUE,File_Info);

        usr_upd=TRUE;
        rdplay(sysp,"NLOGIN5.VMS");
      }
    }
    else
    if(!strcmp(dtmf,"09")&&ulogin)
      logout(FALSE);
    else
    if(!strncmp(dtmf,"000*",4)&&ulogin)
      logout(FALSE);
    else
    if(!strcmp(dtmf,"999") &&!ulogin)
      nlogin();
    else
    if(!strcmp(dtmf,"040")&&ulogin)
      spk_short_list_of_msg(ulogin);
    else
    if(!strcmp(dtmf,"04") && ulogin)
      spk_list_of_msg(ulogin,0,0);
    else
    if(!strcmp(dtmf,"08") && ulogin)
      spk_list_of_msg(ulogin,1,0);
    else
    if((dtmf[2]!='0')&&!strncmp(dtmf,"08",2)&&ulogin &&strcmp(dtmf,"08"))
      spk_list_of_msg(ulogin,129,atoi(dtmf+2));
    else
    if((dtmf[2]!='0')&&!strncmp(dtmf,"04",2)&&ulogin &&strcmp(dtmf,"04"))
      spk_list_of_msg(ulogin,128,atoi(dtmf+2));
    else
    if(!strncmp(dtmf,"050",3)&&ulogin)
      unerase_msg(ulogin,atoi(dtmf+2));
    else
    if(!strncmp(dtmf,"05",2)&&ulogin)
    {  if(atoi(dtmf+2))
        del_msg_num(ulogin,atoi(dtmf+2));
      else
        del_read(ulogin,1);
    }
    else
    if(!strcmp(dtmf,"070"))
      spk_links();
    else
    if(!strncmp(dtmf,"07",2)&&ulogin)
      send_msg (dtmf+2);

    if(ptt_state && !call_state && !(get_global_msg()&_SHUTDOWN))
    { rogersema=1;
      if(!ulogin)
      { if((cfg.config&3)==3)
        {  c_tx_rate(350000L,400000L);
          suspend(1);
          c_tx_rate(0L,0L);
        }
      }
      if(cfg.config&1)
      {  c_tx_rate((s_meter*35L)+370000L,400000L);
        suspend(3);
        c_tx_rate(0L,0L);
      }
      if((cfg.config&3)==2)
      {  c_tx_rate(cfg.tone,400000L);
        suspend(3);
        c_tx_rate(0L,0L);
      }
      rogersema=0;
    }
  }
  rdplay(cfg.sysp[0],"SYST_OFL.VMS");
}

