/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  DVMS main program & command line interpreter
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
       Guardinistr. 47
       D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmschk.h"
#include "dvmscron.h"
#include "dvmskeyb.h"
#include "dvmsirq.h"
#include "dvmsmbox.h"
#include "dvmsmem.h"
#include "dvmspara.h"
#include "dvmssb.h"
#include "dvmsscrn.h"
#include "dvmssuba.h"
#include "dvmswin.h"

#include "exit.h"
#include "talkdaem.h"
#include "critical.h"
#include "tncrdwrt.h"
#include "util.h"

char startpath[80],exep[80],skiphwcheck=0,usesb16=0,ignore=0,*safety=NULL;
time_t startup;

#pragma argsused
void main(int argc,char *argv[])
{ char *s;
  time_t tt=time(NULL);
  struct tm *tm;
  int i,diagonly=0;

  tm=localtime(&tt);

  #ifdef __MSDOS__
  dosscreen[0]=0;
  directvideo=1;
  harderr(crit_handler);
  ctrlbrk(c_break);

  strcpy(exep,argv[0]);
  i=strlen(exep);
  while(exep[--i]!='\\');
    exep[i+1]=0;

  startup=tt;
  delstart=tt;

  if((s=getenv("DVMS"))!=NULL)
  { char tmp[80];
    strcpy(tmp,s);
    subst(tmp,'/','\\');
    _fullpath(startpath,tmp,79);

    if(tmp[strlen(startpath)-1]!='\\')
      strcat(startpath,"\\");
  }
  else
  { strcpy(startpath,argv[0]);
    subst(startpath,'/','\\');
    i=strlen(startpath);
    while(startpath[--i]!='\\');
    startpath[i+1]=0;
  }

  strlwr(startpath);
  strlwr(exep);
  xchdir(startpath);

  strcpy(sysp,startpath);
  strcpy(cfg.usrp,startpath);
  strcpy(cfg.msgp,startpath);
  printf(initmsg);
  puts("");
  storescr(dosscreen);

  #ifdef CRC
  if(!check_file(argv[0]))
  {
    win(errorwin,16,10,48,4,"Attention",15+4*16);
    cputs("   The DVMS security envelope is corrupt.\r\n"
          "   Please check your drive on viruses or\r\n"
          "   use the unmodified original file.\r\n"
          "   (Wait 10 seconds for countdown.)");
    window(1,1,80,25);
    attr(7);

    for(i=0;i<20000;i++)
    { sound(1200-i%500);
      delay(1);
    }
    nosound();
    retrscr(dosscreen);
    remove(dosscreen);
    exit(90);
  }
  #endif

/*
  if((tm->tm_mon!=11)&&(tm->tm_year!=97))
  { win(errorwin,10,10,48,3,"Information",15+1*16);
    cputs("   This version of DVMS is out of date please\r\n"
	  "  request the update version from distributor!\r\n"
	  "   (Wait 5 seconds for countdown.)");
    window(1,1,80,25);
    attr(7);
    delay(5000);
    retrscr(dosscreen,1);
    remove(dosscreen);
  }
*/
  #endif

  atexit(atex);

  alloc_mem();

  if((safety=(char *)tmalloc(32768))==NULL)
  { printf("- sorry, out of memory.\a\n");
    exit(0);
  }
  tfree(safety);

  while(argc>1)
  {  switch(argv[--argc][1]&0x5f)
    {
       case 'C':vmode=-1;break;
       case 'S':skiphwcheck=1;break;
       case 'D':diagonly=1;break;
       case 'I':ignore=1;break;
       case 'B':usesb16=1;break;
       default:
	    printf("\n%s [/b] [/c] [/d] [/i] [/s]\n"
		   "% 18s/b use sound blaster 16 card (new).\n"
		   "% 18s/c startup in 25 line mode (ega/vga).\n"
		   "% 18s/d diagnosis.\n"
		   "% 18s/i ignore any error.\n"
		   "% 18s/s skip hardware checks.\n\n"
		   ,argv[0],"","","","",""
		 );
                 exit(80);
    }
  }
  char *t=" DVMS home-path";
  if(xchdir(startpath))
  {  printf("-%s: %s not found.\n\a",t,startpath);
    exit(0);
  }
  else
    if(s)
      printf("%s: %s\n",t,startpath);

  readconfig();

  if(usesb16)
  {
     if (sb16_getconfig("BLASTER"))
       exit(20);
     if (sb16_init())
       exit(20);
     skiphwcheck=1;
  }

  if(!skiphwcheck)
    if(!check_hardware()&&!ignore)
      exit(20);

  install_irq();

  if(diagonly)
    exit(100);

  winmgr_on();

  c_init();
  afsw(1);
  set_win(filewin);
  clrscr();

  i =fork("logind"    ,fcheck_tnc ,_NPRIO,_NPROC,userwin   ,_MED);
  i|=fork("talkd"     ,talkdaemon,_NPRIO,_NPROC,defaultwin,_MED);
  i|=fork("crond"     ,crontab   ,_NPRIO,_NPROC,0         ,_BIG);
  i|=fork("keybd"     ,servkeyb  ,_NPRIO,_NPROC|_CONSOLE,keybwin   ,_MED);
  i|=fork("updscr"    ,updscr    ,_NPRIO,_NPROC,systwin   ,_MED);
  i|=fork("mailbox"   ,mailbox   ,_NPRIO,_NPROC,dtmfwin   ,_MED);

  char *r="dvmsmain";

  if(i>0)
  {  write_log(_report,r,"*** Start V%s",version);
    write_log(_report,r,"compiled %s %s",__DATE__,__TIME__);
    startsched();
    write_log(_report,r,"*** End  V%s",version);
  }
  else
  { char *l="- error initializing multiuser kernel: low memory";
    cprintf("\r\n%s\a",l);
    write_log(_report,r,l);
    delay(5000);
    exit(10);
  }

  exit(100);
}



