/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  Topic sensitive help via dtmf input
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
       Guardinistr. 47
       D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmscmd.h"
#include "dvmsirq.h"
#include "dvmsmsgb.h"
#include "dvmsptt.h"
#include "dvmssq.h"

void topic_help(char *Topic)
{
  FILE *f;
  char help[80],file[80];

  if((f=tfopen("DVMS_HLP.IDX","rb"))==NULL)
  {  write_log(_serious,"topic_help","tfopen error %s",help);
    return;
  }
  file[0]=0;
  help[0]=0;
  while (fscanf(f,"%79s %79s",help,file)!=EOF)
    if(!strcmp(help,Topic)) break;
  tfclose(f);
  rdplay (cfg.sysp[0],file);
}

void mbox_cmds(char *path,char *File_Find,int flag)
{ msg_info_t MInfo;
  struct find_t find;
  char help [80];
  int count=0;

  sprintf(help,"%s%s",path,File_Find);

  if(!_dos_findfirst(help, 0xffff, &find ))
  do
  { if((!flag&&count&&!cfg.repeater && !go_on()) ||stopped()||(get_global_msg()&_SHUTDOWN))
    { rdplay(sysp,"ABORT000.VMS");
      break;
    }
    count++;

    skip:;
    rdplay(path,find.name);
    if(get_global_msg()&_SHUTDOWN)
      return;

    if(flag)
    { skip1:;
      while(kbhit())
        getch();
      set_win(dtmfwin);
      clrscr();
      cputs("Rec new / Keys: +,#,Enter,ESC");
      if(!cfg.repeater)
      ptt(0);
      srate=32000L;

      while((!getsq()&&!kbhit()&&!(get_global_msg()&_SHUTDOWN))||sema||cronplay)
        build_mask();

    if(!kbhit())
      {  init_msg_info(MInfo);
        record_write(path,find.name,cfg.max_msg_length,MInfo);
        goto skip;
      }
      if(kbhit())
      switch(getch())
      { case '#': goto skip;
        case 27 : goto skip1;
        case '+': clrscr();return;
      }
    }
  }
  while(!_dos_findnext( &find ));
}

void keyhelp(void)
{
  if(ti[0].screenheight<50)
    return;
  set_win(get_tcb()->tty);
  clrscr();
  cputs("KEYBOARD:\r\n\r\n"
        "Alt-C force cw-callsign\r\n"
        "Alt-D simulate dtmf-input\r\n"
        "Alt-E edit DVMS-fileheader\r\n"
        "Alt-M purge msg-database\r\n"
        "Alt-N re-record files (wildcards ok)\r\n"
        "Alt-O DOS-shell\r\n"
        "Alt-R playback files (wildcards ok)\r\n"
        "Alt-X exit software (shutdown)\r\n"
        "Alt-U purge usr-database\r\n"
        "Alt-W record file\r\n"
        "Alt-Y simulate PR-login\r\n\r\n");
}
