/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  basic diskaccess / dvms header management
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/


#include "dvms.h"
#include "dvmsirq.h"
#include "dvmsmsgb.h"
#include "dvmspurg.h"
#include "movefile.h"

/* FILE_Info File BASIC-Procedures */
int crc (msg_info_t &FInfo)
{  int i;
  unsigned crc=0;
  char far *point=(char far*)&FInfo;

  /*printf("length -%d-crc %d-",sizeof(msg_info_t),FInfo->Crc);*/

  for (i=0;i<(sizeof( msg_info_t )-3);i++)
     crc+=(*(point+i)&255);

  if(FInfo.Crc!=crc)
  {  FInfo.Crc=crc;
    return 0;
  }
    return 1;
  /*
  List_MInfo(*FInfo);
  printf("crc %d-",crc);
  getch();
  */
}

static unsigned long flength (FILE *handle)
{
  long length1,length=ftell(handle);
  fseek(handle,0L,SEEK_END);
  length1=ftell(handle);
  fseek(handle,length,SEEK_SET);
  return(length1);
}

void write_finfo(msg_info_t &FInfo,FILE *File_Handle)
{
  crc(FInfo);

  if(fseek(File_Handle,0L,SEEK_SET))
  {  write_log(_serious,"write_finfo","fseek error");
    return;
  }
  fwrite(&FInfo, sizeof( msg_info_t ), 1, File_Handle );
}

int read_finfo (FILE *File_Handle,msg_info_t &File_Info)
{ char *r="read_finfo";
  int i;

  if(fseek(File_Handle,0L,SEEK_SET))
  {  write_log(_serious,r,"fseek error");
    init_msg_info(File_Info);
    return(0);
  }

  fread( &File_Info,sizeof(msg_info_t), 1, File_Handle );


  /*
   printf("r1 %u %u   ",Crc&255,FInfo.Crc&255);
   crc(&FInfo);
   printf("r2 %u   \n",FInfo.Crc&255);

   getch();
  */

  if(!crc(File_Info))
  { write_log(_serious,r,"crc check failed");
    init_msg_info(File_Info);
    return(0);
  }

  i=0;

  while(File_Info.Info[i++])
  if(i>=sizeof(File_Info.Info))
  { write_log(_serious,r,"finfo.info corrupt");
    init_msg_info(File_Info);
    return 0;
  }
  return(1);
}

void writesnd(char *path,char *input,unsigned long memptr,unsigned long pblength,msg_info_t &WFile_Info)
{ unsigned long WRT_Count=0L;
  char File_Path[80],*r="writesnd";
  FILE *f;
  while(sema)
    suspend(1);
  sema=1;

  set_win(filewin);
  gotoxy(1,1);
  cprintf("Writing: %s%s",path,input);

  if((pblength<1024)&&(pblength>_MEM))
  {  write_log(_serious,r,"pblength out of range %ld %s",pblength,input);
    sema=0;
    return;
  }

  WFile_Info.Length=pblength;

  input[12]=0;
  strcpy(WFile_Info.Filename,input);
  update_msg_info(WFile_Info);

  sprintf(File_Path,"%s%s",path,input);
  list_minfo(WFile_Info);

  crc(WFile_Info);
  if ((f=tfopen(File_Path,"wb"))!=NULL)
  {  write_finfo (WFile_Info,f);
     location=memptr+pblength;
     while((WRT_Count+_IRQ_CACHE)<pblength)
     {
      fwrite((void*)(puffer+memptr+WRT_Count),(unsigned)_IRQ_CACHE,1,f);
      WRT_Count+=_IRQ_CACHE;
      toggle_wd();
     }
     fwrite((void*)(puffer+memptr+WRT_Count),(unsigned)(pblength-WRT_Count),1,f);
     tfclose(f);
  }
  else
    write_log(_serious,r,"tfopen error %s",File_Path);
  set_win(filewin);
  gotoxy(1,1);
  cprintf("% 37s","");
  sema=0;
}

long readsnd(char *path,char *input,long unsigned memptr)
{ static char help[80],*r="readsnd";
  FILE *f;
  unsigned long length=0L;//,RD_Count=0L;
  while(sema)
    suspend(1);
  sema=1;

  srate=0L;

  set_win(filewin);
  gotoxy(1,1);
  cprintf("Reading: %s%s",path,input);
  sprintf(help,"%s%s",path,input);

  if ((f=tfopen(help,"rb"))!=NULL)
  { if(!read_finfo (f,File_Info))
    {  tfclose(f);
      move_file(help,cfg.tmppath,1);
      write_log(_serious,r,"file moved %s",help);
      sema=0;
      return 0L;
    }

    if(File_Info.Length<(length=filelength(fileno(f))))
      length=File_Info.Length;

    srate=File_Info.Srate*100;
    /*if(!ulogin) List_MInfo(File_Info);*/
    if (length>=(_MEM-memptr))
    { write_log(_serious,r,"length %ld out of range",length);
      length=_MEM-memptr-1;
    }
    setrate(srate);
    fread((void *)(puffer+memptr),length,1,f);
    location=memptr+length;
    tfclose(f);
  }
  else
  { length=0;
    write_log(_serious,r,"tfopen error %s",help);
  }
  set_win(filewin);
  gotoxy(1,1);
  cprintf("% 37s","");
  sema=0;
  return(length);
}

int wrt_file_info(char *path,char *input,int update,msg_info_t &File_Info)
{  FILE *f;
  char File_Path[80],*r="wrt_file_info";
  input[12]=0;
  strcpy(File_Info.Filename,input);

  if(update)
    update_msg_info(File_Info);

  sprintf(File_Path,"%s%s",path,input);

  if ((f=tfopen(File_Path,"rb+wb+"))!=NULL)
  {
    write_finfo (File_Info,f);
    tfclose(f);
    return 1;
  }
  else
  {
    write_log(_serious,r,"tfopen error %s",File_Path);
    return(0);
  }

}

int rd_file_info(char *path,char *input,msg_info_t &File_Info)
{  FILE *f;
  char help[80],*r="rd_file_info";

  sprintf(help,"%s%s",path,input);
  if ((f=tfopen(help,"rb"))!=NULL)
  { if(!read_finfo (f,File_Info))
    { tfclose(f);
      write_log(_serious,r,"crc check failed %s",help);
      if(move_file(help,cfg.tmppath,1))
        write_log(_serious,r,"file moved %s",help);
      reorg_msg();
      init_msg_info(File_Info);
      return(0);
    }
    tfclose(f);
  }
  else
  {  write_log(_serious,r,"tfopen error %s",help);
    init_msg_info(File_Info);
    return(0);
  }

  srate=File_Info.Srate*100;
  return(1);
}

int rd_ext_info(char *path,char *input,int num,msg_info_t &File_Info)
{  FILE *handle;
  char help[80],*r="rd_ext_info";

  sprintf(help,"%s%s",path,input);
  if((handle=tfopen(help,"rb+wb+"))!=NULL)
  {  if(!read_finfo(handle,File_Info))
    {  tfclose(handle);
      write_log(_serious,r,"crc check failed %s",help);
      if(move_file(help,cfg.tmppath,1))
        write_log(_serious,r,"file moved %s",help);
      reorg_msg();
      init_msg_info(File_Info);
      return(0);
    }

    if(!num)
      return(TRUE);

    if(flength(handle)<(File_Info.Length+(num-1)*sizeof(msg_info_t))||fseek(handle,File_Info.Length+(num-1)*sizeof(msg_info_t),SEEK_SET))
    {  write_log(_serious,r,"fseek error %ld %s",File_Info.Length+(num-1)*sizeof(msg_info_t),help);
      tfclose(handle);
      return(FALSE);
    }

    fread( &File_Info, sizeof(msg_info_t), 1, handle );

    if(!crc(File_Info))
    {  tfclose(handle);
      write_log(_serious,r,"#%d crc check failed %s",num,help);
      move_file(help,cfg.tmppath,1);
      reorg_msg();
      return FALSE;
    }

    tfclose(handle);
    return(TRUE);
  }
  else
  {  write_log(_serious,r,"tfopen error %s",help);
    reorg_msg();
    return(FALSE);
  }
}

int wrt_ext_info(char *path,char *input,int num,msg_info_t &FInfo)
{  FILE *handle;
  char help[80],*r="wrt_ext_info";
  long length,l=0;
  msg_info_t Read_Info;

  sprintf(help,"%s%s",path,input);

  if((handle=tfopen(help,"rb+wb+"))!=NULL)
  {  if(!read_finfo (handle,Read_Info))
    {  tfclose(handle);
      write_log(_serious,r,"read_finfo error %s",help);
      return 0;
    }
    switch(num)
    {   /* Marc USA 001 908 463 87 87 */
     case -1:
      length=Read_Info.Length;
      if(Read_Info.State&_MSGST_EXTHEADER)
      do
      { if(fseek( handle,length+l*sizeof(msg_info_t),SEEK_SET))
        { tfclose(handle);
          write_log(_serious,r,"%ld fseek error %s",length+l*sizeof(msg_info_t),help);
          return 0;
        }
        if(fread( &Read_Info, sizeof(msg_info_t), 1, handle )!=1)
        { tfclose(handle);
          write_log(_serious,r,"#%d fread error %s",num,help);
          return 0;
        }
        if(!crc(Read_Info))
        { tfclose(handle);
          write_log(_serious,r,"#%d crc error %s",num,help);
          move_file(help,cfg.tmppath,1);
          return 0;
        }

        l++;

      }while(Read_Info.State&_MSGST_EXTHEADER);

      if(l)
      {  if(fseek(handle,length+(l-1)*sizeof(msg_info_t),SEEK_SET))
        { tfclose(handle);
          write_log(_serious,r,"#%d fseek error %s",length+(l-1)*sizeof(msg_info_t),help);
          return 0;
        }
      }
      else
        if(fseek(handle,0L,SEEK_SET))
        { tfclose(handle);
          write_log(_serious,r,"#0 fseek error %s",help);
          return 0;
        }

      Read_Info.State|=_MSGST_EXTHEADER;
      crc(Read_Info);
      if(fwrite(&Read_Info, sizeof(msg_info_t), 1, handle )!=1)
      {  tfclose(handle);
        write_log(_serious,r,"fwrite error %s",help);
        return 0;
      }

      if(fseek(handle,length+l*sizeof(msg_info_t),SEEK_SET))
      {  tfclose(handle);
        write_log(_serious,r,"%ld fseek error %s",length+l*sizeof(msg_info_t),help);
        return 0;
      }
      break;

     case  0:
      if(fseek(handle,0L,SEEK_SET))
      {  tfclose(handle);
        write_log(_serious,r,"fseek error %s",help);
        return 0;
      }
      break;

     default:
      if(fseek(handle,Read_Info.Length+(num-1)*sizeof(msg_info_t),SEEK_SET))
      {  tfclose(handle);
        write_log(_serious,r,"%ld fseek error %s",Read_Info.Length+(num-1)*sizeof(msg_info_t),help);
        return 0;
      }
    }
    crc(FInfo);
    if(fwrite( &FInfo, sizeof(msg_info_t), 1, handle )!=1)
    {  tfclose(handle);
      write_log(_serious,r,"fwrite error %s",help);
      return 0;
    }
    tfclose(handle);
  }
  else
  { write_log(_serious,r,"tfopen error %s",help);
    reorg_msg();
    return 0;
  }
  return 1;
}

