/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  Packet radio forwarding - send/receive
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmscmd.h"
#include "dvmsfwd.h"
#include "dvmsmsgb.h"
#include "util.h"
#include "dvmshead.h"
#include "dvmspara.h"
#include "movefile.h"
#include "tnclow.h"
#include "tncrdwrt.h"
fwdpartner_t fwdp[_MAXFWDPS];

//2.2.96 Option I
static int getpriv(char *befbuf,char *privname)
{ char pwcmp[5];
  FILE *f;

  if(strlen(befbuf)==4)
  {
    f=tfopen(privname,"rt");
    if(f)
    { struct tm *tt=localtime(&get_tcb()->create);
      fseek(f,((tt->tm_min+tt->tm_mday)%60)*27+tt->tm_hour,SEEK_SET);
      fread(pwcmp,4,1,f);
      pwcmp[4]=0;
      tfclose(f);
    }
    else
    { char *s="*** no privfile\r";
      putf(s);
      write_log(_serious,"getpriv","%s %s",s,privname);
      tflush();
      return 0;
    }
    if(strcmp(pwcmp,befbuf)==0)
      return 1;
  }
  putf("***priv failure\r");
  tflush();
  return 0;
}

static int near loginline(char *date)
{ // 2301941530    23.01.94 15:30
  // 0123456789
  int day,hour,min;

  while(date[0] && !isdigit(date[0])) date++;
  if(date[0]==0)
    return -1;
  min=atoi(date+8);
  date[8]=0;
  hour=atoi(date+6);
  date[2]=0;
  day=atoi(date);

  return ((min+day)%60)*27+hour;
}

static char *putpriv(char *s,char *privname)
{ static char pwcmp[5];
  int i;
  char *t="***no logintime",*u="***no privfile",*r="putpriv";
  FILE *f;


  if(strlen(s)>=10)
  { if((i=loginline(s))==-1)
    {  write_log(_serious,r,"%s %s",t,s);
       return t;
    }
    f=tfopen(privname,"rt");

    if(f)
    {
      fseek(f,i,SEEK_SET);
      fread(pwcmp,4,1,f);
      pwcmp[4]=0;
      tfclose(f);
    }
    else
    {
      write_log(_serious,r,"%s %s",u,privname);
      return u;
    }
  }
  return pwcmp;
}

char *ad_id(char *s)
//adjusts special hadr of Export_Id to normal DVMS id: for e.g.
//089DB0LA.#BAY.DEU.EU -> 089DB0LA_
{  static char t[80],*u;

  strcpy(t,s);
  if((u=strchr(t,'.'))!=NULL)
    u[0]=0;
  while(strlen(t)<9)
    strcat(t,"_");
  return t;
}

char *id2ascii(char *s)
//adjusts special hadr of Export_Id to normal DVMS id: for e.g.
//089DB0LA_DG9MHZ -> 089DB0LA
{  static char t[10];

  strncpy(t,s,9);
  t[9]=0;
  if(strchr(t,'_'))
    strchr(t,'_')[0]=0;
  return t;
}

int expand_id(char *id,unsigned *usr,char *input)
//expands numerical DVMS id to full id, if usr is found in ???_USER.VMS file:
//for e.g. input="089" usr=100 -> return true and ID="089DB0LBM", if user
//exists
{  FILE *f;
  char help[_MAX_PATH];
  unsigned rd_usr;

  sprintf(help,"%s%-3.3s_user.vms",cfg.usrp,input);

  if((f=tfopen(help,"r"))!=NULL)
  {  while(fscanf(f,"%16s %d",help,&rd_usr)!=EOF)
    {  if(rd_usr==*usr)
      {  tfclose(f);
        strcpy(id,help);
        return 1;
      }
    }
    tfclose(f);
  }
  return 0;
}

char *fromright(char *s,char c)
{  for(int i=strlen(s)-1;i>=0;i--)
     if(s[i]==c)
     {
       if(*(s+i+1)==' ')
         return nextarg(s+i);
       else
         return (s+i+1);
     }
   return s;
}

int findfwdbox(char *s,char *t,unsigned long *u)
//input: s="071" -> output: s="071DB0VMS.#BW.DEU.EU" t="DB0AAB-8"
//input: s="DB0VMS" ourput: s="071DB0VMS.#BW.DEU.EU" t="DB0AAB-8"
{ int i;

  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
    if(!strncmp(fwdp[i].p,s,3)||!stricmp(get_onlycall(fwdp[i].p+3),s))
    {   if(s!=NULL)
          strcpy(s,fwdp[i].p);
        if(t!=NULL)
          strcpy(t,fromright(fwdp[i].c,'/'));
        if(u!=NULL)
          *u=fwdp[i].f;
        return 1;
    }
  return 0;
}

int getconnpath(char *s,char *t)
//input: s="071" -> output: s="071DB0VMS.#BW.DEU.EU" t="DB0AAB-8"
//input: s="DB0VMS" ourput: s="071DB0VMS.#BW.DEU.EU" t="DB0AAB-8"
{ int i;

  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
    if(!strncmp(fwdp[i].p,s,3)||!stricmp(get_onlycall(fwdp[i].p+3),s))
    {   if(s!=NULL)
          strcpy(s,fwdp[i].p);
        if(t!=NULL)
          strcpy(t,fwdp[i].c);
        return 1;
    }
  return 0;
}

int findboxid(char *s)
//input: s="DB0VM_" -> output: s="071DB0VM.#BW.DEU.EU"
//       s="DB0VMS" -> output  s="071DB0VS.#BW.DEU.EU"
{  int i;
  char t[7];

  strcpy(t,get_onlycall(s));
  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
    if(!stricmp(get_onlycall(fwdp[i].p+3),t))
    {   strcpy(s,fwdp[i].p);
        return 1;
    }
  return 0;
}
int isfwdpartner(char *s)
{ int i;
  char t[7];
  strcpy(t,get_onlycall(s));
  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
    if(!stricmp(get_onlycall(fromright(fwdp[i].c,'/')),t))
      return 1;
  if(!stricmp(get_onlycall(fromright(fwdp[0].c,'/')),t))
      return 1;
  return 0;
}

//2.2.96 Optionen I
void rdfwdpartners(void)
{  FILE *f;
  char line[81],*s="fwd.ini",*r="rdfwdpartners",*t,*u,*v;
  int i=1,j,lin=0;

  memset(fwdp,0,_MAXFWDPS*sizeof(fwdpartner_t));

  if((f=tfopen(s,"r"))!=NULL)
  {  while(!feof(f)&&(i<_MAXFWDPS))
    {  lin++;
      line[0]=0;
      fgets(line,80,f);
      if((s=strchr(line,'\n'))!=NULL)
        s[0]=0;

      if((s=strchr(line,'\r'))!=NULL)
        s[0]=0;

      if(((s=firstarg(line))[0]==';') || (s[0]=='#') || !s[0])
        continue;
      t=fwdp[i].c;
      u=fwdp[i].p;

      if(sscanf(s,"%30s %50s",u,t)==2)
      {
        strcpy(t,nextarg(s));
        strupr(t);
        strupr(u);

        if((v=strchr(t,','))!=NULL)
        { v[0]=0;
          j=1;
          while(v[j])
            switch(v[j++])
            {
              case 'P': fwdp[i].f|=_FWDPOLL;break;
            }
        }


        if(!strnicmp(u,"usrmsg",6))
        {
          strcpy(fwdp[0].p,u);
          strcpy(fwdp[0].c,t);
          u[0]=0;
          t[0]=0;
        }
        else
        { if((strlen(u)<10)||!hadrok(u+3))
          {
            set_win(userwin);
            gotoxy(1,8);
            cprintf("line %d [%s] invalid haddress ",lin,u);
            write_log(_fatal,r,"file fwd.ini invalid haddress in line %d",lin);
            u[0]=0;
            t[0]=0;
          }
          else
            i++;
        }
      }
    }
    tfclose(f);
  }
  else
  {  if((f=tfopen(s,"wb"))==NULL)
      return;

    fputs(";Example forward configuration\r\n"
          ";BoxId+Hadress:     Fwd-Connect Call [Port] [Via]\r\n"
          ";071DG9MHZ.#BW.DEU.EU DG9MHZ-8 1 DB0AAB-8 \r\n"
          ";USRMSG DB0AAB-8 1\r\n",f);
    tfclose(f);
    write_log(_report,r,"%s generated",s);
  }
  if(get_tasksrun())
  {  set_win(userwin);
    gotoxy(1,8);
    cprintf("rdfwdps: %d partner(s).",i-1);
  }
}

//04.01.96
char *convcall(char *s)
{ static char t[10];
  char *u;

  sscanf(s,"%9s",t);

  if((u=strchr(t,'-'))!=NULL)
  {
    u[0]=0;
    strcat(u,u+1);
  }
  return t;
}

int addfwdlist(char *concall,char *dest,char *file)
{  FILE *f;
  char path[_MAX_PATH];
  //04.01.96
  //sprintf(path,"fwd\\%s.vms",get_onlycall(concall));
  sprintf(path,"fwd\\%s.vms",convcall(concall));
  if((f=tfopen(path,"a+"))==NULL)
  {    write_log(_serious,"addfwdlist","fopen error %s",path);
      return 0;
  }
  fseek(f,0,SEEK_END);
  fprintf(f,"%-.6s/%-8.8s\n",get_onlycall(dest),file);
  tfclose(f);
  return 1;
}

int delfwdlist(char *concall,char *s,int mode)
{  FILE *f,*g;
  char line[81],path[_MAX_PATH],*t;
  int i=0;
  //04.01.96
  //t=get_onlycall(concall);
  t=convcall(concall);
  sprintf(path,"fwd\\%s.$$$",t);
  if((g=tfopen(path,"w"))==NULL)
    goto lab;
  sprintf(path,"fwd\\%s.vms",t);
  if((f=tfopen(path,"r"))!=NULL)
  {  while(!feof(f))
    {  line[0]=0;
      fgets(line,80,f);
      if(!stristr(line,s))
        fputs(line,g);
      else
      {  if(mode && i)
          fputs(line,g);
        i++;
      }
    }
    tfclose(f);
    tfclose(g);
    remove(path);
    sprintf(line,"fwd\\%s.$$$",t);
    rename(line,path);
    return i;
  }
  else
  {  tfclose(g);
    lab:;
    sprintf(path,"fwd\\%s.$$$",t);
    remove(path);
    write_log(_serious,"delfwdlist","fopen error %s",path);
  }
  return 0;
}

static int cntfwdlist(char *concall)
{ FILE *f;
  char line[81],path[_MAX_PATH],*t;
  int i=0;
  t=convcall(concall);
  sprintf(path,"fwd\\%s.vms",t);
  if((f=tfopen(path,"r"))!=NULL)
  { if(filelength(fileno(f))>0)
      while(!feof(f))
      {
        line[0]=0;
         fgets(line,80,f);
        if(strlen(line)>3)
          i++;
      }
    tfclose(f);
    return i;
  }
  return 0;
}

static int getfstfwdlist(char *concall,char *line)
{  FILE *f;
  //04.01.96
  //char path[81],*t=get_onlycall(concall);
  char path[_MAX_PATH],*t=convcall(concall);

  sprintf(path,"fwd\\%s.vms",t);
  if((f=tfopen(path,"r"))!=NULL)
  { line[0]=0;
    if(feof(f)||!fgets(line,80,f))
      line[0]=0;
    tfclose(f);
    return strlen(line);
  }
  return 0;
}

static int getnumfwdlist(char *concall,char *line,int num)
{
  FILE *f;
  char path[_MAX_PATH],*t=convcall(concall);
  int cnt=0;

  sprintf(path,"fwd\\%s.vms",t);
  if((f=tfopen(path,"r"))!=NULL)
  {
    line[0]=0;
    while(!feof(f)&&fgets(line,80,f)&&(cnt<num))
    {
      cnt++;
      line[0]=0;
    }
    tfclose(f);
    return strlen(line);
  }
  return 0;
}

static void DelOldUserFiles(void)
{
  char* line=get_tcb()->cmd;
  char* t;
  char  path[20],file[13];
  BOOL  ret;
  FILE* f;
  int   i,num;
  msg_info_t minfo;

  for(i=1,num=0;i<_MAXFWDPS,fwdp[i].p[0];i++,num=0)
  {
    t=fromright(fwdp[i].c,'/');

    while(getnumfwdlist(t,line,num))
    {
      subst(line,'/',' ');
      sscanf(line,"%6s %8s",path,file);
      sprintf(path,"fwd\\%s.vms",file);

      ret=FALSE;

      if((f=tfopen(path,"rb"))!=NULL)
      {
        fread( &minfo,sizeof(msg_info_t), 1, f);
        ret=crc(minfo);
        tfclose(f);
      }

      if(!ret)
      {
        delfwdlist(t,file,0);
        unlink(path);
        //write_log(_report,"DelOldUserFiles","%s for %s",file,convcall(t));
      }
      else
        num++;
    }
    scheduler();
  }
}

void export_users(void)
{
  char source[_MAX_PATH],dest[20],file[13];
  int i;

  DelOldUserFiles();

  sprintf(source,"%s%-3.3s_user.vms",cfg.usrp,cfg.boxaddress);

  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
  {
    mkfilename(file);
    sprintf(dest  ,"fwd\\%s",file);
    if(move_file(source,dest,0))
    {
      addfwdlist(fromright(fwdp[i].c,'/'),fwdp[i].p+3,file);
      scheduler();
    }
  }
}

static int isconnected(char *s)
{
  if(get_tasknum(get_onlycall(s))!=-1)
  //if(get_tasknum(convcall(s))!=-1)
    return 1;
  else
    return 0;
}

static char *extract(char *line,char *fname)
{  char drive[_MAX_DRIVE];
  char dir[_MAX_DIR];
  char file[_MAX_FNAME];
  char ext[_MAX_EXT];
  _splitpath(line,drive,dir,file,ext);
  sprintf(fname,"%s%s",file,ext);
  return fname;
}

static int wait_prompt(char *prompt,int i)
{
  do
  {
    if(getline(get_tcb()->cmd,_MAXCMD,1)==-1)
      return 0;
    i--;
  }
  while(!stristr(get_tcb()->cmd,prompt) && i);

  if(!i)
    return -1;
  else
    return 1;
}

static int fwd_disc(void)
{ time_t tt;

  tflush();
  tdisconnect(1);

  tt=ad_time(NULL);

  while((tget_lstate()>=info_transfer)&&((ad_time(NULL)-tt)<_TIMEOUT)&&!(get_global_msg()&_SHUTDOWN))
    suspend(18);

  return 1;
}



static int fwd_connect(char *c)
{ char *s=get_tcb()->cmd,pwds[11],file[15];
  //05.01.96
  //sprintf(mycall,"%s-%d",get_onlycall(get_mycall()),_FWDSSID);
  //if(connect(mycall,c))
  if(connect(get_mycall(),c))
  {
    switch(wait_prompt("$]",5))
    {  case -1:  fwd_disc();
                return 0;
      case  0:  goto disc;
    }

    if(!strchr(s,'['))
    {  fwd_disc();
      return 0;
    }

    if(strstr(s,"THEBOX"))
      get_tcb()->ttymode=1;

    sprintf(file,"%s.pwd",get_onlycall(c));

    if(!access(file,0))
      strcpy(pwds,putpriv(strchr(s,']'),file));
    else
      pwds[0]=0;

    switch(wait_prompt(">",5))
    { case -1:  fwd_disc();
                return 0;
      case  0:  goto disc;
    }

    putf("[DVMS-%s-DH$] %s\r",version,pwds);
    if(strlen(pwds)>4)
      goto disc;

    switch(wait_prompt(">",5))
    { case -1: fwd_disc();
                return 0;
      case  0:  goto disc;
    }

    set_win(userwin);
    gotoxy(1,8);
    cprintf("fwd conn   %s task #%d",get_tcb()->name,get_tasknum());
    write_log(_report,"fwdconn","stream %d",get_tcb()->tty);
    return 1;
  }
  else
  { disc:;
    write_log(_report,"fwdconn","failed on stream %d",get_tcb()->tty);
    return 0;
  }
}

char *mkrhdr(char *s)
{  time_t ti;
  struct tm *tt;

  ti=ad_time(NULL);
  ti+=(cfg.utcoffset*3600);
  tt=localtime(&ti);
  sprintf(s,"R:%02d%02d%02d/%02d%02dZ @:%s [%s] DVMS%s\r",
            tt->tm_year%100,tt->tm_mon+1,tt->tm_mday,tt->tm_hour,tt->tm_min,
            cfg.boxaddress+3,cfg.boxheader,version);
  return s;
}

int static near insert_file_msg(char *file,FILE *handle,msg_info_t &msg_info)
{  FILE *f;
  char c;
  if((f=tfopen(file,"rb"))!=NULL)
  {  while(!feof(f))
    {  if(((c=fgetc(f))!=255)&&(c!=_CTRLZ))
      {  if(c=='%')
          switch(fgetc(f))
          {  case '%': fputc('%',handle); break;
            case 'm': fprintf(handle,get_onlycall(cfg.boxaddress+3)); break;
            case 't': fprintf(handle,timestr(ad_time(NULL))); break;
            case 'd': fprintf(handle,datestr(ad_time(NULL),0)); break;
            case 'C': if(strlen(msg_info.Info+9))
                        fprintf(handle,"%s @ %s",msg_info.Info+9,id2ascii(msg_info.Info));
                      break;
            case 'S': fprintf(handle,"%d",msg_info.Usender);break;
            case 'R': fprintf(handle,"%d",msg_info.Ureceiver);break;
            case 'r': {
                        fprintf(handle,zeitspanne(ad_time(NULL)-startup,0));break;
                      }
            case 'l': fprintf(handle,"%ld",(msg_info.Length*8L)/((long)msg_info.Srate*100L));break;
          }
        else
          fputc(c,handle);
      }
    }
    tfclose(f);
    return 1;
  }
  else
    fprintf(handle,"\rDVMS-Text File %s not found, but probably a new voicemail \rarrived for you.",file);
  return 0;
}

int inform_sysop(msg_info_t &user)
{ char sysopcall[17],help[160],t[12],*file,*r="inform_sysop",*s;
  FILE *handle;

  if(!get_callsign(sysopcall,cfg.boxaddress,cfg.sysop_num))
    return -1;

  if(access("txt\\newuser.txt",0))
    return -1;

  //if no fwd partner for usrmsg is defined
  if(!fwdp[0].p[0])
    return 0;

  if(strlen(sysopcall)<=9)
    return(0);

  write_log(_report,r,"send msg to sysop %s(%d)",sysopcall+9,cfg.sysop_num);

  ltoa(time(NULL),t,36);
  file=t+strlen(t)-5;

  sprintf(help,"fwd\\fwd%s.vms",file);
  addfwdlist(fromright(fwdp[0].c,'/'),sysopcall+9,help+4);
  if((handle=tfopen(help,"wb"))==NULL)
  {  write_log(_report,r,"fopen error %s",help);
    return 0;
  }
  s=get_onlycall(cfg.boxaddress+3);
  fprintf(handle,"SP %s < %s $%s%-6.6s\n",sysopcall+9,s,s,file);
  fprintf(handle,"DVMS: new user %s (%d)\r",user.Info+9,user.Ureceiver);
  fprintf(handle,mkrhdr(help));
  insert_file_msg("txt\\newuser.txt",handle,user);
  fputc(_CTRLZ,handle);
  tfclose(handle);
  return(1);
}

int check_pr_msg(msg_info_t msg_info)
{
  char help[160],t[12],*file,*r="check_prmsg",*s;
  msg_info_t File_Info;
  FILE *handle;

  if(!get_callsign(help,cfg.boxaddress,msg_info.Ureceiver))
    return -1;

  if(strcmp(msg_info.extend,help))
    return -1;

  sprintf(help,"%04d_usr.vms",msg_info.Ureceiver);
  rd_file_info (cfg.usrp,help,File_Info);

  if(strlen(msg_info.extend+9))
  {
    sprintf(help,"%s \x07New voicemail from %s(%d)",msg_info.extend+9,msg_info.Info+9,msg_info.Usender);
    put_msg("talkd",(long)help);
    suspend(2);
  }

  //if no fwd partner for usrmsg is defined
  if(!fwdp[0].p[0])
    return 0;

  if((File_Info.State&_USRST_PRMSG))
  {
    if((msg_info.extend[9]==0) && !strlen(msg_info.extend+9) )
    {
      write_log(_serious,r,"no AMP-call %d",msg_info.Ureceiver);
      return(0);
    }
    write_log(_report,r,"send PR msg to %s(%d)",msg_info.extend+9,msg_info.Ureceiver);

    ltoa(time(NULL),t,36);
    file=t+strlen(t)-5;

    sprintf(help,"fwd\\fwd%s.vms",file);
    addfwdlist(fromright(fwdp[0].c,'/'),msg_info.extend+9,help+4);

    if((handle=tfopen(help,"wb"))==NULL)
    {
      write_log(_report,r,"fopen error %s",help);
      return 0;
    }

    s=get_onlycall(cfg.boxaddress+3);
    fprintf(handle,"SP %s < %s $%s%-6.6s\n",msg_info.extend+9,s,s,file);
    fprintf(handle,"DVMS-Mail from %s (%d)\r",msg_info.Info+9,msg_info.Usender);
    fprintf(handle,mkrhdr(help));

    insert_file_msg("txt\\prmsg.txt",handle,msg_info);

    fputc(_CTRLZ,handle);
    tfclose(handle);
  }
  return(1);
}

static int sendtxtmsg(char *file)
{
  FILE *f;
  char *line=get_tcb()->cmd,c,*r="sendtxtmsg";
  char path[_MAX_PATH];

  sprintf(path,"fwd\\%s.vms",file);

  if((f=tfopen(path,"rb"))==NULL)
  {
    write_log(_serious,r,"file not found %s",file);
    delfwdlist(get_tcb()->name,file,0);
    return  0;
  }

  line[0]=0;
  fgets(line,_MAXCMD,f);
  line[strlen(line)-1]=0;
  putf(line);
  putv('\r');

  if(getline(line,_MAXCMD,1)==-1)
  {  write_log(_serious,r,"unexpected disc stream %d",get_tcb()->tty);
    tfclose(f);
    return 0;
  }

  if(line[0]=='N')
  {  write_log(_serious,r,"%s stream %d",line,get_tcb()->tty);
   move_file(path,cfg.tmppath,1);
    delfwdlist(get_tcb()->name,file,1);
    tfclose(f);
    return wait_prompt(">",5);
  }

  if(line[0]!='O')
  {  write_log(_serious,r,"OK expected error %s stream %d",line,get_tcb()->tty);
    tfclose(f);
    return 0;
  }

  while(!feof(f))
    if(((c=fgetc(f))!='\n') && (c!=255))
        putv(c);

  tfclose(f);
  putv('\r');

  switch(wait_prompt(">",5))
  {  case 0 :  write_log(_serious,r,"unexpected disc stream %d",get_tcb()->tty);
              return 0;
    case -1:  write_log(_serious,r,"syntax error %s stream %d",line,get_tcb()->tty);
              return -1;
  }

  write_log(_report,r,"file ok %s stream %d",file,get_tcb()->tty);
  remove(path);
  delfwdlist(get_tcb()->name,file,1);
  return 1;
}

static int sendbinmsg(char *call,char *file)
{
  char *line=get_tcb()->cmd,*r="sendbinmsg",*s;
  char path[_MAX_PATH];

  sprintf(path,"fwd\\%s.vms",file);

  if(access(path,0))
  {
    write_log(_serious,r,"file not found %s",file);
    delfwdlist(get_tcb()->name,file,0);
    return  1;
  }

  strupr(call);
  s=get_onlycall(cfg.boxaddress+3);

  //putf("SP %s @ %s < %s $%s%-4.4s\r",call,call,s,file,s);
  putf("SP %s < %s $%s%-4.4s\r",call,s,file,s);

  if(getline(line,_MAXCMD,1)==-1)
  {
    write_log(_serious,r,"unexpected disc stream %d",get_tcb()->tty);
    return 0;
  }

  if(line[0]=='N')
  {
    write_log(_serious,r,"%s stream %d",line,get_tcb()->tty);
    move_file(path,cfg.tmppath,1);
    delfwdlist(get_tcb()->name,file,1);
    return wait_prompt(">",5);
  }

  if(line[0]!='O')
  {
    write_log(_serious,r,"OK expected error %s stream %d",line,get_tcb()->tty);
    return 0;
  }

  putf("%s\r",file);
  mkrhdr(line);
  putf(line);
  putf("From: %s @ %s\r",get_onlycall(get_mycall()),cfg.boxaddress+3);
  putf("To  : %s @ %s\r",call,call);

  if(bread(path,1))
  {
    if(get_tcb()->ttymode)
      putf("%c\r",_CTRLZ);
    switch(wait_prompt(">",5))
    {
      case 0: write_log(_serious,r,"unexpected disc stream %d",get_tcb()->tty);
              return 0;

      case -1:write_log(_serious,r,"> expected error %s stream %d",line,get_tcb()->tty);
              return 0;
      case 1: if(line[0]=='|')
          {
                write_log(_serious,r,"crc error %s stream %d",file,get_tcb()->tty);
                return -1;
              }
              else
              {
                write_log(_report,r,"file ok %s stream %d",file,get_tcb()->tty);
                remove(path);
                delfwdlist(get_tcb()->name,file,1);
                return 1;
              }
    }
  }
  return 0;
}

static char* get_fwdpartner(char *s)
{
  for(int i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
    if(!stricmp(get_onlycall(fromright(fwdp[i].c,'/')),s))
      return convcall(fromright(fwdp[i].c,'/'));

  if(!stricmp(get_onlycall(fromright(fwdp[0].c,'/')),s))
      return convcall(fromright(fwdp[0].c,'/'));

  return NULL;
}

void do_forward(void)
{
  char connect[81],destcall[7],file[9],line[80],*r="do_forward";
  int i,retry;
  BOOL reverse=(get_tcb()->tty==-1)?FALSE:TRUE;

  if(!reverse)
  {
    if(!stricmp(get_tcb()->name,"usrmsg"))
      strcpy(connect,fwdp[0].c);
    else
      if(!getconnpath(get_tcb()->name,connect))
        return;
    //04.01.96
    //strcpy(get_tcb()->name,get_onlycall(connect));
    strcpy(get_tcb()->name,convcall(fromright(connect,'/')));
    if(!fwd_connect(connect))
      return;
  }
  else
  {
     char *t=get_fwdpartner(get_tcb()->name);
     if(t)
       strcpy(get_tcb()->name,t);
     else
       write_log(_serious,r,"Could not find fwdpartner %s",get_tcb()->name);
  }


 //sfwid.box
  while(getfstfwdlist(get_tcb()->name,line)&&(tget_lstate()>=info_transfer))
  { subst(line,'/',' ');
    sscanf(line,"%6s %8s",destcall,file);

    if(!strnicmp(file,"fwd",3))
    { if(sendtxtmsg(file)<1)
        break;
    }
    else
    { retry=0;
      while(((i=sendbinmsg(destcall,file))==-1)&&(retry<5))
        retry++;
      if(retry==5)
      {  char path[_MAX_PATH];
        sprintf(path,"fwd\\%s.vms",file);
        move_file(path,cfg.tmppath,1);
        delfwdlist(get_tcb()->name,file,1);
        write_log(_report,r,"sendbinmsg: too many retries %s",file);
      }

      if(!i)
        break;
    }
  }

  if(!reverse)
  {
    putf("F>\r");
    write_log(_report,r,"reverse forward");
    fwd_chat(TRUE);
  }
  else
  {
    putf("***done\r");
    set_win(userwin);
    gotoxy(1,8);
    cprintf("fwd logout %s task #%d",get_tcb()->name,get_tasknum());
    write_log(_report,r,"fwddisc stream %d CPUt %s",get_tcb()->tty,zeitspanne(get_tcb()->cputime,2));
  }
  fwd_disc();
}

int fwddcall(char *f)
{ int i;
  char a=0;
  char line[81];

  if(!flex || !(cfg.system_state&1))
    return 0;

  if(fwdp[0].p[0] && !stricmp(f,get_onlycall(fromright(fwdp[0].c,'/'))))
    if((getfstfwdlist(fromright(fwdp[0].c,'/'),line)||(fwdp[0].f&_FWDPOLL)) &&
       !isconnected(fromright(fwdp[0].c,'/')))
    { fork("USRMSG",do_forward,_NPRIO,_TNCPROC|_FWDPROC,-1,_BIG);
      a=1;
      suspend(1);
    }
  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
  {
    if(!stricmp(f,get_onlycall(fromright(fwdp[i].c,'/'))))
      if((getfstfwdlist(fromright(fwdp[i].c,'/'),line)||(fwdp[i].f&_FWDPOLL)) &&
        !isconnected(fromright(fwdp[i].c,'/')))
      { fork(get_onlycall(fwdp[i].p+3),do_forward,_NPRIO,_TNCPROC|_FWDPROC,-1,_BIG);
        suspend(1);
        a=1;
      }
  }
  return a;
}

void fwdd(void)
{
  int i;
  char line[81];

  if(!flex || !(cfg.system_state&1))
    return;

  if(fwdp[0].p[0])
    if((getfstfwdlist(fromright(fwdp[0].c,'/'),line)||(fwdp[0].f&_FWDPOLL)) &&
       !isconnected(fromright(fwdp[0].c,'/')))
    { fork("USRMSG",do_forward,_NPRIO,_TNCPROC|_FWDPROC,-1,_BIG);
      suspend(1);
    }

  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
    if((getfstfwdlist(fromright(fwdp[i].c,'/'),line)||(fwdp[i].f&_FWDPOLL)) &&
       !isconnected(fromright(fwdp[i].c,'/')))
    { fork(get_onlycall(fwdp[i].p+3),do_forward,_NPRIO,_TNCPROC|_FWDPROC,-1,_BIG);
      suspend(1);
    }
}

void fwdstat(void)
{
  int i,m,n;
  char help[10];

  putf("Call       Conn Mails:\r");

  if(fwdp[0].p[0])
  { sscanf(fromright(fwdp[0].c,'/'),"%9s",help);
    putf("%-10s   %d    %d\r",help,isconnected(fromright(fwdp[0].c,'/')),m=cntfwdlist(fromright(fwdp[0].c,'/')));

  }

  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
  {
    n=cntfwdlist(fromright(fwdp[i].c,'/'));
    m+=n;
    sscanf(fromright(fwdp[i].c,'/'),"%s",help);
    putf("%-10s   %d    %d\r",help,isconnected(fromright(fwdp[i].c,'/')),n);
  }

  putf("Total:     %d mails\r",m);
}

static int lookup_msg(char *s)
{
  char path[_MAX_PATH];

  if(strlen(s)<8)
    return 0;

  s[8]=0;
  sprintf(path,"%s%s.vms",cfg.msgp,s);

  return !access(path,0);
}

static void putno(char *r,char *s,char *t)
{
  write_log(_serious,r,"NO %s because %s",s,t);
  putf("NO - %s\r",s);
}

static void fwd_chat(BOOL reverse)
{
  char *fstarg,help[3][32],file[_MAX_PATH],path[_MAX_PATH],dest[_MAX_PATH],*line=get_tcb()->cmd,*r="fwd_dialog",
       bid[16],*s;
  msg_info_t minfo;
  FILE *f;
  int i,retry;
  if(!reverse)
  {
    strcpy(line,get_tcb()->name);

    sprintf(file,"%s.pwd",get_tcb()->name);

    if(!access(file,0))
    {
      struct tm *tt=localtime(&get_tcb()->create);
      sprintf(help[0]," %02d%02d%02d%02d%02d",
                tt->tm_mday,tt->tm_mon+1,tt->tm_year,tt->tm_hour,tt->tm_min);
    }
    else
      help[0][0]=0;

    putf("[DVMS-%s-DH$]%s\r>\r",version,help[0]);
    if(wait_prompt("$]",3)<1)
    {
      if(line[0]=='<')
      {
        void tnc_dialog();
        l2_i_ack(get_tcb()->tty);
        fork(get_tcb()->name,tnc_dialog,_NPRIO,_TNCPROC,get_tcb()->tty ,_BIG);
        get_tcb()->tty=-1;
      }
      else
        fwd_disc();
      return;
    }

    if(line[0]!='[')
    { fwd_disc();
      return;
    }

    if(!access(file,0))
      if(!getpriv(strchr(line,']')+2,file))
      {
        suspend(20);
        fwd_disc();
        return;
      }
  }

  while(!(cfg.system_state&1) && !(get_global_msg()&_SHUTDOWN) && (tget_lstate()>=info_transfer))
    suspend(18);

  set_win(userwin);
  gotoxy(1,8);
  cprintf("fwd login  %s pid #%d",get_tcb()->name,get_tasknum());
  write_log(_report,r,"fwdlogin stream %d",get_tcb()->tty);

  while(!(get_global_msg()&_SHUTDOWN))
  {
    retry=5;
    do
    {
      putf(">\r");
      if(getline(line,_MAXCMD,1)==-1)
          goto disc;
      get_tcb()->lastinput=ad_time(NULL);
      fstarg=firstarg(line);
      retry--;
    }while((!fstarg[0]||(fstarg[0]=='>')) && retry);

    //forward send?
    if((fstarg[0]&0x5f)=='S')
    {
      fstarg=nextarg(fstarg);
      //get send line
      help[1][0]=0;
      if((sscanf(fstarg,"%31s @ %31s < %31s",help[0],help[1],help[2])==3) ||
         (sscanf(fstarg,"%31s < %31s",help[0],help[2])==2))
      { //is it for me ?
        if(!stricmp(help[0],get_onlycall(cfg.boxaddress+3)))
        {  //is the @ box correct (must be my boxaddress)
          if(help[1][0]&&strnicmp(help[0],help[1],strlen(help[0])))
            write_log(_serious,r,"suspicious @ box %s",fstarg);

	        if((s=strchr(fstarg,'$'))!=NULL)
	        {
	          sscanf(s+1,"$%15s",bid);
	          if(lookup_msg(bid))
            {
	            putno(r,"BID",bid);
              continue;
            }
	        }
	        //ok - I take the msg
	        putf("OK\r");
	        if(getline(line,_MAXCMD,1)==-1)
	          break;
	        else
	          putv('\r');

	        if(bwrite(path,1))
	        { //filename and directory guessing
	          //is it a userfile
	          if((f=tfopen(path,"rb"))!=NULL)
	          {
              fread(file,9,1,f);
	            tfclose(f);
	            file[9]=0;
	            if(findboxid(file+3))
	            {
                sprintf(dest,"%s%-3.3s_user.vms",cfg.usrp,file+3);
		            write_log(_report,r,"userfile %s",dest);
		            move_file(path,dest,1);
	            }
	            else
	            if((file[0]=='M') && (file[1]=='Z'))
	            {
                extract(line,file);
                if(stristr(file,".exe"))
		              sprintf(dest,"dist\\%s",file);
                else
                  sprintf(dest,"dist\\dvmsdist.exe");
                write_log(_report,r,"exefile %s",dest);
                move_file(path,dest,1);
              }
              else
              if((file[0]=='P') && (file[1]=='K'))
              {
                extract(line,file);
                if(stristr(file,".zip"))
                  sprintf(dest,"dist\\%s",file);
                else
                  sprintf(dest,"dist\\dvmsdist.zip");

                write_log(_report,r,"zipfile %s",dest);
                move_file(path,dest,1);
              }
              else
              if((file[0]=='`') && (file[1]==''))
              { extract(line,file);
		            if(stristr(file,".arj"))
                  sprintf(dest,"dist\\%s",file);
                else
                  sprintf(dest,"dist\\dvmsdist.arj");
                write_log(_report,r,"arjfile %s",dest);
                move_file(path,dest,1);
              }
              else
              if((file[3]=='l') && (file[4]=='h'))
              { extract(line,file);
                if(stristr(file,".lzh"))
                  sprintf(dest,"dist\\%s",file);
                else
                  sprintf(dest,"dist\\dvmsdist.lzh");
                write_log(_report,r,"lzhfile %s",dest);
                move_file(path,dest,1);
              }
              else
              //is it a voice msg ?
              {
                f=tfopen(path,"rb");
                i=read_finfo (f,minfo);
                tfclose(f);
                if(i)
		            {
                  sprintf(dest,"%s%s",cfg.msgp,minfo.Filename);
                  if(access(dest,0))
                  {
                    write_log(_report,r,"msgfile %s",dest);
                    move_file(path,dest,1);
                    write_minfo (minfo);
                  }
                  else
                  {
                    write_log(_serious,r,"double msgfile %s",path);
                    goto skip;
                  }

                  if(check_pr_msg(minfo)==-1)
		              {
                    write_log(_serious,r,"user not found %s",minfo.extend);
                    goto skip;
                  }
                  else
                  {
                    rdplay(sysp,"msg_new.vms");
                    spk_user(minfo.extend,minfo.Ureceiver,_USER_ONLY);
                  }

                }
                else
                {
		              write_log(_serious,r,"corruptfile %s",path);
                  skip:;
                  unlink(path);
                }
              }
            }
          }
        }
        else
         putno(r,"invalid dest call",fstarg);
      }
      else
        putno(r,"incorrect fwd send format",fstarg);
    }
    else //7.2.97
    if(((fstarg[0]&0x5f)=='F')&&(fstarg[1]=='>'))
    {
      write_log(_report,r,"reverse forward");
      do_forward();
      return;
    }
    else
      break;
  }
  putf("***done\r");
  disc:;
  set_win(userwin);
  gotoxy(1,8);
  cprintf("fwd logout %s pid #%d",get_tcb()->name,get_tasknum());
  write_log(_report,r,"fwdlogout stream %d CPUt %s",get_tcb()->tty,zeitspanne(get_tcb()->cputime,2));
  fwd_disc();
}

void fwd_dialog(void)
{
  fwd_chat(FALSE);
}
