/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  DTMF-Reception with G8870
  Generation of Dual-tone (paging)
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
       Guardinistr. 47
       D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#define getrandom( min, max ) ((rand() % (int)((max) - (min))) + (min) + 1)

#include "dvms.h"
#include "dvmshead.h"
#include "dvmscmd.h"
#include "dvmsirq.h"
#include "dvmsptt.h"
#include "dvmssuba.h"
#include "dvmssq.h"
#include "dvmssyso.h"
#include "util.h"

time_t dtmfstart;
time_t delstart;

unsigned long sig_count,s_meter;
char dtmf[20];
char DTMF_Code[]={"D1234567890*#ABC"};

void rcvdtmf(char *dtin,int mode)
{  static rptr_prio=0;
  unsigned long sqopen=timer();
  unsigned long sqstart=timer();
  int c,i,j=0,lsq=1,sqt=0;
  time_t inpstart=ad_time(NULL);

  sig_count=0L;
  s_meter=0L;

  afsw(1);
  set_win(dtmfwin);
  clrscr();

  if(strlen(dtmf))
  { cprintf("EXTERN: %s",dtmf);
    ctcss=maxtones;

    if(cfg.repeater && !ptt_state && (idletime()>(cfg.tx_hold+cfg.tx_retrig)))
      call_count=18;
   ptt(1);
    time(&dtmfstart);

    if(dtmf!=dtin)
      strcpy(dtin,dtmf);
    return;
  }
  update_ctcss();
  dtin[0]=0;
  while(!(get_global_msg()&_SHUTDOWN))
  {
    if(cfg.inp_timeout && ((ad_time(NULL)-inpstart)>=cfg.inp_timeout))
    { rdplay(sysp,"OVERTIME.VMS");
      while(getsq())
      { build_mask();
        ptt(0);
      }
      break;
    }
    //Auftasten, wenn repeater>0 und !ptt_state
    // rptr_prio=0 setzen
    //3. 1750Hz callsign abspielen und merken in rptr_prio=1, falls repeater==3
    //1. richtiger sub_ton
    //2. dtmf
    //-> ptt(1); und CW Kennung einschalten
    if(!ptt_state && (idletime()>(cfg.tx_hold+cfg.tx_retrig)))
    {  rptr_prio=0;
      if(!(getdt(0)&32))
      { suspend(6);
        if(!(getdt(0)&32))
        { set_audio(32);

          while(!(getdt(0)&32))
          {  scheduler();
             toggle_wd();
          }
          ptt(1);
          suspend(6);
          set_chb(16);
          rdplay(cfg.sysp[0],"CALLSIGN.VMS");
          set_chb(0);
          call_count=18;
          if(cfg.repeater==3)
            rptr_prio=1;
        }
      }

      if(cfg.repeater)
      { if(ctcss)
        if((cfg.ctcss_open==-1)||(ctcss==cfg.ctcss_open))
        {  ptt(1);
          if(!call_state)
            call_count=18;
        }

        if(getdt(0)&16)
        {  ptt(1);
          if(!call_state)
            call_count=18;
        }
      }
    }

    //ptt-nachtriggern immer durch dtmf
    //DTMF auswerten, maximal 16 Zeichen, Abbruch bei C oder #, wenn !Spd
    //dtmfstart neu stellen - und irq_audio fr 1 Sekunde abstellen.
    c=getdt(1);
    if(c&16)
    { set_audio(32);
      afsw(0);
      scheduler();
      i=getdt(1);
      if((i&16) && (i==c))
      { while(getdt(0)&16)
        {  scheduler();
           toggle_wd();
        }
        ad_time(&dtmfstart);

        if(cfg.repeater)
          ptt(1);
        else
          ad_time(&delstart);

        if(!(i&15) && (dtin[0]!='D') && j)
          j=0;
        else
          dtin[j++]=DTMF_Code[i&15];

        dtin[j]=0;

        set_win(dtmfwin);
        clrscr();
        cprintf("DTMF: %s",dtin);

        if(j==16)
          break;

        if(!mode && ((dtin[0]=='#')||(dtin[0]=='C')))
          break;
        //Sysop switch befehl auswerten
        if(!strncmp(dtin,cfg.remote_switch,strlen(cfg.remote_switch))&&
           ((ctcss==cfg.sysop_tone)||(cfg.sysop_tone==-1))&&
            (strlen(dtin)==(strlen(cfg.remote_switch)+1)))
        { swstate(atoi(dtin+strlen(dtin)-1));
          write_log(_report,"rcvdtmf","swstate %d",atoi(dtin+strlen(dtin)-1));
          dtin[0]=0;
          j=0;
        }
      }
    }

    if(j&&((ad_time(NULL)-dtmfstart)>cfg.dtmf_timeout))
      break;

    //und nur bei repeater>1 durch trger
    if((cfg.repeater>1)&&(idletime()<=(cfg.tx_hold+cfg.tx_retrig)))
      ptt(1);
    else
      ptt(-1);

    //wenn aufgetastet und 1750Hz dann Signalstrke
    if(cfg.repeater&& ptt_state && !(getdt(0)&32))
    { suspend(6);
      set_audio(32);
      afsw(0);
      if(!(getdt(0)&32))
      {  while(!(getdt(0)&32))
        {  scheduler();
           toggle_wd();
        }
        if(!call_state && (cfg.config&4))
        {  if(s_meter<10000L)
            sprintf(cw,"@@@S@%d",(unsigned)s_meter/1000L);
          else
            sprintf(cw,"@@@S@9P");
        }
      }
    }

    //Squelch auswerten
    //nach zeit>sq_wait break;
    //vorher warten und wenn mehr als x mal pro Sekunde
    //squelch toggelt, dann rauschsperre offen lassen -> irq_audio
    //audio einschalten wenn letzter DTMF Ton vor 1sek war

    if((timer()-sqstart)>36)
    {  sqt=0;
      sqstart=timer();
    }

    if(lsq!=getsq())
      sqt++;
    build_mask();
    lsq=getsq();

    if(lsq)
    { sqopen=timer();
      if((ad_time(NULL)-dtmfstart)>1)
      { afsw(1);
        set_audio(16+32);
      }
    }
    else
    {  if((sqt>cfg.sq_sens)&&((ad_time(NULL)-dtmfstart)>1))
      {  afsw(1);
        set_audio(16+32);
      }
      else
      { afsw(0);
        set_audio(32);
      }
    }

    if((timer()-sqopen)>cfg.sq_wait)
      break;
  }


  if(dtin[0])
  { char help[80];
    sprintf(help,"MON %s sig:% 3ld sub:% 4ldHz dtmf:%s",timestr(ad_time(NULL)),s_meter/1000L,ctcss_tone[ctcss]/1000L,dtin);
    put_msg("talkd",(long)help);
    suspend(2);
    wrtdtmflog(help+22);
  }

  //bei rptr_prio oder disable DTMF Eingabe loeschen
  if(((cfg.system_state&3)!=3) || rptr_prio)
    dtin[0]=0;

  afsw(0);
  set_audio(32);

  if(!call_state && strcmp(cw,cfg.call))
    call_state=1;

  return;
}

void tx_dtmf(char *input)
{ int i;
  suspend(3);
  readsnd(cfg.sysp[0],"DTMF.VMS",0L);

  for(i=0;i<strlen(input);i++)
  {  switch (input[i])
    {  case '1': location =    0L   ; break;
      case '2': location = 1400L*1L; break;
      case '3': location = 1400L*2L; break;
      case '4': location = 1400L*3L; break;
      case '5': location = 1400L*4L; break;
      case '6': location = 1400L*5L; break;
      case '7': location = 1400L*6L; break;
      case '8': location = 1400L*7L; break;
      case '9': location = 1400L*8L; break;
      case '*': location = 1400L*9L; break;
      case '0': location = 1400L*10L; break;
      case '#': location = 1400L*11L; break;
      case 'A': location = 1400L*12L; break;
      case 'B': location = 1400L*13L; break;
      case 'C': location = 1400L*14L; break;
      case 'D': location = 1400L*15L; break;
      default : location =1;
    }
    if (location!=1)
      playback(location,350L);

    suspend(2);

    toggle_wd();
  }
}
/*
void make_DTMF(void)
{

  readsnd(cfg.sysp1,"1_DTM.VMS",0L);
  readsnd(cfg.sysp1,"2_DTM.VMS",location);
  readsnd(cfg.sysp1,"3_DTM.VMS",location);
  readsnd(cfg.sysp1,"4_DTM.VMS",location);
  readsnd(cfg.sysp1,"5_DTM.VMS",location);
  readsnd(cfg.sysp1,"6_DTM.VMS",location);
  readsnd(cfg.sysp1,"7_DTM.VMS",location);
  readsnd(cfg.sysp1,"8_DTM.VMS",location);
  readsnd(cfg.sysp1,"9_DTM.VMS",location);
  readsnd(cfg.sysp1,"ST_DTM.VMS",location);
  readsnd(cfg.sysp1,"0_DTM.VMS",location);
  readsnd(cfg.sysp1,"#_DTM.VMS",location);
  readsnd(cfg.sysp1,"a_DTM.VMS",location);
  readsnd(cfg.sysp1,"b_DTM.VMS",location);
  readsnd(cfg.sysp1,"c_DTM.VMS",location);
  readsnd(cfg.sysp1,"d_DTM.VMS",location);

  File_Info   = Init_Msg_Info();
  File_Info   = Update_MSG_Info (File_Info);

  File_Info.Usender = 1;
  File_Info.Id=_MSGID_SYSTEM;

  writesnd(sysp,"DTMF.VMS",0L,22400L,File_Info);
}
*/
void paging(char *dtmf)
{ char help[80];

  tx_dtmf(dtmf);
  dtmf[3]=0;
  if(spk_user(cfg.boxaddress,atoi(dtmf),_USER_ONLY))
  { extern char *timestr(time_t time);
    strcpy(help,File_Info.Info);

    if(!accessp(sysp,"PAGED.VMS"))
      rdplay(sysp,"PAGED.VMS");
    else
      rdplay(sysp,"VON.VMS");

    strcpy(dtmf,dtmf+4);

    spk_user(cfg.boxaddress,atoi(dtmf),_USER_ONLY);

    sprintf(help,"%s %s \x07paged by %s(%d)",help+9,timestr(ad_time(NULL)),File_Info.Info+9,File_Info.Ureceiver);
    put_msg("talkd",(long)help);
    suspend(2);

    sprintf(help,"%sNO_RPTR.VMS",sysp);
    if(!access(help,0))
      rdplay(sysp,"NO_RPTR.VMS");
  }
}
