/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  dtmf command: erase and unerase message
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
       Guardinistr. 47
       D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmscmd.h"
#include "dvmsdtmf.h"
#include "dvmshead.h"
#include "dvmsmsgb.h"
#include "dvmsrecm.h"
#include "dvmssuba.h"
#include "dvmssq.h"

void del_msg_num(int usr,int MSG_Number)
{ long MSG_Num;
  char dtmf[20];
  msg_info_t MInfo;

  if(!check_ctcss())
  { rdplay(sysp,"MSG_DEL5.VMS");
    return;
  }

  location=0L;
  MSG_Num=spk_msg_info(usr,MSG_Number,0);

  if(MSG_Num!=-1L)
  {  if(!read_minfo(MSG_Num,MInfo))
    {  write_log(_serious,"del_msg_num","read_minfo error");
      return;
    }
   readsnd (sysp,"MSG_DEL0.VMS",0L);
    if (MInfo.State==_MSGST_UNREAD)
      readsnd(sysp,"MSG_WURD.VMS",location);
    playback(0L,location);

    if(wait_carrier(1)==-1)
      return;
    rcvdtmf(dtmf,TRUE);

    if(dtmf[0]=='*')
    {  write_log(_report,"del_msg_num","msg #%d",MSG_Number);
      MInfo.State|=_MSGST_DELETED;
      write_minfo_num (MSG_Num,MInfo);
      rdplay(sysp,"MSG_DEL1.VMS");
    }
    else
      rdplay(sysp,"MSG_DEL2.VMS");
  }
  else
    rdplay(sysp,"MSG_NOM1.VMS");
}

void del_read(int usr,int flag)
{ long Msg_Num,Msg_Count=0;
  int Del_Count=0;
  char help[80],dtmf[20];
  msg_info_t MInfo,MInfo_read;
  FILE *handle;

  size_t rec_size = sizeof( MInfo );
  //WD_enable=FALSE;

  if(!flag)
    goto Del;
  if(!check_ctcss())
  {  rdplay(sysp,"MSG_DEL5.VMS");
    return;
  }

  rdplay(sysp,"MSG_DEL3.VMS");
  if(wait_carrier(1)==-1)
    return;

  rcvdtmf(dtmf,TRUE);

  if(dtmf[0]=='*')
  {  Del:;
    init_msg_info(MInfo);
    if(flag)
      MInfo.State=_MSGST_READ;
    else
      MInfo.State=(unsigned)0xFFFF;
    MInfo.Ureceiver=usr;

    sprintf(help,"%s"_LISTNAME".VMS",cfg.msgp);
    if ((handle=tfopen(help,"rb+wb+"))==NULL)
    {  write_log(_serious,"del_read","tfopen error %s",help);
      return;
    }

    fseek(handle,0L,SEEK_END);
    Msg_Num=ftell(handle)/sizeof( MInfo);

    for(Msg_Count=0;Msg_Count<Msg_Num;Msg_Count++)
    {  fseek(handle,Msg_Count*rec_size,SEEK_SET);
      fread( &MInfo_read, rec_size, 1, handle );
      if((MInfo_read.State&MInfo.State)&&(MInfo_read.Ureceiver==MInfo.Ureceiver)&&!(MInfo_read.State&_MSGST_DELETED))
      {  MInfo_read.State|=_MSGST_DELETED;
        fseek(handle,Msg_Count*rec_size,SEEK_SET);
        crc(MInfo_read);
        fwrite( &MInfo_read, rec_size, 1, handle );
        /*List_MInfo(MInfo_read);*/
        Del_Count++;
      }
    }
    tfclose(handle);

    if(flag)
    {  write_log(_report,"del_read","usr #%d",usr);
      rdplay(sysp,"MSG_DEL4.VMS");
      if(Del_Count==1)
        rdplay(sysp,"EINE.VMS");
      else
        spknum(Del_Count);
    }
  }
  else
    rdplay(sysp,"ABORT000.VMS");
  //WD_enable=TRUE;
}

void unerase_msg(int usr,int msg)
{ long Msg_Num,Msg_Count=0;
  int Del_Count=0;
  char help[80],*r="unerase_msg";
  msg_info_t MInfo,MInfo_read;

  FILE *handle;
  size_t rec_size = sizeof( MInfo );

  rdplay(sysp,"UNERASE0.VMS");
  init_msg_info(MInfo);
  MInfo.Ureceiver=usr;
  sprintf(help,"%s"_LISTNAME".VMS",cfg.msgp);
  if ((handle=tfopen(help,"rb+wb+"))==NULL)
  {  write_log(_serious,r,"tfopen error %s",help);
    return;
  }
  fseek(handle,0L,SEEK_END);
  Msg_Num=ftell(handle)/sizeof( MInfo);

  for(Msg_Count=0;Msg_Count<Msg_Num;Msg_Count++)
  {  fseek(handle,Msg_Count*rec_size,SEEK_SET);
    fread( &MInfo_read, rec_size, 1, handle );
    if((MInfo_read.Ureceiver==MInfo.Ureceiver)&&(MInfo_read.State&_MSGST_DELETED))
      Del_Count++;
  }
  tfclose(handle);
  if(!msg)
  {  rdplay(sysp,"MSG_DEL4.VMS");
    if(Del_Count==1)
      rdplay(sysp,"EINE.VMS");
    else
      spknum(Del_Count);
      if(!Del_Count) return;
  }
  else
  {  rdplay(sysp,"MSG_FRM0.VMS");
    spknum((long)msg);
    if(msg>Del_Count)
    {  rdplay(sysp,"MSG_NOM1.VMS");
      return;
    }
  }

  if(go_on())
  {  Del_Count=0;
    if ((handle=tfopen(help,"rb+wb+"))==NULL)
    {  write_log(_serious,r,"tfopen error %s",help);
      return;
    }
    fseek(handle,0L,SEEK_END);
    Msg_Num=ftell(handle)/sizeof( MInfo);

    for(Msg_Count=0;Msg_Count<Msg_Num;Msg_Count++)
    {  fseek(handle,Msg_Count*rec_size,SEEK_SET);
      fread( &MInfo_read, rec_size, 1, handle );

      if((MInfo_read.Ureceiver==MInfo.Ureceiver)&&(MInfo_read.State&_MSGST_DELETED))
      {  Del_Count++;
        if(msg==Del_Count||!msg)
        {  MInfo_read.State&=(0xffff-_MSGST_DELETED);
          fseek(handle,Msg_Count*rec_size,SEEK_SET);
          crc(MInfo_read);
          fwrite( &MInfo_read, rec_size, 1, handle );
        }
      }
    }
    tfclose(handle);
    rdplay(sysp,"UNERASE1.VMS");
    if(!msg)
    {  write_log(_report,r,"usr #%d msgs %d",usr,Del_Count);
      if(Del_Count==1)
        rdplay(sysp,"EINE.VMS");
      else
        spknum(Del_Count);
    }
    else
      rdplay(sysp,"EINE.VMS");
  }
  else
    rdplay(sysp,"ABORT000.VMS");
}

