/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  DCF77 decoder for INT08 usage
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/
#ifdef __MSDOS__

#include "dvms.h"

extern void c_tx_rate(unsigned long rate,unsigned long filter);
extern void beep(long freq);
extern int  set_win(int win);

struct dostime_t  dtime[3];
struct dosdate_t  ddate[3];

int  dcf_flag=0,
    dcf_state=1,
    dcf_sync=1,
    dcf_retry,
    high_count=0,
    low_count=0,
    sec=0,dcf_ok=0;

long dcf_timeout=3000L;
long dcf_help;

char dcf_in[60],dcfmon=0;
char *days[] = { "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" };

static void get_time(struct dostime_t *dtime)
{  dtime->minute=  dcf_in[21]*1+dcf_in[22]*2+dcf_in[23]*4+dcf_in[24]*8+
                  dcf_in[25]*10+dcf_in[26]*20+dcf_in[27]*40;
  dtime->hour  =  dcf_in[29]*1+dcf_in[30]*2+dcf_in[31]*4+dcf_in[32]*8+
                  dcf_in[33]*10+dcf_in[34]*20;
  dtime->second=0;
  dtime->hsecond=0;
}

static void get_date(struct dosdate_t *ddate)
{  ddate->day      =  dcf_in[36]*1+dcf_in[37]*2+dcf_in[38]*4+dcf_in[39]*8+
                    dcf_in[40]*10+dcf_in[41]*20;
  ddate->dayofweek=  (dcf_in[42]*1+dcf_in[43]*2+dcf_in[44]*4)%7;
  ddate->month    =  dcf_in[45]*1+dcf_in[46]*2+dcf_in[47]*4+dcf_in[48]*8+
                    dcf_in[49]*10;
  ddate->year      =  dcf_in[50]*1+dcf_in[51]*2+dcf_in[52]*4+dcf_in[53]*8+
                    dcf_in[54]*10+dcf_in[55]*20+dcf_in[56]*40+dcf_in[57]*80;
}

static int rxparity(void)
{  int i,Test=0;
  if(!dcf_in[20]) return 0;
  for(i=21;i<28;i++)
    if(dcf_in[i]) Test++;
  if ((Test%2)!=dcf_in[28]) return 0;

  Test=0;
  for(i=29;i<35;i++)
    if(dcf_in[i]) Test++;
  if ((Test%2)!=dcf_in[35]) return 0;

  Test=0;
  for(i=36;i<58;i++)
    if(dcf_in[i]) Test++;
  if ((Test%2)!=dcf_in[58]) return 0;

  get_time(&dtime[2]);
  get_date(&ddate[2]);

  if (ddate[2].year > 94)
    ddate[2].year+=1900;
  else
    ddate[2].year+=2000;

  if ((ddate[2].day>0) && (ddate[2].day<32) && (ddate[2].month>0) &&
      (ddate[2].month<13) && (ddate[2].dayofweek<7) && (dtime[2].hour<24) &&
      (dtime[2].minute<60) && (dtime[2].second<60))
    return(1);
  return(0);
}

void dcf_start(void)
{ low_count=0;
  high_count=0;
  dcf_flag=0;
  sec=0;
  dcf_timeout=3000L;
  dcf_state=TRUE;
}

void dcf_win(void)
{
  set_win(dcfwin);
  gotoxy(1,1);
  cprintf("SEC:%03d LOCK:%d INP.:%d SYNC:%d TOUT:%03d",sec%1000,dcf_flag,dcf_in[sec],dcf_sync,(int)(dcf_timeout/18));
    if(flex)
    { int i;
      char s;
    /* Gibt verschiedene Kanalzustnde zurck, Bits sind 1 wenn wahr:
         0x20   PTT Sender ist an
         0x10   DCD Empfnger ist aktiv
         0x08   FDX Kanal ist Vollduplex, kann also immer empfangen
         0x04   TBY Sender ist nicht bereit, z.B. wg. Calibrate */
      #define start 201 //41
      for(i=0;i<15;i++)
        if(ch_active(i))
        {  if((s=ch_state(i))&0x20)
            screen[((i<<1)+start)*2+320]='T';
          else
            screen[((i<<1)+start)*2+320]=' ';

          if(s&0x10)
            screen[((i<<1)+start+1)*2+320]='R';
          else
            screen[((i<<1)+start+1)*2+320]=' ';
          if((s&0x30))
          {  screen[((i<<1)+start)*2+321]=((s&0x30)<<1)+WHITE;
            screen[((i<<1)+start+1)*2+321]=((s&0x30)<<1)+WHITE;
          }
          else
          { screen[((i<<1)+start)*2+321]=(BLUE<<4)+7;
            screen[((i<<1)+start+1)*2+321]=(BLUE<<4)+7;
          }
        }

    }

  if(dcf_ok&2)
  { gotoxy(1,2);
    cprintf("DCF: %s, %02u.%02u.%02u  %02u:%02u:%02u",
              days[ddate[2].dayofweek],
              ddate[2].day, ddate[2].month, ddate[2].year%100,
              dtime[2].hour, dtime[2].minute, dtime[2].second );
    dcf_ok&=253;
  }

}

void dcf_update(void)
{  if(dcf_state)
  {  dcf_timeout--;
    if ((usesb16 ? inp(lpt+1) : inp(cfg.iobase+4)) & DCF_BIT)
    { if(dcfmon==1)
        beep(1000);
      if(dcfmon==2)
        c_tx_rate(cfg.tone,400000L);
      high_count++;
      low_count=0;
    }
    else
    { if(dcfmon==1)
        beep(0);
      if(dcfmon==2)
        c_tx_rate(0L,400000L);
      low_count++;
      if((low_count>28))
      {  sec=0;
        dcf_flag=1;
      }
      if(high_count&&(low_count==1))
      {
        if(high_count<3)
          dcf_in[sec]=0;
        else
          dcf_in[sec]=1;
        high_count=0;

        if(sec==59)
          sec=0;
        else
          sec++;
      }
      if((sec==59)&&dcf_flag&&(low_count==1))
        dcf_state=0;
    }
    if(!dcf_timeout)
      dcf_state=0;
  }
  else
    dcf_timeout=3000L;

  if(!(dcf_sync&3))
  {  dcf_start();
    dcf_sync|=1;
  }
  if(!dcf_state&&(dcf_sync&1))
  {  if(rxparity())
    { dtime[1]=dtime[2];
      ddate[1]=ddate[2];
      dcf_sync=(dcf_sync&4)|2;
      dcf_retry=0;
      dcf_ok=2;
    }
    dcf_start();
  }
  if(!dcf_state&&(dcf_sync&2))
  {  if(rxparity())
    {    if((ddate[2].day==ddate[1].day)&&(ddate[2].month==ddate[1].month)&&(ddate[2].year==ddate[1].year)&&(ddate[2].dayofweek==ddate[1].dayofweek)
        &&(dtime[2].hour==dtime[1].hour)&&((dtime[2].minute-dtime[1].minute)<6)&&(dtime[2].minute!=dtime[1].minute))
          {  dcf_help=timer();
            dcf_sync=4;
          }
          else
            dcf_sync=0;
    }
    else
    {  if(dcf_retry<4)
      {  dcf_start();
        dcf_retry++;
      }
      else
        dcf_sync=0;
    }
  }
  if((dcf_sync&4)&&((timer()-dcf_help)>32)&&!*indos)
  {  _dos_settime(&dtime[2]);
    //_dos_setdate(&ddate[2]);
    dtime[0]=dtime[2];
    ddate[0]=ddate[2];

    dcf_sync&=3;
    dcf_ok=3;
    switch(dcf_in[17]+dcf_in[18]*2)
    {  case 1: cfg.utcoffset=-2;break;
      case 2: cfg.utcoffset=-1;break;
    }
  }
}
#endif
/*
            Hier mal fr alle Interessenten einige
            Informationen zum DCF77-Sender:

            Der DCF77-Sender steht in Mainflingen bei Frankfurt
            am Main und sendet ber den Langwellenbereich auf
            77,500 kHz stndig die gesetzliche Uhrzeit der
            Bundesrepublick Deutschland. Die Trgerfrequenz ist
            eine hochstabile Normalfrequenz, die von einer Gruppe
            von Csiumnormalen (Atomfrequenznormale) durch
            stndigen vergleich hergeleitet wird. Damit ist eine
            Langzeitabweichung von weniger als
            1 zu 2.000.000.000.000 gewhrleistet. Das entspricht
            einer Abweichung von weniger als 1 Sekunde in 300.000
            Jahren. Auch die codierte Zeitinformation besitzt nur
            diese geringe Abweichung. Die Trgeramplitude wird
            einmal pro Sekunde auf ca. 25% fr 0,1 bzw. 0,2 Sekun-
            den abgesenkt. In diesen Absenkungen stecken die Zeit-
            informationen. Die 59. Sekunde wird jedoch ausgelassen,
            um den Minutenwechsel anzukndigen (dadurch wird eine
            Synchronisation ermglicht). Die 59 verfgbaren Bits
            sind wie folgt zugeordnet:

            Bit  0.. 3: nicht belegt
            Bit  4    : Ausfall eines der Zeitnormale
            Bit  5..14: nicht belegt
            Bit 15    : Es wird ber die Reserve-Antenne gesendet
            Bit 16    : Ankndigung eines Zeitzonenwechsels
            Bit 17..18: Zeitzone: 00=Zone 0
                                  01=Sommerzeit
                                  10=Winterzeit
                                  11=Zone 3
            Bit 19    : Ankndigung einer Schaltsekunde
            Bit 20    : Fest auf logisch 1 (Startbit)
            Bit 21..24: Minuten (Einer)
            Bit 25..27: Minuten (Zehner)
            Bit 28    : Parittsbit 1
            Bit 29..32: Stunden (Einer)
            Bit 33..34: Stunden (Zehner)
            Bit 35    : Parittsbit 2
            Bit 36..39: Tag (Einer)
            Bit 40..41: Tag (Zehner)
            Bit 42..44: Wochentag
            Bit 45..48: Monat (Einer)
            Bit 49    : Monat (Zehner)
            Bit 50..53: Jahr (Einer)
            Bit 54..57: Jahr (Zehner)
            Bit 58    : Parittsbit 3
            Bit 59    : Bit entfllt

            Die Ankndigungsbits werden bereits 1 Stunde vor dem
            entsprechendem Ereignis gesetzt.
            Wird eine Schaltsekunde eingefgt, so wird zwischen
            Bit 58 und 59 ein weiterer Impuls eingefgt.
            Die Absenkung des Trgersignals um 0,1 Sekunde ent-
            spricht der logischen "0", die Absenkung von 0,2
            Sekunden entspricht der logischen "1".

*/
