/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  CW-generator for INT08 usage
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/
#ifdef __MSDOS__
#include "dvms.h"
extern void c_tx_gain(int Gain);
extern void c_tx_rate(unsigned long rate,unsigned long filter);

char cw[80];

//Definition aller Morsezeichen
int sign[]=
  {
  5*256+128+64+32+16+8, /*0*/
  5*256+  0+64+32+16+8, /*1*/
  5*256+  0+ 0+32+16+8, /*2*/
  5*256+  0+ 0+ 0+16+8, /*3*/
  5*256+  0+ 0+ 0+ 0+8, /*4*/
  5*256+  0+ 0+ 0+ 0+0, /*5*/
  5*256+128+ 0+ 0+ 0+0, /*6*/
  5*256+128+64+ 0+ 0+0, /*7*/
  5*256+128+64+32+ 0+0, /*8*/
  5*256+128+64+32+16+0, /*9*/

  6*256+  0+64+ 0+16+0+4, /*.*/
  6*256+128+64+ 0+ 0+8+4, /*,*/
  5*256+  0+64+ 0+16+0,   /*+*/
  5*256+128+ 0+ 0+ 0+8,   /*=*/
  5*256+128+ 0+ 0+16+0,   /*/*/
  6*256+  0+ 0+32+16+0,   /*?*/
  0,
  2*256+  0+64+ 0+ 0+0, /*A*/
  4*256+128+ 0+ 0+ 0+0, /*B*/
  4*256+128+ 0+32+ 0+0, /*C*/
  3*256+128+ 0+ 0+ 0+0, /*D*/
  1*256+  0+ 0+ 0+ 0+0, /*E*/
  4*256+  0+ 0+32+ 0+0, /*F*/
  3*256+128+64+ 0+ 0+0, /*G*/
  4*256+  0+ 0+ 0+ 0+0, /*H*/
  2*256+  0+ 0+ 0+ 0+0, /*I*/
  4*256+  0+64+32+16+0, /*J*/
  3*256+128+ 0+32+ 0+0, /*K*/
  4*256+  0+64+ 0+ 0+0, /*L*/
  2*256+128+64+ 0+ 0+0, /*M*/
  2*256+128+ 0+ 0+ 0+0, /*N*/
  3*256+128+64+32+ 0+0, /*O*/
  4*256+  0+64+32+ 0+0, /*P*/
  4*256+128+64+ 0+16+0, /*Q*/
  3*256+  0+64+ 0+ 0+0, /*R*/
  3*256+  0+ 0+ 0+ 0+0, /*S*/
  1*256+128+ 0+ 0+ 0+0, /*T*/
  3*256+  0+ 0+32+ 0+0, /*U*/
  4*256+  0+ 0+ 0+16+0, /*V*/
  3*256+  0+64+32+ 0+0, /*W*/
  4*256+128+ 0+ 0+16+0, /*X*/
  4*256+128+ 0+32+16+0, /*Y*/
  4*256+128+64+ 0+ 0+0  /*Z*/
  };

int call_bit,
    call_time,
    call_char,
    call_state=0,
    call_count=18;

void call_generator(void)
{
    //Einsprung Rufzeichengeber

    if(ptt_state&&cfg.rzz)
    {  if(!call_count--)
        call_state=1;
      if(call_state==1)
      {  call_state=2;
        call_bit =0;
        call_time=0;
        call_char=0;
        c_tx_gain(0);
      }

      if(call_state&4)
      {  if(call_time)
          call_time--;
        else
        {  if(call_state==4)
          {  call_state=5;
            c_tx_rate(0L,0L);
          }
          else
            call_state=2;
        }
      }
      if(call_state==2)
      {  if(call_bit<(sign[cw[call_char]-48]>>8))
        { call_time=(((sign[cw[call_char]-48]<<call_bit)&128)>>6);
          //c_tx_gain(6*!(inp(cfg.iobase+4)&SQ_BIT));
          c_tx_rate(cfg.tone,400000L);
          call_bit++;
          call_state=4;
        }
        else
        {  call_char++;
          call_bit=0;
          if(!cw[call_char])
          { strcpy(cw,cfg.call);
            call_state=0;
            c_tx_gain(0);
            call_count=cfg.rzz*18;
          }
          else
          {  call_state=4;
            call_time=1;
          }
        }
      }
    }
}
#endif