/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  Crontab handling
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/
#include "dosexit.h"
#include "dvms.h"
#include "dvmsfwd.h"
#include "dvmspara.h"
#include "dvmspurg.h"
#include "tnc.h"

char cronplay=0;
static char cron_init[]=";Example crontab configuration\r\n"
                ";0,30 * * * * wrtadc\n"
                        ";0,30 * * * * halfhour\n"
                        ";0,30 * * * * forward\n"
                           "30 3 * * * purge\n"
                           "50 3 * * * statistic\n"
                        ";0,15,30,45 * * * * quarter\n";


static int near cron_match(char *s,int t)
// ****************************************************
//
//  test if given pattern matches the current time
//
// ****************************************************
{ char *c=s;

  if(s[0]=='*') return 1;               // match everytime

  while(isdigit(c[0])) c++;             // remember next non-decimal
  scheduler();
  if(c[0]=='-')                         // check for range
    return (atoi(s)<=t && atoi(c+1)>=t) || cron_match(c+1,t);

  if(c[0]==',')                         // check for enumeration
    return atoi(s)==t || cron_match(c+1,t);

  if(c!=s)                              // begin of string is decimal
    return atoi(s)==t;

  return 0;
}

static void near run_crontab(struct tm *tt)
{ FILE *f=tfopen(_CRONTABNAME,"rt");
  char s[200];
  char mi[31],h[31],d[31],m[31],wd[31],script[21],para[21],*r="run_crontab";
  int  line=0;

  if(!f) // if crontab does not exist, create it
  { f=tfopen(_CRONTABNAME,"w+t");
   if(!f) return;                  // file is not accessible (why ever...)
   fwrite(cron_init,sizeof(cron_init)-1,1,f);
   write_log(_report,r,"crontab.ini generated");
   rewind(f);
  }
  remove("cron.out");
  while(fgets(s,sizeof(s),f))
  {
   line++;                    // remember line for error message
   // recognise comment lines
   if((s[0]!='*' && !isdigit(s[0])) || strlen(s)<10)
    continue;
   para[0]=0;
   if(sscanf(s,"%30s %30s %30s %30s %30s %20s %20s\n",mi,h,d,m,wd,script,para)>=6)
   {  if(cron_match(mi,tt->tm_min)  && cron_match(h,tt->tm_hour) &&
      cron_match(m,tt->tm_mon+1) && cron_match(d,tt->tm_mday) &&
      cron_match(wd,tt->tm_wday) )
    { if(!stricmp(script,"dtmf"))
      {  sprintf(s,"dtmf %s",para);
       put_msg("talkd",(long)s);
       suspend(2);
      }
      else
      if((!stricmp(script,"reorg")||!stricmp(script,"purge"))&&!para[0])
      {  write_log(_report,r,"system: starting reorg","");
       fork("reorg",event,_NPRIO,_NPROC,0,_BIG);
      }
      else
      { char *fstarg=strstr(s,script),c=1;
       char *t;
       if((t=strchr(fstarg,'\n'))!=NULL)
        t[0]=0;
       if((t=strchr(fstarg,'\r'))!=NULL)
        t[0]=0;

       if(!tnc_usrcmd(fstarg,&c))
        if(!tnc_syscmd(fstarg))
        {
          err=0;
          int i=execinipar(fstarg);
          if(i&&!err)
           write_par();
          else
                if(strlen(script))
                {
                  oshell(script,0);
                  fork(script,execimp,_NPRIO,_NPROC,-1,_BIG);
                }

            }
        }
      }
      scheduler();
    }
    else
      write_log(_serious,r,"syntax error at line %d",line);
  }
  tfclose(f);
}

static void near cron_hour (void)
{  chkfiles();
  write_par();
  rdfwdpartners();
}
void crontab (void)
{  int oldmin=0;
  int oldhour=25;
  time_t ti;
  struct tm *tt;
  struct tm tmbuf;
  get_tcb()->type|=(_SYSOP|_BATCH);

  while(!(get_global_msg()&_SHUTDOWN))
  {  ti=ad_time(NULL);
    tt=localtime(&ti);
    _fmemcpy(&tmbuf,tt,sizeof(struct tm));
    tt=&tmbuf;

    if(tt->tm_hour!=oldhour)
    { oldhour=tt->tm_hour;
      cron_hour();
    }

   if(tt->tm_min!=oldmin)
    {  oldmin=tt->tm_min;
      run_crontab(tt);
    }

    suspend(18);
  }
}