/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  DTMF command / mailbox functions
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmsamp.h"
#include "dvmsdtmf.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmshelp.h"
#include "dvmsirq.h"
#include "dvmsmem.h"
#include "dvmsmsgb.h"
#include "dvmspurg.h"
#include "dvmsrecm.h"
#include "dvmssq.h"
#include "dvmssuba.h"
#include "dvmstime.h"
#include "util.h"

#define _maxprefs 7

msg_info_t File_Info,User_Info;
int usr_upd,ulogin=0;

unsigned go_on(void)
{  char dtmf[20];
  rdplay(sysp,"STOPGOON.VMS");
  if(wait_carrier(1)==-1)return(0);
  rcvdtmf(dtmf,TRUE);
  if((dtmf[0]=='*')|| (dtmf[0]=='A'))
    return (0);
  else
    return (1);

}

unsigned stopped(void)
{  if((getdt(1)==27) || (getdt(1)==29))
    return(1);
  else
    return(0);
}

void spkstr(char *str,int flag)
{  char file[13];
  int s;

  if(flag)
    location=0L;

  for (s=0;s<strlen(str);s++)
  {  switch (str[s])
    { case '*':
        strcpy(file,"ST.VMS");
        break;

      case ',':
      case '.':
        strcpy(file,"KOMMA.VMS");
        break;

      default:
        if((str[s]!=0x20)&&(str[s]!='_'))
          sprintf(file,"%c.VMS",str[s]);
        else
          file[0]=0;
    }
    if(file[0])
      readsnd(sysp,file,location);
  }
  if(flag && location)
    playback(0L,location);
}

void spknum(long i)
{  char help[20],str[20];
  location=0L;
  ltoa(i,str,10);
  if(i<0)
  {  spkstr("-",1);
    i=labs(i);
  }
  if(i<60)
  {  sprintf(help,"%d.VMS",i);
    rdplay(sysp,help);
    return;
  }
  if(strlen(str)>4)
  {  strcpy(help,str);
    help[strlen(str)-3]=0;
    spknum(atol(help));
    readsnd(sysp,"1000.VMS",0L);
    strcpy(str,str+strlen(str)-3);
  }
  else
  if(strlen(str)==4)
  {  if(str[0]!='1')
    {  sprintf(help,"%c.VMS",str[0]);
      readsnd(sysp,help,location);
    }
    else
      readsnd(sysp,"EIN.VMS",location);
    readsnd(sysp,"1000.VMS",location);
    strcpy(str,str+1);
  }
  if((strlen(str)==3)&&(str[0]!='0'))
  {  if(str[0]!='1')
    {  sprintf(help,"%c.VMS",str[0]);
      readsnd(sysp,help,location);
    }
    else
      readsnd(sysp,"EIN.VMS",location);
    readsnd(sysp,"100.VMS",location);
    strcpy(str,str+1);
  }
  if((strlen(str)==2))
  {  if(atoi(str)||!i)
    if(atoi(str)>60)
    {  if(str[1]!='0')
      {  if((str[1]=='1') && (str[0]!='0'))
          readsnd(sysp,"EIN.VMS",location);
        else
        {  sprintf(help,"%c.VMS",str[1]);
          readsnd(sysp,help,location);
        }
      }
      if((str[1]!='0') && (str[0]!='0'))
        readsnd(sysp,"UND.VMS",location);
      if(str[0]!='0')
      {  sprintf(help,"%c0.VMS",str[0]);
        readsnd(sysp,help,location);
      }
    }
    else
    {  sprintf(help,"%d.VMS",atoi(str));
      readsnd(sysp,help,location);
    }
  }
  playback(0L,location);
}

int spk_user(char *Id,unsigned usr,int state)
{
  char address[20],file[80];
  set_win(filewin);
  if(!strncmp(cfg.boxaddress,Id,3))
    if(get_callsign(file,Id,usr))
    {
      sprintf(file,"%04d_USR.VMS",usr);
      if(!rd_file_info(cfg.usrp,file,File_Info))
        goto notfound;

      if((state==1) && (File_Info.Id&_MSGID_BBS))
        goto notfound;

      if((state==2) && !(File_Info.Id&_MSGID_BBS))
        goto notfound;

      if((!call_state)&&!(state&_NO_CTCSS))
      {
        c_tx_gain(cfg.ctcss_gain);
        c_tx_rate(ctcss_tone[File_Info.Id>>8],0L);
      }

      if(!rdplay(cfg.usrp,file))
      {
        c_tx_rate(0L,0L);
        goto notfound;
      }
      if((!call_state)&&!(state&_NO_CTCSS))
      {
        c_tx_rate(0L,0L);
        c_tx_gain(6);
      }

      if(stopped())
        return(-1);
      if(File_Info.Id&_MSGID_BBS) return(2);
    }
    else
    {
      notfound:;
      rdplay(sysp,"USR_NUM1.VMS");
      return 0;
    }
  else
  {
    if(!get_callsign(file,Id,usr))
      goto notfound;

    strcpy(address,file);

    if((usr=amp_local(file+9))!=0)
    {
      sprintf(file,"%04d_USR.VMS",usr);
      rdplay(cfg.usrp,file);
      goto lab;
    }

    if(!strncmp(file+9,"BBS",3))
      goto notfound;


    if(!strlen(file+9))
      goto notfound;

    location=0L;
    spkstr(file+9,1);

    lab:;
    if(!accessp(sysp,"AT.VMS"))
      rdplay(sysp,"AT.VMS");
    else
      rdplay(sysp,"VON.VMS");

    address[9]=0;
    location=0L;
    spkstr(address/*+3*/,1);
  }
  return 1;
}

int spk_name(char *Id,int usr)
{  char file[80];
  if(!strncmp(cfg.boxaddress,Id,3))
  {  sprintf(file,"%04d_NAM.VMS",usr);
    rdplay(cfg.usrp,file);
    if(stopped()&&(usr<800))
      return -1;
    return 1;
  }
  return 0;
}

int reccall(int usr,int flag)
{  char help[80],file[80];
  location=0L;
  write_log(_report,"reccall","#%d",usr);

  rdplay(sysp,"USR_NUM0.VMS");

  spknum((long)usr);

  sprintf(help,"%04d_USR.VMS",usr);
  sprintf(file,"%s%s",cfg.usrp,help);
  if(!access(file,0))
    rd_file_info(cfg.usrp,help,User_Info);
  else
  {
    init_msg_info(User_Info);
    User_Info.State=cfg.defuprefs;
  }
  if(!strlen(File_Info.Filename))
    init_msg_info(User_Info);

  if(User_Info.State&0x80)
  {  rdplay(sysp,"NLOGIN5.VMS");
    return(0);
  }
  rdplay(sysp,"NLOGIN2.VMS");

  if(wait_carrier(1)==-1)
    return (0);


  if(record(0L,srate)>(srate/8))
  {  suspend(250/55);
    playback(0,location);
    sprintf(file,"%s%s",cfg.usrp,help);
    remove(file);

    if(flag)
      User_Info.Id|=_MSGID_BBS;
    else
      User_Info.Id|=_MSGID_USER;

    User_Info.Ureceiver=usr;

    if(flag)
    {  User_Info.Days=0;
      User_Info.State=0;
    }
    else
      User_Info.Days=cfg.max_usr_days;

    if(strncmp(User_Info.Info,ad_id(cfg.boxaddress),9))
      strncpy(User_Info.Info,ad_id(cfg.boxaddress),9);

    if(flag)
    {  User_Info.Info[9]=0;
      strcat(User_Info.Info,"BBS");
    }
    writesnd(cfg.usrp,help,0L,location,User_Info);

    rdplay(sysp,"NLOGIN3.VMS");
    return(1);
  }
  rdplay(sysp,"NLOGIN4.VMS");

  /*write_log(usr,"ABORTED");*/
  return(0);
}

int recname(int usr)
{  char help[80],file[80];
  location=0L;
  write_log(_report,"recname","#%d",usr);
  rdplay(sysp,"USR_NUM0.VMS");
  spknum((long)usr);
  /*
  sprintf(help,"%d",usr);
  spkstr(help,1);
  */
  sprintf(help,"%04d_NAM.VMS",usr);
  sprintf(file,"%s%s",cfg.usrp,help);
  if(!access(file,0))
    rd_file_info(cfg.usrp,help,File_Info);
  else
    init_msg_info(File_Info);

  if(File_Info.State&0x80)
  {  rdplay(sysp,"NLOGIN5.VMS");
    return(0);
  }
  rdplay(sysp,"NLOGIN6.VMS");

  if(wait_carrier(1)==-1)return(0);

  if(record(0L,srate)>(srate/8))
  {  suspend(250/55);
    playback(0L,location);
    File_Info.Id=_MSGID_NAME;
    File_Info.Usender=0;
    File_Info.Ureceiver=usr;
    File_Info.Days=0;
   File_Info.State=0;
    /*
    if(strncmp(User_Info.Info,cfg.boxaddress,8))
      strcpy(User_Info.Info,cfg.boxaddress);
    */
    writesnd(cfg.usrp,help,0L,location,File_Info);

    rdplay(sysp,"NLOGIN7.VMS");
    return(1);
  }
  rdplay(sysp,"NLOGIN8.VMS");
  /*write_log(usr,"ABORTED");*/
  return(0);
}
void user_prefs_set(void)
{
  if ((User_Info.State&3)==0)
    strcpy(sysp,cfg.sysp[0]);
  if (cfg.sysp[1][0]&&(User_Info.State&3)==1)
    strcpy(sysp,cfg.sysp[1]);
  if (cfg.sysp[2][0]&&(User_Info.State&3)==2)
    strcpy(sysp,cfg.sysp[2]);

}


int user_prefs(int service)
{  char dtmf[20];

  write_log(_report,"user_prefs","#%d",service);
  switch(service)
  {  case 1:  if(cfg.sysp[1][0])
        { rdplay(sysp,"PREFS_00.VMS");
          if(wait_carrier(1)==-1)return(0);
          rcvdtmf(dtmf,TRUE);
          User_Info.State&=(0xffff-7);
              if(dtmf[0]=='*') User_Info.State&=(0xffff-7);
              if(cfg.sysp[1][0]&&(dtmf[0]=='#')) User_Info.State|=1;
              if(cfg.sysp[2][0]&&(dtmf[0]=='0')) User_Info.State|=2;
              if(dtmf[0]=='A') {rdplay(sysp,"ABORT000.VMS");return(0);}
              user_prefs_set();
              dtmf[1]=0;
              spkstr(dtmf,1);
            }break;
    case 2:  rdplay(sysp,"PREFS_02.VMS");
            if(wait_carrier(1)==-1)return(0);
            rcvdtmf(dtmf,TRUE);
            if(dtmf[0]=='#') User_Info.State|=_USRST_SPKNUM;
            if(dtmf[0]=='*') User_Info.State&=_USRST_SPKNUM^0xffff;
            if(dtmf[0]=='A') {rdplay(sysp,"ABORT000.VMS");return(0);}
            dtmf[1]=0;
            spkstr(dtmf,1);
            break;
    case 3:  rdplay(sysp,"PREFS_03.VMS");
            if(wait_carrier(1)==-1)return(0);
            rcvdtmf(dtmf,TRUE);
            if(dtmf[0]=='#') User_Info.State|=_USRST_SPKNAME;
            if(dtmf[0]=='*') User_Info.State&=_USRST_SPKNAME^0xffff;
        if(dtmf[0]=='A') {rdplay(sysp,"ABORT000.VMS");return(0);}
            dtmf[1]=0;
            spkstr(dtmf,1);
            break;
    case 4:  rdplay(sysp,"PREFS_04.VMS");
            if(wait_carrier(1)==-1)return(0);
            rcvdtmf(dtmf,TRUE);
            if(dtmf[0]=='*') User_Info.State&=(0xffff-_USRST_SPKDATE-_USRST_SPKTIME);
            if(dtmf[0]=='0') User_Info.State|=_USRST_SPKDATE;
            if(dtmf[0]=='#') User_Info.State|=(_USRST_SPKTIME+_USRST_SPKDATE);
            if(dtmf[0]=='A') {rdplay(sysp,"ABORT000.VMS");return(0);}
            dtmf[1]=0;
            spkstr(dtmf,1);
            break;
    case 5:  rdplay(sysp,"PREFS_05.VMS");
            if(wait_carrier(1)==-1)return(0);
            rcvdtmf(dtmf,TRUE);
            if(dtmf[0]=='#') User_Info.State|=_USRST_ASKSEND;
            if(dtmf[0]=='*') User_Info.State&=_USRST_ASKSEND^0xffff;
            if(dtmf[0]=='A') {rdplay(sysp,"ABORT000.VMS");return(0);}
            dtmf[1]=0;
            spkstr(dtmf,1);
            break;
   case 6:  if((User_Info.Id>>8)!=255)
              if(ctcss)
              {  rdplay(sysp,"PREFS_06.VMS");
                if(wait_carrier(1)==-1)return(0);
                rcvdtmf(dtmf,TRUE);
                if(dtmf[0]=='#') User_Info.Id=(User_Info.Id&255)|(ctcss<<8);
                if(dtmf[0]=='*') User_Info.Id&=0xff;
                if(dtmf[0]=='A') {rdplay(sysp,"ABORT000.VMS");return(0);}
                if(dtmf[0]=='0') User_Info.Id=(User_Info.Id&255)|(255<<8);
                dtmf[1]=0;
                spkstr(dtmf,1);
              }
              else
              {  User_Info.Id&=0xff;
                rdplay(sysp,"NO_TONE0.VMS");
                if(wait_carrier(1)==-1)return(0);
                rcvdtmf(dtmf,TRUE);
                if(dtmf[0]=='0') User_Info.Id=(User_Info.Id&255)|(255<<8);
                dtmf[1]=0;
                spkstr(dtmf,1);
              }
            else
              rdplay(sysp,"PREFS_16.VMS");
        break;
    case 7:
            if((strlen(User_Info.Info)>9)&&fwdp[0].p[0])
            {  rdplay(sysp,"PREFS_07.VMS");
              if(wait_carrier(1)==-1)return(0);
              rcvdtmf(dtmf,TRUE);
              if(dtmf[0]=='#') User_Info.State|=_USRST_PRMSG;
              if(dtmf[0]=='*') User_Info.State&=_USRST_PRMSG^0xffff;
              if(dtmf[0]=='A') {rdplay(sysp,"ABORT000.VMS");return(0);}
              dtmf[1]=0;
              spkstr(dtmf,1);
            }
            else
              rdplay(sysp,"PREFS_17.VMS");
        break;

  }
  return(1);
}
void spk_user_prefs(int usr)
{  msg_info_t Info;

  write_log(_report,"spk_user_prefs","usr #%d",usr);

  if((usr==User_Info.Ureceiver)||!usr)
    Info=User_Info;
  else
  {  if (spk_user(cfg.boxaddress,usr,_USER_ONLY|_NO_CTCSS)!=1)
      return;
    Info=File_Info;
  }

  readsnd(sysp,"LOG_IN_1.VMS",0L);
  _ddate(Info.Unixtime,TRUE);
  playback(0L,location);

  rdplay(sysp,"LOG_NUM0.VMS");
  spknum((long)Info.Usender);
  rdplay(sysp,"RECVSNUM.VMS");
  spknum((long)Info.Custom1);
  rdplay(sysp,"SENDSNUM.VMS");
  spknum((long)Info.Custom2);
}


void user_prefs_select(int usr,char *service)
{ int i;
  msg_info_t old;
  char file[80];

  old=User_Info;
  if(!(i=atoi(service))||(service[0]=='0'))
  {  if(!service[0])
    {
      for(i=1;i<=_maxprefs;i++)
        if(!user_prefs(i))
        {  User_Info=old;
          return;
        }
    }
    else
    {  if(service[0]=='0')
    { spk_user_prefs(atoi(service));
        return;
      }
    }
  }
  else
    if(i<=_maxprefs)
    {  if(!user_prefs(i))
      {  User_Info=old;
      return;
      }
    }
    else
      return;

  if(!usr_upd)
  {  User_Info.Days=cfg.max_usr_days;
    User_Info.Usender++;
    usr_upd=TRUE;
  }

  sprintf(file,"%04d_USR.VMS",usr);
  File_Info=User_Info;
  srate=User_Info.Srate*100;
  wrt_file_info(cfg.usrp,file,TRUE,File_Info);
  while(getsq())
    build_mask();
  if(!(i=atoi(service))||(service[0]=='0'))
    rdplay(sysp,"PREFS_01.VMS");
}


int login(int usr,char *dtmf)
{  unsigned long unixtime;
  char file[80];

  usr_upd=FALSE;
  ulogin=usr;

  if (spk_user(cfg.boxaddress,usr,_USER_ONLY|_NO_CTCSS)==1)
  {  User_Info=File_Info;
    if(!check_ctcss())
    {  rdplay(sysp,"MSG_DEL5.VMS");
      User_Info.Ureceiver=0;
      User_Info.Id=0;
      User_Info.Info[0]=0;
      User_Info.Unixtime=0;
      ulogin=0;
      set_win(userwin);
      clrscr();
      return(FALSE);
    }
    write_log(_report,"login","dvms %s (%d)",User_Info.Info+9,User_Info.Ureceiver);
    unixtime=File_Info.Unixtime;
    user_prefs_set();
    if(dtmf[0]=='1')
    {  rdplay(sysp,"LOG_IN.VMS");
      if((ad_time(NULL)-User_Info.Unixtime)>(24*60*60))
        mbox_cmds(cfg.sysp[0],"LOGIN*.VMS",0);
      readsnd(sysp,"LOG_IN_1.VMS",0L);
      _ddate(unixtime,TRUE);
      playback(0L,location);

    }
    else
      if((ad_time(NULL)-User_Info.Unixtime)>(24*60*60))
        mbox_cmds(cfg.sysp[0],"LOGIN*.VMS",0);

    sprintf(file,"%s%04d_NAM.VMS",cfg.usrp,usr);
    if(access( file, 00 ) )
    { rdplay(sysp,"SPK_NAM.VMS");
      if(!recname(ulogin))
        return(0);
    }

    if(!strlen(User_Info.Info+9))
       rdplay(sysp,"NOAMPREG.VMS");

    if(!spk_short_list_of_msg(ulogin)&&(dtmf[0]=='1'))
      rdplay(sysp,"MSG_EOM2.VMS");

    build_mask();
    dtmf[0]=0;
    sprintf(file,"%s (%d)",User_Info.Info+9,ulogin);
    strcpy(get_tcb()->cmd,file);
    return(1);
  }
  else
  {  ulogin=0;
    set_win(userwin);
    clrscr();

  }
  location=0L;
  return(0);
}

void nlogin(void)
{  FILE *in,*out;
  char help[81],file[81],*r="nlogin";
  unsigned int unumber=0,found=0,alt=cfg.unum_min-1;
  msg_info_t MInfo;

  if(!(cfg.system_state&4))
  {  rdplay(sysp,"MSG_DEL5.VMS");
    return;
  }

  if(!checkdiskspace())
    return;

  rdplay(sysp,"NLOGIN1.VMS");
  sprintf(help,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);
  if(access(help,00))
  {  sprintf(help,"%s%04d_USR.VMS",cfg.usrp,cfg.unum_min);
    if(!access(help,00))
    {  write_log(_serious,r,"rebulid user / file not found %s",help);
      reorg_usr();
      goto label1;
    }

    sprintf(help,"%s$$$_USER.VMS",cfg.usrp);
    if ((out=fopen(help,"w"))!=NULL)
    {  fprintf(out,"%-16.16s %03d\n",ad_id(cfg.boxaddress),cfg.unum_min);
      fclose(out);
    }
    else
      write_log(_serious,r,"fopen error %s",help);
    found=cfg.unum_min;
    goto label;
  }

  label1:;

  sprintf(help,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);
  if ((in=fopen(help,"r"))==NULL)
  {  write_log(_serious,r,"fopen error %s",help);
    return;
  }
  sprintf(help,"%s$$$_USER.VMS",cfg.usrp);
  if ((out=fopen(help,"w"))==NULL)
  {  write_log(_serious,r,"fopen error %s",help);
    fclose(in);
    return;
  }

  while (fscanf(in,"%80s %d",help,&unumber)!=EOF)
  {  if((unumber-1>alt)&&!found&&(cfg.unum_min<=(alt+1)))
    {  fprintf(out,"%-16.16s %03d\n",ad_id(cfg.boxaddress),alt+1);
      found=alt+1;
    }
    fprintf(out,"%-16.16s %03d\n",help,unumber);
    alt=unumber;
  }

  if(!found)
  {  fprintf(out,"%-16.16s %03d\n",ad_id(cfg.boxaddress),alt+1);
    found=alt+=1;
  }
  fclose(out);
  fclose(in);

  label:;
  ulogin=found;

  write_log(_report,"nlogin","#%d",ulogin);
  del_usr(ulogin);
  init_msg_info(User_Info);
  if(reccall(found,FALSE))
  { if(!recname(found))
    {  sprintf(help,"%s%04d_USR.VMS",cfg.usrp,found);
      remove(help);
      goto l1;
    }

    sprintf(file,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);
    sprintf(help,"%s$$$_USER.VMS",cfg.usrp);

    remove(file);
    rename(help,file);

    inform_sysop(User_Info);

    rdplay(sysp,"NLOGIN9.VMS");


    MInfo.Usender=cfg.sysop_num;
    MInfo.Ureceiver=ulogin;
    MInfo.Id=_MSGID_PRIV;
    MInfo.Days=cfg.max_msg_days;
    MInfo.State=_MSGST_UNREAD;
    MInfo.Length=80*1024L;
    strcpy(MInfo.Info,ad_id(cfg.boxaddress));
    update_msg_info(MInfo);
    strcpy(MInfo.Filename,"WELCOME.VMS");
    write_minfo (MInfo);
    mbox_cmds(cfg.sysp[0],"LOGIN*.VMS",0);
    login(ulogin,"");
  }
  else
  {  l1:;
    ulogin=0;
    set_win(userwin);
    clrscr();

    init_msg_info(User_Info);
    sprintf(help,"%s$$$_USER.VMS",cfg.usrp);
    remove(help);
  }

}

void logout(int mode)
{ char file[80];
  
  if(!mode)
  {  if(!check_ctcss()) {rdplay(sysp,"MSG_DEL5.VMS");return;}
    write_log(_report,"logout","dvms %s (%d)",User_Info.Info+9,User_Info.Ureceiver);
  }
  else
    write_log(_report,"logout","timeout dvms %s (%d)",User_Info.Info+9,User_Info.Ureceiver);
  set_chb(16);
  spk_user(cfg.boxaddress,User_Info.Ureceiver,_USER_ONLY|_NO_CTCSS);

  if(usr_upd)
  {  File_Info=User_Info;
    sprintf(file,"%04d_USR.VMS",User_Info.Ureceiver);
    srate=User_Info.Srate*100;
    wrt_file_info(cfg.usrp,file,TRUE,File_Info);
  }
  rdplay(sysp,"LOGOFF.VMS");
  set_chb(0);
  ulogin=0;
  set_win(userwin);
  clrscr();
  get_tcb()->cmd[0]=0;
}

void spk_10_user(void)
{ static int alt=0;
  char help[80],Id[16],dtmf[20],file[20];
  FILE *f;
  unsigned unumber,User_Count=0;
  char Search_Id[16];

  if(cfg.nouser_list)
  {  rdplay(sysp,"USR_NUM2.VMS");
    return;
  }
  rdplay(sysp,"USR_NUM3.VMS");

  if(wait_carrier(1)==-1)return;

  rcvdtmf(dtmf,TRUE);

  if(dtmf[0]=='A' || dtmf[0]=='*') return;

  if(dtmf[0]=='#')
  { decode_callsign(Search_Id,dtmf);
    amp_search(file,&unumber,Search_Id,TRUE);
    return;
  }
  if((strlen(dtmf)>3)||(dtmf[0]=='0'))
  { strncpy(Id,dtmf,3);
    alt=atoi(dtmf+3);
  }
  else
  {  strncpy(Id,cfg.boxaddress,3);
    if(atoi(dtmf))
    alt=atoi(dtmf);
  }

  Id[3]=0;
  sprintf(help,"%s%s_USER.VMS",cfg.usrp,Id);
  if(!access(help,0))
  if ((f=fopen(help,"rb"))!=NULL)
  { while (fscanf(f,"%79s %u",help,&unumber)!=EOF)
    { if((alt<=unumber)&&strncmp(help+9,"BBS",3))
      { rdplay(sysp,"BBS_000.VMS");
        spknum((long)unumber);
        if((spk_user(Id,unumber,_USER_ONLY|_NO_CTCSS)==-1) || (spk_name(Id,unumber)==-1)||stopped())
        { rdplay(sysp,"ABORT000.VMS");
          goto end;
        }
        if(get_global_msg()&_SHUTDOWN)
          goto end;
        if(!(++User_Count%10))
          if(!go_on())
            goto end;
      }
    }
    rdplay(sysp,"USR_NUM2.VMS");
    end:;
    fclose(f);
  }
  else
    write_log(_serious,"spk_10_user","fopen error %s",help);
  dtmf[0]=0;
  alt=unumber;
}


void spk_links(void)
{ int i;
  rdplay(sysp,"LINKS_01.VMS");
  for(i=1;i<_MAXFWDPS,fwdp[i].p[0];i++)
  {  rdplay(sysp,"LINKS_03.VMS");
    spkstr(ad_id(fwdp[i].p),1);
    if(stopped()||(get_global_msg()&_SHUTDOWN))
    {  rdplay(sysp,"ABORT000.VMS");
      return;
    }
  }
  rdplay(sysp,"LINKS_02.VMS");
}

void spk_boards(void)
{ FILE *f;
  int i,t=0;
  char help[80],file[80];

  rdplay(sysp,"BOARDS.VMS");
  sprintf(file,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);
  if((f=fopen(file,"rb"))!=NULL)
  { while(fscanf(f,"%79s %d",help,&i)!=EOF)
    {  if(!strncmp(help+9,"BBS",3))
      {  sprintf(help,"%04d_USR.VMS",i);
        rdplay(cfg.usrp,help);
        rdplay(sysp,"BBS_000.VMS");
        spknum((long)i);
        if(stopped()||(get_global_msg()&_SHUTDOWN))
          break;
      }
    }
     fclose(f);
  }
  else
    write_log(_serious,"spk_boards","fopen error %s",file);

  if(t!=-1)
    rdplay(sysp,"BBS_002.VMS");
  else
    rdplay(sysp,"ABORT000.VMS");
}


