/***************************************************************

  DVMS            Digital Voice Mailbox System


  --------------------------------------------------
  hardware checks after startup
  --------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#ifdef __MSDOS__
#include "dvms.h"
#include "dvmssuba.h"

static int test8255(void)
{  int i;
  outp(cfg.iobase+7,0x80);
  delay(10);
  for(i=1;i<3;i++)
  {  outp(cfg.iobase+4+i,0x55);
    delay(10);
    if(inp(cfg.iobase+4+i)!=0x55)
    {  fx805=0;
      return 0;
    }
  }
  fx805=1;
  return 1;
}

int check_hardware(void)
{
  // Fr Fx709, damit er irqs schickt         //DL1GLH
  inp(cfg.iobase);                            //DL1GLH
  delay( 200);                                //DL1GLH

  if(inp(cfg.iobase+7)==0xff)
  {  if(inp(cfg.iobase)!=0xff)
      printf(" SMB-slotcard at 0x%X maybe incompatible.\a\n",cfg.iobase);
    else
    {  printf("- No Slotcard at 0x%X !\a\n",cfg.iobase);
      return 0;
    }
  }

  if(!test8255())
  {
    printf("- 8255: can't access!\a\n");
    fx805=0;
    write_log(_fatal,"check_hardware","8255: can't access!","");
  }
  else
  {
    printf(" 8255 ok.\n");
    if(!test805())
    {
      printf("- FX805: can't access, using PC-speaker!\n");
      write_log(_serious,"check_hardware","FX805: can't access","");
      fx805=0;
    }
    else
    {
      printf(" FX805 ok.\n");
      fx805=1;
    }
  }
  ADC adc;
  adc.getanalog(1);
  delay(55);
  adc.getanalog(1);
  return 1;
}

#endif