/***************************************************************

  DVMS            Digital Voice Mailbox System


  ------------------------------------------------
  Alphanumeric Message Paging format Conversion
  lookup calls in AMP-format
  ------------------------------------------------


  Copyright (c)92-95 Detlef Fliegl DG9MHZ
          Guardinistr. 47
          D-81375 Muenchen

  Alle Rechte vorbehalten / All Rights reserved

 ***************************************************************/

#include "dvms.h"
#include "dvmscmd.h"
#include "dvmsdtmf.h"
#include "dvmsfwd.h"
#include "dvmshead.h"
#include "dvmsmsgb.h"
#include "dvmssq.h"


int decode_callsign(char *help,char *input)
{ static char *AMP[40]={"0000","1QZZ","2ABC","3DEF","4GHI","5JKL","6MNO","7PRS","8TUV","9WXY"};
  int dec_count=0,i=0,sel,add=1;
  char dtmf[20];

  if((input[0]!='#')||(input[strlen(input)-1]!='#'))
    return(0);

  strcpy(dtmf,input+1);

  dtmf[strlen(dtmf)-1]=0;

  while((dec_count<6)&&(dec_count<strlen(dtmf)))
  { if(!dtmf[i])
      break;

    if((dtmf[i+1]>='A' && dtmf[i+1]<='C')||(dtmf[i+1]=='*')||(dtmf[i+1]=='0')||(dtmf[i+1]=='#'))
    { add=2;
      if(dtmf[i+1]>='A' && dtmf[i+1]<='C')
        sel=dtmf[i+1]-64;
      else
      {  if(dtmf[i+1]=='*') sel=1;
        if(dtmf[i+1]=='0') sel=2;
        if(dtmf[i+1]=='#') sel=3;
      }
    }
    else
    { sel=0;
      add=1;
    }

    if(((dtmf[i])<=0x39)&&(dtmf[i]>=0x30))
      help[dec_count++]=AMP[dtmf[i]-0x30][sel];
    else
    {  help[0]=0;
      return(0);
    }

    i+=add;
  }
  help[dec_count]=0;
  help[6]=0;
  return(1);
}

void amp_call(int usr)
{  msg_info_t File_Info;
  char Call[16],dtmf[20],file[80];

  rdplay(sysp,"AMP_CAL1.VMS");

  if(wait_carrier(1)==-1) return;
  rcvdtmf(dtmf,1);

  if((!decode_callsign(Call,dtmf))/*||(!strlen(help))*/)
  {  rdplay(sysp,"AMP_CAL3.VMS");
    return;
  }

  sprintf(file,"%04d_USR.VMS",usr);
  rd_file_info(cfg.usrp,file,File_Info);

  if(!strlen(Call) || (!(File_Info.Id&_MSGID_BBS) &&!mbcallok(Call)))
  {  rdplay(sysp,"AMP_CAL3.VMS");
    return;
  }

  if(File_Info.Id&_MSGID_BBS)
  {  File_Info.Info[12]=0;
    Call[3]=0;
  }
  else
    File_Info.Info[9]=0;

  strcat(File_Info.Info,Call);

  sprintf(file,"%04d_USR.VMS",usr);
  wrt_file_info(cfg.usrp,file,FALSE,File_Info);

  if(usr==ulogin)
    User_Info=File_Info;

  location=0L;
  spkstr(File_Info.Info+9,1);

  change_userfile(File_Info.Info,usr);

  fork("export_users",export_users,_NPRIO,_NPROC,-1,_MED);

  rdplay(sysp,"AMP_CAL2.VMS");
  write_log(_report,"amp_call","%d %s",usr,File_Info.Info+9);
}

int amp_callreg(int usr,char *Call)
{  msg_info_t File_Info;
  char file[80];

  strupr(Call);

  sprintf(file,"%04d_USR.VMS",usr);

  if(!rd_file_info(cfg.usrp,file,File_Info))
    return 0;

  if(!strlen(Call) || (!(File_Info.Id&_MSGID_BBS) &&!mbcallok(Call)))
    return 0;

  if(File_Info.Id&_MSGID_BBS)
  {  File_Info.Info[12]=0;
    Call[3]=0;
  }
  else
    File_Info.Info[9]=0;

  strcat(File_Info.Info,Call);

  if(!wrt_file_info(cfg.usrp,file,FALSE,File_Info))
    return 0;

  change_userfile(File_Info.Info,usr);
  fork("export_users",export_users,_NPRIO,_NPROC,-1,_MED);

  write_log(_report,"amp_callreg","%d %s",usr,Call);
  return 1;
}
int amp_search(char *id,unsigned *usr,char *call,int flag)
{ FILE *in;
  struct find_t find;
  int found=0;
  char help[80],rid[17];
  unsigned rusr;

  char frid[17];   //DL1GLH Speicher fuer gefundenen einzigen User
  unsigned frusr;  //DL1GLH Speicher fuer gefundenen einzigen User

  sprintf(help,"%s???_USER.VMS",cfg.usrp);
  if(!_dos_findfirst(help, 0xffff, &find ))
  do
  { sprintf(help,"%s%s",cfg.usrp,find.name);
    //if(!access(help,0))
    if((in=tfopen(help,"r"))==NULL)
    { write_log(_serious,"amp_search","fopen error %s",help);
      return 0;
    }
    while (fscanf(in,"%16s %d",rid,&rusr)!=EOF)
    {
      if(!strncmp(rid+9,call,strlen(call)))
      { found++;
        frusr = rusr;          //DL1GLH Benutzer jetzt zwischenspeichern
        strcpy( frid, rid);    //DL1GLH Benutzer jetzt zwischenspeichern
        if(flag)
        { if(stopped()) break;
          rdplay(sysp,"BBS_000.VMS");
          spknum((long)rusr);
          spk_user(rid,rusr,_USER_ONLY|_NO_CTCSS);
          if(stopped())
          { rdplay(sysp,"ABORT000.VMS");
            tfclose(in);
            return 0;
          }
          if(flag&&(found>9))
          { rdplay(sysp,"ABORT000.VMS");
            tfclose(in);
            return 0;
          }
        }
      }
      scheduler();
    }
    tfclose(in);
  }
  while(!_dos_findnext( &find ));
  if(!found&&flag) rdplay(sysp,"USR_NUM2.VMS");

  if(!found&&!flag)
    return 0;

  if((found>1)&&!flag)
  {  rdplay(sysp,"USR_NUM4.VMS");
    return 0;
  }

  //DL1GLH  Genau einen Benutzer mit AMP-Call gefunden
  strcpy(id,frid);   //DL1GLH
  *usr=frusr;        //DL1GLH
  return 1;
}
/*
int amp_search(char *id,unsigned *usr,char *call,int flag)
{ FILE *in;
  struct find_t find;
  int found=0;
  char help[80],rid[17];
  unsigned rusr;

  sprintf(help,"%s???_USER.VMS",cfg.usrp);
  if(!_dos_findfirst(help, 0xffff, &find ))
  do
  { sprintf(help,"%s%s",cfg.usrp,find.name);
    //if(!access(help,0))
    if((in=tfopen(help,"r"))==NULL)
    { write_log(_serious,"amp_search","fopen error %s",help);
      return 0;
    }
    while (fscanf(in,"%16s %d",rid,&rusr)!=EOF)
    {
      if(!strncmp(rid+9,call,strlen(call)))
      { found++;
        if(flag)
        { if(stopped()) break;
          rdplay(sysp,"BBS_000.VMS");
          spknum((long)rusr);
          spk_user(rid,rusr,_USER_ONLY|_NO_CTCSS);
          if(stopped())
          { rdplay(sysp,"ABORT000.VMS");
            tfclose(in);
            return 0;
          }
          if(flag&&(found>9))
          { rdplay(sysp,"ABORT000.VMS");
            tfclose(in);
            return 0;
          }
        }
      }
      scheduler();
    }
    tfclose(in);
  }
  while(!_dos_findnext( &find ));
  if(!found&&flag) rdplay(sysp,"USR_NUM2.VMS");

  if(!found&&!flag)
    return 0;

  if((found>1)&&!flag)
  {  rdplay(sysp,"USR_NUM4.VMS");
    return 0;
  }
  strcpy(id,rid);
  *usr=rusr;
  return 1;
}
*/
void not_amp(void)
{  FILE *handle;
  char path[80],file[80];
  unsigned unumber;

  sprintf(path,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);

  if((handle=tfopen(path,"r"))==NULL)
  {  write_log(_serious,"not_amp","fopen error %s",path);
    return;
  }

  while(fscanf(handle,"%79s %d",file,&unumber)!=EOF)
  {  if(strncmp(file+9,"BBS",3) && (strlen(file+9)<5))
    { rdplay(sysp,"BBS_000.VMS");
      spknum((long)unumber);
      spkstr(file+9,1);
      if(spk_user(file,unumber,_USER_ONLY|_NO_CTCSS))
      {    amp_call(unumber);
          file[3]=0;
          file[9]=0;
      }
      if(stopped()) break;
    }

  }
  tfclose(handle);
}

void all_call(void)
{  FILE *handle;
  char path[80],file[80];
  unsigned unumber;

  sprintf(path,"%-3.3s%s_USER.VMS",cfg.usrp,cfg.boxaddress);

  if((handle=tfopen(path,"r"))==NULL)
  {
    write_log(_serious,"all_call","fopen error %s",path);
    return;
  }

  while(fscanf(handle,"%79s %d",file,&unumber)!=EOF)
  {  sprintf(path,"%s%04d_USR.VMS",cfg.usrp,unumber);
    if (access(path,00))
    {  spkstr(file+9,1);
      write_log(_report,"all_call","mkuser %d",unumber);
      init_msg_info(User_Info);
      strcpy(User_Info.Info,file);
      if(strncmp(file+9,"BBS",3))
        reccall(unumber,FALSE);
      else
        reccall(unumber,TRUE);
    }
    if(stopped()) break;
  }
  tfclose(handle);
}

void auto_amp(void)
{ msg_info_t File_Info;
  FILE *handle;
  char path[80],file[80];
  unsigned unumber;

  sprintf(path,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);

  if((handle=tfopen(path,"r"))==NULL)
  {  write_log(_serious,"auto_amp","fopen error %s",path);
    return;
  }

  while(fscanf(handle,"%79s %d",file,&unumber)!=EOF)
  {  sprintf(path,"%04d_USR.VMS",unumber);
    rd_file_info(cfg.usrp,path,File_Info);
    strcpy(File_Info.Info,file);
    wrt_file_info(cfg.usrp,path,0,File_Info);
  }
  tfclose(handle);
}

int amp_exist(char *s)
{ FILE *f;
  struct find_t find;
  int found=0;
  char path[80],rid[17],*r="amp_exist";
  unsigned rusr;

  sprintf(path,"%s???_USER.VMS",cfg.usrp);
  if(!_dos_findfirst(path, 0xffff, &find ))
  do
  { sprintf(path,"%s%s",cfg.usrp,find.name);
    if((f=tfopen(path,"r"))==NULL)
    { write_log(_serious,r,"fopen error %s",path);
      return 0;
    }
    while(fscanf(f,"%16s %d",rid,&rusr)!=EOF)
    {
      if(!stricmp(rid+9,s))
      { found++;
        putf("Found user at %-9.9s, #%u %s\r",rid,rusr,strnicmp(rid,cfg.boxaddress,3)?"":"double");
      }
      scheduler();
    }
    tfclose(f);
  }
  while(!_dos_findnext( &find ));
  return found;
}

int amp_local(char *s)
{
  FILE *f;
  int found=0;
  char path[80],rid[17],*r="amp_local";
  unsigned rusr;

  sprintf(path,"%s%-3.3s_USER.VMS",cfg.usrp,cfg.boxaddress);

  if((f=tfopen(path,"r"))==NULL)
  { write_log(_serious,r,"fopen error %s",path);
    return 0;
  }

  while(fscanf(f,"%16s %d",rid,&rusr)!=EOF)
  {
    if(!stricmp(rid+9,s))
      found=rusr;
    scheduler();
  }
  tfclose(f);
  return found;
}
